/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.cloud;

import com.aspose.barcode.cloud.ServerVariable;
import java.util.Map;

public class ServerConfiguration {
    public String url;
    public String description;
    public Map<String, ServerVariable> variables;

    public ServerConfiguration(String url, String description, Map<String, ServerVariable> variables) {
        this.url = url;
        this.description = description;
        this.variables = variables;
    }

    public String url(Map<String, String> variables) {
        String url = this.url;
        for (Map.Entry<String, ServerVariable> variable : this.variables.entrySet()) {
            String name = variable.getKey();
            ServerVariable serverVariable = variable.getValue();
            String value = serverVariable.defaultValue;
            if (variables != null && variables.containsKey(name)) {
                value = variables.get(name);
                if (serverVariable.enumValues.size() > 0 && !serverVariable.enumValues.contains(value)) {
                    throw new IllegalArgumentException("The variable " + name + " in the server url has invalid value " + value + ".");
                }
            }
            url = url.replace("{" + name + "}", value);
        }
        return url;
    }

    public String url() {
        return this.url(null);
    }
}

