/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.cloud.api;

import com.aspose.barcode.cloud.ApiCallback;
import com.aspose.barcode.cloud.ApiClient;
import com.aspose.barcode.cloud.ApiException;
import com.aspose.barcode.cloud.ApiResponse;
import com.aspose.barcode.cloud.Pair;
import com.aspose.barcode.cloud.ProgressRequestBody;
import com.aspose.barcode.cloud.ProgressResponseBody;
import com.aspose.barcode.cloud.model.BarcodeResponseList;
import com.aspose.barcode.cloud.model.RecognizeBase64Request;
import com.aspose.barcode.cloud.requests.RecognizeBase64RequestWrapper;
import com.aspose.barcode.cloud.requests.RecognizeMultipartRequestWrapper;
import com.aspose.barcode.cloud.requests.RecognizeRequestWrapper;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RecognizeApi {
    private final ApiClient apiClient;

    public RecognizeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    protected Call recognizeCall(RecognizeRequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String path = "/barcode/recognize";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        if (request.barcodeType != null) {
            queryParams.addAll(this.apiClient.parameterToPair("barcodeType", (Object)request.barcodeType));
        }
        if (request.fileUrl != null) {
            queryParams.addAll(this.apiClient.parameterToPair("fileUrl", request.fileUrl));
        }
        if (request.recognitionMode != null) {
            queryParams.addAll(this.apiClient.parameterToPair("recognitionMode", (Object)request.recognitionMode));
        }
        if (request.recognitionImageKind != null) {
            queryParams.addAll(this.apiClient.parameterToPair("recognitionImageKind", (Object)request.recognitionImageKind));
        }
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json", "application/xml"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call recognizeValidateBeforeCall(RecognizeRequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.barcodeType == null) {
            throw new ApiException("Missing the required parameter 'request.barcodeType' when calling recognize(...)");
        }
        if (request.fileUrl == null) {
            throw new ApiException("Missing the required parameter 'request.fileUrl' when calling recognize(...)");
        }
        Call call = this.recognizeCall(request, progressListener, progressRequestListener);
        return call;
    }

    public BarcodeResponseList recognize(RecognizeRequestWrapper request) throws ApiException {
        ApiResponse<BarcodeResponseList> resp = this.recognizeWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<BarcodeResponseList> recognizeWithHttpInfo(RecognizeRequestWrapper request) throws ApiException {
        Call call = this.recognizeValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call recognizeAsync(RecognizeRequestWrapper request, final ApiCallback<BarcodeResponseList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.recognizeValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    protected Call recognizeBase64Call(RecognizeBase64RequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RecognizeBase64Request postBody = request.recognizeBase64Request;
        String path = "/barcode/recognize-body";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json", "application/xml"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json", "application/xml"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call recognizeBase64ValidateBeforeCall(RecognizeBase64RequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.recognizeBase64Request == null) {
            throw new ApiException("Missing the required parameter 'request.recognizeBase64Request' when calling recognizeBase64(...)");
        }
        Call call = this.recognizeBase64Call(request, progressListener, progressRequestListener);
        return call;
    }

    public BarcodeResponseList recognizeBase64(RecognizeBase64RequestWrapper request) throws ApiException {
        ApiResponse<BarcodeResponseList> resp = this.recognizeBase64WithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<BarcodeResponseList> recognizeBase64WithHttpInfo(RecognizeBase64RequestWrapper request) throws ApiException {
        Call call = this.recognizeBase64ValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call recognizeBase64Async(RecognizeBase64RequestWrapper request, final ApiCallback<BarcodeResponseList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.recognizeBase64ValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    protected Call recognizeMultipartCall(RecognizeMultipartRequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        Object postBody = null;
        String path = "/barcode/recognize-multipart";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (request.barcodeType != null) {
            formParams.put("barcodeType", (Object)request.barcodeType);
        }
        if (request.file != null) {
            formParams.put("file", request.file);
        }
        if (request.recognitionMode != null) {
            formParams.put("recognitionMode", (Object)request.recognitionMode);
        }
        if (request.recognitionImageKind != null) {
            formParams.put("recognitionImageKind", (Object)request.recognitionImageKind);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json", "application/xml"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call recognizeMultipartValidateBeforeCall(RecognizeMultipartRequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.barcodeType == null) {
            throw new ApiException("Missing the required parameter 'request.barcodeType' when calling recognizeMultipart(...)");
        }
        if (request.file == null) {
            throw new ApiException("Missing the required parameter 'request.file' when calling recognizeMultipart(...)");
        }
        Call call = this.recognizeMultipartCall(request, progressListener, progressRequestListener);
        return call;
    }

    public BarcodeResponseList recognizeMultipart(RecognizeMultipartRequestWrapper request) throws ApiException {
        ApiResponse<BarcodeResponseList> resp = this.recognizeMultipartWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<BarcodeResponseList> recognizeMultipartWithHttpInfo(RecognizeMultipartRequestWrapper request) throws ApiException {
        Call call = this.recognizeMultipartValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call recognizeMultipartAsync(RecognizeMultipartRequestWrapper request, final ApiCallback<BarcodeResponseList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.recognizeMultipartValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }
}

