/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.cloud.api;

import com.aspose.barcode.cloud.ApiCallback;
import com.aspose.barcode.cloud.ApiClient;
import com.aspose.barcode.cloud.ApiException;
import com.aspose.barcode.cloud.ApiResponse;
import com.aspose.barcode.cloud.Pair;
import com.aspose.barcode.cloud.ProgressRequestBody;
import com.aspose.barcode.cloud.ProgressResponseBody;
import com.aspose.barcode.cloud.model.GenerateParams;
import com.aspose.barcode.cloud.requests.GenerateBodyRequestWrapper;
import com.aspose.barcode.cloud.requests.GenerateMultipartRequestWrapper;
import com.aspose.barcode.cloud.requests.GenerateRequestWrapper;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class GenerateApi {
    private final ApiClient apiClient;

    public GenerateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    protected Call generateCall(GenerateRequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String path = "/barcode/generate/{barcodeType}".replaceAll("\\{barcodeType}", request.barcodeType.toString());
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        if (request.dataType != null) {
            queryParams.addAll(this.apiClient.parameterToPair("dataType", (Object)request.dataType));
        }
        if (request.data != null) {
            queryParams.addAll(this.apiClient.parameterToPair("data", request.data));
        }
        if (request.imageFormat != null) {
            queryParams.addAll(this.apiClient.parameterToPair("imageFormat", (Object)request.imageFormat));
        }
        if (request.textLocation != null) {
            queryParams.addAll(this.apiClient.parameterToPair("textLocation", (Object)request.textLocation));
        }
        if (request.foregroundColor != null) {
            queryParams.addAll(this.apiClient.parameterToPair("foregroundColor", request.foregroundColor));
        }
        if (request.backgroundColor != null) {
            queryParams.addAll(this.apiClient.parameterToPair("backgroundColor", request.backgroundColor));
        }
        if (request.units != null) {
            queryParams.addAll(this.apiClient.parameterToPair("units", (Object)request.units));
        }
        if (request.resolution != null) {
            queryParams.addAll(this.apiClient.parameterToPair("resolution", request.resolution));
        }
        if (request.imageHeight != null) {
            queryParams.addAll(this.apiClient.parameterToPair("imageHeight", request.imageHeight));
        }
        if (request.imageWidth != null) {
            queryParams.addAll(this.apiClient.parameterToPair("imageWidth", request.imageWidth));
        }
        if (request.rotationAngle != null) {
            queryParams.addAll(this.apiClient.parameterToPair("rotationAngle", request.rotationAngle));
        }
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"image/png", "image/bmp", "image/gif", "image/jpeg", "image/svg+xml", "image/tiff", "application/json", "application/xml"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call generateValidateBeforeCall(GenerateRequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.barcodeType == null) {
            throw new ApiException("Missing the required parameter 'request.barcodeType' when calling generate(...)");
        }
        if (request.data == null) {
            throw new ApiException("Missing the required parameter 'request.data' when calling generate(...)");
        }
        Call call = this.generateCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File generate(GenerateRequestWrapper request) throws ApiException {
        ApiResponse<File> resp = this.generateWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> generateWithHttpInfo(GenerateRequestWrapper request) throws ApiException {
        Call call = this.generateValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call generateAsync(GenerateRequestWrapper request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    protected Call generateBodyCall(GenerateBodyRequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GenerateParams postBody = request.generateParams;
        String path = "/barcode/generate-body";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"image/png", "image/bmp", "image/gif", "image/jpeg", "image/svg+xml", "image/tiff", "application/json", "application/xml"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json", "application/xml"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call generateBodyValidateBeforeCall(GenerateBodyRequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.generateParams == null) {
            throw new ApiException("Missing the required parameter 'request.generateParams' when calling generateBody(...)");
        }
        Call call = this.generateBodyCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File generateBody(GenerateBodyRequestWrapper request) throws ApiException {
        ApiResponse<File> resp = this.generateBodyWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> generateBodyWithHttpInfo(GenerateBodyRequestWrapper request) throws ApiException {
        Call call = this.generateBodyValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call generateBodyAsync(GenerateBodyRequestWrapper request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateBodyValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    protected Call generateMultipartCall(GenerateMultipartRequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        Object postBody = null;
        String path = "/barcode/generate-multipart";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (request.barcodeType != null) {
            formParams.put("barcodeType", (Object)request.barcodeType);
        }
        if (request.dataType != null) {
            formParams.put("dataType", (Object)request.dataType);
        }
        if (request.data != null) {
            formParams.put("data", request.data);
        }
        if (request.imageFormat != null) {
            formParams.put("imageFormat", (Object)request.imageFormat);
        }
        if (request.textLocation != null) {
            formParams.put("textLocation", (Object)request.textLocation);
        }
        if (request.foregroundColor != null) {
            formParams.put("foregroundColor", request.foregroundColor);
        }
        if (request.backgroundColor != null) {
            formParams.put("backgroundColor", request.backgroundColor);
        }
        if (request.units != null) {
            formParams.put("units", (Object)request.units);
        }
        if (request.resolution != null) {
            formParams.put("resolution", request.resolution);
        }
        if (request.imageHeight != null) {
            formParams.put("imageHeight", request.imageHeight);
        }
        if (request.imageWidth != null) {
            formParams.put("imageWidth", request.imageWidth);
        }
        if (request.rotationAngle != null) {
            formParams.put("rotationAngle", request.rotationAngle);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"image/png", "image/bmp", "image/gif", "image/jpeg", "image/svg+xml", "image/tiff", "application/json", "application/xml"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call generateMultipartValidateBeforeCall(GenerateMultipartRequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.barcodeType == null) {
            throw new ApiException("Missing the required parameter 'request.barcodeType' when calling generateMultipart(...)");
        }
        if (request.data == null) {
            throw new ApiException("Missing the required parameter 'request.data' when calling generateMultipart(...)");
        }
        Call call = this.generateMultipartCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File generateMultipart(GenerateMultipartRequestWrapper request) throws ApiException {
        ApiResponse<File> resp = this.generateMultipartWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> generateMultipartWithHttpInfo(GenerateMultipartRequestWrapper request) throws ApiException {
        Call call = this.generateMultipartValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call generateMultipartAsync(GenerateMultipartRequestWrapper request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateMultipartValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }
}

