/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.cloud;

import com.aspose.barcode.cloud.model.ApiError;
import com.aspose.barcode.cloud.model.ApiErrorResponse;
import java.util.List;
import java.util.Map;

public class ApiException
extends Exception {
    private int httpCode = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private ApiErrorResponse response = null;

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, int httpCode) {
        super(message);
        this.httpCode = httpCode;
    }

    public ApiException(String message, int httpCode, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, httpCode);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ApiException(String message, Throwable throwable, int httpCode, Map<String, List<String>> responseHeaders) {
        super(message, throwable);
        this.httpCode = httpCode;
        this.responseHeaders = responseHeaders;
    }

    public ApiException(String message, int httpCode, ApiErrorResponse errorResponse) {
        this(message, httpCode);
        this.response = errorResponse;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getDetails() {
        ApiError err;
        if (this.response != null && (err = this.response.getError()) != null) {
            StringBuilder sb = new StringBuilder();
            if (err.getCode() != null) {
                sb.append(err.getCode()).append(": ");
            }
            if (err.getMessage() != null) {
                sb.append(err.getMessage());
            }
            if (err.getDescription() != null) {
                sb.append(err.getDescription());
            }
            return sb.toString();
        }
        if (this.responseBody != null) {
            return this.responseBody;
        }
        return "";
    }
}

