/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.cloud.api;

import com.aspose.barcode.cloud.ApiCallback;
import com.aspose.barcode.cloud.ApiClient;
import com.aspose.barcode.cloud.ApiException;
import com.aspose.barcode.cloud.ApiResponse;
import com.aspose.barcode.cloud.Pair;
import com.aspose.barcode.cloud.ProgressRequestBody;
import com.aspose.barcode.cloud.ProgressResponseBody;
import com.aspose.barcode.cloud.model.BarcodeResponseList;
import com.aspose.barcode.cloud.model.ScanBase64Request;
import com.aspose.barcode.cloud.requests.ScanBase64RequestWrapper;
import com.aspose.barcode.cloud.requests.ScanMultipartRequestWrapper;
import com.aspose.barcode.cloud.requests.ScanRequestWrapper;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ScanApi {
    private final ApiClient apiClient;

    public ScanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    protected Call scanCall(ScanRequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String path = "/barcode/scan";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        if (request.fileUrl != null) {
            queryParams.addAll(this.apiClient.parameterToPair("fileUrl", request.fileUrl));
        }
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json", "application/xml"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call scanValidateBeforeCall(ScanRequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.fileUrl == null) {
            throw new ApiException("Missing the required parameter 'request.fileUrl' when calling scan(...)");
        }
        Call call = this.scanCall(request, progressListener, progressRequestListener);
        return call;
    }

    public BarcodeResponseList scan(ScanRequestWrapper request) throws ApiException {
        ApiResponse<BarcodeResponseList> resp = this.scanWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<BarcodeResponseList> scanWithHttpInfo(ScanRequestWrapper request) throws ApiException {
        Call call = this.scanValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call scanAsync(ScanRequestWrapper request, final ApiCallback<BarcodeResponseList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.scanValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    protected Call scanBase64Call(ScanBase64RequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ScanBase64Request postBody = request.scanBase64Request;
        String path = "/barcode/scan-body";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json", "application/xml"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json", "application/xml"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call scanBase64ValidateBeforeCall(ScanBase64RequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.scanBase64Request == null) {
            throw new ApiException("Missing the required parameter 'request.scanBase64Request' when calling scanBase64(...)");
        }
        Call call = this.scanBase64Call(request, progressListener, progressRequestListener);
        return call;
    }

    public BarcodeResponseList scanBase64(ScanBase64RequestWrapper request) throws ApiException {
        ApiResponse<BarcodeResponseList> resp = this.scanBase64WithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<BarcodeResponseList> scanBase64WithHttpInfo(ScanBase64RequestWrapper request) throws ApiException {
        Call call = this.scanBase64ValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call scanBase64Async(ScanBase64RequestWrapper request, final ApiCallback<BarcodeResponseList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.scanBase64ValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    protected Call scanMultipartCall(ScanMultipartRequestWrapper request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        Object postBody = null;
        String path = "/barcode/scan-multipart";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (request.file != null) {
            formParams.put("file", request.file);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json", "application/xml"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    private Call scanMultipartValidateBeforeCall(ScanMultipartRequestWrapper request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.file == null) {
            throw new ApiException("Missing the required parameter 'request.file' when calling scanMultipart(...)");
        }
        Call call = this.scanMultipartCall(request, progressListener, progressRequestListener);
        return call;
    }

    public BarcodeResponseList scanMultipart(ScanMultipartRequestWrapper request) throws ApiException {
        ApiResponse<BarcodeResponseList> resp = this.scanMultipartWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<BarcodeResponseList> scanMultipartWithHttpInfo(ScanMultipartRequestWrapper request) throws ApiException {
        Call call = this.scanMultipartValidateBeforeCall(request, null, null);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call scanMultipartAsync(ScanMultipartRequestWrapper request, final ApiCallback<BarcodeResponseList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.scanMultipartValidateBeforeCall(request, progressListener, progressRequestListener);
        Type returnType = new TypeToken<BarcodeResponseList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }
}

