/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cloud.cells.request;

import com.aspose.cloud.cells.client.ApiClient;
import com.aspose.cloud.cells.client.ApiException;
import com.aspose.cloud.cells.client.Pair;
import com.aspose.cloud.cells.client.ProgressRequestBody;
import com.aspose.cloud.cells.client.ProgressResponseBody;
import com.aspose.cloud.cells.request.IRequestModel;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class UploadFileRequest
implements IRequestModel {
    private HashMap<String, String> extendQueryParameterMap;
    private String path;
    private String storageName;
    private String uploadFiles;

    public HashMap<String, String> getExtendQueryParameterMap() {
        return this.extendQueryParameterMap;
    }

    public void setExtendQueryParameterMap(HashMap<String, String> extendQueryParameterMap) {
        this.extendQueryParameterMap = extendQueryParameterMap;
    }

    public UploadFileRequest() {
    }

    public UploadFileRequest(String uploadFiles, String path, String storageName) {
        this.uploadFiles = uploadFiles;
        this.path = path;
        this.storageName = storageName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public String getUploadFiles() {
        return this.uploadFiles;
    }

    public void setUploadFiles(String uploadFiles) {
        this.uploadFiles = uploadFiles;
    }

    @Override
    public Call buildHttpRequest(ApiClient apiClient, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, Boolean addAuthHeaders) throws ApiException {
        File UploadFilesToUpload;
        if (this.getUploadFiles() == null) {
            throw new ApiException("Missing the required parameter 'UploadFiles' when calling UploadFile");
        }
        if (this.getPath() == null) {
            throw new ApiException("Missing the required parameter 'Path' when calling UploadFile");
        }
        String localVarPath = "v4.0/cells/storage/file/{path}".replaceAll("\\{path\\}", apiClient.escapeString(this.path.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (this.getStorageName() != null) {
            localVarQueryParams.addAll(apiClient.parameterToPairs("", "storageName", this.getStorageName()));
        }
        if (this.extendQueryParameterMap != null) {
            for (String key : this.extendQueryParameterMap.keySet()) {
                localVarQueryParams.addAll(apiClient.parameterToPairs("", key, this.extendQueryParameterMap.get(key)));
            }
        }
        if ((UploadFilesToUpload = new File(this.getUploadFiles())).exists()) {
            localVarFormParams.put(UploadFilesToUpload.getName(), UploadFilesToUpload);
        }
        Object localVarPostBody = null;
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
}

