/*
 * --------------------------------------------------------------------------------
 * <copyright company="Aspose" file="CellsApi.java">
 *   Copyright (c) 2026 Aspose.Cells Cloud
 * </copyright>
 * <summary>
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 * </summary>
 * --------------------------------------------------------------------------------
 */

package com.aspose.cloud.cells.api;

import com.aspose.cloud.cells.*;
import com.aspose.cloud.cells.model.*;
import com.aspose.cloud.cells.request.*;
import com.aspose.cloud.cells.client.*;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Response;
import java.io.IOException;
import javax.crypto.NoSuchPaddingException;

import java.io.File;
import java.lang.reflect.Type;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.*;

public class CellsApi {

    private ApiClient apiClient;

    public CellsApi(String clientId, String clientSecret) throws ApiException {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath("https://api.aspose.cloud");
        apiClient.setApiVersion("v3.0");
        String accesstoken = apiClient.getAccessToken("client_credentials", clientId, clientSecret, "v3.0");
        apiClient.addDefaultHeader("Authorization", "Bearer " + accesstoken);
        apiClient.addDefaultHeader("x-aspose-client", "java sdk");
        apiClient.addDefaultHeader("x-aspose-client-version", "26.2");
        this.apiClient = apiClient;
    }

    public CellsApi(String clientId, String clientSecret, String Version, String baseURI) throws ApiException {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(baseURI.endsWith("/") ? baseURI.substring(0,
                baseURI.length() - 1) : baseURI);
        apiClient.setApiVersion(Version);
        if((clientId == null || clientId.length() == 0) && (clientSecret == null ||clientSecret.length() == 0)){
            apiClient.SetNeedAuth(false);
        }else{
            String accesstoken = apiClient.getAccessToken("client_credentials", clientId, clientSecret, "v3.0");
            apiClient.addDefaultHeader("Authorization", "Bearer " + accesstoken);
        }
        apiClient.addDefaultHeader("x-aspose-client", "java sdk");
        apiClient.addDefaultHeader("x-aspose-client-version", "26.2");
        this.apiClient = apiClient;
    }

         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call decomposeUserTaskValidateBeforeCall(DecomposeUserTaskRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void decomposeUserTask(DecomposeUserTaskRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(decomposeUserTask(request), new File(LocalOutPath));
             }
         public  File  decomposeUserTask(DecomposeUserTaskRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = decomposeUserTaskWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = decomposeUserTaskWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > decomposeUserTaskWithHttpInfo(DecomposeUserTaskRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  decomposeUserTaskValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  decomposeUserTaskAsync( DecomposeUserTaskRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  decomposeUserTaskValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call translateSpreadsheetValidateBeforeCall(TranslateSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void translateSpreadsheet(TranslateSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(translateSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  translateSpreadsheet(TranslateSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = translateSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = translateSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > translateSpreadsheetWithHttpInfo(TranslateSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  translateSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  translateSpreadsheetAsync( TranslateSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  translateSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call translateTextFileValidateBeforeCall(TranslateTextFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  translateTextFile(TranslateTextFileRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = translateTextFileWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = translateTextFileWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > translateTextFileWithHttpInfo(TranslateTextFileRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  translateTextFileValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  translateTextFileAsync( TranslateTextFileRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  translateTextFileValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call aggregateCellsByColorValidateBeforeCall(AggregateCellsByColorRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AggregateResultByColorResponse  aggregateCellsByColor(AggregateCellsByColorRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AggregateResultByColorResponse > resp = aggregateCellsByColorWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AggregateResultByColorResponse > resp = aggregateCellsByColorWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AggregateResultByColorResponse > aggregateCellsByColorWithHttpInfo(AggregateCellsByColorRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  aggregateCellsByColorValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AggregateResultByColorResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  aggregateCellsByColorAsync( AggregateCellsByColorRequest request, final ApiCallback< AggregateResultByColorResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  aggregateCellsByColorValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AggregateResultByColorResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call mathCalculateValidateBeforeCall(MathCalculateRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void mathCalculate(MathCalculateRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(mathCalculate(request), new File(LocalOutPath));
             }
         public  File  mathCalculate(MathCalculateRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = mathCalculateWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = mathCalculateWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > mathCalculateWithHttpInfo(MathCalculateRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  mathCalculateValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  mathCalculateAsync( MathCalculateRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  mathCalculateValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postAccessTokenValidateBeforeCall(PostAccessTokenRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  postAccessToken(PostAccessTokenRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = postAccessTokenWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = postAccessTokenWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > postAccessTokenWithHttpInfo(PostAccessTokenRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postAccessTokenValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postAccessTokenAsync( PostAccessTokenRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postAccessTokenValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getAsposeCellsCloudStatusValidateBeforeCall(GetAsposeCellsCloudStatusRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  getAsposeCellsCloudStatus(GetAsposeCellsCloudStatusRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = getAsposeCellsCloudStatusWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = getAsposeCellsCloudStatusWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > getAsposeCellsCloudStatusWithHttpInfo(GetAsposeCellsCloudStatusRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getAsposeCellsCloudStatusValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getAsposeCellsCloudStatusAsync( GetAsposeCellsCloudStatusRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getAsposeCellsCloudStatusValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call checkCloudServiceHealthValidateBeforeCall(CheckCloudServiceHealthRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  checkCloudServiceHealth(CheckCloudServiceHealthRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = checkCloudServiceHealthWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = checkCloudServiceHealthWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > checkCloudServiceHealthWithHttpInfo(CheckCloudServiceHealthRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  checkCloudServiceHealthValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  checkCloudServiceHealthAsync( CheckCloudServiceHealthRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  checkCloudServiceHealthValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call exportSpreadsheetAsFormatValidateBeforeCall(ExportSpreadsheetAsFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void exportSpreadsheetAsFormat(ExportSpreadsheetAsFormatRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(exportSpreadsheetAsFormat(request), new File(LocalOutPath));
             }
         public  File  exportSpreadsheetAsFormat(ExportSpreadsheetAsFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = exportSpreadsheetAsFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = exportSpreadsheetAsFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > exportSpreadsheetAsFormatWithHttpInfo(ExportSpreadsheetAsFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  exportSpreadsheetAsFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  exportSpreadsheetAsFormatAsync( ExportSpreadsheetAsFormatRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  exportSpreadsheetAsFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call exportWorksheetAsFormatValidateBeforeCall(ExportWorksheetAsFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void exportWorksheetAsFormat(ExportWorksheetAsFormatRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(exportWorksheetAsFormat(request), new File(LocalOutPath));
             }
         public  File  exportWorksheetAsFormat(ExportWorksheetAsFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = exportWorksheetAsFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = exportWorksheetAsFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > exportWorksheetAsFormatWithHttpInfo(ExportWorksheetAsFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  exportWorksheetAsFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  exportWorksheetAsFormatAsync( ExportWorksheetAsFormatRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  exportWorksheetAsFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call exportChartAsFormatValidateBeforeCall(ExportChartAsFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void exportChartAsFormat(ExportChartAsFormatRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(exportChartAsFormat(request), new File(LocalOutPath));
             }
         public  File  exportChartAsFormat(ExportChartAsFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = exportChartAsFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = exportChartAsFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > exportChartAsFormatWithHttpInfo(ExportChartAsFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  exportChartAsFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  exportChartAsFormatAsync( ExportChartAsFormatRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  exportChartAsFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call exportTableAsFormatValidateBeforeCall(ExportTableAsFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void exportTableAsFormat(ExportTableAsFormatRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(exportTableAsFormat(request), new File(LocalOutPath));
             }
         public  File  exportTableAsFormat(ExportTableAsFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = exportTableAsFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = exportTableAsFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > exportTableAsFormatWithHttpInfo(ExportTableAsFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  exportTableAsFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  exportTableAsFormatAsync( ExportTableAsFormatRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  exportTableAsFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call exportRangeAsFormatValidateBeforeCall(ExportRangeAsFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void exportRangeAsFormat(ExportRangeAsFormatRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(exportRangeAsFormat(request), new File(LocalOutPath));
             }
         public  File  exportRangeAsFormat(ExportRangeAsFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = exportRangeAsFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = exportRangeAsFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > exportRangeAsFormatWithHttpInfo(ExportRangeAsFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  exportRangeAsFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  exportRangeAsFormatAsync( ExportRangeAsFormatRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  exportRangeAsFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertSpreadsheetValidateBeforeCall(ConvertSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertSpreadsheet(ConvertSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  convertSpreadsheet(ConvertSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertSpreadsheetWithHttpInfo(ConvertSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertSpreadsheetAsync( ConvertSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertSpreadsheetToPdfValidateBeforeCall(ConvertSpreadsheetToPdfRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertSpreadsheetToPdf(ConvertSpreadsheetToPdfRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertSpreadsheetToPdf(request), new File(LocalOutPath));
             }
         public  File  convertSpreadsheetToPdf(ConvertSpreadsheetToPdfRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertSpreadsheetToPdfWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertSpreadsheetToPdfWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertSpreadsheetToPdfWithHttpInfo(ConvertSpreadsheetToPdfRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertSpreadsheetToPdfValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertSpreadsheetToPdfAsync( ConvertSpreadsheetToPdfRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertSpreadsheetToPdfValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertSpreadsheetToJsonValidateBeforeCall(ConvertSpreadsheetToJsonRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertSpreadsheetToJson(ConvertSpreadsheetToJsonRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertSpreadsheetToJson(request), new File(LocalOutPath));
             }
         public  File  convertSpreadsheetToJson(ConvertSpreadsheetToJsonRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertSpreadsheetToJsonWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertSpreadsheetToJsonWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertSpreadsheetToJsonWithHttpInfo(ConvertSpreadsheetToJsonRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertSpreadsheetToJsonValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertSpreadsheetToJsonAsync( ConvertSpreadsheetToJsonRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertSpreadsheetToJsonValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertSpreadsheetToCsvValidateBeforeCall(ConvertSpreadsheetToCsvRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertSpreadsheetToCsv(ConvertSpreadsheetToCsvRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertSpreadsheetToCsv(request), new File(LocalOutPath));
             }
         public  File  convertSpreadsheetToCsv(ConvertSpreadsheetToCsvRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertSpreadsheetToCsvWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertSpreadsheetToCsvWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertSpreadsheetToCsvWithHttpInfo(ConvertSpreadsheetToCsvRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertSpreadsheetToCsvValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertSpreadsheetToCsvAsync( ConvertSpreadsheetToCsvRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertSpreadsheetToCsvValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertWorksheetToImageValidateBeforeCall(ConvertWorksheetToImageRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertWorksheetToImage(ConvertWorksheetToImageRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertWorksheetToImage(request), new File(LocalOutPath));
             }
         public  File  convertWorksheetToImage(ConvertWorksheetToImageRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertWorksheetToImageWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertWorksheetToImageWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertWorksheetToImageWithHttpInfo(ConvertWorksheetToImageRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertWorksheetToImageValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertWorksheetToImageAsync( ConvertWorksheetToImageRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertWorksheetToImageValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertWorksheetToPdfValidateBeforeCall(ConvertWorksheetToPdfRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertWorksheetToPdf(ConvertWorksheetToPdfRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertWorksheetToPdf(request), new File(LocalOutPath));
             }
         public  File  convertWorksheetToPdf(ConvertWorksheetToPdfRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertWorksheetToPdfWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertWorksheetToPdfWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertWorksheetToPdfWithHttpInfo(ConvertWorksheetToPdfRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertWorksheetToPdfValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertWorksheetToPdfAsync( ConvertWorksheetToPdfRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertWorksheetToPdfValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertWorksheetToJsonValidateBeforeCall(ConvertWorksheetToJsonRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertWorksheetToJson(ConvertWorksheetToJsonRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertWorksheetToJson(request), new File(LocalOutPath));
             }
         public  File  convertWorksheetToJson(ConvertWorksheetToJsonRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertWorksheetToJsonWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertWorksheetToJsonWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertWorksheetToJsonWithHttpInfo(ConvertWorksheetToJsonRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertWorksheetToJsonValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertWorksheetToJsonAsync( ConvertWorksheetToJsonRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertWorksheetToJsonValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertWorksheetToCsvValidateBeforeCall(ConvertWorksheetToCsvRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertWorksheetToCsv(ConvertWorksheetToCsvRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertWorksheetToCsv(request), new File(LocalOutPath));
             }
         public  File  convertWorksheetToCsv(ConvertWorksheetToCsvRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertWorksheetToCsvWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertWorksheetToCsvWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertWorksheetToCsvWithHttpInfo(ConvertWorksheetToCsvRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertWorksheetToCsvValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertWorksheetToCsvAsync( ConvertWorksheetToCsvRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertWorksheetToCsvValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertWorksheetToHtmlValidateBeforeCall(ConvertWorksheetToHtmlRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertWorksheetToHtml(ConvertWorksheetToHtmlRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertWorksheetToHtml(request), new File(LocalOutPath));
             }
         public  File  convertWorksheetToHtml(ConvertWorksheetToHtmlRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertWorksheetToHtmlWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertWorksheetToHtmlWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertWorksheetToHtmlWithHttpInfo(ConvertWorksheetToHtmlRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertWorksheetToHtmlValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertWorksheetToHtmlAsync( ConvertWorksheetToHtmlRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertWorksheetToHtmlValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertWorksheetToHtmlTableValidateBeforeCall(ConvertWorksheetToHtmlTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertWorksheetToHtmlTable(ConvertWorksheetToHtmlTableRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertWorksheetToHtmlTable(request), new File(LocalOutPath));
             }
         public  File  convertWorksheetToHtmlTable(ConvertWorksheetToHtmlTableRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertWorksheetToHtmlTableWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertWorksheetToHtmlTableWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertWorksheetToHtmlTableWithHttpInfo(ConvertWorksheetToHtmlTableRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertWorksheetToHtmlTableValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertWorksheetToHtmlTableAsync( ConvertWorksheetToHtmlTableRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertWorksheetToHtmlTableValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertTableToImageValidateBeforeCall(ConvertTableToImageRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertTableToImage(ConvertTableToImageRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertTableToImage(request), new File(LocalOutPath));
             }
         public  File  convertTableToImage(ConvertTableToImageRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertTableToImageWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertTableToImageWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertTableToImageWithHttpInfo(ConvertTableToImageRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertTableToImageValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertTableToImageAsync( ConvertTableToImageRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertTableToImageValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertTableToPdfValidateBeforeCall(ConvertTableToPdfRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertTableToPdf(ConvertTableToPdfRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertTableToPdf(request), new File(LocalOutPath));
             }
         public  File  convertTableToPdf(ConvertTableToPdfRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertTableToPdfWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertTableToPdfWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertTableToPdfWithHttpInfo(ConvertTableToPdfRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertTableToPdfValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertTableToPdfAsync( ConvertTableToPdfRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertTableToPdfValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertTableToCsvValidateBeforeCall(ConvertTableToCsvRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertTableToCsv(ConvertTableToCsvRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertTableToCsv(request), new File(LocalOutPath));
             }
         public  File  convertTableToCsv(ConvertTableToCsvRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertTableToCsvWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertTableToCsvWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertTableToCsvWithHttpInfo(ConvertTableToCsvRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertTableToCsvValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertTableToCsvAsync( ConvertTableToCsvRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertTableToCsvValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertTableToHtmlValidateBeforeCall(ConvertTableToHtmlRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertTableToHtml(ConvertTableToHtmlRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertTableToHtml(request), new File(LocalOutPath));
             }
         public  File  convertTableToHtml(ConvertTableToHtmlRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertTableToHtmlWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertTableToHtmlWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertTableToHtmlWithHttpInfo(ConvertTableToHtmlRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertTableToHtmlValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertTableToHtmlAsync( ConvertTableToHtmlRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertTableToHtmlValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertTableToJsonValidateBeforeCall(ConvertTableToJsonRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertTableToJson(ConvertTableToJsonRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertTableToJson(request), new File(LocalOutPath));
             }
         public  File  convertTableToJson(ConvertTableToJsonRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertTableToJsonWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertTableToJsonWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertTableToJsonWithHttpInfo(ConvertTableToJsonRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertTableToJsonValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertTableToJsonAsync( ConvertTableToJsonRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertTableToJsonValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertRangeToImageValidateBeforeCall(ConvertRangeToImageRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertRangeToImage(ConvertRangeToImageRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertRangeToImage(request), new File(LocalOutPath));
             }
         public  File  convertRangeToImage(ConvertRangeToImageRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertRangeToImageWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertRangeToImageWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertRangeToImageWithHttpInfo(ConvertRangeToImageRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertRangeToImageValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertRangeToImageAsync( ConvertRangeToImageRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertRangeToImageValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertRangeToPdfValidateBeforeCall(ConvertRangeToPdfRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertRangeToPdf(ConvertRangeToPdfRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertRangeToPdf(request), new File(LocalOutPath));
             }
         public  File  convertRangeToPdf(ConvertRangeToPdfRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertRangeToPdfWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertRangeToPdfWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertRangeToPdfWithHttpInfo(ConvertRangeToPdfRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertRangeToPdfValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertRangeToPdfAsync( ConvertRangeToPdfRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertRangeToPdfValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertRangeToCsvValidateBeforeCall(ConvertRangeToCsvRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertRangeToCsv(ConvertRangeToCsvRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertRangeToCsv(request), new File(LocalOutPath));
             }
         public  File  convertRangeToCsv(ConvertRangeToCsvRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertRangeToCsvWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertRangeToCsvWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertRangeToCsvWithHttpInfo(ConvertRangeToCsvRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertRangeToCsvValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertRangeToCsvAsync( ConvertRangeToCsvRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertRangeToCsvValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertRangeToHtmlValidateBeforeCall(ConvertRangeToHtmlRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertRangeToHtml(ConvertRangeToHtmlRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertRangeToHtml(request), new File(LocalOutPath));
             }
         public  File  convertRangeToHtml(ConvertRangeToHtmlRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertRangeToHtmlWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertRangeToHtmlWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertRangeToHtmlWithHttpInfo(ConvertRangeToHtmlRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertRangeToHtmlValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertRangeToHtmlAsync( ConvertRangeToHtmlRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertRangeToHtmlValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertRangeToJsonValidateBeforeCall(ConvertRangeToJsonRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertRangeToJson(ConvertRangeToJsonRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertRangeToJson(request), new File(LocalOutPath));
             }
         public  File  convertRangeToJson(ConvertRangeToJsonRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertRangeToJsonWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertRangeToJsonWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertRangeToJsonWithHttpInfo(ConvertRangeToJsonRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertRangeToJsonValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertRangeToJsonAsync( ConvertRangeToJsonRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertRangeToJsonValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertChartToImageValidateBeforeCall(ConvertChartToImageRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertChartToImage(ConvertChartToImageRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertChartToImage(request), new File(LocalOutPath));
             }
         public  File  convertChartToImage(ConvertChartToImageRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertChartToImageWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertChartToImageWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertChartToImageWithHttpInfo(ConvertChartToImageRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertChartToImageValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertChartToImageAsync( ConvertChartToImageRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertChartToImageValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertChartToPdfValidateBeforeCall(ConvertChartToPdfRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertChartToPdf(ConvertChartToPdfRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertChartToPdf(request), new File(LocalOutPath));
             }
         public  File  convertChartToPdf(ConvertChartToPdfRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertChartToPdfWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertChartToPdfWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertChartToPdfWithHttpInfo(ConvertChartToPdfRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertChartToPdfValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertChartToPdfAsync( ConvertChartToPdfRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertChartToPdfValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call saveSpreadsheetAsValidateBeforeCall(SaveSpreadsheetAsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  saveSpreadsheetAs(SaveSpreadsheetAsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = saveSpreadsheetAsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = saveSpreadsheetAsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > saveSpreadsheetAsWithHttpInfo(SaveSpreadsheetAsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  saveSpreadsheetAsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  saveSpreadsheetAsAsync( SaveSpreadsheetAsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  saveSpreadsheetAsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call mergeSpreadsheetsValidateBeforeCall(MergeSpreadsheetsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void mergeSpreadsheets(MergeSpreadsheetsRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(mergeSpreadsheets(request), new File(LocalOutPath));
             }
         public  File  mergeSpreadsheets(MergeSpreadsheetsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = mergeSpreadsheetsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = mergeSpreadsheetsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > mergeSpreadsheetsWithHttpInfo(MergeSpreadsheetsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  mergeSpreadsheetsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  mergeSpreadsheetsAsync( MergeSpreadsheetsRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  mergeSpreadsheetsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call mergeSpreadsheetsInRemoteFolderValidateBeforeCall(MergeSpreadsheetsInRemoteFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void mergeSpreadsheetsInRemoteFolder(MergeSpreadsheetsInRemoteFolderRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(mergeSpreadsheetsInRemoteFolder(request), new File(LocalOutPath));
             }
         public  File  mergeSpreadsheetsInRemoteFolder(MergeSpreadsheetsInRemoteFolderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = mergeSpreadsheetsInRemoteFolderWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = mergeSpreadsheetsInRemoteFolderWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > mergeSpreadsheetsInRemoteFolderWithHttpInfo(MergeSpreadsheetsInRemoteFolderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  mergeSpreadsheetsInRemoteFolderValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  mergeSpreadsheetsInRemoteFolderAsync( MergeSpreadsheetsInRemoteFolderRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  mergeSpreadsheetsInRemoteFolderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call mergeRemoteSpreadsheetValidateBeforeCall(MergeRemoteSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void mergeRemoteSpreadsheet(MergeRemoteSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(mergeRemoteSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  mergeRemoteSpreadsheet(MergeRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = mergeRemoteSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = mergeRemoteSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > mergeRemoteSpreadsheetWithHttpInfo(MergeRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  mergeRemoteSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  mergeRemoteSpreadsheetAsync( MergeRemoteSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  mergeRemoteSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call splitSpreadsheetValidateBeforeCall(SplitSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void splitSpreadsheet(SplitSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(splitSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  splitSpreadsheet(SplitSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = splitSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = splitSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > splitSpreadsheetWithHttpInfo(SplitSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  splitSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  splitSpreadsheetAsync( SplitSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  splitSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call splitTableValidateBeforeCall(SplitTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void splitTable(SplitTableRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(splitTable(request), new File(LocalOutPath));
             }
         public  File  splitTable(SplitTableRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = splitTableWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = splitTableWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > splitTableWithHttpInfo(SplitTableRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  splitTableValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  splitTableAsync( SplitTableRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  splitTableValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call splitRemoteSpreadsheetValidateBeforeCall(SplitRemoteSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void splitRemoteSpreadsheet(SplitRemoteSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(splitRemoteSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  splitRemoteSpreadsheet(SplitRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = splitRemoteSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = splitRemoteSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > splitRemoteSpreadsheetWithHttpInfo(SplitRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  splitRemoteSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  splitRemoteSpreadsheetAsync( SplitRemoteSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  splitRemoteSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call importDataIntoSpreadsheetValidateBeforeCall(ImportDataIntoSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void importDataIntoSpreadsheet(ImportDataIntoSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(importDataIntoSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  importDataIntoSpreadsheet(ImportDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = importDataIntoSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = importDataIntoSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > importDataIntoSpreadsheetWithHttpInfo(ImportDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  importDataIntoSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  importDataIntoSpreadsheetAsync( ImportDataIntoSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  importDataIntoSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call importJSONDataIntoSpreadsheetValidateBeforeCall(ImportJSONDataIntoSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void importJSONDataIntoSpreadsheet(ImportJSONDataIntoSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(importJSONDataIntoSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  importJSONDataIntoSpreadsheet(ImportJSONDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = importJSONDataIntoSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = importJSONDataIntoSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > importJSONDataIntoSpreadsheetWithHttpInfo(ImportJSONDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  importJSONDataIntoSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  importJSONDataIntoSpreadsheetAsync( ImportJSONDataIntoSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  importJSONDataIntoSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call importXMLDataIntoSpreadsheetValidateBeforeCall(ImportXMLDataIntoSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void importXMLDataIntoSpreadsheet(ImportXMLDataIntoSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(importXMLDataIntoSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  importXMLDataIntoSpreadsheet(ImportXMLDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = importXMLDataIntoSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = importXMLDataIntoSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > importXMLDataIntoSpreadsheetWithHttpInfo(ImportXMLDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  importXMLDataIntoSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  importXMLDataIntoSpreadsheetAsync( ImportXMLDataIntoSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  importXMLDataIntoSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call importCSVDataIntoSpreadsheetValidateBeforeCall(ImportCSVDataIntoSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void importCSVDataIntoSpreadsheet(ImportCSVDataIntoSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(importCSVDataIntoSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  importCSVDataIntoSpreadsheet(ImportCSVDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = importCSVDataIntoSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = importCSVDataIntoSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > importCSVDataIntoSpreadsheetWithHttpInfo(ImportCSVDataIntoSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  importCSVDataIntoSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  importCSVDataIntoSpreadsheetAsync( ImportCSVDataIntoSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  importCSVDataIntoSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getPublicKeyValidateBeforeCall(GetPublicKeyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudPublicKeyResponse  getPublicKey(GetPublicKeyRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudPublicKeyResponse > resp = getPublicKeyWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudPublicKeyResponse > resp = getPublicKeyWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudPublicKeyResponse > getPublicKeyWithHttpInfo(GetPublicKeyRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getPublicKeyValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudPublicKeyResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getPublicKeyAsync( GetPublicKeyRequest request, final ApiCallback< CellsCloudPublicKeyResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getPublicKeyValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudPublicKeyResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call createSpreadsheetValidateBeforeCall(CreateSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void createSpreadsheet(CreateSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(createSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  createSpreadsheet(CreateSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = createSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = createSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > createSpreadsheetWithHttpInfo(CreateSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  createSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  createSpreadsheetAsync( CreateSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  createSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetsWithLocalSpreadsheetValidateBeforeCall(GetWorksheetsWithLocalSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  getWorksheetsWithLocalSpreadsheet(GetWorksheetsWithLocalSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = getWorksheetsWithLocalSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = getWorksheetsWithLocalSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > getWorksheetsWithLocalSpreadsheetWithHttpInfo(GetWorksheetsWithLocalSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetsWithLocalSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetsWithLocalSpreadsheetAsync( GetWorksheetsWithLocalSpreadsheetRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetsWithLocalSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call addWorksheetToSpreadsheetValidateBeforeCall(AddWorksheetToSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void addWorksheetToSpreadsheet(AddWorksheetToSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(addWorksheetToSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  addWorksheetToSpreadsheet(AddWorksheetToSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = addWorksheetToSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = addWorksheetToSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > addWorksheetToSpreadsheetWithHttpInfo(AddWorksheetToSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  addWorksheetToSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  addWorksheetToSpreadsheetAsync( AddWorksheetToSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  addWorksheetToSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetFromSpreadsheetValidateBeforeCall(DeleteWorksheetFromSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void deleteWorksheetFromSpreadsheet(DeleteWorksheetFromSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(deleteWorksheetFromSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  deleteWorksheetFromSpreadsheet(DeleteWorksheetFromSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = deleteWorksheetFromSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = deleteWorksheetFromSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > deleteWorksheetFromSpreadsheetWithHttpInfo(DeleteWorksheetFromSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetFromSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetFromSpreadsheetAsync( DeleteWorksheetFromSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetFromSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call renameWorksheetInSpreadsheetValidateBeforeCall(RenameWorksheetInSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void renameWorksheetInSpreadsheet(RenameWorksheetInSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(renameWorksheetInSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  renameWorksheetInSpreadsheet(RenameWorksheetInSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = renameWorksheetInSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = renameWorksheetInSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > renameWorksheetInSpreadsheetWithHttpInfo(RenameWorksheetInSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  renameWorksheetInSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  renameWorksheetInSpreadsheetAsync( RenameWorksheetInSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  renameWorksheetInSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call moveWorksheetInSpreadsheetValidateBeforeCall(MoveWorksheetInSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void moveWorksheetInSpreadsheet(MoveWorksheetInSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(moveWorksheetInSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  moveWorksheetInSpreadsheet(MoveWorksheetInSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = moveWorksheetInSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = moveWorksheetInSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > moveWorksheetInSpreadsheetWithHttpInfo(MoveWorksheetInSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  moveWorksheetInSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  moveWorksheetInSpreadsheetAsync( MoveWorksheetInSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  moveWorksheetInSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call compressSpreadsheetValidateBeforeCall(CompressSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void compressSpreadsheet(CompressSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(compressSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  compressSpreadsheet(CompressSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = compressSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = compressSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > compressSpreadsheetWithHttpInfo(CompressSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  compressSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  compressSpreadsheetAsync( CompressSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  compressSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call repairSpreadsheetValidateBeforeCall(RepairSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void repairSpreadsheet(RepairSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(repairSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  repairSpreadsheet(RepairSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = repairSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = repairSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > repairSpreadsheetWithHttpInfo(RepairSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  repairSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  repairSpreadsheetAsync( RepairSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  repairSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getMergedCellsInRemotedWorksheetValidateBeforeCall(GetMergedCellsInRemotedWorksheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ArrayList<CellArea>  getMergedCellsInRemotedWorksheet(GetMergedCellsInRemotedWorksheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ArrayList<CellArea> > resp = getMergedCellsInRemotedWorksheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ArrayList<CellArea> > resp = getMergedCellsInRemotedWorksheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ArrayList<CellArea> > getMergedCellsInRemotedWorksheetWithHttpInfo(GetMergedCellsInRemotedWorksheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getMergedCellsInRemotedWorksheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ArrayList<CellArea> >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getMergedCellsInRemotedWorksheetAsync( GetMergedCellsInRemotedWorksheetRequest request, final ApiCallback< ArrayList<CellArea> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getMergedCellsInRemotedWorksheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ArrayList<CellArea> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getMergedCellsInWorksheetValidateBeforeCall(GetMergedCellsInWorksheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ArrayList<CellArea>  getMergedCellsInWorksheet(GetMergedCellsInWorksheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ArrayList<CellArea> > resp = getMergedCellsInWorksheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ArrayList<CellArea> > resp = getMergedCellsInWorksheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ArrayList<CellArea> > getMergedCellsInWorksheetWithHttpInfo(GetMergedCellsInWorksheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getMergedCellsInWorksheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ArrayList<CellArea> >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getMergedCellsInWorksheetAsync( GetMergedCellsInWorksheetRequest request, final ApiCallback< ArrayList<CellArea> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getMergedCellsInWorksheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ArrayList<CellArea> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call protectSpreadsheetValidateBeforeCall(ProtectSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void protectSpreadsheet(ProtectSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(protectSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  protectSpreadsheet(ProtectSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = protectSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = protectSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > protectSpreadsheetWithHttpInfo(ProtectSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  protectSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  protectSpreadsheetAsync( ProtectSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  protectSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call unprotectSpreadsheetValidateBeforeCall(UnprotectSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void unprotectSpreadsheet(UnprotectSpreadsheetRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(unprotectSpreadsheet(request), new File(LocalOutPath));
             }
         public  File  unprotectSpreadsheet(UnprotectSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = unprotectSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = unprotectSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > unprotectSpreadsheetWithHttpInfo(UnprotectSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  unprotectSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  unprotectSpreadsheetAsync( UnprotectSpreadsheetRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  unprotectSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call spreadsheetDigitalsignatureValidateBeforeCall(SpreadsheetDigitalsignatureRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void spreadsheetDigitalsignature(SpreadsheetDigitalsignatureRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(spreadsheetDigitalsignature(request), new File(LocalOutPath));
             }
         public  File  spreadsheetDigitalsignature(SpreadsheetDigitalsignatureRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = spreadsheetDigitalsignatureWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = spreadsheetDigitalsignatureWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > spreadsheetDigitalsignatureWithHttpInfo(SpreadsheetDigitalsignatureRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  spreadsheetDigitalsignatureValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  spreadsheetDigitalsignatureAsync( SpreadsheetDigitalsignatureRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  spreadsheetDigitalsignatureValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchAllTextItemsInRemoteSpreadsheetValidateBeforeCall(SearchAllTextItemsInRemoteSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  SearchResponse  searchAllTextItemsInRemoteSpreadsheet(SearchAllTextItemsInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< SearchResponse > resp = searchAllTextItemsInRemoteSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< SearchResponse > resp = searchAllTextItemsInRemoteSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< SearchResponse > searchAllTextItemsInRemoteSpreadsheetWithHttpInfo(SearchAllTextItemsInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchAllTextItemsInRemoteSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchAllTextItemsInRemoteSpreadsheetAsync( SearchAllTextItemsInRemoteSpreadsheetRequest request, final ApiCallback< SearchResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchAllTextItemsInRemoteSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchSpreadsheetAllTextItemsValidateBeforeCall(SearchSpreadsheetAllTextItemsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  SearchResponse  searchSpreadsheetAllTextItems(SearchSpreadsheetAllTextItemsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< SearchResponse > resp = searchSpreadsheetAllTextItemsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< SearchResponse > resp = searchSpreadsheetAllTextItemsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< SearchResponse > searchSpreadsheetAllTextItemsWithHttpInfo(SearchSpreadsheetAllTextItemsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchSpreadsheetAllTextItemsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchSpreadsheetAllTextItemsAsync( SearchSpreadsheetAllTextItemsRequest request, final ApiCallback< SearchResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchSpreadsheetAllTextItemsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchSpreadsheetContentValidateBeforeCall(SearchSpreadsheetContentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  SearchResponse  searchSpreadsheetContent(SearchSpreadsheetContentRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< SearchResponse > resp = searchSpreadsheetContentWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< SearchResponse > resp = searchSpreadsheetContentWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< SearchResponse > searchSpreadsheetContentWithHttpInfo(SearchSpreadsheetContentRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchSpreadsheetContentValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchSpreadsheetContentAsync( SearchSpreadsheetContentRequest request, final ApiCallback< SearchResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchSpreadsheetContentValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchContentInRemoteSpreadsheetValidateBeforeCall(SearchContentInRemoteSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  SearchResponse  searchContentInRemoteSpreadsheet(SearchContentInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< SearchResponse > resp = searchContentInRemoteSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< SearchResponse > resp = searchContentInRemoteSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< SearchResponse > searchContentInRemoteSpreadsheetWithHttpInfo(SearchContentInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchContentInRemoteSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchContentInRemoteSpreadsheetAsync( SearchContentInRemoteSpreadsheetRequest request, final ApiCallback< SearchResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchContentInRemoteSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchContentInRemoteWorksheetValidateBeforeCall(SearchContentInRemoteWorksheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  SearchResponse  searchContentInRemoteWorksheet(SearchContentInRemoteWorksheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< SearchResponse > resp = searchContentInRemoteWorksheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< SearchResponse > resp = searchContentInRemoteWorksheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< SearchResponse > searchContentInRemoteWorksheetWithHttpInfo(SearchContentInRemoteWorksheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchContentInRemoteWorksheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchContentInRemoteWorksheetAsync( SearchContentInRemoteWorksheetRequest request, final ApiCallback< SearchResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchContentInRemoteWorksheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchContentInRemoteRangeValidateBeforeCall(SearchContentInRemoteRangeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  SearchResponse  searchContentInRemoteRange(SearchContentInRemoteRangeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< SearchResponse > resp = searchContentInRemoteRangeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< SearchResponse > resp = searchContentInRemoteRangeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< SearchResponse > searchContentInRemoteRangeWithHttpInfo(SearchContentInRemoteRangeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchContentInRemoteRangeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchContentInRemoteRangeAsync( SearchContentInRemoteRangeRequest request, final ApiCallback< SearchResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchContentInRemoteRangeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< SearchResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call replaceSpreadsheetContentValidateBeforeCall(ReplaceSpreadsheetContentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void replaceSpreadsheetContent(ReplaceSpreadsheetContentRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(replaceSpreadsheetContent(request), new File(LocalOutPath));
             }
         public  File  replaceSpreadsheetContent(ReplaceSpreadsheetContentRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = replaceSpreadsheetContentWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = replaceSpreadsheetContentWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > replaceSpreadsheetContentWithHttpInfo(ReplaceSpreadsheetContentRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  replaceSpreadsheetContentValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  replaceSpreadsheetContentAsync( ReplaceSpreadsheetContentRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  replaceSpreadsheetContentValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call replaceContentInRemoteSpreadsheetValidateBeforeCall(ReplaceContentInRemoteSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  replaceContentInRemoteSpreadsheet(ReplaceContentInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = replaceContentInRemoteSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = replaceContentInRemoteSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > replaceContentInRemoteSpreadsheetWithHttpInfo(ReplaceContentInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  replaceContentInRemoteSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  replaceContentInRemoteSpreadsheetAsync( ReplaceContentInRemoteSpreadsheetRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  replaceContentInRemoteSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call replaceContentInRemoteWorksheetValidateBeforeCall(ReplaceContentInRemoteWorksheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  replaceContentInRemoteWorksheet(ReplaceContentInRemoteWorksheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = replaceContentInRemoteWorksheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = replaceContentInRemoteWorksheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > replaceContentInRemoteWorksheetWithHttpInfo(ReplaceContentInRemoteWorksheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  replaceContentInRemoteWorksheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  replaceContentInRemoteWorksheetAsync( ReplaceContentInRemoteWorksheetRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  replaceContentInRemoteWorksheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call replaceContentInRemoteRangeValidateBeforeCall(ReplaceContentInRemoteRangeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  replaceContentInRemoteRange(ReplaceContentInRemoteRangeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = replaceContentInRemoteRangeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = replaceContentInRemoteRangeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > replaceContentInRemoteRangeWithHttpInfo(ReplaceContentInRemoteRangeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  replaceContentInRemoteRangeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  replaceContentInRemoteRangeAsync( ReplaceContentInRemoteRangeRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  replaceContentInRemoteRangeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchSpreadsheetBrokenLinksValidateBeforeCall(SearchSpreadsheetBrokenLinksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  BrokenLinksResponse  searchSpreadsheetBrokenLinks(SearchSpreadsheetBrokenLinksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< BrokenLinksResponse > resp = searchSpreadsheetBrokenLinksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< BrokenLinksResponse > resp = searchSpreadsheetBrokenLinksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< BrokenLinksResponse > searchSpreadsheetBrokenLinksWithHttpInfo(SearchSpreadsheetBrokenLinksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchSpreadsheetBrokenLinksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchSpreadsheetBrokenLinksAsync( SearchSpreadsheetBrokenLinksRequest request, final ApiCallback< BrokenLinksResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchSpreadsheetBrokenLinksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchBrokenLinksInRemoteSpreadsheetValidateBeforeCall(SearchBrokenLinksInRemoteSpreadsheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  BrokenLinksResponse  searchBrokenLinksInRemoteSpreadsheet(SearchBrokenLinksInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< BrokenLinksResponse > resp = searchBrokenLinksInRemoteSpreadsheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< BrokenLinksResponse > resp = searchBrokenLinksInRemoteSpreadsheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< BrokenLinksResponse > searchBrokenLinksInRemoteSpreadsheetWithHttpInfo(SearchBrokenLinksInRemoteSpreadsheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchBrokenLinksInRemoteSpreadsheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchBrokenLinksInRemoteSpreadsheetAsync( SearchBrokenLinksInRemoteSpreadsheetRequest request, final ApiCallback< BrokenLinksResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchBrokenLinksInRemoteSpreadsheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchBrokenLinksInRemoteWorksheetValidateBeforeCall(SearchBrokenLinksInRemoteWorksheetRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  BrokenLinksResponse  searchBrokenLinksInRemoteWorksheet(SearchBrokenLinksInRemoteWorksheetRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< BrokenLinksResponse > resp = searchBrokenLinksInRemoteWorksheetWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< BrokenLinksResponse > resp = searchBrokenLinksInRemoteWorksheetWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< BrokenLinksResponse > searchBrokenLinksInRemoteWorksheetWithHttpInfo(SearchBrokenLinksInRemoteWorksheetRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchBrokenLinksInRemoteWorksheetValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchBrokenLinksInRemoteWorksheetAsync( SearchBrokenLinksInRemoteWorksheetRequest request, final ApiCallback< BrokenLinksResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchBrokenLinksInRemoteWorksheetValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call searchBrokenLinksInRemoteRangeValidateBeforeCall(SearchBrokenLinksInRemoteRangeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  BrokenLinksResponse  searchBrokenLinksInRemoteRange(SearchBrokenLinksInRemoteRangeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< BrokenLinksResponse > resp = searchBrokenLinksInRemoteRangeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< BrokenLinksResponse > resp = searchBrokenLinksInRemoteRangeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< BrokenLinksResponse > searchBrokenLinksInRemoteRangeWithHttpInfo(SearchBrokenLinksInRemoteRangeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  searchBrokenLinksInRemoteRangeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  searchBrokenLinksInRemoteRangeAsync( SearchBrokenLinksInRemoteRangeRequest request, final ApiCallback< BrokenLinksResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  searchBrokenLinksInRemoteRangeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< BrokenLinksResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call specValidateBeforeCall(SpecRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  spec(SpecRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = specWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = specWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > specWithHttpInfo(SpecRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  specValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  specAsync( SpecRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  specValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call codegenSpecValidateBeforeCall(CodegenSpecRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  codegenSpec(CodegenSpecRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = codegenSpecWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = codegenSpecWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > codegenSpecWithHttpInfo(CodegenSpecRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  codegenSpecValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  codegenSpecAsync( CodegenSpecRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  codegenSpecValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call trimCharacterValidateBeforeCall(TrimCharacterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void trimCharacter(TrimCharacterRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(trimCharacter(request), new File(LocalOutPath));
             }
         public  File  trimCharacter(TrimCharacterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = trimCharacterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = trimCharacterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > trimCharacterWithHttpInfo(TrimCharacterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  trimCharacterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  trimCharacterAsync( TrimCharacterRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  trimCharacterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call updateWordCaseValidateBeforeCall(UpdateWordCaseRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void updateWordCase(UpdateWordCaseRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(updateWordCase(request), new File(LocalOutPath));
             }
         public  File  updateWordCase(UpdateWordCaseRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = updateWordCaseWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = updateWordCaseWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > updateWordCaseWithHttpInfo(UpdateWordCaseRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  updateWordCaseValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  updateWordCaseAsync( UpdateWordCaseRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  updateWordCaseValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call removeCharactersValidateBeforeCall(RemoveCharactersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void removeCharacters(RemoveCharactersRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(removeCharacters(request), new File(LocalOutPath));
             }
         public  File  removeCharacters(RemoveCharactersRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = removeCharactersWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = removeCharactersWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > removeCharactersWithHttpInfo(RemoveCharactersRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  removeCharactersValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  removeCharactersAsync( RemoveCharactersRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  removeCharactersValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call removeCharactersByPositionValidateBeforeCall(RemoveCharactersByPositionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void removeCharactersByPosition(RemoveCharactersByPositionRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(removeCharactersByPosition(request), new File(LocalOutPath));
             }
         public  File  removeCharactersByPosition(RemoveCharactersByPositionRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = removeCharactersByPositionWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = removeCharactersByPositionWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > removeCharactersByPositionWithHttpInfo(RemoveCharactersByPositionRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  removeCharactersByPositionValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  removeCharactersByPositionAsync( RemoveCharactersByPositionRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  removeCharactersByPositionValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call removeDuplicateSubstringsValidateBeforeCall(RemoveDuplicateSubstringsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void removeDuplicateSubstrings(RemoveDuplicateSubstringsRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(removeDuplicateSubstrings(request), new File(LocalOutPath));
             }
         public  File  removeDuplicateSubstrings(RemoveDuplicateSubstringsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = removeDuplicateSubstringsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = removeDuplicateSubstringsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > removeDuplicateSubstringsWithHttpInfo(RemoveDuplicateSubstringsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  removeDuplicateSubstringsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  removeDuplicateSubstringsAsync( RemoveDuplicateSubstringsRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  removeDuplicateSubstringsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call addTextValidateBeforeCall(AddTextRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void addText(AddTextRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(addText(request), new File(LocalOutPath));
             }
         public  File  addText(AddTextRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = addTextWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = addTextWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > addTextWithHttpInfo(AddTextRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  addTextValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  addTextAsync( AddTextRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  addTextValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call convertTextValidateBeforeCall(ConvertTextRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void convertText(ConvertTextRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(convertText(request), new File(LocalOutPath));
             }
         public  File  convertText(ConvertTextRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = convertTextWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = convertTextWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > convertTextWithHttpInfo(ConvertTextRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  convertTextValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  convertTextAsync( ConvertTextRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  convertTextValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call extractTextValidateBeforeCall(ExtractTextRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void extractText(ExtractTextRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(extractText(request), new File(LocalOutPath));
             }
         public  File  extractText(ExtractTextRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = extractTextWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = extractTextWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > extractTextWithHttpInfo(ExtractTextRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  extractTextValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  extractTextAsync( ExtractTextRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  extractTextValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call splitTextValidateBeforeCall(SplitTextRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void splitText(SplitTextRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(splitText(request), new File(LocalOutPath));
             }
         public  File  splitText(SplitTextRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = splitTextWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = splitTextWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > splitTextWithHttpInfo(SplitTextRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  splitTextValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  splitTextAsync( SplitTextRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  splitTextValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call removeSpreadsheetBlankRowsValidateBeforeCall(RemoveSpreadsheetBlankRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void removeSpreadsheetBlankRows(RemoveSpreadsheetBlankRowsRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(removeSpreadsheetBlankRows(request), new File(LocalOutPath));
             }
         public  File  removeSpreadsheetBlankRows(RemoveSpreadsheetBlankRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = removeSpreadsheetBlankRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = removeSpreadsheetBlankRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > removeSpreadsheetBlankRowsWithHttpInfo(RemoveSpreadsheetBlankRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  removeSpreadsheetBlankRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  removeSpreadsheetBlankRowsAsync( RemoveSpreadsheetBlankRowsRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  removeSpreadsheetBlankRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call removeSpreadsheetBlankColumnsValidateBeforeCall(RemoveSpreadsheetBlankColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void removeSpreadsheetBlankColumns(RemoveSpreadsheetBlankColumnsRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(removeSpreadsheetBlankColumns(request), new File(LocalOutPath));
             }
         public  File  removeSpreadsheetBlankColumns(RemoveSpreadsheetBlankColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = removeSpreadsheetBlankColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = removeSpreadsheetBlankColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > removeSpreadsheetBlankColumnsWithHttpInfo(RemoveSpreadsheetBlankColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  removeSpreadsheetBlankColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  removeSpreadsheetBlankColumnsAsync( RemoveSpreadsheetBlankColumnsRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  removeSpreadsheetBlankColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call removeSpreadsheetBlankWorksheetsValidateBeforeCall(RemoveSpreadsheetBlankWorksheetsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void removeSpreadsheetBlankWorksheets(RemoveSpreadsheetBlankWorksheetsRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(removeSpreadsheetBlankWorksheets(request), new File(LocalOutPath));
             }
         public  File  removeSpreadsheetBlankWorksheets(RemoveSpreadsheetBlankWorksheetsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = removeSpreadsheetBlankWorksheetsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = removeSpreadsheetBlankWorksheetsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > removeSpreadsheetBlankWorksheetsWithHttpInfo(RemoveSpreadsheetBlankWorksheetsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  removeSpreadsheetBlankWorksheetsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  removeSpreadsheetBlankWorksheetsAsync( RemoveSpreadsheetBlankWorksheetsRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  removeSpreadsheetBlankWorksheetsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call removeDuplicatesValidateBeforeCall(RemoveDuplicatesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void removeDuplicates(RemoveDuplicatesRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(removeDuplicates(request), new File(LocalOutPath));
             }
         public  File  removeDuplicates(RemoveDuplicatesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = removeDuplicatesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = removeDuplicatesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > removeDuplicatesWithHttpInfo(RemoveDuplicatesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  removeDuplicatesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  removeDuplicatesAsync( RemoveDuplicatesRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  removeDuplicatesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call swapRangeValidateBeforeCall(SwapRangeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void swapRange(SwapRangeRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(swapRange(request), new File(LocalOutPath));
             }
         public  File  swapRange(SwapRangeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = swapRangeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = swapRangeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > swapRangeWithHttpInfo(SwapRangeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  swapRangeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  swapRangeAsync( SwapRangeRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  swapRangeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call flipDataValidateBeforeCall(FlipDataRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void flipData(FlipDataRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(flipData(request), new File(LocalOutPath));
             }
         public  File  flipData(FlipDataRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = flipDataWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = flipDataWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > flipDataWithHttpInfo(FlipDataRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  flipDataValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  flipDataAsync( FlipDataRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  flipDataValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call downloadFileValidateBeforeCall(DownloadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
             public void downloadFile(DownloadFileRequest request, String LocalOutPath) throws ApiException ,  IOException {
                 FileUtil.copyFile(downloadFile(request), new File(LocalOutPath));
             }
         public  File  downloadFile(DownloadFileRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = downloadFileWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = downloadFileWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > downloadFileWithHttpInfo(DownloadFileRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  downloadFileValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  downloadFileAsync( DownloadFileRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  downloadFileValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call uploadFileValidateBeforeCall(UploadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesUploadResult  uploadFile(UploadFileRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesUploadResult > resp = uploadFileWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesUploadResult > resp = uploadFileWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesUploadResult > uploadFileWithHttpInfo(UploadFileRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  uploadFileValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesUploadResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  uploadFileAsync( UploadFileRequest request, final ApiCallback< FilesUploadResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  uploadFileValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesUploadResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call copyFileValidateBeforeCall(CopyFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  copyFile(CopyFileRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = copyFileWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = copyFileWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > copyFileWithHttpInfo(CopyFileRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  copyFileValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  copyFileAsync( CopyFileRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  copyFileValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call moveFileValidateBeforeCall(MoveFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  moveFile(MoveFileRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = moveFileWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = moveFileWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > moveFileWithHttpInfo(MoveFileRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  moveFileValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  moveFileAsync( MoveFileRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  moveFileValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteFileValidateBeforeCall(DeleteFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  deleteFile(DeleteFileRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = deleteFileWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = deleteFileWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > deleteFileWithHttpInfo(DeleteFileRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteFileValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  deleteFileAsync( DeleteFileRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteFileValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getFilesListValidateBeforeCall(GetFilesListRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesList  getFilesList(GetFilesListRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesList > resp = getFilesListWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesList > resp = getFilesListWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesList > getFilesListWithHttpInfo(GetFilesListRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getFilesListValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesList >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getFilesListAsync( GetFilesListRequest request, final ApiCallback< FilesList > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getFilesListValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesList >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call createFolderValidateBeforeCall(CreateFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  createFolder(CreateFolderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = createFolderWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = createFolderWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > createFolderWithHttpInfo(CreateFolderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  createFolderValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  createFolderAsync( CreateFolderRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  createFolderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call copyFolderValidateBeforeCall(CopyFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  copyFolder(CopyFolderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = copyFolderWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = copyFolderWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > copyFolderWithHttpInfo(CopyFolderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  copyFolderValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  copyFolderAsync( CopyFolderRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  copyFolderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call moveFolderValidateBeforeCall(MoveFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  moveFolder(MoveFolderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = moveFolderWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = moveFolderWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > moveFolderWithHttpInfo(MoveFolderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  moveFolderValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  moveFolderAsync( MoveFolderRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  moveFolderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteFolderValidateBeforeCall(DeleteFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  void  deleteFolder(DeleteFolderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< Void > resp = deleteFolderWithHttpInfo(request);
                  return ;  
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< Void > resp = deleteFolderWithHttpInfo(request);
                      return ;        
                 }
                 throw ex;
             }
         }

         private ApiResponse< Void > deleteFolderWithHttpInfo(DeleteFolderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteFolderValidateBeforeCall(request, null, null);
             return apiClient.execute(call);
         }

         public com.squareup.okhttp.Call  deleteFolderAsync( DeleteFolderRequest request, final ApiCallback< Void > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteFolderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< Void >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call storageExistsValidateBeforeCall(StorageExistsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  StorageExist  storageExists(StorageExistsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< StorageExist > resp = storageExistsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< StorageExist > resp = storageExistsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< StorageExist > storageExistsWithHttpInfo(StorageExistsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  storageExistsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< StorageExist >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  storageExistsAsync( StorageExistsRequest request, final ApiCallback< StorageExist > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  storageExistsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< StorageExist >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call objectExistsValidateBeforeCall(ObjectExistsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ObjectExist  objectExists(ObjectExistsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ObjectExist > resp = objectExistsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ObjectExist > resp = objectExistsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ObjectExist > objectExistsWithHttpInfo(ObjectExistsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  objectExistsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ObjectExist >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  objectExistsAsync( ObjectExistsRequest request, final ApiCallback< ObjectExist > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  objectExistsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ObjectExist >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getDiscUsageValidateBeforeCall(GetDiscUsageRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  DiscUsage  getDiscUsage(GetDiscUsageRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< DiscUsage > resp = getDiscUsageWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< DiscUsage > resp = getDiscUsageWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< DiscUsage > getDiscUsageWithHttpInfo(GetDiscUsageRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getDiscUsageValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< DiscUsage >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getDiscUsageAsync( GetDiscUsageRequest request, final ApiCallback< DiscUsage > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getDiscUsageValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< DiscUsage >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getFileVersionsValidateBeforeCall(GetFileVersionsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileVersions  getFileVersions(GetFileVersionsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileVersions > resp = getFileVersionsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileVersions > resp = getFileVersionsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileVersions > getFileVersionsWithHttpInfo(GetFileVersionsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getFileVersionsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileVersions >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getFileVersionsAsync( GetFileVersionsRequest request, final ApiCallback< FileVersions > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getFileVersionsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileVersions >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postAnalyzeExcelValidateBeforeCall(PostAnalyzeExcelRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  List<AnalyzedResult>  postAnalyzeExcel(PostAnalyzeExcelRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< List<AnalyzedResult> > resp = postAnalyzeExcelWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< List<AnalyzedResult> > resp = postAnalyzeExcelWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< List<AnalyzedResult> > postAnalyzeExcelWithHttpInfo(PostAnalyzeExcelRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postAnalyzeExcelValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< List<AnalyzedResult> >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postAnalyzeExcelAsync( PostAnalyzeExcelRequest request, final ApiCallback< List<AnalyzedResult> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postAnalyzeExcelValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< List<AnalyzedResult> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetAutoFilterValidateBeforeCall(GetWorksheetAutoFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AutoFilterResponse  getWorksheetAutoFilter(GetWorksheetAutoFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AutoFilterResponse > resp = getWorksheetAutoFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AutoFilterResponse > resp = getWorksheetAutoFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AutoFilterResponse > getWorksheetAutoFilterWithHttpInfo(GetWorksheetAutoFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetAutoFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AutoFilterResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetAutoFilterAsync( GetWorksheetAutoFilterRequest request, final ApiCallback< AutoFilterResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetAutoFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AutoFilterResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetDateFilterValidateBeforeCall(PutWorksheetDateFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetDateFilter(PutWorksheetDateFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetDateFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetDateFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetDateFilterWithHttpInfo(PutWorksheetDateFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetDateFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetDateFilterAsync( PutWorksheetDateFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetDateFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetFilterValidateBeforeCall(PutWorksheetFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetFilter(PutWorksheetFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetFilterWithHttpInfo(PutWorksheetFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetFilterAsync( PutWorksheetFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetIconFilterValidateBeforeCall(PutWorksheetIconFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetIconFilter(PutWorksheetIconFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetIconFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetIconFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetIconFilterWithHttpInfo(PutWorksheetIconFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetIconFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetIconFilterAsync( PutWorksheetIconFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetIconFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetCustomFilterValidateBeforeCall(PutWorksheetCustomFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetCustomFilter(PutWorksheetCustomFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetCustomFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetCustomFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetCustomFilterWithHttpInfo(PutWorksheetCustomFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetCustomFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetCustomFilterAsync( PutWorksheetCustomFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetCustomFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetDynamicFilterValidateBeforeCall(PutWorksheetDynamicFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetDynamicFilter(PutWorksheetDynamicFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetDynamicFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetDynamicFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetDynamicFilterWithHttpInfo(PutWorksheetDynamicFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetDynamicFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetDynamicFilterAsync( PutWorksheetDynamicFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetDynamicFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetFilterTop10ValidateBeforeCall(PutWorksheetFilterTop10Request request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetFilterTop10(PutWorksheetFilterTop10Request request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetFilterTop10WithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetFilterTop10WithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetFilterTop10WithHttpInfo(PutWorksheetFilterTop10Request request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetFilterTop10ValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetFilterTop10Async( PutWorksheetFilterTop10Request request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetFilterTop10ValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetColorFilterValidateBeforeCall(PutWorksheetColorFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetColorFilter(PutWorksheetColorFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetColorFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetColorFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetColorFilterWithHttpInfo(PutWorksheetColorFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetColorFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetColorFilterAsync( PutWorksheetColorFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetColorFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetMatchBlanksValidateBeforeCall(PostWorksheetMatchBlanksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetMatchBlanks(PostWorksheetMatchBlanksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetMatchBlanksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetMatchBlanksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetMatchBlanksWithHttpInfo(PostWorksheetMatchBlanksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetMatchBlanksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetMatchBlanksAsync( PostWorksheetMatchBlanksRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetMatchBlanksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetMatchNonBlanksValidateBeforeCall(PostWorksheetMatchNonBlanksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetMatchNonBlanks(PostWorksheetMatchNonBlanksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetMatchNonBlanksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetMatchNonBlanksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetMatchNonBlanksWithHttpInfo(PostWorksheetMatchNonBlanksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetMatchNonBlanksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetMatchNonBlanksAsync( PostWorksheetMatchNonBlanksRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetMatchNonBlanksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetAutoFilterRefreshValidateBeforeCall(PostWorksheetAutoFilterRefreshRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetAutoFilterRefresh(PostWorksheetAutoFilterRefreshRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetAutoFilterRefreshWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetAutoFilterRefreshWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetAutoFilterRefreshWithHttpInfo(PostWorksheetAutoFilterRefreshRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetAutoFilterRefreshValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetAutoFilterRefreshAsync( PostWorksheetAutoFilterRefreshRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetAutoFilterRefreshValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetDateFilterValidateBeforeCall(DeleteWorksheetDateFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetDateFilter(DeleteWorksheetDateFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetDateFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetDateFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetDateFilterWithHttpInfo(DeleteWorksheetDateFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetDateFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetDateFilterAsync( DeleteWorksheetDateFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetDateFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetFilterValidateBeforeCall(DeleteWorksheetFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetFilter(DeleteWorksheetFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetFilterWithHttpInfo(DeleteWorksheetFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetFilterAsync( DeleteWorksheetFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetAutoshapesValidateBeforeCall(GetWorksheetAutoshapesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AutoShapesResponse  getWorksheetAutoshapes(GetWorksheetAutoshapesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AutoShapesResponse > resp = getWorksheetAutoshapesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AutoShapesResponse > resp = getWorksheetAutoshapesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AutoShapesResponse > getWorksheetAutoshapesWithHttpInfo(GetWorksheetAutoshapesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetAutoshapesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AutoShapesResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetAutoshapesAsync( GetWorksheetAutoshapesRequest request, final ApiCallback< AutoShapesResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetAutoshapesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AutoShapesResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetAutoshapeWithFormatValidateBeforeCall(GetWorksheetAutoshapeWithFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  getWorksheetAutoshapeWithFormat(GetWorksheetAutoshapeWithFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = getWorksheetAutoshapeWithFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = getWorksheetAutoshapeWithFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > getWorksheetAutoshapeWithFormatWithHttpInfo(GetWorksheetAutoshapeWithFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetAutoshapeWithFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetAutoshapeWithFormatAsync( GetWorksheetAutoshapeWithFormatRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetAutoshapeWithFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postBatchConvertValidateBeforeCall(PostBatchConvertRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postBatchConvert(PostBatchConvertRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postBatchConvertWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postBatchConvertWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postBatchConvertWithHttpInfo(PostBatchConvertRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postBatchConvertValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postBatchConvertAsync( PostBatchConvertRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postBatchConvertValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postBatchProtectValidateBeforeCall(PostBatchProtectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postBatchProtect(PostBatchProtectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postBatchProtectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postBatchProtectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postBatchProtectWithHttpInfo(PostBatchProtectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postBatchProtectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postBatchProtectAsync( PostBatchProtectRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postBatchProtectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postBatchLockValidateBeforeCall(PostBatchLockRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postBatchLock(PostBatchLockRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postBatchLockWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postBatchLockWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postBatchLockWithHttpInfo(PostBatchLockRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postBatchLockValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postBatchLockAsync( PostBatchLockRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postBatchLockValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postBatchUnlockValidateBeforeCall(PostBatchUnlockRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postBatchUnlock(PostBatchUnlockRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postBatchUnlockWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postBatchUnlockWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postBatchUnlockWithHttpInfo(PostBatchUnlockRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postBatchUnlockValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postBatchUnlockAsync( PostBatchUnlockRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postBatchUnlockValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postBatchSplitValidateBeforeCall(PostBatchSplitRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postBatchSplit(PostBatchSplitRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postBatchSplitWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postBatchSplitWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postBatchSplitWithHttpInfo(PostBatchSplitRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postBatchSplitValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postBatchSplitAsync( PostBatchSplitRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postBatchSplitValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postClearContentsValidateBeforeCall(PostClearContentsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postClearContents(PostClearContentsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postClearContentsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postClearContentsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postClearContentsWithHttpInfo(PostClearContentsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postClearContentsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postClearContentsAsync( PostClearContentsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postClearContentsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postClearFormatsValidateBeforeCall(PostClearFormatsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postClearFormats(PostClearFormatsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postClearFormatsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postClearFormatsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postClearFormatsWithHttpInfo(PostClearFormatsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postClearFormatsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postClearFormatsAsync( PostClearFormatsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postClearFormatsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUpdateWorksheetRangeStyleValidateBeforeCall(PostUpdateWorksheetRangeStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUpdateWorksheetRangeStyle(PostUpdateWorksheetRangeStyleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetRangeStyleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetRangeStyleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUpdateWorksheetRangeStyleWithHttpInfo(PostUpdateWorksheetRangeStyleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUpdateWorksheetRangeStyleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUpdateWorksheetRangeStyleAsync( PostUpdateWorksheetRangeStyleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUpdateWorksheetRangeStyleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetMergeValidateBeforeCall(PostWorksheetMergeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetMerge(PostWorksheetMergeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetMergeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetMergeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetMergeWithHttpInfo(PostWorksheetMergeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetMergeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetMergeAsync( PostWorksheetMergeRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetMergeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetUnmergeValidateBeforeCall(PostWorksheetUnmergeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetUnmerge(PostWorksheetUnmergeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetUnmergeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetUnmergeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetUnmergeWithHttpInfo(PostWorksheetUnmergeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetUnmergeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetUnmergeAsync( PostWorksheetUnmergeRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetUnmergeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetCellsValidateBeforeCall(GetWorksheetCellsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsResponse  getWorksheetCells(GetWorksheetCellsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsResponse > resp = getWorksheetCellsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsResponse > resp = getWorksheetCellsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsResponse > getWorksheetCellsWithHttpInfo(GetWorksheetCellsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetCellsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetCellsAsync( GetWorksheetCellsRequest request, final ApiCallback< CellsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetCellsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetCellValidateBeforeCall(GetWorksheetCellRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  getWorksheetCell(GetWorksheetCellRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = getWorksheetCellWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = getWorksheetCellWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > getWorksheetCellWithHttpInfo(GetWorksheetCellRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetCellValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetCellAsync( GetWorksheetCellRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetCellValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetCellStyleValidateBeforeCall(GetWorksheetCellStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  StyleResponse  getWorksheetCellStyle(GetWorksheetCellStyleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< StyleResponse > resp = getWorksheetCellStyleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< StyleResponse > resp = getWorksheetCellStyleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< StyleResponse > getWorksheetCellStyleWithHttpInfo(GetWorksheetCellStyleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetCellStyleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< StyleResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetCellStyleAsync( GetWorksheetCellStyleRequest request, final ApiCallback< StyleResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetCellStyleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< StyleResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetCellSetValueValidateBeforeCall(PostWorksheetCellSetValueRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellResponse  postWorksheetCellSetValue(PostWorksheetCellSetValueRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellResponse > resp = postWorksheetCellSetValueWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellResponse > resp = postWorksheetCellSetValueWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellResponse > postWorksheetCellSetValueWithHttpInfo(PostWorksheetCellSetValueRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetCellSetValueValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetCellSetValueAsync( PostWorksheetCellSetValueRequest request, final ApiCallback< CellResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetCellSetValueValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUpdateWorksheetCellStyleValidateBeforeCall(PostUpdateWorksheetCellStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUpdateWorksheetCellStyle(PostUpdateWorksheetCellStyleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetCellStyleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetCellStyleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUpdateWorksheetCellStyleWithHttpInfo(PostUpdateWorksheetCellStyleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUpdateWorksheetCellStyleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUpdateWorksheetCellStyleAsync( PostUpdateWorksheetCellStyleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUpdateWorksheetCellStyleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postSetCellRangeValueValidateBeforeCall(PostSetCellRangeValueRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postSetCellRangeValue(PostSetCellRangeValueRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postSetCellRangeValueWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postSetCellRangeValueWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postSetCellRangeValueWithHttpInfo(PostSetCellRangeValueRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postSetCellRangeValueValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postSetCellRangeValueAsync( PostSetCellRangeValueRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postSetCellRangeValueValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postCopyCellIntoCellValidateBeforeCall(PostCopyCellIntoCellRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postCopyCellIntoCell(PostCopyCellIntoCellRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postCopyCellIntoCellWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postCopyCellIntoCellWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postCopyCellIntoCellWithHttpInfo(PostCopyCellIntoCellRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postCopyCellIntoCellValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postCopyCellIntoCellAsync( PostCopyCellIntoCellRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postCopyCellIntoCellValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getCellHtmlStringValidateBeforeCall(GetCellHtmlStringRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  getCellHtmlString(GetCellHtmlStringRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = getCellHtmlStringWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = getCellHtmlStringWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > getCellHtmlStringWithHttpInfo(GetCellHtmlStringRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getCellHtmlStringValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getCellHtmlStringAsync( GetCellHtmlStringRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getCellHtmlStringValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postSetCellHtmlStringValidateBeforeCall(PostSetCellHtmlStringRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postSetCellHtmlString(PostSetCellHtmlStringRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postSetCellHtmlStringWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postSetCellHtmlStringWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postSetCellHtmlStringWithHttpInfo(PostSetCellHtmlStringRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postSetCellHtmlStringValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postSetCellHtmlStringAsync( PostSetCellHtmlStringRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postSetCellHtmlStringValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postCellCalculateValidateBeforeCall(PostCellCalculateRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postCellCalculate(PostCellCalculateRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postCellCalculateWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postCellCalculateWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postCellCalculateWithHttpInfo(PostCellCalculateRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postCellCalculateValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postCellCalculateAsync( PostCellCalculateRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postCellCalculateValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postCellCharactersValidateBeforeCall(PostCellCharactersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postCellCharacters(PostCellCharactersRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postCellCharactersWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postCellCharactersWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postCellCharactersWithHttpInfo(PostCellCharactersRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postCellCharactersValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postCellCharactersAsync( PostCellCharactersRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postCellCharactersValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetColumnsValidateBeforeCall(GetWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ColumnsResponse  getWorksheetColumns(GetWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ColumnsResponse > resp = getWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ColumnsResponse > resp = getWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ColumnsResponse > getWorksheetColumnsWithHttpInfo(GetWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ColumnsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetColumnsAsync( GetWorksheetColumnsRequest request, final ApiCallback< ColumnsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ColumnsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postSetWorksheetColumnWidthValidateBeforeCall(PostSetWorksheetColumnWidthRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postSetWorksheetColumnWidth(PostSetWorksheetColumnWidthRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postSetWorksheetColumnWidthWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postSetWorksheetColumnWidthWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postSetWorksheetColumnWidthWithHttpInfo(PostSetWorksheetColumnWidthRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postSetWorksheetColumnWidthValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postSetWorksheetColumnWidthAsync( PostSetWorksheetColumnWidthRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postSetWorksheetColumnWidthValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetColumnValidateBeforeCall(GetWorksheetColumnRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ColumnResponse  getWorksheetColumn(GetWorksheetColumnRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ColumnResponse > resp = getWorksheetColumnWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ColumnResponse > resp = getWorksheetColumnWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ColumnResponse > getWorksheetColumnWithHttpInfo(GetWorksheetColumnRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetColumnValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ColumnResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetColumnAsync( GetWorksheetColumnRequest request, final ApiCallback< ColumnResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetColumnValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ColumnResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putInsertWorksheetColumnsValidateBeforeCall(PutInsertWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putInsertWorksheetColumns(PutInsertWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putInsertWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putInsertWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putInsertWorksheetColumnsWithHttpInfo(PutInsertWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putInsertWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putInsertWorksheetColumnsAsync( PutInsertWorksheetColumnsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putInsertWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetColumnsValidateBeforeCall(DeleteWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetColumns(DeleteWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetColumnsWithHttpInfo(DeleteWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetColumnsAsync( DeleteWorksheetColumnsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postHideWorksheetColumnsValidateBeforeCall(PostHideWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postHideWorksheetColumns(PostHideWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postHideWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postHideWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postHideWorksheetColumnsWithHttpInfo(PostHideWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postHideWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postHideWorksheetColumnsAsync( PostHideWorksheetColumnsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postHideWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUnhideWorksheetColumnsValidateBeforeCall(PostUnhideWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUnhideWorksheetColumns(PostUnhideWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUnhideWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUnhideWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUnhideWorksheetColumnsWithHttpInfo(PostUnhideWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUnhideWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUnhideWorksheetColumnsAsync( PostUnhideWorksheetColumnsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUnhideWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postGroupWorksheetColumnsValidateBeforeCall(PostGroupWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postGroupWorksheetColumns(PostGroupWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postGroupWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postGroupWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postGroupWorksheetColumnsWithHttpInfo(PostGroupWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postGroupWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postGroupWorksheetColumnsAsync( PostGroupWorksheetColumnsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postGroupWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUngroupWorksheetColumnsValidateBeforeCall(PostUngroupWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUngroupWorksheetColumns(PostUngroupWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUngroupWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUngroupWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUngroupWorksheetColumnsWithHttpInfo(PostUngroupWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUngroupWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUngroupWorksheetColumnsAsync( PostUngroupWorksheetColumnsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUngroupWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postCopyWorksheetColumnsValidateBeforeCall(PostCopyWorksheetColumnsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postCopyWorksheetColumns(PostCopyWorksheetColumnsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postCopyWorksheetColumnsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postCopyWorksheetColumnsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postCopyWorksheetColumnsWithHttpInfo(PostCopyWorksheetColumnsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postCopyWorksheetColumnsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postCopyWorksheetColumnsAsync( PostCopyWorksheetColumnsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postCopyWorksheetColumnsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postColumnStyleValidateBeforeCall(PostColumnStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postColumnStyle(PostColumnStyleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postColumnStyleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postColumnStyleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postColumnStyleWithHttpInfo(PostColumnStyleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postColumnStyleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postColumnStyleAsync( PostColumnStyleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postColumnStyleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetRowsValidateBeforeCall(GetWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  RowsResponse  getWorksheetRows(GetWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< RowsResponse > resp = getWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< RowsResponse > resp = getWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< RowsResponse > getWorksheetRowsWithHttpInfo(GetWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< RowsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetRowsAsync( GetWorksheetRowsRequest request, final ApiCallback< RowsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< RowsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetRowValidateBeforeCall(GetWorksheetRowRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  RowResponse  getWorksheetRow(GetWorksheetRowRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< RowResponse > resp = getWorksheetRowWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< RowResponse > resp = getWorksheetRowWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< RowResponse > getWorksheetRowWithHttpInfo(GetWorksheetRowRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetRowValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< RowResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetRowAsync( GetWorksheetRowRequest request, final ApiCallback< RowResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetRowValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< RowResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetRowValidateBeforeCall(DeleteWorksheetRowRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetRow(DeleteWorksheetRowRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetRowWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetRowWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetRowWithHttpInfo(DeleteWorksheetRowRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetRowValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetRowAsync( DeleteWorksheetRowRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetRowValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetRowsValidateBeforeCall(DeleteWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetRows(DeleteWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetRowsWithHttpInfo(DeleteWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetRowsAsync( DeleteWorksheetRowsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putInsertWorksheetRowsValidateBeforeCall(PutInsertWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putInsertWorksheetRows(PutInsertWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putInsertWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putInsertWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putInsertWorksheetRowsWithHttpInfo(PutInsertWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putInsertWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putInsertWorksheetRowsAsync( PutInsertWorksheetRowsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putInsertWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putInsertWorksheetRowValidateBeforeCall(PutInsertWorksheetRowRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putInsertWorksheetRow(PutInsertWorksheetRowRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putInsertWorksheetRowWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putInsertWorksheetRowWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putInsertWorksheetRowWithHttpInfo(PutInsertWorksheetRowRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putInsertWorksheetRowValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putInsertWorksheetRowAsync( PutInsertWorksheetRowRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putInsertWorksheetRowValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUpdateWorksheetRowValidateBeforeCall(PostUpdateWorksheetRowRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUpdateWorksheetRow(PostUpdateWorksheetRowRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetRowWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetRowWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUpdateWorksheetRowWithHttpInfo(PostUpdateWorksheetRowRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUpdateWorksheetRowValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUpdateWorksheetRowAsync( PostUpdateWorksheetRowRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUpdateWorksheetRowValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postHideWorksheetRowsValidateBeforeCall(PostHideWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postHideWorksheetRows(PostHideWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postHideWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postHideWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postHideWorksheetRowsWithHttpInfo(PostHideWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postHideWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postHideWorksheetRowsAsync( PostHideWorksheetRowsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postHideWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUnhideWorksheetRowsValidateBeforeCall(PostUnhideWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUnhideWorksheetRows(PostUnhideWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUnhideWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUnhideWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUnhideWorksheetRowsWithHttpInfo(PostUnhideWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUnhideWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUnhideWorksheetRowsAsync( PostUnhideWorksheetRowsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUnhideWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postGroupWorksheetRowsValidateBeforeCall(PostGroupWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postGroupWorksheetRows(PostGroupWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postGroupWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postGroupWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postGroupWorksheetRowsWithHttpInfo(PostGroupWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postGroupWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postGroupWorksheetRowsAsync( PostGroupWorksheetRowsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postGroupWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUngroupWorksheetRowsValidateBeforeCall(PostUngroupWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUngroupWorksheetRows(PostUngroupWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUngroupWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUngroupWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUngroupWorksheetRowsWithHttpInfo(PostUngroupWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUngroupWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUngroupWorksheetRowsAsync( PostUngroupWorksheetRowsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUngroupWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postCopyWorksheetRowsValidateBeforeCall(PostCopyWorksheetRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postCopyWorksheetRows(PostCopyWorksheetRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postCopyWorksheetRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postCopyWorksheetRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postCopyWorksheetRowsWithHttpInfo(PostCopyWorksheetRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postCopyWorksheetRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postCopyWorksheetRowsAsync( PostCopyWorksheetRowsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postCopyWorksheetRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postRowStyleValidateBeforeCall(PostRowStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postRowStyle(PostRowStyleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postRowStyleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postRowStyleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postRowStyleWithHttpInfo(PostRowStyleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postRowStyleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postRowStyleAsync( PostRowStyleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postRowStyleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getCellsCloudServicesHealthCheckValidateBeforeCall(GetCellsCloudServicesHealthCheckRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  getCellsCloudServicesHealthCheck(GetCellsCloudServicesHealthCheckRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = getCellsCloudServicesHealthCheckWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = getCellsCloudServicesHealthCheckWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > getCellsCloudServicesHealthCheckWithHttpInfo(GetCellsCloudServicesHealthCheckRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getCellsCloudServicesHealthCheckValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getCellsCloudServicesHealthCheckAsync( GetCellsCloudServicesHealthCheckRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getCellsCloudServicesHealthCheckValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getCellsCloudServiceStatusValidateBeforeCall(GetCellsCloudServiceStatusRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  String  getCellsCloudServiceStatus(GetCellsCloudServiceStatusRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< String > resp = getCellsCloudServiceStatusWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< String > resp = getCellsCloudServiceStatusWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< String > getCellsCloudServiceStatusWithHttpInfo(GetCellsCloudServiceStatusRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getCellsCloudServiceStatusValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getCellsCloudServiceStatusAsync( GetCellsCloudServiceStatusRequest request, final ApiCallback< String > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getCellsCloudServiceStatusValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< String >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartAreaValidateBeforeCall(GetChartAreaRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ChartAreaResponse  getChartArea(GetChartAreaRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ChartAreaResponse > resp = getChartAreaWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ChartAreaResponse > resp = getChartAreaWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ChartAreaResponse > getChartAreaWithHttpInfo(GetChartAreaRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartAreaValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ChartAreaResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartAreaAsync( GetChartAreaRequest request, final ApiCallback< ChartAreaResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartAreaValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ChartAreaResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartAreaFillFormatValidateBeforeCall(GetChartAreaFillFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FillFormatResponse  getChartAreaFillFormat(GetChartAreaFillFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FillFormatResponse > resp = getChartAreaFillFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FillFormatResponse > resp = getChartAreaFillFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FillFormatResponse > getChartAreaFillFormatWithHttpInfo(GetChartAreaFillFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartAreaFillFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FillFormatResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartAreaFillFormatAsync( GetChartAreaFillFormatRequest request, final ApiCallback< FillFormatResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartAreaFillFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FillFormatResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartAreaBorderValidateBeforeCall(GetChartAreaBorderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  LineResponse  getChartAreaBorder(GetChartAreaBorderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< LineResponse > resp = getChartAreaBorderWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< LineResponse > resp = getChartAreaBorderWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< LineResponse > getChartAreaBorderWithHttpInfo(GetChartAreaBorderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartAreaBorderValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< LineResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartAreaBorderAsync( GetChartAreaBorderRequest request, final ApiCallback< LineResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartAreaBorderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< LineResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetChartsValidateBeforeCall(GetWorksheetChartsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ChartsResponse  getWorksheetCharts(GetWorksheetChartsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ChartsResponse > resp = getWorksheetChartsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ChartsResponse > resp = getWorksheetChartsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ChartsResponse > getWorksheetChartsWithHttpInfo(GetWorksheetChartsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetChartsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ChartsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetChartsAsync( GetWorksheetChartsRequest request, final ApiCallback< ChartsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetChartsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ChartsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetChartValidateBeforeCall(GetWorksheetChartRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  getWorksheetChart(GetWorksheetChartRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = getWorksheetChartWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = getWorksheetChartWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > getWorksheetChartWithHttpInfo(GetWorksheetChartRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetChartValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetChartAsync( GetWorksheetChartRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetChartValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetChartValidateBeforeCall(PutWorksheetChartRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetChart(PutWorksheetChartRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetChartWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetChartWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetChartWithHttpInfo(PutWorksheetChartRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetChartValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetChartAsync( PutWorksheetChartRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetChartValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetChartValidateBeforeCall(DeleteWorksheetChartRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetChart(DeleteWorksheetChartRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetChartWithHttpInfo(DeleteWorksheetChartRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetChartValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetChartAsync( DeleteWorksheetChartRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetChartValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetChartValidateBeforeCall(PostWorksheetChartRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetChart(PostWorksheetChartRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetChartWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetChartWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetChartWithHttpInfo(PostWorksheetChartRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetChartValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetChartAsync( PostWorksheetChartRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetChartValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetChartLegendValidateBeforeCall(GetWorksheetChartLegendRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  LegendResponse  getWorksheetChartLegend(GetWorksheetChartLegendRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< LegendResponse > resp = getWorksheetChartLegendWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< LegendResponse > resp = getWorksheetChartLegendWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< LegendResponse > getWorksheetChartLegendWithHttpInfo(GetWorksheetChartLegendRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetChartLegendValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< LegendResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetChartLegendAsync( GetWorksheetChartLegendRequest request, final ApiCallback< LegendResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetChartLegendValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< LegendResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetChartLegendValidateBeforeCall(PostWorksheetChartLegendRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetChartLegend(PostWorksheetChartLegendRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetChartLegendWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetChartLegendWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetChartLegendWithHttpInfo(PostWorksheetChartLegendRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetChartLegendValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetChartLegendAsync( PostWorksheetChartLegendRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetChartLegendValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetChartLegendValidateBeforeCall(PutWorksheetChartLegendRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetChartLegend(PutWorksheetChartLegendRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetChartLegendWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetChartLegendWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetChartLegendWithHttpInfo(PutWorksheetChartLegendRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetChartLegendValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetChartLegendAsync( PutWorksheetChartLegendRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetChartLegendValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetChartLegendValidateBeforeCall(DeleteWorksheetChartLegendRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetChartLegend(DeleteWorksheetChartLegendRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartLegendWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartLegendWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetChartLegendWithHttpInfo(DeleteWorksheetChartLegendRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetChartLegendValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetChartLegendAsync( DeleteWorksheetChartLegendRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetChartLegendValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetChartsValidateBeforeCall(DeleteWorksheetChartsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetCharts(DeleteWorksheetChartsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetChartsWithHttpInfo(DeleteWorksheetChartsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetChartsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetChartsAsync( DeleteWorksheetChartsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetChartsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetChartTitleValidateBeforeCall(GetWorksheetChartTitleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  TitleResponse  getWorksheetChartTitle(GetWorksheetChartTitleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< TitleResponse > resp = getWorksheetChartTitleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< TitleResponse > resp = getWorksheetChartTitleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< TitleResponse > getWorksheetChartTitleWithHttpInfo(GetWorksheetChartTitleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetChartTitleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< TitleResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetChartTitleAsync( GetWorksheetChartTitleRequest request, final ApiCallback< TitleResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetChartTitleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< TitleResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetChartTitleValidateBeforeCall(PostWorksheetChartTitleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetChartTitle(PostWorksheetChartTitleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetChartTitleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetChartTitleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetChartTitleWithHttpInfo(PostWorksheetChartTitleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetChartTitleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetChartTitleAsync( PostWorksheetChartTitleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetChartTitleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetChartTitleValidateBeforeCall(PutWorksheetChartTitleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetChartTitle(PutWorksheetChartTitleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetChartTitleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetChartTitleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetChartTitleWithHttpInfo(PutWorksheetChartTitleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetChartTitleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetChartTitleAsync( PutWorksheetChartTitleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetChartTitleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetChartTitleValidateBeforeCall(DeleteWorksheetChartTitleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetChartTitle(DeleteWorksheetChartTitleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartTitleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetChartTitleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetChartTitleWithHttpInfo(DeleteWorksheetChartTitleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetChartTitleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetChartTitleAsync( DeleteWorksheetChartTitleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetChartTitleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartSeriesAxisValidateBeforeCall(GetChartSeriesAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AxisResponse  getChartSeriesAxis(GetChartSeriesAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AxisResponse > resp = getChartSeriesAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AxisResponse > resp = getChartSeriesAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AxisResponse > getChartSeriesAxisWithHttpInfo(GetChartSeriesAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartSeriesAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartSeriesAxisAsync( GetChartSeriesAxisRequest request, final ApiCallback< AxisResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartSeriesAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartCategoryAxisValidateBeforeCall(GetChartCategoryAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AxisResponse  getChartCategoryAxis(GetChartCategoryAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AxisResponse > resp = getChartCategoryAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AxisResponse > resp = getChartCategoryAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AxisResponse > getChartCategoryAxisWithHttpInfo(GetChartCategoryAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartCategoryAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartCategoryAxisAsync( GetChartCategoryAxisRequest request, final ApiCallback< AxisResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartCategoryAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartValueAxisValidateBeforeCall(GetChartValueAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AxisResponse  getChartValueAxis(GetChartValueAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AxisResponse > resp = getChartValueAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AxisResponse > resp = getChartValueAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AxisResponse > getChartValueAxisWithHttpInfo(GetChartValueAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartValueAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartValueAxisAsync( GetChartValueAxisRequest request, final ApiCallback< AxisResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartValueAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartSecondCategoryAxisValidateBeforeCall(GetChartSecondCategoryAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AxisResponse  getChartSecondCategoryAxis(GetChartSecondCategoryAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AxisResponse > resp = getChartSecondCategoryAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AxisResponse > resp = getChartSecondCategoryAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AxisResponse > getChartSecondCategoryAxisWithHttpInfo(GetChartSecondCategoryAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartSecondCategoryAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartSecondCategoryAxisAsync( GetChartSecondCategoryAxisRequest request, final ApiCallback< AxisResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartSecondCategoryAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getChartSecondValueAxisValidateBeforeCall(GetChartSecondValueAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  AxisResponse  getChartSecondValueAxis(GetChartSecondValueAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< AxisResponse > resp = getChartSecondValueAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< AxisResponse > resp = getChartSecondValueAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< AxisResponse > getChartSecondValueAxisWithHttpInfo(GetChartSecondValueAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getChartSecondValueAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getChartSecondValueAxisAsync( GetChartSecondValueAxisRequest request, final ApiCallback< AxisResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getChartSecondValueAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< AxisResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postChartSeriesAxisValidateBeforeCall(PostChartSeriesAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postChartSeriesAxis(PostChartSeriesAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postChartSeriesAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postChartSeriesAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postChartSeriesAxisWithHttpInfo(PostChartSeriesAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postChartSeriesAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postChartSeriesAxisAsync( PostChartSeriesAxisRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postChartSeriesAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postChartCategoryAxisValidateBeforeCall(PostChartCategoryAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postChartCategoryAxis(PostChartCategoryAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postChartCategoryAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postChartCategoryAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postChartCategoryAxisWithHttpInfo(PostChartCategoryAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postChartCategoryAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postChartCategoryAxisAsync( PostChartCategoryAxisRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postChartCategoryAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postChartValueAxisValidateBeforeCall(PostChartValueAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postChartValueAxis(PostChartValueAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postChartValueAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postChartValueAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postChartValueAxisWithHttpInfo(PostChartValueAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postChartValueAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postChartValueAxisAsync( PostChartValueAxisRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postChartValueAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postChartSecondCategoryAxisValidateBeforeCall(PostChartSecondCategoryAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postChartSecondCategoryAxis(PostChartSecondCategoryAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postChartSecondCategoryAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postChartSecondCategoryAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postChartSecondCategoryAxisWithHttpInfo(PostChartSecondCategoryAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postChartSecondCategoryAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postChartSecondCategoryAxisAsync( PostChartSecondCategoryAxisRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postChartSecondCategoryAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postChartSecondValueAxisValidateBeforeCall(PostChartSecondValueAxisRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postChartSecondValueAxis(PostChartSecondValueAxisRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postChartSecondValueAxisWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postChartSecondValueAxisWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postChartSecondValueAxisWithHttpInfo(PostChartSecondValueAxisRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postChartSecondValueAxisValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postChartSecondValueAxisAsync( PostChartSecondValueAxisRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postChartSecondValueAxisValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetConditionalFormattingsValidateBeforeCall(GetWorksheetConditionalFormattingsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ConditionalFormattingsResponse  getWorksheetConditionalFormattings(GetWorksheetConditionalFormattingsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ConditionalFormattingsResponse > resp = getWorksheetConditionalFormattingsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ConditionalFormattingsResponse > resp = getWorksheetConditionalFormattingsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ConditionalFormattingsResponse > getWorksheetConditionalFormattingsWithHttpInfo(GetWorksheetConditionalFormattingsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetConditionalFormattingsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ConditionalFormattingsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetConditionalFormattingsAsync( GetWorksheetConditionalFormattingsRequest request, final ApiCallback< ConditionalFormattingsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetConditionalFormattingsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ConditionalFormattingsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetConditionalFormattingValidateBeforeCall(GetWorksheetConditionalFormattingRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ConditionalFormattingResponse  getWorksheetConditionalFormatting(GetWorksheetConditionalFormattingRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ConditionalFormattingResponse > resp = getWorksheetConditionalFormattingWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ConditionalFormattingResponse > resp = getWorksheetConditionalFormattingWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ConditionalFormattingResponse > getWorksheetConditionalFormattingWithHttpInfo(GetWorksheetConditionalFormattingRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetConditionalFormattingValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ConditionalFormattingResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetConditionalFormattingAsync( GetWorksheetConditionalFormattingRequest request, final ApiCallback< ConditionalFormattingResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetConditionalFormattingValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ConditionalFormattingResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetConditionalFormattingValidateBeforeCall(PutWorksheetConditionalFormattingRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetConditionalFormatting(PutWorksheetConditionalFormattingRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetConditionalFormattingWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetConditionalFormattingWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetConditionalFormattingWithHttpInfo(PutWorksheetConditionalFormattingRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetConditionalFormattingValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetConditionalFormattingAsync( PutWorksheetConditionalFormattingRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetConditionalFormattingValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetFormatConditionValidateBeforeCall(PutWorksheetFormatConditionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetFormatCondition(PutWorksheetFormatConditionRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetFormatConditionWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetFormatConditionWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetFormatConditionWithHttpInfo(PutWorksheetFormatConditionRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetFormatConditionValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetFormatConditionAsync( PutWorksheetFormatConditionRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetFormatConditionValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetFormatConditionAreaValidateBeforeCall(PutWorksheetFormatConditionAreaRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetFormatConditionArea(PutWorksheetFormatConditionAreaRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetFormatConditionAreaWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetFormatConditionAreaWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetFormatConditionAreaWithHttpInfo(PutWorksheetFormatConditionAreaRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetFormatConditionAreaValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetFormatConditionAreaAsync( PutWorksheetFormatConditionAreaRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetFormatConditionAreaValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetFormatConditionConditionValidateBeforeCall(PutWorksheetFormatConditionConditionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetFormatConditionCondition(PutWorksheetFormatConditionConditionRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetFormatConditionConditionWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetFormatConditionConditionWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetFormatConditionConditionWithHttpInfo(PutWorksheetFormatConditionConditionRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetFormatConditionConditionValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetFormatConditionConditionAsync( PutWorksheetFormatConditionConditionRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetFormatConditionConditionValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetConditionalFormattingsValidateBeforeCall(DeleteWorksheetConditionalFormattingsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetConditionalFormattings(DeleteWorksheetConditionalFormattingsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetConditionalFormattingsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetConditionalFormattingsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetConditionalFormattingsWithHttpInfo(DeleteWorksheetConditionalFormattingsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetConditionalFormattingsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetConditionalFormattingsAsync( DeleteWorksheetConditionalFormattingsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetConditionalFormattingsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetConditionalFormattingValidateBeforeCall(DeleteWorksheetConditionalFormattingRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetConditionalFormatting(DeleteWorksheetConditionalFormattingRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetConditionalFormattingWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetConditionalFormattingWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetConditionalFormattingWithHttpInfo(DeleteWorksheetConditionalFormattingRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetConditionalFormattingValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetConditionalFormattingAsync( DeleteWorksheetConditionalFormattingRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetConditionalFormattingValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetConditionalFormattingAreaValidateBeforeCall(DeleteWorksheetConditionalFormattingAreaRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetConditionalFormattingArea(DeleteWorksheetConditionalFormattingAreaRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetConditionalFormattingAreaWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetConditionalFormattingAreaWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetConditionalFormattingAreaWithHttpInfo(DeleteWorksheetConditionalFormattingAreaRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetConditionalFormattingAreaValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetConditionalFormattingAreaAsync( DeleteWorksheetConditionalFormattingAreaRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetConditionalFormattingAreaValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorkbookValidateBeforeCall(GetWorkbookRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  getWorkbook(GetWorkbookRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = getWorkbookWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = getWorkbookWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > getWorkbookWithHttpInfo(GetWorkbookRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorkbookValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorkbookAsync( GetWorkbookRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorkbookValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putConvertWorkbookValidateBeforeCall(PutConvertWorkbookRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  putConvertWorkbook(PutConvertWorkbookRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = putConvertWorkbookWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = putConvertWorkbookWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > putConvertWorkbookWithHttpInfo(PutConvertWorkbookRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putConvertWorkbookValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putConvertWorkbookAsync( PutConvertWorkbookRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putConvertWorkbookValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorkbookSaveAsValidateBeforeCall(PostWorkbookSaveAsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  SaveResponse  postWorkbookSaveAs(PostWorkbookSaveAsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< SaveResponse > resp = postWorkbookSaveAsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< SaveResponse > resp = postWorkbookSaveAsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< SaveResponse > postWorkbookSaveAsWithHttpInfo(PostWorkbookSaveAsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorkbookSaveAsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< SaveResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorkbookSaveAsAsync( PostWorkbookSaveAsRequest request, final ApiCallback< SaveResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorkbookSaveAsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< SaveResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToPDFValidateBeforeCall(PostConvertWorkbookToPDFRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToPDF(PostConvertWorkbookToPDFRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToPDFWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToPDFWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToPDFWithHttpInfo(PostConvertWorkbookToPDFRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToPDFValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToPDFAsync( PostConvertWorkbookToPDFRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToPDFValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToPNGValidateBeforeCall(PostConvertWorkbookToPNGRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToPNG(PostConvertWorkbookToPNGRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToPNGWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToPNGWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToPNGWithHttpInfo(PostConvertWorkbookToPNGRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToPNGValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToPNGAsync( PostConvertWorkbookToPNGRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToPNGValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToDocxValidateBeforeCall(PostConvertWorkbookToDocxRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToDocx(PostConvertWorkbookToDocxRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToDocxWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToDocxWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToDocxWithHttpInfo(PostConvertWorkbookToDocxRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToDocxValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToDocxAsync( PostConvertWorkbookToDocxRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToDocxValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToPptxValidateBeforeCall(PostConvertWorkbookToPptxRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToPptx(PostConvertWorkbookToPptxRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToPptxWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToPptxWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToPptxWithHttpInfo(PostConvertWorkbookToPptxRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToPptxValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToPptxAsync( PostConvertWorkbookToPptxRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToPptxValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToHtmlValidateBeforeCall(PostConvertWorkbookToHtmlRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToHtml(PostConvertWorkbookToHtmlRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToHtmlWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToHtmlWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToHtmlWithHttpInfo(PostConvertWorkbookToHtmlRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToHtmlValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToHtmlAsync( PostConvertWorkbookToHtmlRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToHtmlValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToMarkdownValidateBeforeCall(PostConvertWorkbookToMarkdownRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToMarkdown(PostConvertWorkbookToMarkdownRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToMarkdownWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToMarkdownWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToMarkdownWithHttpInfo(PostConvertWorkbookToMarkdownRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToMarkdownValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToMarkdownAsync( PostConvertWorkbookToMarkdownRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToMarkdownValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToJsonValidateBeforeCall(PostConvertWorkbookToJsonRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToJson(PostConvertWorkbookToJsonRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToJsonWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToJsonWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToJsonWithHttpInfo(PostConvertWorkbookToJsonRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToJsonValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToJsonAsync( PostConvertWorkbookToJsonRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToJsonValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToSQLValidateBeforeCall(PostConvertWorkbookToSQLRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToSQL(PostConvertWorkbookToSQLRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToSQLWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToSQLWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToSQLWithHttpInfo(PostConvertWorkbookToSQLRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToSQLValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToSQLAsync( PostConvertWorkbookToSQLRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToSQLValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookToCSVValidateBeforeCall(PostConvertWorkbookToCSVRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbookToCSV(PostConvertWorkbookToCSVRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookToCSVWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookToCSVWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookToCSVWithHttpInfo(PostConvertWorkbookToCSVRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookToCSVValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookToCSVAsync( PostConvertWorkbookToCSVRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookToCSVValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorksheetToImageValidateBeforeCall(PostConvertWorksheetToImageRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorksheetToImage(PostConvertWorksheetToImageRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorksheetToImageWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorksheetToImageWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorksheetToImageWithHttpInfo(PostConvertWorksheetToImageRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorksheetToImageValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorksheetToImageAsync( PostConvertWorksheetToImageRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorksheetToImageValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postConvertWorkbookValidateBeforeCall(PostConvertWorkbookRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postConvertWorkbook(PostConvertWorkbookRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postConvertWorkbookWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postConvertWorkbookWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postConvertWorkbookWithHttpInfo(PostConvertWorkbookRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postConvertWorkbookValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postConvertWorkbookAsync( PostConvertWorkbookRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postConvertWorkbookValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call checkWrokbookExternalReferenceValidateBeforeCall(CheckWrokbookExternalReferenceRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CheckedExternalReferenceResponse  checkWrokbookExternalReference(CheckWrokbookExternalReferenceRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CheckedExternalReferenceResponse > resp = checkWrokbookExternalReferenceWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CheckedExternalReferenceResponse > resp = checkWrokbookExternalReferenceWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CheckedExternalReferenceResponse > checkWrokbookExternalReferenceWithHttpInfo(CheckWrokbookExternalReferenceRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  checkWrokbookExternalReferenceValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CheckedExternalReferenceResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  checkWrokbookExternalReferenceAsync( CheckWrokbookExternalReferenceRequest request, final ApiCallback< CheckedExternalReferenceResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  checkWrokbookExternalReferenceValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CheckedExternalReferenceResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call checkWorkbookFormulaErrorsValidateBeforeCall(CheckWorkbookFormulaErrorsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CheckedFormulaErrorsResponse  checkWorkbookFormulaErrors(CheckWorkbookFormulaErrorsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CheckedFormulaErrorsResponse > resp = checkWorkbookFormulaErrorsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CheckedFormulaErrorsResponse > resp = checkWorkbookFormulaErrorsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CheckedFormulaErrorsResponse > checkWorkbookFormulaErrorsWithHttpInfo(CheckWorkbookFormulaErrorsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  checkWorkbookFormulaErrorsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CheckedFormulaErrorsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  checkWorkbookFormulaErrorsAsync( CheckWorkbookFormulaErrorsRequest request, final ApiCallback< CheckedFormulaErrorsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  checkWorkbookFormulaErrorsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CheckedFormulaErrorsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postExportValidateBeforeCall(PostExportRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postExport(PostExportRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postExportWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postExportWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postExportWithHttpInfo(PostExportRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postExportValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postExportAsync( PostExportRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postExportValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorkbookExportXMLValidateBeforeCall(PostWorkbookExportXMLRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postWorkbookExportXML(PostWorkbookExportXMLRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postWorkbookExportXMLWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postWorkbookExportXMLWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postWorkbookExportXMLWithHttpInfo(PostWorkbookExportXMLRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorkbookExportXMLValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorkbookExportXMLAsync( PostWorkbookExportXMLRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorkbookExportXMLValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorkbookImportJsonValidateBeforeCall(PostWorkbookImportJsonRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postWorkbookImportJson(PostWorkbookImportJsonRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postWorkbookImportJsonWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postWorkbookImportJsonWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postWorkbookImportJsonWithHttpInfo(PostWorkbookImportJsonRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorkbookImportJsonValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorkbookImportJsonAsync( PostWorkbookImportJsonRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorkbookImportJsonValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorkbookImportXMLValidateBeforeCall(PostWorkbookImportXMLRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  postWorkbookImportXML(PostWorkbookImportXMLRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = postWorkbookImportXMLWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = postWorkbookImportXMLWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > postWorkbookImportXMLWithHttpInfo(PostWorkbookImportXMLRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorkbookImportXMLValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorkbookImportXMLAsync( PostWorkbookImportXMLRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorkbookImportXMLValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postImportDataValidateBeforeCall(PostImportDataRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postImportData(PostImportDataRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postImportDataWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postImportDataWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postImportDataWithHttpInfo(PostImportDataRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postImportDataValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postImportDataAsync( PostImportDataRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postImportDataValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorkbookDataCleansingValidateBeforeCall(PostWorkbookDataCleansingRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postWorkbookDataCleansing(PostWorkbookDataCleansingRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postWorkbookDataCleansingWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postWorkbookDataCleansingWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postWorkbookDataCleansingWithHttpInfo(PostWorkbookDataCleansingRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorkbookDataCleansingValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorkbookDataCleansingAsync( PostWorkbookDataCleansingRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorkbookDataCleansingValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postDataCleansingValidateBeforeCall(PostDataCleansingRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postDataCleansing(PostDataCleansingRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postDataCleansingWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postDataCleansingWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postDataCleansingWithHttpInfo(PostDataCleansingRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postDataCleansingValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postDataCleansingAsync( PostDataCleansingRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postDataCleansingValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorkbookDataDeduplicationValidateBeforeCall(PostWorkbookDataDeduplicationRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postWorkbookDataDeduplication(PostWorkbookDataDeduplicationRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postWorkbookDataDeduplicationWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postWorkbookDataDeduplicationWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postWorkbookDataDeduplicationWithHttpInfo(PostWorkbookDataDeduplicationRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorkbookDataDeduplicationValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorkbookDataDeduplicationAsync( PostWorkbookDataDeduplicationRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorkbookDataDeduplicationValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postDataDeduplicationValidateBeforeCall(PostDataDeduplicationRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postDataDeduplication(PostDataDeduplicationRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postDataDeduplicationWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postDataDeduplicationWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postDataDeduplicationWithHttpInfo(PostDataDeduplicationRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postDataDeduplicationValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postDataDeduplicationAsync( PostDataDeduplicationRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postDataDeduplicationValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorkbookDataFillValidateBeforeCall(PostWorkbookDataFillRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postWorkbookDataFill(PostWorkbookDataFillRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postWorkbookDataFillWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postWorkbookDataFillWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postWorkbookDataFillWithHttpInfo(PostWorkbookDataFillRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorkbookDataFillValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorkbookDataFillAsync( PostWorkbookDataFillRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorkbookDataFillValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postDataFillValidateBeforeCall(PostDataFillRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postDataFill(PostDataFillRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postDataFillWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postDataFillWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postDataFillWithHttpInfo(PostDataFillRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postDataFillValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postDataFillAsync( PostDataFillRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postDataFillValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postDeleteIncompleteRowsValidateBeforeCall(PostDeleteIncompleteRowsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postDeleteIncompleteRows(PostDeleteIncompleteRowsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postDeleteIncompleteRowsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postDeleteIncompleteRowsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postDeleteIncompleteRowsWithHttpInfo(PostDeleteIncompleteRowsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postDeleteIncompleteRowsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postDeleteIncompleteRowsAsync( PostDeleteIncompleteRowsRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postDeleteIncompleteRowsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postDataTransformationValidateBeforeCall(PostDataTransformationRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postDataTransformation(PostDataTransformationRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postDataTransformationWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postDataTransformationWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postDataTransformationWithHttpInfo(PostDataTransformationRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postDataTransformationValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postDataTransformationAsync( PostDataTransformationRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postDataTransformationValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetHyperlinksValidateBeforeCall(GetWorksheetHyperlinksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  HyperlinksResponse  getWorksheetHyperlinks(GetWorksheetHyperlinksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< HyperlinksResponse > resp = getWorksheetHyperlinksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< HyperlinksResponse > resp = getWorksheetHyperlinksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< HyperlinksResponse > getWorksheetHyperlinksWithHttpInfo(GetWorksheetHyperlinksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetHyperlinksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< HyperlinksResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetHyperlinksAsync( GetWorksheetHyperlinksRequest request, final ApiCallback< HyperlinksResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetHyperlinksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HyperlinksResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetHyperlinkValidateBeforeCall(GetWorksheetHyperlinkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  HyperlinkResponse  getWorksheetHyperlink(GetWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< HyperlinkResponse > resp = getWorksheetHyperlinkWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< HyperlinkResponse > resp = getWorksheetHyperlinkWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< HyperlinkResponse > getWorksheetHyperlinkWithHttpInfo(GetWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetHyperlinkValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< HyperlinkResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetHyperlinkAsync( GetWorksheetHyperlinkRequest request, final ApiCallback< HyperlinkResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetHyperlinkValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HyperlinkResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetHyperlinkValidateBeforeCall(DeleteWorksheetHyperlinkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetHyperlink(DeleteWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetHyperlinkWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetHyperlinkWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetHyperlinkWithHttpInfo(DeleteWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetHyperlinkValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetHyperlinkAsync( DeleteWorksheetHyperlinkRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetHyperlinkValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetHyperlinkValidateBeforeCall(PostWorksheetHyperlinkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetHyperlink(PostWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetHyperlinkWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetHyperlinkWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetHyperlinkWithHttpInfo(PostWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetHyperlinkValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetHyperlinkAsync( PostWorksheetHyperlinkRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetHyperlinkValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetHyperlinkValidateBeforeCall(PutWorksheetHyperlinkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetHyperlink(PutWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetHyperlinkWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetHyperlinkWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetHyperlinkWithHttpInfo(PutWorksheetHyperlinkRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetHyperlinkValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetHyperlinkAsync( PutWorksheetHyperlinkRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetHyperlinkValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetHyperlinksValidateBeforeCall(DeleteWorksheetHyperlinksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetHyperlinks(DeleteWorksheetHyperlinksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetHyperlinksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetHyperlinksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetHyperlinksWithHttpInfo(DeleteWorksheetHyperlinksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetHyperlinksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetHyperlinksAsync( DeleteWorksheetHyperlinksRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetHyperlinksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postAssembleValidateBeforeCall(PostAssembleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postAssemble(PostAssembleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postAssembleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postAssembleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postAssembleWithHttpInfo(PostAssembleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postAssembleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postAssembleAsync( PostAssembleRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postAssembleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postCompressValidateBeforeCall(PostCompressRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postCompress(PostCompressRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postCompressWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postCompressWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postCompressWithHttpInfo(PostCompressRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postCompressValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postCompressAsync( PostCompressRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postCompressValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postMergeValidateBeforeCall(PostMergeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FileInfo  postMerge(PostMergeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FileInfo > resp = postMergeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FileInfo > resp = postMergeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FileInfo > postMergeWithHttpInfo(PostMergeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postMergeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postMergeAsync( PostMergeRequest request, final ApiCallback< FileInfo > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postMergeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FileInfo >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postSplitValidateBeforeCall(PostSplitRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postSplit(PostSplitRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postSplitWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postSplitWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postSplitWithHttpInfo(PostSplitRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postSplitValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postSplitAsync( PostSplitRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postSplitValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postSearchValidateBeforeCall(PostSearchRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  List<TextItem>  postSearch(PostSearchRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< List<TextItem> > resp = postSearchWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< List<TextItem> > resp = postSearchWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< List<TextItem> > postSearchWithHttpInfo(PostSearchRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postSearchValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< List<TextItem> >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postSearchAsync( PostSearchRequest request, final ApiCallback< List<TextItem> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postSearchValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< List<TextItem> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postReplaceValidateBeforeCall(PostReplaceRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postReplace(PostReplaceRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postReplaceWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postReplaceWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postReplaceWithHttpInfo(PostReplaceRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postReplaceValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postReplaceAsync( PostReplaceRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postReplaceValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postImportValidateBeforeCall(PostImportRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postImport(PostImportRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postImportWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postImportWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postImportWithHttpInfo(PostImportRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postImportValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postImportAsync( PostImportRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postImportValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWatermarkValidateBeforeCall(PostWatermarkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postWatermark(PostWatermarkRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postWatermarkWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postWatermarkWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postWatermarkWithHttpInfo(PostWatermarkRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWatermarkValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWatermarkAsync( PostWatermarkRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWatermarkValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postClearObjectsValidateBeforeCall(PostClearObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postClearObjects(PostClearObjectsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postClearObjectsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postClearObjectsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postClearObjectsWithHttpInfo(PostClearObjectsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postClearObjectsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postClearObjectsAsync( PostClearObjectsRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postClearObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postReverseValidateBeforeCall(PostReverseRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postReverse(PostReverseRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postReverseWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postReverseWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postReverseWithHttpInfo(PostReverseRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postReverseValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postReverseAsync( PostReverseRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postReverseValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postRepairValidateBeforeCall(PostRepairRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postRepair(PostRepairRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postRepairWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postRepairWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postRepairWithHttpInfo(PostRepairRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postRepairValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postRepairAsync( PostRepairRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postRepairValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postRotateValidateBeforeCall(PostRotateRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postRotate(PostRotateRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postRotateWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postRotateWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postRotateWithHttpInfo(PostRotateRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postRotateValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postRotateAsync( PostRotateRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postRotateValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postMetadataValidateBeforeCall(PostMetadataRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  postMetadata(PostMetadataRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = postMetadataWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = postMetadataWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > postMetadataWithHttpInfo(PostMetadataRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postMetadataValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postMetadataAsync( PostMetadataRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postMetadataValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getMetadataValidateBeforeCall(GetMetadataRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  List<CellsDocumentProperty>  getMetadata(GetMetadataRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< List<CellsDocumentProperty> > resp = getMetadataWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< List<CellsDocumentProperty> > resp = getMetadataWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< List<CellsDocumentProperty> > getMetadataWithHttpInfo(GetMetadataRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getMetadataValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< List<CellsDocumentProperty> >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getMetadataAsync( GetMetadataRequest request, final ApiCallback< List<CellsDocumentProperty> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getMetadataValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< List<CellsDocumentProperty> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteMetadataValidateBeforeCall(DeleteMetadataRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  FilesResult  deleteMetadata(DeleteMetadataRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< FilesResult > resp = deleteMetadataWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< FilesResult > resp = deleteMetadataWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< FilesResult > deleteMetadataWithHttpInfo(DeleteMetadataRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteMetadataValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteMetadataAsync( DeleteMetadataRequest request, final ApiCallback< FilesResult > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteMetadataValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< FilesResult >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetListObjectsValidateBeforeCall(GetWorksheetListObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  ListObjectsResponse  getWorksheetListObjects(GetWorksheetListObjectsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< ListObjectsResponse > resp = getWorksheetListObjectsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< ListObjectsResponse > resp = getWorksheetListObjectsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< ListObjectsResponse > getWorksheetListObjectsWithHttpInfo(GetWorksheetListObjectsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetListObjectsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< ListObjectsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetListObjectsAsync( GetWorksheetListObjectsRequest request, final ApiCallback< ListObjectsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetListObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< ListObjectsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetListObjectValidateBeforeCall(GetWorksheetListObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  getWorksheetListObject(GetWorksheetListObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = getWorksheetListObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = getWorksheetListObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > getWorksheetListObjectWithHttpInfo(GetWorksheetListObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetListObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetListObjectAsync( GetWorksheetListObjectRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetListObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetListObjectValidateBeforeCall(PutWorksheetListObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetListObject(PutWorksheetListObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetListObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetListObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetListObjectWithHttpInfo(PutWorksheetListObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetListObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetListObjectAsync( PutWorksheetListObjectRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetListObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetListObjectsValidateBeforeCall(DeleteWorksheetListObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetListObjects(DeleteWorksheetListObjectsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetListObjectsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetListObjectsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetListObjectsWithHttpInfo(DeleteWorksheetListObjectsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetListObjectsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetListObjectsAsync( DeleteWorksheetListObjectsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetListObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetListObjectValidateBeforeCall(DeleteWorksheetListObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetListObject(DeleteWorksheetListObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetListObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetListObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetListObjectWithHttpInfo(DeleteWorksheetListObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetListObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetListObjectAsync( DeleteWorksheetListObjectRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetListObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListObjectValidateBeforeCall(PostWorksheetListObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListObject(PostWorksheetListObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListObjectWithHttpInfo(PostWorksheetListObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListObjectAsync( PostWorksheetListObjectRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListObjectConvertToRangeValidateBeforeCall(PostWorksheetListObjectConvertToRangeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListObjectConvertToRange(PostWorksheetListObjectConvertToRangeRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectConvertToRangeWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectConvertToRangeWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListObjectConvertToRangeWithHttpInfo(PostWorksheetListObjectConvertToRangeRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListObjectConvertToRangeValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListObjectConvertToRangeAsync( PostWorksheetListObjectConvertToRangeRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListObjectConvertToRangeValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListObjectSummarizeWithPivotTableValidateBeforeCall(PostWorksheetListObjectSummarizeWithPivotTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListObjectSummarizeWithPivotTable(PostWorksheetListObjectSummarizeWithPivotTableRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectSummarizeWithPivotTableWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectSummarizeWithPivotTableWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListObjectSummarizeWithPivotTableWithHttpInfo(PostWorksheetListObjectSummarizeWithPivotTableRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListObjectSummarizeWithPivotTableValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListObjectSummarizeWithPivotTableAsync( PostWorksheetListObjectSummarizeWithPivotTableRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListObjectSummarizeWithPivotTableValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListObjectSortTableValidateBeforeCall(PostWorksheetListObjectSortTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListObjectSortTable(PostWorksheetListObjectSortTableRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectSortTableWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectSortTableWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListObjectSortTableWithHttpInfo(PostWorksheetListObjectSortTableRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListObjectSortTableValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListObjectSortTableAsync( PostWorksheetListObjectSortTableRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListObjectSortTableValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListObjectRemoveDuplicatesValidateBeforeCall(PostWorksheetListObjectRemoveDuplicatesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListObjectRemoveDuplicates(PostWorksheetListObjectRemoveDuplicatesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectRemoveDuplicatesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectRemoveDuplicatesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListObjectRemoveDuplicatesWithHttpInfo(PostWorksheetListObjectRemoveDuplicatesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListObjectRemoveDuplicatesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListObjectRemoveDuplicatesAsync( PostWorksheetListObjectRemoveDuplicatesRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListObjectRemoveDuplicatesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListObjectInsertSlicerValidateBeforeCall(PostWorksheetListObjectInsertSlicerRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListObjectInsertSlicer(PostWorksheetListObjectInsertSlicerRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectInsertSlicerWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListObjectInsertSlicerWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListObjectInsertSlicerWithHttpInfo(PostWorksheetListObjectInsertSlicerRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListObjectInsertSlicerValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListObjectInsertSlicerAsync( PostWorksheetListObjectInsertSlicerRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListObjectInsertSlicerValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListColumnValidateBeforeCall(PostWorksheetListColumnRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListColumn(PostWorksheetListColumnRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListColumnWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListColumnWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListColumnWithHttpInfo(PostWorksheetListColumnRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListColumnValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListColumnAsync( PostWorksheetListColumnRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListColumnValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetListColumnsTotalValidateBeforeCall(PostWorksheetListColumnsTotalRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetListColumnsTotal(PostWorksheetListColumnsTotalRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetListColumnsTotalWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetListColumnsTotalWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetListColumnsTotalWithHttpInfo(PostWorksheetListColumnsTotalRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetListColumnsTotalValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetListColumnsTotalAsync( PostWorksheetListColumnsTotalRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetListColumnsTotalValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetOleObjectsValidateBeforeCall(GetWorksheetOleObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  OleObjectsResponse  getWorksheetOleObjects(GetWorksheetOleObjectsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< OleObjectsResponse > resp = getWorksheetOleObjectsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< OleObjectsResponse > resp = getWorksheetOleObjectsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< OleObjectsResponse > getWorksheetOleObjectsWithHttpInfo(GetWorksheetOleObjectsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetOleObjectsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< OleObjectsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetOleObjectsAsync( GetWorksheetOleObjectsRequest request, final ApiCallback< OleObjectsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetOleObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< OleObjectsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetOleObjectValidateBeforeCall(GetWorksheetOleObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  getWorksheetOleObject(GetWorksheetOleObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = getWorksheetOleObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = getWorksheetOleObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > getWorksheetOleObjectWithHttpInfo(GetWorksheetOleObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetOleObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetOleObjectAsync( GetWorksheetOleObjectRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetOleObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetOleObjectsValidateBeforeCall(DeleteWorksheetOleObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetOleObjects(DeleteWorksheetOleObjectsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetOleObjectsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetOleObjectsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetOleObjectsWithHttpInfo(DeleteWorksheetOleObjectsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetOleObjectsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetOleObjectsAsync( DeleteWorksheetOleObjectsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetOleObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetOleObjectValidateBeforeCall(DeleteWorksheetOleObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetOleObject(DeleteWorksheetOleObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetOleObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetOleObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetOleObjectWithHttpInfo(DeleteWorksheetOleObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetOleObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetOleObjectAsync( DeleteWorksheetOleObjectRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetOleObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postUpdateWorksheetOleObjectValidateBeforeCall(PostUpdateWorksheetOleObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postUpdateWorksheetOleObject(PostUpdateWorksheetOleObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetOleObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postUpdateWorksheetOleObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postUpdateWorksheetOleObjectWithHttpInfo(PostUpdateWorksheetOleObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postUpdateWorksheetOleObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postUpdateWorksheetOleObjectAsync( PostUpdateWorksheetOleObjectRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postUpdateWorksheetOleObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetOleObjectValidateBeforeCall(PutWorksheetOleObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetOleObject(PutWorksheetOleObjectRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetOleObjectWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetOleObjectWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetOleObjectWithHttpInfo(PutWorksheetOleObjectRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetOleObjectValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetOleObjectAsync( PutWorksheetOleObjectRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetOleObjectValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getVerticalPageBreaksValidateBeforeCall(GetVerticalPageBreaksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  VerticalPageBreaksResponse  getVerticalPageBreaks(GetVerticalPageBreaksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< VerticalPageBreaksResponse > resp = getVerticalPageBreaksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< VerticalPageBreaksResponse > resp = getVerticalPageBreaksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< VerticalPageBreaksResponse > getVerticalPageBreaksWithHttpInfo(GetVerticalPageBreaksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getVerticalPageBreaksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< VerticalPageBreaksResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getVerticalPageBreaksAsync( GetVerticalPageBreaksRequest request, final ApiCallback< VerticalPageBreaksResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getVerticalPageBreaksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< VerticalPageBreaksResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getHorizontalPageBreaksValidateBeforeCall(GetHorizontalPageBreaksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  HorizontalPageBreaksResponse  getHorizontalPageBreaks(GetHorizontalPageBreaksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< HorizontalPageBreaksResponse > resp = getHorizontalPageBreaksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< HorizontalPageBreaksResponse > resp = getHorizontalPageBreaksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< HorizontalPageBreaksResponse > getHorizontalPageBreaksWithHttpInfo(GetHorizontalPageBreaksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getHorizontalPageBreaksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< HorizontalPageBreaksResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getHorizontalPageBreaksAsync( GetHorizontalPageBreaksRequest request, final ApiCallback< HorizontalPageBreaksResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getHorizontalPageBreaksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HorizontalPageBreaksResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getVerticalPageBreakValidateBeforeCall(GetVerticalPageBreakRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  VerticalPageBreakResponse  getVerticalPageBreak(GetVerticalPageBreakRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< VerticalPageBreakResponse > resp = getVerticalPageBreakWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< VerticalPageBreakResponse > resp = getVerticalPageBreakWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< VerticalPageBreakResponse > getVerticalPageBreakWithHttpInfo(GetVerticalPageBreakRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getVerticalPageBreakValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< VerticalPageBreakResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getVerticalPageBreakAsync( GetVerticalPageBreakRequest request, final ApiCallback< VerticalPageBreakResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getVerticalPageBreakValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< VerticalPageBreakResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getHorizontalPageBreakValidateBeforeCall(GetHorizontalPageBreakRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  HorizontalPageBreakResponse  getHorizontalPageBreak(GetHorizontalPageBreakRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< HorizontalPageBreakResponse > resp = getHorizontalPageBreakWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< HorizontalPageBreakResponse > resp = getHorizontalPageBreakWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< HorizontalPageBreakResponse > getHorizontalPageBreakWithHttpInfo(GetHorizontalPageBreakRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getHorizontalPageBreakValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< HorizontalPageBreakResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getHorizontalPageBreakAsync( GetHorizontalPageBreakRequest request, final ApiCallback< HorizontalPageBreakResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getHorizontalPageBreakValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HorizontalPageBreakResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putVerticalPageBreakValidateBeforeCall(PutVerticalPageBreakRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putVerticalPageBreak(PutVerticalPageBreakRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putVerticalPageBreakWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putVerticalPageBreakWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putVerticalPageBreakWithHttpInfo(PutVerticalPageBreakRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putVerticalPageBreakValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putVerticalPageBreakAsync( PutVerticalPageBreakRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putVerticalPageBreakValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putHorizontalPageBreakValidateBeforeCall(PutHorizontalPageBreakRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putHorizontalPageBreak(PutHorizontalPageBreakRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putHorizontalPageBreakWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putHorizontalPageBreakWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putHorizontalPageBreakWithHttpInfo(PutHorizontalPageBreakRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putHorizontalPageBreakValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putHorizontalPageBreakAsync( PutHorizontalPageBreakRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putHorizontalPageBreakValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteVerticalPageBreaksValidateBeforeCall(DeleteVerticalPageBreaksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteVerticalPageBreaks(DeleteVerticalPageBreaksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteVerticalPageBreaksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteVerticalPageBreaksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteVerticalPageBreaksWithHttpInfo(DeleteVerticalPageBreaksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteVerticalPageBreaksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteVerticalPageBreaksAsync( DeleteVerticalPageBreaksRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteVerticalPageBreaksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteHorizontalPageBreaksValidateBeforeCall(DeleteHorizontalPageBreaksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteHorizontalPageBreaks(DeleteHorizontalPageBreaksRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteHorizontalPageBreaksWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteHorizontalPageBreaksWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteHorizontalPageBreaksWithHttpInfo(DeleteHorizontalPageBreaksRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteHorizontalPageBreaksValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteHorizontalPageBreaksAsync( DeleteHorizontalPageBreaksRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteHorizontalPageBreaksValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteVerticalPageBreakValidateBeforeCall(DeleteVerticalPageBreakRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteVerticalPageBreak(DeleteVerticalPageBreakRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteVerticalPageBreakWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteVerticalPageBreakWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteVerticalPageBreakWithHttpInfo(DeleteVerticalPageBreakRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteVerticalPageBreakValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteVerticalPageBreakAsync( DeleteVerticalPageBreakRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteVerticalPageBreakValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteHorizontalPageBreakValidateBeforeCall(DeleteHorizontalPageBreakRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteHorizontalPageBreak(DeleteHorizontalPageBreakRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteHorizontalPageBreakWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteHorizontalPageBreakWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteHorizontalPageBreakWithHttpInfo(DeleteHorizontalPageBreakRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteHorizontalPageBreakValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteHorizontalPageBreakAsync( DeleteHorizontalPageBreakRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteHorizontalPageBreakValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getPageSetupValidateBeforeCall(GetPageSetupRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PageSetupResponse  getPageSetup(GetPageSetupRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PageSetupResponse > resp = getPageSetupWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PageSetupResponse > resp = getPageSetupWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PageSetupResponse > getPageSetupWithHttpInfo(GetPageSetupRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getPageSetupValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PageSetupResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getPageSetupAsync( GetPageSetupRequest request, final ApiCallback< PageSetupResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getPageSetupValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PageSetupResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postPageSetupValidateBeforeCall(PostPageSetupRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postPageSetup(PostPageSetupRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postPageSetupWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postPageSetupWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postPageSetupWithHttpInfo(PostPageSetupRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postPageSetupValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postPageSetupAsync( PostPageSetupRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postPageSetupValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteHeaderFooterValidateBeforeCall(DeleteHeaderFooterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteHeaderFooter(DeleteHeaderFooterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteHeaderFooterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteHeaderFooterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteHeaderFooterWithHttpInfo(DeleteHeaderFooterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteHeaderFooterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteHeaderFooterAsync( DeleteHeaderFooterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteHeaderFooterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getHeaderValidateBeforeCall(GetHeaderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PageSectionsResponse  getHeader(GetHeaderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PageSectionsResponse > resp = getHeaderWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PageSectionsResponse > resp = getHeaderWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PageSectionsResponse > getHeaderWithHttpInfo(GetHeaderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getHeaderValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PageSectionsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getHeaderAsync( GetHeaderRequest request, final ApiCallback< PageSectionsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getHeaderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PageSectionsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postHeaderValidateBeforeCall(PostHeaderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postHeader(PostHeaderRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postHeaderWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postHeaderWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postHeaderWithHttpInfo(PostHeaderRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postHeaderValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postHeaderAsync( PostHeaderRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postHeaderValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getFooterValidateBeforeCall(GetFooterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PageSectionsResponse  getFooter(GetFooterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PageSectionsResponse > resp = getFooterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PageSectionsResponse > resp = getFooterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PageSectionsResponse > getFooterWithHttpInfo(GetFooterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getFooterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PageSectionsResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getFooterAsync( GetFooterRequest request, final ApiCallback< PageSectionsResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getFooterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PageSectionsResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postFooterValidateBeforeCall(PostFooterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postFooter(PostFooterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postFooterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postFooterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postFooterWithHttpInfo(PostFooterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postFooterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postFooterAsync( PostFooterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postFooterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postFitWideToPagesValidateBeforeCall(PostFitWideToPagesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postFitWideToPages(PostFitWideToPagesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postFitWideToPagesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postFitWideToPagesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postFitWideToPagesWithHttpInfo(PostFitWideToPagesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postFitWideToPagesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postFitWideToPagesAsync( PostFitWideToPagesRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postFitWideToPagesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postFitTallToPagesValidateBeforeCall(PostFitTallToPagesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postFitTallToPages(PostFitTallToPagesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postFitTallToPagesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postFitTallToPagesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postFitTallToPagesWithHttpInfo(PostFitTallToPagesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postFitTallToPagesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postFitTallToPagesAsync( PostFitTallToPagesRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postFitTallToPagesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetPicturesValidateBeforeCall(GetWorksheetPicturesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PicturesResponse  getWorksheetPictures(GetWorksheetPicturesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PicturesResponse > resp = getWorksheetPicturesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PicturesResponse > resp = getWorksheetPicturesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PicturesResponse > getWorksheetPicturesWithHttpInfo(GetWorksheetPicturesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetPicturesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PicturesResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetPicturesAsync( GetWorksheetPicturesRequest request, final ApiCallback< PicturesResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetPicturesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PicturesResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetPictureWithFormatValidateBeforeCall(GetWorksheetPictureWithFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  File  getWorksheetPictureWithFormat(GetWorksheetPictureWithFormatRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< File > resp = getWorksheetPictureWithFormatWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< File > resp = getWorksheetPictureWithFormatWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< File > getWorksheetPictureWithFormatWithHttpInfo(GetWorksheetPictureWithFormatRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetPictureWithFormatValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< File >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetPictureWithFormatAsync( GetWorksheetPictureWithFormatRequest request, final ApiCallback< HashMap<String,File> > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetPictureWithFormatValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< HashMap<String,File> >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetAddPictureValidateBeforeCall(PutWorksheetAddPictureRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetAddPicture(PutWorksheetAddPictureRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetAddPictureWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetAddPictureWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetAddPictureWithHttpInfo(PutWorksheetAddPictureRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetAddPictureValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetAddPictureAsync( PutWorksheetAddPictureRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetAddPictureValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call addPictureInCellValidateBeforeCall(AddPictureInCellRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  addPictureInCell(AddPictureInCellRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = addPictureInCellWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = addPictureInCellWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > addPictureInCellWithHttpInfo(AddPictureInCellRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  addPictureInCellValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  addPictureInCellAsync( AddPictureInCellRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  addPictureInCellValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetPictureValidateBeforeCall(PostWorksheetPictureRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetPicture(PostWorksheetPictureRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetPictureWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetPictureWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetPictureWithHttpInfo(PostWorksheetPictureRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetPictureValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetPictureAsync( PostWorksheetPictureRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetPictureValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetPictureValidateBeforeCall(DeleteWorksheetPictureRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetPicture(DeleteWorksheetPictureRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetPictureWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetPictureWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetPictureWithHttpInfo(DeleteWorksheetPictureRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetPictureValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetPictureAsync( DeleteWorksheetPictureRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetPictureValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetPicturesValidateBeforeCall(DeleteWorksheetPicturesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetPictures(DeleteWorksheetPicturesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetPicturesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetPicturesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetPicturesWithHttpInfo(DeleteWorksheetPicturesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetPicturesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetPicturesAsync( DeleteWorksheetPicturesRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetPicturesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetPivotTablesValidateBeforeCall(GetWorksheetPivotTablesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PivotTablesResponse  getWorksheetPivotTables(GetWorksheetPivotTablesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PivotTablesResponse > resp = getWorksheetPivotTablesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PivotTablesResponse > resp = getWorksheetPivotTablesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PivotTablesResponse > getWorksheetPivotTablesWithHttpInfo(GetWorksheetPivotTablesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetPivotTablesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PivotTablesResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetPivotTablesAsync( GetWorksheetPivotTablesRequest request, final ApiCallback< PivotTablesResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetPivotTablesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PivotTablesResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetPivotTableValidateBeforeCall(GetWorksheetPivotTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PivotTableResponse  getWorksheetPivotTable(GetWorksheetPivotTableRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PivotTableResponse > resp = getWorksheetPivotTableWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PivotTableResponse > resp = getWorksheetPivotTableWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PivotTableResponse > getWorksheetPivotTableWithHttpInfo(GetWorksheetPivotTableRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetPivotTableValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PivotTableResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetPivotTableAsync( GetWorksheetPivotTableRequest request, final ApiCallback< PivotTableResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetPivotTableValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PivotTableResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getPivotTableFieldValidateBeforeCall(GetPivotTableFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PivotFieldResponse  getPivotTableField(GetPivotTableFieldRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PivotFieldResponse > resp = getPivotTableFieldWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PivotFieldResponse > resp = getPivotTableFieldWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PivotFieldResponse > getPivotTableFieldWithHttpInfo(GetPivotTableFieldRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getPivotTableFieldValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PivotFieldResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getPivotTableFieldAsync( GetPivotTableFieldRequest request, final ApiCallback< PivotFieldResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getPivotTableFieldValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PivotFieldResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetPivotTableFiltersValidateBeforeCall(GetWorksheetPivotTableFiltersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PivotFiltersResponse  getWorksheetPivotTableFilters(GetWorksheetPivotTableFiltersRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PivotFiltersResponse > resp = getWorksheetPivotTableFiltersWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PivotFiltersResponse > resp = getWorksheetPivotTableFiltersWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PivotFiltersResponse > getWorksheetPivotTableFiltersWithHttpInfo(GetWorksheetPivotTableFiltersRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetPivotTableFiltersValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PivotFiltersResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetPivotTableFiltersAsync( GetWorksheetPivotTableFiltersRequest request, final ApiCallback< PivotFiltersResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetPivotTableFiltersValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PivotFiltersResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getWorksheetPivotTableFilterValidateBeforeCall(GetWorksheetPivotTableFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  PivotFilterResponse  getWorksheetPivotTableFilter(GetWorksheetPivotTableFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< PivotFilterResponse > resp = getWorksheetPivotTableFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< PivotFilterResponse > resp = getWorksheetPivotTableFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< PivotFilterResponse > getWorksheetPivotTableFilterWithHttpInfo(GetWorksheetPivotTableFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getWorksheetPivotTableFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< PivotFilterResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getWorksheetPivotTableFilterAsync( GetWorksheetPivotTableFilterRequest request, final ApiCallback< PivotFilterResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getWorksheetPivotTableFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< PivotFilterResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetPivotTableValidateBeforeCall(PutWorksheetPivotTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetPivotTable(PutWorksheetPivotTableRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetPivotTableWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetPivotTableWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetPivotTableWithHttpInfo(PutWorksheetPivotTableRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetPivotTableValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetPivotTableAsync( PutWorksheetPivotTableRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetPivotTableValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putPivotTableFieldValidateBeforeCall(PutPivotTableFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putPivotTableField(PutPivotTableFieldRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putPivotTableFieldWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putPivotTableFieldWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putPivotTableFieldWithHttpInfo(PutPivotTableFieldRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putPivotTableFieldValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putPivotTableFieldAsync( PutPivotTableFieldRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putPivotTableFieldValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putWorksheetPivotTableFilterValidateBeforeCall(PutWorksheetPivotTableFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putWorksheetPivotTableFilter(PutWorksheetPivotTableFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putWorksheetPivotTableFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putWorksheetPivotTableFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putWorksheetPivotTableFilterWithHttpInfo(PutWorksheetPivotTableFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putWorksheetPivotTableFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putWorksheetPivotTableFilterAsync( PutWorksheetPivotTableFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putWorksheetPivotTableFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postPivotTableFieldHideItemValidateBeforeCall(PostPivotTableFieldHideItemRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postPivotTableFieldHideItem(PostPivotTableFieldHideItemRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postPivotTableFieldHideItemWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postPivotTableFieldHideItemWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postPivotTableFieldHideItemWithHttpInfo(PostPivotTableFieldHideItemRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postPivotTableFieldHideItemValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postPivotTableFieldHideItemAsync( PostPivotTableFieldHideItemRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postPivotTableFieldHideItemValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postPivotTableFieldMoveToValidateBeforeCall(PostPivotTableFieldMoveToRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postPivotTableFieldMoveTo(PostPivotTableFieldMoveToRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postPivotTableFieldMoveToWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postPivotTableFieldMoveToWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postPivotTableFieldMoveToWithHttpInfo(PostPivotTableFieldMoveToRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postPivotTableFieldMoveToValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postPivotTableFieldMoveToAsync( PostPivotTableFieldMoveToRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postPivotTableFieldMoveToValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postPivotTableCellStyleValidateBeforeCall(PostPivotTableCellStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postPivotTableCellStyle(PostPivotTableCellStyleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postPivotTableCellStyleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postPivotTableCellStyleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postPivotTableCellStyleWithHttpInfo(PostPivotTableCellStyleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postPivotTableCellStyleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postPivotTableCellStyleAsync( PostPivotTableCellStyleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postPivotTableCellStyleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postPivotTableStyleValidateBeforeCall(PostPivotTableStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postPivotTableStyle(PostPivotTableStyleRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postPivotTableStyleWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postPivotTableStyleWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postPivotTableStyleWithHttpInfo(PostPivotTableStyleRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postPivotTableStyleValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postPivotTableStyleAsync( PostPivotTableStyleRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postPivotTableStyleValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postPivotTableUpdatePivotFieldsValidateBeforeCall(PostPivotTableUpdatePivotFieldsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postPivotTableUpdatePivotFields(PostPivotTableUpdatePivotFieldsRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postPivotTableUpdatePivotFieldsWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postPivotTableUpdatePivotFieldsWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postPivotTableUpdatePivotFieldsWithHttpInfo(PostPivotTableUpdatePivotFieldsRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postPivotTableUpdatePivotFieldsValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postPivotTableUpdatePivotFieldsAsync( PostPivotTableUpdatePivotFieldsRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postPivotTableUpdatePivotFieldsValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postPivotTableUpdatePivotFieldValidateBeforeCall(PostPivotTableUpdatePivotFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postPivotTableUpdatePivotField(PostPivotTableUpdatePivotFieldRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postPivotTableUpdatePivotFieldWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postPivotTableUpdatePivotFieldWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postPivotTableUpdatePivotFieldWithHttpInfo(PostPivotTableUpdatePivotFieldRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postPivotTableUpdatePivotFieldValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postPivotTableUpdatePivotFieldAsync( PostPivotTableUpdatePivotFieldRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postPivotTableUpdatePivotFieldValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetPivotTableCalculateValidateBeforeCall(PostWorksheetPivotTableCalculateRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetPivotTableCalculate(PostWorksheetPivotTableCalculateRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetPivotTableCalculateWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetPivotTableCalculateWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetPivotTableCalculateWithHttpInfo(PostWorksheetPivotTableCalculateRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetPivotTableCalculateValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetPivotTableCalculateAsync( PostWorksheetPivotTableCalculateRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetPivotTableCalculateValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postWorksheetPivotTableMoveValidateBeforeCall(PostWorksheetPivotTableMoveRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postWorksheetPivotTableMove(PostWorksheetPivotTableMoveRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postWorksheetPivotTableMoveWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postWorksheetPivotTableMoveWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postWorksheetPivotTableMoveWithHttpInfo(PostWorksheetPivotTableMoveRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postWorksheetPivotTableMoveValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postWorksheetPivotTableMoveAsync( PostWorksheetPivotTableMoveRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postWorksheetPivotTableMoveValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetPivotTablesValidateBeforeCall(DeleteWorksheetPivotTablesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetPivotTables(DeleteWorksheetPivotTablesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTablesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTablesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetPivotTablesWithHttpInfo(DeleteWorksheetPivotTablesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetPivotTablesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetPivotTablesAsync( DeleteWorksheetPivotTablesRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetPivotTablesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetPivotTableValidateBeforeCall(DeleteWorksheetPivotTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetPivotTable(DeleteWorksheetPivotTableRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTableWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTableWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetPivotTableWithHttpInfo(DeleteWorksheetPivotTableRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetPivotTableValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetPivotTableAsync( DeleteWorksheetPivotTableRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetPivotTableValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deletePivotTableFieldValidateBeforeCall(DeletePivotTableFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deletePivotTableField(DeletePivotTableFieldRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deletePivotTableFieldWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deletePivotTableFieldWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deletePivotTableFieldWithHttpInfo(DeletePivotTableFieldRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deletePivotTableFieldValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deletePivotTableFieldAsync( DeletePivotTableFieldRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deletePivotTableFieldValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetPivotTableFiltersValidateBeforeCall(DeleteWorksheetPivotTableFiltersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetPivotTableFilters(DeleteWorksheetPivotTableFiltersRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTableFiltersWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTableFiltersWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetPivotTableFiltersWithHttpInfo(DeleteWorksheetPivotTableFiltersRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetPivotTableFiltersValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetPivotTableFiltersAsync( DeleteWorksheetPivotTableFiltersRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetPivotTableFiltersValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteWorksheetPivotTableFilterValidateBeforeCall(DeleteWorksheetPivotTableFilterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteWorksheetPivotTableFilter(DeleteWorksheetPivotTableFilterRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTableFilterWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteWorksheetPivotTableFilterWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteWorksheetPivotTableFilterWithHttpInfo(DeleteWorksheetPivotTableFilterRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteWorksheetPivotTableFilterValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteWorksheetPivotTableFilterAsync( DeleteWorksheetPivotTableFilterRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteWorksheetPivotTableFilterValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getDocumentPropertiesValidateBeforeCall(GetDocumentPropertiesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsDocumentPropertiesResponse  getDocumentProperties(GetDocumentPropertiesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsDocumentPropertiesResponse > resp = getDocumentPropertiesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsDocumentPropertiesResponse > resp = getDocumentPropertiesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsDocumentPropertiesResponse > getDocumentPropertiesWithHttpInfo(GetDocumentPropertiesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getDocumentPropertiesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsDocumentPropertiesResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getDocumentPropertiesAsync( GetDocumentPropertiesRequest request, final ApiCallback< CellsDocumentPropertiesResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getDocumentPropertiesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsDocumentPropertiesResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call putDocumentPropertyValidateBeforeCall(PutDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  putDocumentProperty(PutDocumentPropertyRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = putDocumentPropertyWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = putDocumentPropertyWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > putDocumentPropertyWithHttpInfo(PutDocumentPropertyRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  putDocumentPropertyValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  putDocumentPropertyAsync( PutDocumentPropertyRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  putDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call getDocumentPropertyValidateBeforeCall(GetDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsDocumentPropertyResponse  getDocumentProperty(GetDocumentPropertyRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsDocumentPropertyResponse > resp = getDocumentPropertyWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsDocumentPropertyResponse > resp = getDocumentPropertyWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsDocumentPropertyResponse > getDocumentPropertyWithHttpInfo(GetDocumentPropertyRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  getDocumentPropertyValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsDocumentPropertyResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  getDocumentPropertyAsync( GetDocumentPropertyRequest request, final ApiCallback< CellsDocumentPropertyResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  getDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsDocumentPropertyResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteDocumentPropertyValidateBeforeCall(DeleteDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteDocumentProperty(DeleteDocumentPropertyRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteDocumentPropertyWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteDocumentPropertyWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteDocumentPropertyWithHttpInfo(DeleteDocumentPropertyRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteDocumentPropertyValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteDocumentPropertyAsync( DeleteDocumentPropertyRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call deleteDocumentPropertiesValidateBeforeCall(DeleteDocumentPropertiesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  deleteDocumentProperties(DeleteDocumentPropertiesRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = deleteDocumentPropertiesWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = deleteDocumentPropertiesWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > deleteDocumentPropertiesWithHttpInfo(DeleteDocumentPropertiesRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  deleteDocumentPropertiesValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  deleteDocumentPropertiesAsync( DeleteDocumentPropertiesRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  deleteDocumentPropertiesValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postDigitalSignatureValidateBeforeCall(PostDigitalSignatureRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postDigitalSignature(PostDigitalSignatureRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postDigitalSignatureWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postDigitalSignatureWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postDigitalSignatureWithHttpInfo(PostDigitalSignatureRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postDigitalSignatureValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postDigitalSignatureAsync( PostDigitalSignatureRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progressListener = null;
             ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

             if (callback != null) {
                 progressListener = new ProgressResponseBody.ProgressListener() {
                     @Override
                     public void update(long bytesRead, long contentLength, boolean done) {
                         callback.onDownloadProgress(bytesRead, contentLength, done);
                     }
                 };

                 progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                     @Override
                     public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                         callback.onUploadProgress(bytesWritten, contentLength, done);
                     }
                 };
             }

             com.squareup.okhttp.Call call =  postDigitalSignatureValidateBeforeCall(request, progressListener, progressRequestListener);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             apiClient.executeAsync(call, localVarReturnType, callback);
             return call;
         }


         @SuppressWarnings("rawtypes")
         private com.squareup.okhttp.Call postEncryptWorkbookValidateBeforeCall(PostEncryptWorkbookRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
             return request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true);
         }
         public  CellsCloudResponse  postEncryptWorkbook(PostEncryptWorkbookRequest request) throws ApiException,  IOException {
             try {
                 ApiResponse< CellsCloudResponse > resp = postEncryptWorkbookWithHttpInfo(request);
                  return resp.getData(); 
             }
             catch (ApiException ex) {
                 if (ex.getCode() == apiClient.getNotAuthCode()) {
                     apiClient.requestToken();
                     ApiResponse< CellsCloudResponse > resp = postEncryptWorkbookWithHttpInfo(request);
                      return resp.getData();       
                 }
                 throw ex;
             }
         }

         private ApiResponse< CellsCloudResponse > postEncryptWorkbookWithHttpInfo(PostEncryptWorkbookRequest request) throws ApiException,  IOException {
             com.squareup.okhttp.Call call =  postEncryptWorkbookValidateBeforeCall(request, null, null);
             Type localVarReturnType = new TypeToken< CellsCloudResponse >(){}.getType();
             return apiClient.execute(call, localVarReturnType);
         }

         public com.squareup.okhttp.Call  postEncryptWorkbookAsync( PostEncryptWorkbookRequest request, final ApiCallback< CellsCloudResponse > callback) throws ApiException,  IOException {

             ProgressResponseBody.ProgressListener progress