/*
 * --------------------------------------------------------------------------------
 * <copyright company="Aspose" file="ArcShape.java">
 *   Copyright (c) 2026 Aspose.Cells Cloud
 * </copyright>
 * <summary>
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 * </summary>
 * --------------------------------------------------------------------------------
 */

package com.aspose.cloud.cells.model;

import java.util.Objects;
import io.swagger.annotations.ApiModelProperty;
import com.aspose.cloud.cells.model.*;
import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.SerializedName;
import java.time.OffsetDateTime;


public class ArcShape  extends  Shape {
        @SerializedName("BeginArrowheadLength")
        private String beginArrowheadLength ;

        public  ArcShape  beginArrowheadLength(String  beginArrowheadLength) {
            this.beginArrowheadLength =  beginArrowheadLength;
            return this;
        }

        @ApiModelProperty(value = "")
        public String getBeginArrowheadLength() {
            return beginArrowheadLength;
        }

        public void setBeginArrowheadLength(String beginArrowheadLength) {
            this.beginArrowheadLength = beginArrowheadLength;
        }

        @SerializedName("BeginArrowheadStyle")
        private String beginArrowheadStyle ;

        public  ArcShape  beginArrowheadStyle(String  beginArrowheadStyle) {
            this.beginArrowheadStyle =  beginArrowheadStyle;
            return this;
        }

        @ApiModelProperty(value = "")
        public String getBeginArrowheadStyle() {
            return beginArrowheadStyle;
        }

        public void setBeginArrowheadStyle(String beginArrowheadStyle) {
            this.beginArrowheadStyle = beginArrowheadStyle;
        }

        @SerializedName("BeginArrowheadWidth")
        private String beginArrowheadWidth ;

        public  ArcShape  beginArrowheadWidth(String  beginArrowheadWidth) {
            this.beginArrowheadWidth =  beginArrowheadWidth;
            return this;
        }

        @ApiModelProperty(value = "")
        public String getBeginArrowheadWidth() {
            return beginArrowheadWidth;
        }

        public void setBeginArrowheadWidth(String beginArrowheadWidth) {
            this.beginArrowheadWidth = beginArrowheadWidth;
        }

        @SerializedName("EndArrowheadLength")
        private String endArrowheadLength ;

        public  ArcShape  endArrowheadLength(String  endArrowheadLength) {
            this.endArrowheadLength =  endArrowheadLength;
            return this;
        }

        @ApiModelProperty(value = "")
        public String getEndArrowheadLength() {
            return endArrowheadLength;
        }

        public void setEndArrowheadLength(String endArrowheadLength) {
            this.endArrowheadLength = endArrowheadLength;
        }

        @SerializedName("EndArrowheadStyle")
        private String endArrowheadStyle ;

        public  ArcShape  endArrowheadStyle(String  endArrowheadStyle) {
            this.endArrowheadStyle =  endArrowheadStyle;
            return this;
        }

        @ApiModelProperty(value = "")
        public String getEndArrowheadStyle() {
            return endArrowheadStyle;
        }

        public void setEndArrowheadStyle(String endArrowheadStyle) {
            this.endArrowheadStyle = endArrowheadStyle;
        }

        @SerializedName("EndArrowheadWidth")
        private String endArrowheadWidth ;

        public  ArcShape  endArrowheadWidth(String  endArrowheadWidth) {
            this.endArrowheadWidth =  endArrowheadWidth;
            return this;
        }

        @ApiModelProperty(value = "")
        public String getEndArrowheadWidth() {
            return endArrowheadWidth;
        }

        public void setEndArrowheadWidth(String endArrowheadWidth) {
            this.endArrowheadWidth = endArrowheadWidth;
        }

        @Override
        public boolean equals(java.lang.Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }

            ArcShape arcShape = (ArcShape) o;
            return
                Objects.equals(this.beginArrowheadLength, arcShape.beginArrowheadLength) &&
                Objects.equals(this.beginArrowheadStyle, arcShape.beginArrowheadStyle) &&
                Objects.equals(this.beginArrowheadWidth, arcShape.beginArrowheadWidth) &&
                Objects.equals(this.endArrowheadLength, arcShape.endArrowheadLength) &&
                Objects.equals(this.endArrowheadStyle, arcShape.endArrowheadStyle) &&
                Objects.equals(this.endArrowheadWidth, arcShape.endArrowheadWidth) &&
                super.equals(o);
      }

      @Override
      public int hashCode() {
        return Objects.hash(beginArrowheadLength, beginArrowheadStyle, beginArrowheadWidth, endArrowheadLength, endArrowheadStyle, endArrowheadWidth, super.hashCode());
      }
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class ArcShape {\n");
            sb.append("    beginArrowheadLength: ").append(toIndentedString(getBeginArrowheadLength())).append("\n");
            sb.append("    beginArrowheadStyle: ").append(toIndentedString(getBeginArrowheadStyle())).append("\n");
            sb.append("    beginArrowheadWidth: ").append(toIndentedString(getBeginArrowheadWidth())).append("\n");
            sb.append("    endArrowheadLength: ").append(toIndentedString(getEndArrowheadLength())).append("\n");
            sb.append("    endArrowheadStyle: ").append(toIndentedString(getEndArrowheadStyle())).append("\n");
            sb.append("    endArrowheadWidth: ").append(toIndentedString(getEndArrowheadWidth())).append("\n");
            sb.append("    name: ").append(toIndentedString(getName())).append("\n");
            sb.append("    msoDrawingType: ").append(toIndentedString(getMsoDrawingType())).append("\n");
            sb.append("    autoShapeType: ").append(toIndentedString(getAutoShapeType())).append("\n");
            sb.append("    placement: ").append(toIndentedString(getPlacement())).append("\n");
            sb.append("    upperLeftRow: ").append(toIndentedString(getUpperLeftRow())).append("\n");
            sb.append("    top: ").append(toIndentedString(getTop())).append("\n");
            sb.append("    upperLeftColumn: ").append(toIndentedString(getUpperLeftColumn())).append("\n");
            sb.append("    left: ").append(toIndentedString(getLeft())).append("\n");
            sb.append("    lowerRightRow: ").append(toIndentedString(getLowerRightRow())).append("\n");
            sb.append("    bottom: ").append(toIndentedString(getBottom())).append("\n");
            sb.append("    lowerRightColumn: ").append(toIndentedString(getLowerRightColumn())).append("\n");
            sb.append("    right: ").append(toIndentedString(getRight())).append("\n");
            sb.append("    width: ").append(toIndentedString(getWidth())).append("\n");
            sb.append("    height: ").append(toIndentedString(getHeight())).append("\n");
            sb.append("    x: ").append(toIndentedString(getX())).append("\n");
            sb.append("    y: ").append(toIndentedString(getY())).append("\n");
            sb.append("    rotationAngle: ").append(toIndentedString(getRotationAngle())).append("\n");
            sb.append("    htmlText: ").append(toIndentedString(getHtmlText())).append("\n");
            sb.append("    text: ").append(toIndentedString(getText())).append("\n");
            sb.append("    alternativeText: ").append(toIndentedString(getAlternativeText())).append("\n");
            sb.append("    textHorizontalAlignment: ").append(toIndentedString(getTextHorizontalAlignment())).append("\n");
            sb.append("    textHorizontalOverflow: ").append(toIndentedString(getTextHorizontalOverflow())).append("\n");
            sb.append("    textOrientationType: ").append(toIndentedString(getTextOrientationType())).append("\n");
            sb.append("    textVerticalAlignment: ").append(toIndentedString(getTextVerticalAlignment())).append("\n");
            sb.append("    textVerticalOverflow: ").append(toIndentedString(getTextVerticalOverflow())).append("\n");
            sb.append("    isGroup: ").append(toIndentedString(getIsGroup())).append("\n");
            sb.append("    isHidden: ").append(toIndentedString(getIsHidden())).append("\n");
            sb.append("    isLockAspectRatio: ").append(toIndentedString(getIsLockAspectRatio())).append("\n");
            sb.append("    isLocked: ").append(toIndentedString(getIsLocked())).append("\n");
            sb.append("    isPrintable: ").append(toIndentedString(getIsPrintable())).append("\n");
            sb.append("    isTextWrapped: ").append(toIndentedString(getIsTextWrapped())).append("\n");
            sb.append("    isWordArt: ").append(toIndentedString(getIsWordArt())).append("\n");
            sb.append("    linkedCell: ").append(toIndentedString(getLinkedCell())).append("\n");
            sb.append("    zOrderPosition: ").append(toIndentedString(getZOrderPosition())).append("\n");
            sb.append("    font: ").append(toIndentedString(getFont())).append("\n");
            sb.append("    hyperlink: ").append(toIndentedString(getHyperlink())).append("\n");
            sb.append("    link: ").append(toIndentedString(getLink())).append("\n");
            sb.append("}");
            return sb.toString();
        }

        /**
        * Convert the given object to string with each line indented by 4 spaces
        * (except the first line).
        */
        private String toIndentedString(java.lang.Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }


}

