/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cloud.cells.client;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

class LocalDateTypeAdapter
extends TypeAdapter<LocalDate> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;

    LocalDateTypeAdapter() {
    }

    public void write(JsonWriter out, LocalDate date) throws IOException {
        if (date == null) {
            out.nullValue();
        } else {
            out.value(this.formatter.format(date));
        }
    }

    public LocalDate read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        String date = in.nextString();
        return LocalDate.parse(date, this.formatter);
    }
}

