/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cloud.cells.request;

import com.aspose.cloud.cells.client.ApiClient;
import com.aspose.cloud.cells.client.ApiException;
import com.aspose.cloud.cells.client.Pair;
import com.aspose.cloud.cells.client.ProgressRequestBody;
import com.aspose.cloud.cells.client.ProgressResponseBody;
import com.aspose.cloud.cells.request.IRequestModel;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PutWorkbookBackgroundRequest
implements IRequestModel {
    private HashMap<String, String> extendQueryParameterMap;
    private String name;
    private String picPath;
    private String imageAdaptOption;
    private String folder;
    private String storageName;
    private HashMap<String, File> file;
    private String localPath;

    public HashMap<String, String> getExtendQueryParameterMap() {
        return this.extendQueryParameterMap;
    }

    public void setExtendQueryParameterMap(HashMap<String, String> extendQueryParameterMap) {
        this.extendQueryParameterMap = extendQueryParameterMap;
    }

    public PutWorkbookBackgroundRequest() {
    }

    public PutWorkbookBackgroundRequest(String name, String picPath, String imageAdaptOption, String folder, String storageName, String localPath) {
        this.name = name;
        this.picPath = picPath;
        this.imageAdaptOption = imageAdaptOption;
        this.folder = folder;
        this.storageName = storageName;
        this.localPath = localPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPicPath() {
        return this.picPath;
    }

    public void setPicPath(String picPath) {
        this.picPath = picPath;
    }

    public String getImageAdaptOption() {
        return this.imageAdaptOption;
    }

    public void setImageAdaptOption(String imageAdaptOption) {
        this.imageAdaptOption = imageAdaptOption;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public HashMap<String, File> getFile() {
        return this.file;
    }

    public void setFile(HashMap<String, File> file) {
        this.file = file;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    @Override
    public Call buildHttpRequest(ApiClient apiClient, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, Boolean addAuthHeaders) throws ApiException {
        Object fileToUpload;
        if (this.getName() == null) {
            throw new ApiException("Missing the required parameter 'Name' when calling PutWorkbookBackground");
        }
        String localVarPath = "v3.0/cells/{name}/background".replaceAll("\\{name\\}", apiClient.escapeString(this.name.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (this.getPicPath() != null) {
            localVarQueryParams.addAll(apiClient.parameterToPairs("", "picPath", this.getPicPath()));
        }
        if (this.getImageAdaptOption() != null) {
            localVarQueryParams.addAll(apiClient.parameterToPairs("", "imageAdaptOption", this.getImageAdaptOption()));
        }
        if (this.getFolder() != null) {
            localVarQueryParams.addAll(apiClient.parameterToPairs("", "folder", this.getFolder()));
        }
        if (this.getStorageName() != null) {
            localVarQueryParams.addAll(apiClient.parameterToPairs("", "storageName", this.getStorageName()));
        }
        if (this.extendQueryParameterMap != null) {
            for (String key : this.extendQueryParameterMap.keySet()) {
                localVarQueryParams.addAll(apiClient.parameterToPairs("", key, this.extendQueryParameterMap.get(key)));
            }
        }
        if (this.getLocalPath() != null && !this.getLocalPath().isEmpty() && ((File)(fileToUpload = new File(this.getLocalPath()))).exists()) {
            localVarFormParams.put(((File)fileToUpload).getName(), fileToUpload);
        }
        if (this.getFile() != null) {
            for (String key : this.getFile().keySet()) {
                localVarFormParams.put(key, this.getFile().get(key));
            }
        }
        Object localVarPostBody = null;
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
}

