/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.tests;

import com.aspose.html.Configuration;
import com.aspose.html.ConverterBuilder;
import com.aspose.html.JobBuilder;
import com.aspose.html.model.OperationResult;
import com.aspose.html.options.ImageConversionOptions;
import com.aspose.html.options.Options;
import com.aspose.html.options.PDFConversionOptions;
import com.aspose.html.options.XPSConversionOptions;
import com.aspose.html.tests.BaseTest;
import com.aspose.html.tests.TestHelper;
import java.io.File;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConvertEpubTest
extends BaseTest {
    @BeforeAll
    public static void init() {
        inputFile = Configuration.getTestSrcDir() + File.separator + "test.epub";
    }

    @ParameterizedTest(name="{index} - epub -> {0} : local -> local")
    @ValueSource(strings={"pdf", "xps", "docx", "jpeg", "bmp", "png", "tiff", "gif"})
    public void convertEpubLocalToLocal(String ext) {
        String outputFile = Configuration.getTestDstDir() + File.separator + "convertEpubLocalToLocal." + ext;
        File f = new File(outputFile);
        if (f.exists()) {
            f.delete();
        }
        JobBuilder builder = new ConverterBuilder().fromLocalFile(inputFile).saveToLocal(outputFile);
        OperationResult result = api.convert(builder);
        File dst = new File(result.getFile());
        Assertions.assertTrue((boolean)dst.exists());
    }

    @ParameterizedTest(name="{index} - epub -> {0} : local -> storage")
    @ValueSource(strings={"pdf", "xps", "docx", "jpeg", "bmp", "png", "tiff", "gif"})
    public void convertEpubLocalToStorage(String ext) {
        String outputFile = "LocalToStorageTest" + File.separator + "convertEpubLocalToStorage." + ext;
        File f = new File(outputFile);
        if (f.exists()) {
            f.delete();
        }
        JobBuilder builder = new ConverterBuilder().fromLocalFile(inputFile).saveToStorage(outputFile);
        OperationResult result = api.convert(builder);
        Assertions.assertTrue((boolean)TestHelper.isExist(result.getFile()));
        TestHelper.deleteFile(result.getFile());
    }

    @Test
    public void convertEpubToPdfWithOptions() {
        String outputFile = Configuration.getTestDstDir() + File.separator + "convertEpubToPdfWithOptions.pdf";
        File f = new File(outputFile);
        if (f.exists()) {
            f.delete();
        }
        PDFConversionOptions opt_A5 = new PDFConversionOptions().setWidth(5.8).setHeight(8.3).setTopMargin(0.5).setBottomMargin(0.5).setLeftMargin(0.5).setRightMargin(0.5).setQuality(95);
        JobBuilder builder = new ConverterBuilder().fromLocalFile(inputFile).useOptions((Options)opt_A5).saveToLocal(outputFile);
        OperationResult result = api.convert(builder);
        String target = Paths.get(builder.target.filePath, new String[0]).getParent().toString() + "/" + Paths.get(result.getFile(), new String[0]).getFileName().toString();
        File testFile = new File(target);
        Assertions.assertTrue((boolean)testFile.exists());
    }

    @Test
    public void convertEpubToXpsWithOptions() {
        String outputFile = Configuration.getTestDstDir() + File.separator + "convertEpubToXpsWithOptions.xps";
        File f = new File(outputFile);
        if (f.exists()) {
            f.delete();
        }
        XPSConversionOptions opt_A5 = new XPSConversionOptions().setWidth(5.8).setHeight(8.3).setTopMargin(0.5).setBottomMargin(0.5).setLeftMargin(0.5).setRightMargin(0.5);
        JobBuilder builder = new ConverterBuilder().fromLocalFile(inputFile).useOptions((Options)opt_A5).saveToLocal(outputFile);
        OperationResult result = api.convert(builder);
        String target = Paths.get(builder.target.filePath, new String[0]).getParent().toString() + "/" + Paths.get(result.getFile(), new String[0]).getFileName().toString();
        File testFile = new File(target);
        Assertions.assertTrue((boolean)testFile.exists());
    }

    @ParameterizedTest(name="{index} - convert to {0}")
    @ValueSource(strings={"jpeg", "bmp", "png", "tiff", "gif"})
    public void convertEpubToImageWithOptions(String ext) {
        String outputFile = Configuration.getTestDstDir() + File.separator + "convertEpubToImageWithOptions." + ext;
        File f = new File(outputFile);
        if (f.exists()) {
            f.delete();
        }
        ImageConversionOptions opt = new ImageConversionOptions().setWidth(600).setHeight(900).setTopMargin(20).setBottomMargin(20).setLeftMargin(20).setRightMargin(20);
        JobBuilder builder = new ConverterBuilder().fromLocalFile(inputFile).useOptions((Options)opt).saveToLocal(outputFile);
        OperationResult result = api.convert(builder);
        File testFile = new File(result.getFile());
        Assertions.assertTrue((boolean)testFile.exists());
    }
}

