/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.tests;

import com.aspose.html.Configuration;
import com.aspose.html.ConverterBuilder;
import com.aspose.html.JobBuilder;
import com.aspose.html.model.OperationResult;
import com.aspose.html.options.Options;
import com.aspose.html.options.VectorizationOptions;
import com.aspose.html.tests.BaseTest;
import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConvertImageToSVGTest
extends BaseTest {
    @BeforeAll
    public static void init() {
        inputFile = Configuration.getTestSrcDir() + File.separator + "car.";
    }

    @ParameterizedTest(name="{index} - {0} -> svg trace")
    @ValueSource(strings={"jpg", "bmp", "png", "tiff", "gif"})
    public void traceImageToSvgLocalToLocal(String ext) {
        String outputFile = Configuration.getTestDstDir() + File.separator + "traceFrom" + ext.toUpperCase() + "ToSVG.svg";
        File f = new File(outputFile);
        if (f.exists()) {
            f.delete();
        }
        JobBuilder builder = new ConverterBuilder().fromLocalFile(inputFile + ext).saveToLocal(outputFile);
        OperationResult result = api.convert(builder);
        File dst = new File(result.getFile());
        Assertions.assertTrue((boolean)dst.exists());
    }

    @ParameterizedTest(name="{index} - {0} -> svg trace with opts")
    @ValueSource(strings={"jpg", "bmp", "png", "tiff", "gif"})
    public void traceImageToSvgLocalToLocalWithOpts(String ext) {
        String outputFile = Configuration.getTestDstDir() + File.separator + "traceFrom" + ext.toUpperCase() + "ToSVGWithOpts.svg";
        File f = new File(outputFile);
        if (f.exists()) {
            f.delete();
        }
        VectorizationOptions opts = new VectorizationOptions().setErrorThreshold(50.0).setColorLimit(2).setLineWidth(1.5).setMaxIteration(10);
        JobBuilder builder = new ConverterBuilder().fromLocalFile(inputFile + ext).useOptions((Options)opts).saveToLocal(outputFile);
        OperationResult result = api.convert(builder);
        File dst = new File(result.getFile());
        Assertions.assertTrue((boolean)dst.exists());
    }
}

