/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.tests;

import com.aspose.html.ApiClient;
import com.aspose.html.Configuration;
import com.aspose.html.api.StorageApi;
import com.aspose.html.model.DiscUsage;
import com.aspose.html.model.FilesList;
import com.aspose.html.model.FilesUploadResult;
import com.aspose.html.model.ObjectExist;
import com.aspose.html.model.StorageExist;
import com.aspose.html.tests.BaseTest;
import com.aspose.html.tests.TestHelper;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import retrofit2.Call;
import retrofit2.Response;

public class StorageTest
extends BaseTest {
    public static StorageApi storageApi;

    public StorageTest() {
        storageApi = (StorageApi)new ApiClient().createService(StorageApi.class);
    }

    @Test
    public void uploadFile() {
        try {
            File f = new File(Configuration.getTestSrcDir(), "test.txt");
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)f);
            MultipartBody.Part fileToUpload = MultipartBody.Part.createFormData((String)"file", (String)f.getName(), (RequestBody)requestBody);
            Call call_create = storageApi.uploadFile(fileToUpload, "HtmlTestDoc", null);
            Response res = call_create.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            FilesUploadResult result = (FilesUploadResult)res.body();
            Assertions.assertEquals((int)1, (int)result.getUploaded().size());
            Assertions.assertEquals((int)0, (int)result.getErrors().size());
            Call call_exist = storageApi.objectExists("HtmlTestDoc/test.txt", null, null);
            Response res_exist = call_exist.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            ObjectExist res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertTrue((boolean)res_exist_body.isExists(), (String)"File not exist");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be file, not folder");
            Call call_response = storageApi.deleteFolder("HtmlTestDoc", null, Boolean.valueOf(true));
            Response res1 = call_response.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            call_exist = storageApi.objectExists("HtmlTestDoc", null, null);
            res_exist = call_exist.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertFalse((boolean)res_exist_body.isExists(), (String)"Error, must be not exist new folder after delete");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be false after delete");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void downloadFile() {
        try {
            File f = new File(Configuration.getTestSrcDir(), "testDownload.jpg");
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)f);
            MultipartBody.Part fileToUpload = MultipartBody.Part.createFormData((String)"file", (String)f.getName(), (RequestBody)requestBody);
            Call call_create = storageApi.uploadFile(fileToUpload, "HtmlTestDoc", null);
            Response res = call_create.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            FilesUploadResult result = (FilesUploadResult)res.body();
            Assertions.assertEquals((int)1, (int)result.getUploaded().size());
            Assertions.assertEquals((int)0, (int)result.getErrors().size());
            Call call_download = storageApi.downloadFile("HtmlTestDoc/testDownload.jpg", null, null);
            Response res1 = call_download.execute();
            Assertions.assertTrue((boolean)res1.isSuccessful());
            ResponseBody res_download = (ResponseBody)res1.body();
            Assertions.assertTrue((boolean)TestHelper.saveToDisc(res_download, "TestDownloadResult.jpg"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void deleteFile() {
        try {
            String fileName = "test_delete.txt";
            File f = new File(Configuration.getTestSrcDir(), fileName);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)f);
            MultipartBody.Part fileToUpload = MultipartBody.Part.createFormData((String)"file", (String)f.getName(), (RequestBody)requestBody);
            Call call_create = storageApi.uploadFile(fileToUpload, "HtmlTestDoc", null);
            Response res = call_create.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            FilesUploadResult result = (FilesUploadResult)res.body();
            Assertions.assertEquals((int)1, (int)result.getUploaded().size());
            Assertions.assertEquals((int)0, (int)result.getErrors().size());
            Call call = storageApi.objectExists("HtmlTestDoc/" + fileName, null, null);
            Response res_exist = call.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            ObjectExist res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertTrue((boolean)res_exist_body.isExists(), (String)"Error, must be exist, not exist");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be file, not folder");
            Call call_response = storageApi.deleteFile("HtmlTestDoc/test_delete_file.txt", null, null);
            Response res2 = call_response.execute();
            Assertions.assertTrue((boolean)res2.isSuccessful());
            call = storageApi.objectExists("HtmlTestDoc/test_delete_file.txt", null, null);
            res_exist = call.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertFalse((boolean)res_exist_body.isExists(), (String)"Error, file exist after delete");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be false, file not exist");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void getFilesList() {
        try {
            Call call = storageApi.getFilesList("HtmlTestDoc", null);
            Response res = call.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            FilesList response = (FilesList)res.body();
            Assertions.assertTrue((boolean)TestHelper.saveToDisc(response.toString(), "FileList.json"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void createFolder() {
        try {
            String folderName = "CreateTestFolder";
            Call call = storageApi.createFolder(folderName, null);
            Response res = call.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            Call call_exist = storageApi.objectExists(folderName, null, null);
            Response res_exist = call_exist.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            ObjectExist res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertTrue((boolean)res_exist_body.isExists(), (String)"Error, must be exist folder after creating");
            Assertions.assertTrue((boolean)res_exist_body.isFolder(), (String)"Error, must be folder, not folder");
            Call call_response = storageApi.deleteFolder(folderName, null, Boolean.valueOf(false));
            Response res1 = call_response.execute();
            Assertions.assertTrue((boolean)res1.isSuccessful());
            call_exist = storageApi.objectExists(folderName, null, null);
            res_exist = call_exist.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertFalse((boolean)res_exist_body.isExists(), (String)"Error, must be  not exist folder after deleting");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be false after deleting folder");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void deleteFolder() {
        try {
            String folderName = "TestDeleteFolder";
            Call call_create = storageApi.createFolder(folderName, null);
            Response res = call_create.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            Call call_exist = storageApi.objectExists(folderName, null, null);
            Response res_exist = call_exist.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            ObjectExist res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertTrue((boolean)res_exist_body.isExists(), (String)"Error, must be exist new folder after create");
            Assertions.assertTrue((boolean)res_exist_body.isFolder(), (String)"Error, must be folder after create");
            Call call_response = storageApi.deleteFolder(folderName, null, Boolean.valueOf(true));
            Response res1 = call_response.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            call_exist = storageApi.objectExists(folderName, null, null);
            res_exist = call_exist.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertFalse((boolean)res_exist_body.isExists(), (String)"Error, must be not exist new folder after delete");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be false after delete");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void storageExists() {
        String storageNotExist = "NotExistStorage";
        String storageExist = "/";
        try {
            Call call = storageApi.storageExists(storageNotExist);
            Response res = call.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            StorageExist result = (StorageExist)res.body();
            Assertions.assertFalse((boolean)result.isExists(), (String)"Storage doesn't exist, but result is exist");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void objectExists() {
        String existFile = "HtmlTestDoc/test.txt";
        String notExistFile = "HtmlTestDoc/fake.txt";
        String existFolder = "HtmlTestDoc";
        String notExistFolder = "FakeFolder";
        try {
            File f = new File(Configuration.getTestSrcDir(), "test.txt");
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)f);
            MultipartBody.Part fileToUpload = MultipartBody.Part.createFormData((String)"file", (String)f.getName(), (RequestBody)requestBody);
            Call call_upload = storageApi.uploadFile(fileToUpload, "HtmlTestDoc", null);
            Response res = call_upload.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            FilesUploadResult result = (FilesUploadResult)res.body();
            Assertions.assertEquals((int)1, (int)result.getUploaded().size());
            Assertions.assertEquals((int)0, (int)result.getErrors().size());
            Call call = storageApi.objectExists(existFile, null, null);
            Response res_exist = call.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            ObjectExist res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertTrue((boolean)res_exist_body.isExists(), (String)"Error, must be exist");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be file, not folder");
            call = storageApi.objectExists(notExistFile, null, null);
            res_exist = call.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertFalse((boolean)res_exist_body.isExists(), (String)"Error, must be not exist");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be false for not exist file");
            call = storageApi.objectExists(existFolder, null, null);
            res_exist = call.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertTrue((boolean)res_exist_body.isExists(), (String)"Error, must be exist");
            Assertions.assertTrue((boolean)res_exist_body.isFolder(), (String)"Error, must be folder");
            call = storageApi.objectExists(notExistFolder, null, null);
            res_exist = call.execute();
            Assertions.assertTrue((boolean)res_exist.isSuccessful());
            res_exist_body = (ObjectExist)res_exist.body();
            Assertions.assertFalse((boolean)res_exist_body.isExists(), (String)"Error, must be not exist");
            Assertions.assertFalse((boolean)res_exist_body.isFolder(), (String)"Error, must be false for not exist folder");
            Call call_response = storageApi.deleteFile("HtmlTestDoc/test.txt", null, null);
            Response res2 = call_response.execute();
            Assertions.assertTrue((boolean)res2.isSuccessful());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void getDiscUsage() {
        try {
            Call call = storageApi.getDiscUsage(null);
            Response res = call.execute();
            Assertions.assertTrue((boolean)res.isSuccessful());
            DiscUsage result = (DiscUsage)res.body();
            Assertions.assertTrue((result.getUsedSize() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((result.getTotalSize() > 0L ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail();
        }
    }
}

