/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.tests;

import com.aspose.html.ApiClient;
import com.aspose.html.Configuration;
import com.aspose.html.api.StorageApi;
import com.aspose.html.model.ObjectExist;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.junit.jupiter.api.Assertions;
import retrofit2.Call;
import retrofit2.Response;

public class TestHelper {
    private static final StorageApi storageApi = (StorageApi)new ApiClient().createService(StorageApi.class);

    public static void checkAndSave(Call<ResponseBody> call, String fileName) throws IOException {
        Response res = call.execute();
        Assertions.assertTrue((boolean)res.isSuccessful());
        ResponseBody answer = (ResponseBody)res.body();
        boolean result = TestHelper.saveToDisc(answer, fileName);
        Assertions.assertTrue((boolean)result);
    }

    public static boolean saveToDisc(String data, String fileName) {
        try {
            Files.write(Paths.get(Configuration.getTestDstDir() + "/" + fileName, new String[0]), data.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean saveToDisc(ResponseBody body, String fileName) {
        File savedFile = new File(Configuration.getTestDstDir() + File.separator + fileName);
        try (InputStream inputStream = body.byteStream();){
            boolean bl;
            try (FileOutputStream outputStream = new FileOutputStream(savedFile);){
                int read;
                byte[] fileReader = new byte[4096];
                long fileSizeDownloaded = 0L;
                while ((read = inputStream.read(fileReader)) != -1) {
                    ((OutputStream)outputStream).write(fileReader, 0, read);
                    fileSizeDownloaded += (long)read;
                }
                outputStream.flush();
                bl = true;
            }
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isExist(String path) {
        return TestHelper.isExist(path, null, null);
    }

    public static boolean isExist(String path, String storageName) {
        return TestHelper.isExist(path, storageName, null);
    }

    public static boolean isExist(String path, String storageName, String versionId) {
        Call call = storageApi.objectExists(path, storageName, versionId);
        Response res_exist = null;
        try {
            res_exist = call.execute();
            return ((ObjectExist)res_exist.body()).isExists();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteFile(String path) {
        return TestHelper.deleteFile(path, null, null);
    }

    public static boolean deleteFile(String path, String storageName) {
        return TestHelper.deleteFile(path, storageName, null);
    }

    public static boolean deleteFile(String path, String storageName, String versionId) {
        try {
            Call call = storageApi.deleteFile(path, storageName, versionId);
            Response res_delete = call.execute();
            return res_delete.isSuccessful();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean uploadFile(String fileName) throws IOException {
        return TestHelper.uploadFile(fileName, "");
    }

    public static boolean uploadFile(String fileName, String uploadFolder) throws IOException {
        File f = new File(Configuration.getTestSrcDir(), fileName);
        if (!f.exists()) {
            System.out.println("file not found");
            throw new RuntimeException("Test file not found");
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)f);
        MultipartBody.Part fileToUpload = MultipartBody.Part.createFormData((String)"file", (String)f.getName(), (RequestBody)requestBody);
        Call call = storageApi.uploadFile(fileToUpload, uploadFolder + File.separator + fileName, null);
        Response res = call.execute();
        Assertions.assertTrue((boolean)res.isSuccessful());
        return res.isSuccessful();
    }
}

