/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.AuthAnswer;
import com.aspose.html.Configuration;
import com.aspose.html.GsonCustomConverterFactory;
import com.aspose.html.JSON;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.threeten.bp.format.DateTimeFormatter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private static final JSON json = new JSON();
    private static String accessToken;
    private static String userAgent;
    private static final String clientHeaderName = "x-aspose-client";
    private static final String clientVersionHeaderName = "x-aspose-client-version";
    private static final String clientHeaderValue = "aspose.html-cloud java sdk";
    private static final String clientVersionHeaderValue = "22.11.1";

    public ApiClient() {
        userAgent = Configuration.getUserAgent();
        accessToken = ApiClient.getAccessToken();
        this.createDefaultAdapter();
    }

    private void createDefaultAdapter() {
        String baseUrl = Configuration.getBasePath();
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.okBuilder = new OkHttpClient.Builder().readTimeout(3600L, TimeUnit.SECONDS).connectTimeout(3600L, TimeUnit.SECONDS).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = null;
                if (accessToken != null) {
                    Request original = chain.request();
                    Request.Builder requestBuilder = original.newBuilder().addHeader("Authorization", accessToken).addHeader("User-Agent", userAgent).addHeader(ApiClient.clientHeaderName, ApiClient.clientHeaderValue).addHeader(ApiClient.clientVersionHeaderName, ApiClient.clientVersionHeaderValue);
                    String orignUrl = original.url().toString();
                    String changeUrl = orignUrl.replace("%2F", "/").replace("%5C", "/");
                    Request newRequest = requestBuilder.url(changeUrl).build();
                    return chain.proceed(newRequest);
                }
                return chain.proceed(request);
            }
        });
        if (Configuration.getDebug()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY);
            this.okBuilder.addInterceptor((Interceptor)logging);
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(json.getGson()));
    }

    static String getAccessToken() {
        OkHttpClient client = new OkHttpClient();
        FormBody formBody = new FormBody.Builder().add("grant_type", "client_credentials").add("client_id", Configuration.getAPP_SID()).add("client_secret", Configuration.getAPI_KEY()).build();
        Request request = new Request.Builder().url(Configuration.getAuthPath()).post((RequestBody)formBody).build();
        try {
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String out = response.body().string();
            AuthAnswer answer = (AuthAnswer)json.deserialize(out, (Type)((Object)AuthAnswer.class));
            return "Bearer " + answer.access_token;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <S> S createService(Class<S> serviceClass) {
        return (S)this.adapterBuilder.client(this.okBuilder.build()).build().create(serviceClass);
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        json.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        json.setLocalDateFormat(dateFormat);
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ApiClient setAdapterBuilder(Retrofit.Builder adapterBuilder) {
        this.adapterBuilder = adapterBuilder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }
}

