/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.ApiClient;
import com.aspose.html.Configuration;
import com.aspose.html.JobBuilder;
import com.aspose.html.api.ConversionApi;
import com.aspose.html.api.StorageApi;
import com.aspose.html.model.FilesUploadResult;
import com.aspose.html.model.InputFormats;
import com.aspose.html.model.JobRequest;
import com.aspose.html.model.OperationResult;
import com.aspose.html.model.OutputFormats;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class HtmlApi {
    private ConversionApi conversionApi;
    private StorageApi storageApi;
    private String tempSource = null;
    private String tempTarget = null;
    private boolean clearSourceFile = false;
    private boolean clearTargetFile = false;
    private final String tempDir = "temp/";

    public HtmlApi(String apiKey, String apiSID) {
        Configuration.setAPI_KEY(apiKey);
        Configuration.setAPP_SID(apiSID);
        this.storageApi = new ApiClient().createService(StorageApi.class);
        this.conversionApi = new ApiClient().createService(ConversionApi.class);
    }

    public OperationResult convert(JobBuilder builder) {
        Response res_del;
        Call<ResponseBody> call_delete;
        if (builder.source.inputFormat == null) {
            throw new IllegalArgumentException("The input format is absent");
        }
        if (builder.target.outputFormat == null) {
            throw new IllegalArgumentException("The output format is absent");
        }
        if (builder.source.filePath == null || builder.source.filePath.isEmpty()) {
            throw new IllegalArgumentException("The input file is absent");
        }
        if (builder.target.filePath == null || builder.target.filePath.isEmpty()) {
            throw new IllegalArgumentException("The output format is absent");
        }
        JobRequest req = new JobRequest();
        if (builder.source.isLocal != null && builder.source.isLocal.booleanValue()) {
            File file = new File(builder.source.filePath);
            this.tempSource = this.tempDir + file.getName();
            boolean res = this.uploadFile(file, this.tempDir);
            if (!res) {
                throw new RuntimeException("Unable to upload the file to the storage");
            }
            req.setInputPath(this.tempSource);
            this.clearSourceFile = true;
        } else {
            req.setInputPath(builder.source.filePath);
            if (builder.source.storageName != null && !builder.source.storageName.isEmpty()) {
                req.setStorageName(builder.source.storageName);
            }
        }
        if (builder.source.resources != null && !builder.source.resources.isEmpty()) {
            req.setResources(builder.source.resources);
        }
        if (builder.options != null) {
            req.setOptions(builder.options);
        }
        if (builder.target.isLocal.booleanValue()) {
            File f = new File(builder.target.filePath);
            this.tempTarget = this.tempDir + f.getName();
            this.clearTargetFile = true;
            req.setOutputFile(this.tempTarget);
        } else {
            req.setOutputFile(builder.target.filePath);
        }
        Call<OperationResult> call_convert = this.conversionApi.convert(req, builder.source.inputFormat.toString(), builder.target.outputFormat.toString());
        Response result = null;
        try {
            result = call_convert.execute();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert");
        }
        OperationResult resp = this.WaitForResult(((OperationResult)result.body()).id);
        if (resp == null || !resp.status.equals("completed")) {
            throw new RuntimeException("Conversion failed");
        }
        if (builder.target.isLocal.booleanValue()) {
            String file = resp.getFile();
            String target = Paths.get(builder.target.filePath, new String[0]).getParent().toString() + "/" + Paths.get(file, new String[0]).getFileName().toString();
            boolean res = this.downloadFile(file, target, builder.source.storageName);
            resp.setFile(target);
            if (!res) {
                throw new RuntimeException("Unable to get result");
            }
        }
        if (this.clearSourceFile) {
            call_delete = this.storageApi.deleteFile(this.tempSource, builder.source.storageName, null);
            try {
                res_del = call_delete.execute();
                this.clearSourceFile = false;
                this.tempSource = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.clearTargetFile) {
            call_delete = this.storageApi.deleteFile(this.tempTarget, builder.target.storageName, null);
            try {
                res_del = call_delete.execute();
                this.clearTargetFile = false;
                this.tempTarget = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resp;
    }

    public OperationResult vectorize(JobBuilder builder) {
        if (builder.source.inputFormat == null || !this.isImage(builder.source.inputFormat)) {
            throw new IllegalArgumentException("The input file must be image");
        }
        if (builder.target.outputFormat == null || builder.target.outputFormat != OutputFormats.SVG) {
            throw new IllegalArgumentException("The output file must be SVG");
        }
        return this.convert(builder);
    }

    private boolean uploadFile(File file, String targetPath) {
        return this.uploadFile(file, targetPath, null);
    }

    private boolean uploadFile(File file, String targetPath, String storageName) {
        if (file.exists() && file.isFile()) {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
            MultipartBody.Part fileToUpload = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestBody);
            Call<FilesUploadResult> call_create = this.storageApi.uploadFile(fileToUpload, targetPath, storageName);
            try {
                Response response = call_create.execute();
            }
            catch (IOException ex) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean downloadFile(String sourcePath, String targetPath, String storageName) {
        return this.downloadFile(sourcePath, targetPath, storageName, null);
    }

    private boolean downloadFile(String sourcePath, String targetPath, String storageName, String versionId) {
        Call<ResponseBody> call_download = this.storageApi.downloadFile(sourcePath, storageName, versionId);
        Response res_download = null;
        try {
            res_download = call_download.execute();
        }
        catch (IOException e) {
            return false;
        }
        ResponseBody body = (ResponseBody)res_download.body();
        File savedFile = new File(targetPath);
        try (InputStream inputStream = body.byteStream();
             FileOutputStream outputStream = new FileOutputStream(savedFile);){
            int read;
            byte[] fileReader = new byte[4096];
            while ((read = inputStream.read(fileReader)) != -1) {
                ((OutputStream)outputStream).write(fileReader, 0, read);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private OperationResult WaitForResult(String id) {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                call = this.conversionApi.getConversionStatus(id);
                res = call.execute();
                result = (OperationResult)res.body();
                if (result.code != 200 || result.status.equals("faulted") || result.status.equals("canceled") || result.status.equals("completed")) {
                    return result;
                }
                try {
                    TimeUnit.SECONDS.sleep(2L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return null;
                }
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
        {
            ** while (true)
        }
    }

    private boolean isImage(InputFormats format) {
        return format == InputFormats.BMP || format == InputFormats.GIF || format == InputFormats.JPEG || format == InputFormats.PNG || format == InputFormats.TIFF || format == InputFormats.WEBP;
    }
}

