/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Bookmarks;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.LinkElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides link to bookmark.")
public class Bookmark
extends LinkElement {
    @SerializedName(value="Title")
    private String title = null;
    @SerializedName(value="Italic")
    private Boolean italic = null;
    @SerializedName(value="Bold")
    private Boolean bold = null;
    @SerializedName(value="Color")
    private Color color = null;
    @SerializedName(value="Action")
    private String action = null;
    @SerializedName(value="Level")
    private Integer level = null;
    @SerializedName(value="Destination")
    private String destination = null;
    @SerializedName(value="PageDisplay")
    private String pageDisplay = null;
    @SerializedName(value="PageDisplay_Bottom")
    private Integer pageDisplayBottom = null;
    @SerializedName(value="PageDisplay_Left")
    private Integer pageDisplayLeft = null;
    @SerializedName(value="PageDisplay_Right")
    private Integer pageDisplayRight = null;
    @SerializedName(value="PageDisplay_Top")
    private Integer pageDisplayTop = null;
    @SerializedName(value="PageDisplay_Zoom")
    private Integer pageDisplayZoom = null;
    @SerializedName(value="PageNumber")
    private Integer pageNumber = null;
    @SerializedName(value="RemoteFile")
    private String remoteFile = null;
    @SerializedName(value="Bookmarks")
    private Bookmarks bookmarks = null;

    public Bookmark title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Get the Title;")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Bookmark italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @ApiModelProperty(value="Is bookmark italic.")
    public Boolean isItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public Bookmark bold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    @ApiModelProperty(value="Is bookmark bold.")
    public Boolean isBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public Bookmark color(Color color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Get the color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Bookmark action(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the action bound with the bookmark. If PageNumber is presented the action can not be specified. The action type includes: \"GoTo\", \"GoToR\", \"Launch\", \"Named\".")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Bookmark level(Integer level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(value="Gets or sets bookmark's hierarchy level.")
    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Bookmark destination(String destination) {
        this.destination = destination;
        return this;
    }

    @ApiModelProperty(value="Gets or sets bookmark's destination page. Required if action is set as string.Empty.")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Bookmark pageDisplay(String pageDisplay) {
        this.pageDisplay = pageDisplay;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the type of display bookmark's destination page.")
    public String getPageDisplay() {
        return this.pageDisplay;
    }

    public void setPageDisplay(String pageDisplay) {
        this.pageDisplay = pageDisplay;
    }

    public Bookmark pageDisplayBottom(Integer pageDisplayBottom) {
        this.pageDisplayBottom = pageDisplayBottom;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the bottom coordinate of page display.")
    public Integer getPageDisplayBottom() {
        return this.pageDisplayBottom;
    }

    public void setPageDisplayBottom(Integer pageDisplayBottom) {
        this.pageDisplayBottom = pageDisplayBottom;
    }

    public Bookmark pageDisplayLeft(Integer pageDisplayLeft) {
        this.pageDisplayLeft = pageDisplayLeft;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the left coordinate of page display.")
    public Integer getPageDisplayLeft() {
        return this.pageDisplayLeft;
    }

    public void setPageDisplayLeft(Integer pageDisplayLeft) {
        this.pageDisplayLeft = pageDisplayLeft;
    }

    public Bookmark pageDisplayRight(Integer pageDisplayRight) {
        this.pageDisplayRight = pageDisplayRight;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the right coordinate of page display.")
    public Integer getPageDisplayRight() {
        return this.pageDisplayRight;
    }

    public void setPageDisplayRight(Integer pageDisplayRight) {
        this.pageDisplayRight = pageDisplayRight;
    }

    public Bookmark pageDisplayTop(Integer pageDisplayTop) {
        this.pageDisplayTop = pageDisplayTop;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the top coordinate of page display.")
    public Integer getPageDisplayTop() {
        return this.pageDisplayTop;
    }

    public void setPageDisplayTop(Integer pageDisplayTop) {
        this.pageDisplayTop = pageDisplayTop;
    }

    public Bookmark pageDisplayZoom(Integer pageDisplayZoom) {
        this.pageDisplayZoom = pageDisplayZoom;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the zoom factor of page display.")
    public Integer getPageDisplayZoom() {
        return this.pageDisplayZoom;
    }

    public void setPageDisplayZoom(Integer pageDisplayZoom) {
        this.pageDisplayZoom = pageDisplayZoom;
    }

    public Bookmark pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the number of bookmark's destination page. ")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Bookmark remoteFile(String remoteFile) {
        this.remoteFile = remoteFile;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the file (path) which is required for \"GoToR\" action of bookmark.")
    public String getRemoteFile() {
        return this.remoteFile;
    }

    public void setRemoteFile(String remoteFile) {
        this.remoteFile = remoteFile;
    }

    public Bookmark bookmarks(Bookmarks bookmarks) {
        this.bookmarks = bookmarks;
        return this;
    }

    @ApiModelProperty(value="The children bookmarks.")
    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(Bookmarks bookmarks) {
        this.bookmarks = bookmarks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bookmark bookmark = (Bookmark)o;
        return Objects.equals(this.title, bookmark.title) && Objects.equals(this.italic, bookmark.italic) && Objects.equals(this.bold, bookmark.bold) && Objects.equals(this.color, bookmark.color) && Objects.equals(this.action, bookmark.action) && Objects.equals(this.level, bookmark.level) && Objects.equals(this.destination, bookmark.destination) && Objects.equals(this.pageDisplay, bookmark.pageDisplay) && Objects.equals(this.pageDisplayBottom, bookmark.pageDisplayBottom) && Objects.equals(this.pageDisplayLeft, bookmark.pageDisplayLeft) && Objects.equals(this.pageDisplayRight, bookmark.pageDisplayRight) && Objects.equals(this.pageDisplayTop, bookmark.pageDisplayTop) && Objects.equals(this.pageDisplayZoom, bookmark.pageDisplayZoom) && Objects.equals(this.pageNumber, bookmark.pageNumber) && Objects.equals(this.remoteFile, bookmark.remoteFile) && Objects.equals(this.bookmarks, bookmark.bookmarks) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.title, this.italic, this.bold, this.color, this.action, this.level, this.destination, this.pageDisplay, this.pageDisplayBottom, this.pageDisplayLeft, this.pageDisplayRight, this.pageDisplayTop, this.pageDisplayZoom, this.pageNumber, this.remoteFile, this.bookmarks, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Bookmark {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    italic: ").append(this.toIndentedString(this.italic)).append("\n");
        sb.append("    bold: ").append(this.toIndentedString(this.bold)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    pageDisplay: ").append(this.toIndentedString(this.pageDisplay)).append("\n");
        sb.append("    pageDisplayBottom: ").append(this.toIndentedString(this.pageDisplayBottom)).append("\n");
        sb.append("    pageDisplayLeft: ").append(this.toIndentedString(this.pageDisplayLeft)).append("\n");
        sb.append("    pageDisplayRight: ").append(this.toIndentedString(this.pageDisplayRight)).append("\n");
        sb.append("    pageDisplayTop: ").append(this.toIndentedString(this.pageDisplayTop)).append("\n");
        sb.append("    pageDisplayZoom: ").append(this.toIndentedString(this.pageDisplayZoom)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    remoteFile: ").append(this.toIndentedString(this.remoteFile)).append("\n");
        sb.append("    bookmarks: ").append(this.toIndentedString(this.bookmarks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

