/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.BorderInfo;
import com.aspose.asposecloudpdf.model.Cell;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.MarginInfo;
import com.aspose.asposecloudpdf.model.TextState;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a row of the table.")
public class Row {
    @SerializedName(value="BackgroundColor")
    private Color backgroundColor = null;
    @SerializedName(value="Border")
    private BorderInfo border = null;
    @SerializedName(value="Cells")
    private List<Cell> cells = new ArrayList<Cell>();
    @SerializedName(value="DefaultCellBorder")
    private BorderInfo defaultCellBorder = null;
    @SerializedName(value="MinRowHeight")
    private Double minRowHeight = null;
    @SerializedName(value="FixedRowHeight")
    private Double fixedRowHeight = null;
    @SerializedName(value="IsInNewPage")
    private Boolean isInNewPage = null;
    @SerializedName(value="IsRowBroken")
    private Boolean isRowBroken = null;
    @SerializedName(value="DefaultCellTextState")
    private TextState defaultCellTextState = null;
    @SerializedName(value="DefaultCellPadding")
    private MarginInfo defaultCellPadding = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;

    public Row backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the background color.")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Row border(BorderInfo border) {
        this.border = border;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the border.")
    public BorderInfo getBorder() {
        return this.border;
    }

    public void setBorder(BorderInfo border) {
        this.border = border;
    }

    public Row cells(List<Cell> cells) {
        this.cells = cells;
        return this;
    }

    public Row addCellsItem(Cell cellsItem) {
        this.cells.add(cellsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Sets the cells of the row.")
    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(List<Cell> cells) {
        this.cells = cells;
    }

    public Row defaultCellBorder(BorderInfo defaultCellBorder) {
        this.defaultCellBorder = defaultCellBorder;
        return this;
    }

    @ApiModelProperty(value="Gets default cell border;")
    public BorderInfo getDefaultCellBorder() {
        return this.defaultCellBorder;
    }

    public void setDefaultCellBorder(BorderInfo defaultCellBorder) {
        this.defaultCellBorder = defaultCellBorder;
    }

    public Row minRowHeight(Double minRowHeight) {
        this.minRowHeight = minRowHeight;
        return this;
    }

    @ApiModelProperty(value="Gets height for row;")
    public Double getMinRowHeight() {
        return this.minRowHeight;
    }

    public void setMinRowHeight(Double minRowHeight) {
        this.minRowHeight = minRowHeight;
    }

    public Row fixedRowHeight(Double fixedRowHeight) {
        this.fixedRowHeight = fixedRowHeight;
        return this;
    }

    @ApiModelProperty(value="Gets fixed row height - row may have fixed height;")
    public Double getFixedRowHeight() {
        return this.fixedRowHeight;
    }

    public void setFixedRowHeight(Double fixedRowHeight) {
        this.fixedRowHeight = fixedRowHeight;
    }

    public Row isInNewPage(Boolean isInNewPage) {
        this.isInNewPage = isInNewPage;
        return this;
    }

    @ApiModelProperty(value="Gets fixed row is in new page - page with this property should be printed to next page Default false;")
    public Boolean isIsInNewPage() {
        return this.isInNewPage;
    }

    public void setIsInNewPage(Boolean isInNewPage) {
        this.isInNewPage = isInNewPage;
    }

    public Row isRowBroken(Boolean isRowBroken) {
        this.isRowBroken = isRowBroken;
        return this;
    }

    @ApiModelProperty(value="Gets is row can be broken between two pages")
    public Boolean isIsRowBroken() {
        return this.isRowBroken;
    }

    public void setIsRowBroken(Boolean isRowBroken) {
        this.isRowBroken = isRowBroken;
    }

    public Row defaultCellTextState(TextState defaultCellTextState) {
        this.defaultCellTextState = defaultCellTextState;
        return this;
    }

    @ApiModelProperty(value="Gets or sets default text state for row cells")
    public TextState getDefaultCellTextState() {
        return this.defaultCellTextState;
    }

    public void setDefaultCellTextState(TextState defaultCellTextState) {
        this.defaultCellTextState = defaultCellTextState;
    }

    public Row defaultCellPadding(MarginInfo defaultCellPadding) {
        this.defaultCellPadding = defaultCellPadding;
        return this;
    }

    @ApiModelProperty(value="Gets or sets default margin for row cells")
    public MarginInfo getDefaultCellPadding() {
        return this.defaultCellPadding;
    }

    public void setDefaultCellPadding(MarginInfo defaultCellPadding) {
        this.defaultCellPadding = defaultCellPadding;
    }

    public Row verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the vertical alignment.")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row row = (Row)o;
        return Objects.equals(this.backgroundColor, row.backgroundColor) && Objects.equals(this.border, row.border) && Objects.equals(this.cells, row.cells) && Objects.equals(this.defaultCellBorder, row.defaultCellBorder) && Objects.equals(this.minRowHeight, row.minRowHeight) && Objects.equals(this.fixedRowHeight, row.fixedRowHeight) && Objects.equals(this.isInNewPage, row.isInNewPage) && Objects.equals(this.isRowBroken, row.isRowBroken) && Objects.equals(this.defaultCellTextState, row.defaultCellTextState) && Objects.equals(this.defaultCellPadding, row.defaultCellPadding) && Objects.equals((Object)this.verticalAlignment, (Object)row.verticalAlignment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backgroundColor, this.border, this.cells, this.defaultCellBorder, this.minRowHeight, this.fixedRowHeight, this.isInNewPage, this.isRowBroken, this.defaultCellTextState, this.defaultCellPadding, this.verticalAlignment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Row {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    cells: ").append(this.toIndentedString(this.cells)).append("\n");
        sb.append("    defaultCellBorder: ").append(this.toIndentedString(this.defaultCellBorder)).append("\n");
        sb.append("    minRowHeight: ").append(this.toIndentedString(this.minRowHeight)).append("\n");
        sb.append("    fixedRowHeight: ").append(this.toIndentedString(this.fixedRowHeight)).append("\n");
        sb.append("    isInNewPage: ").append(this.toIndentedString(this.isInNewPage)).append("\n");
        sb.append("    isRowBroken: ").append(this.toIndentedString(this.isRowBroken)).append("\n");
        sb.append("    defaultCellTextState: ").append(this.toIndentedString(this.defaultCellTextState)).append("\n");
        sb.append("    defaultCellPadding: ").append(this.toIndentedString(this.defaultCellPadding)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

