/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.LinkElement;
import com.aspose.asposecloudpdf.model.Rotation;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents Pdf stamps.")
public class StampBase
extends LinkElement {
    @SerializedName(value="Background")
    private Boolean background = null;
    @SerializedName(value="HorizontalAlignment")
    private HorizontalAlignment horizontalAlignment = null;
    @SerializedName(value="Opacity")
    private Double opacity = null;
    @SerializedName(value="Rotate")
    private Rotation rotate = null;
    @SerializedName(value="RotateAngle")
    private Double rotateAngle = null;
    @SerializedName(value="XIndent")
    private Double xindent = null;
    @SerializedName(value="YIndent")
    private Double yindent = null;
    @SerializedName(value="Zoom")
    private Double zoom = null;

    public StampBase background(Boolean background) {
        this.background = background;
        return this;
    }

    @ApiModelProperty(value="Sets or gets a bool value that indicates the content is stamped as background. If the value is true, the stamp content is layed at the bottom. By defalt, the value is false, the stamp content is layed at the top.")
    public Boolean isBackground() {
        return this.background;
    }

    public void setBackground(Boolean background) {
        this.background = background;
    }

    public StampBase horizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets Horizontal alignment of stamp on the page. ")
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public StampBase opacity(Double opacity) {
        this.opacity = opacity;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a value to indicate the stamp opacity. The value is from 0.0 to 1.0. By default the value is 1.0.")
    public Double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Double opacity) {
        this.opacity = opacity;
    }

    public StampBase rotate(Rotation rotate) {
        this.rotate = rotate;
        return this;
    }

    @ApiModelProperty(value="Sets or gets the rotation of stamp content according Rotation values. Note. This property is for set angles which are multiples of 90 degrees (0, 90, 180, 270 degrees). To set arbitrary angle use RotateAngle property.  If angle set by ArbitraryAngle is not multiple of 90 then Rotate property returns Rotation.None.")
    public Rotation getRotate() {
        return this.rotate;
    }

    public void setRotate(Rotation rotate) {
        this.rotate = rotate;
    }

    public StampBase rotateAngle(Double rotateAngle) {
        this.rotateAngle = rotateAngle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets rotate angle of stamp in degrees. This property allows to set arbitrary rotate angle. ")
    public Double getRotateAngle() {
        return this.rotateAngle;
    }

    public void setRotateAngle(Double rotateAngle) {
        this.rotateAngle = rotateAngle;
    }

    public StampBase xindent(Double xindent) {
        this.xindent = xindent;
        return this;
    }

    @ApiModelProperty(value="Horizontal stamp coordinate, starting from the left.")
    public Double getXindent() {
        return this.xindent;
    }

    public void setXindent(Double xindent) {
        this.xindent = xindent;
    }

    public StampBase yindent(Double yindent) {
        this.yindent = yindent;
        return this;
    }

    @ApiModelProperty(value="Vertical stamp coordinate, starting from the bottom.")
    public Double getYindent() {
        return this.yindent;
    }

    public void setYindent(Double yindent) {
        this.yindent = yindent;
    }

    public StampBase zoom(Double zoom) {
        this.zoom = zoom;
        return this;
    }

    @ApiModelProperty(value="Zooming factor of the stamp. Allows to scale stamp.")
    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        this.zoom = zoom;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StampBase stampBase = (StampBase)o;
        return Objects.equals(this.background, stampBase.background) && Objects.equals((Object)this.horizontalAlignment, (Object)stampBase.horizontalAlignment) && Objects.equals(this.opacity, stampBase.opacity) && Objects.equals((Object)this.rotate, (Object)stampBase.rotate) && Objects.equals(this.rotateAngle, stampBase.rotateAngle) && Objects.equals(this.xindent, stampBase.xindent) && Objects.equals(this.yindent, stampBase.yindent) && Objects.equals(this.zoom, stampBase.zoom) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.background, this.horizontalAlignment, this.opacity, this.rotate, this.rotateAngle, this.xindent, this.yindent, this.zoom, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StampBase {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    background: ").append(this.toIndentedString(this.background)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    rotate: ").append(this.toIndentedString((Object)this.rotate)).append("\n");
        sb.append("    rotateAngle: ").append(this.toIndentedString(this.rotateAngle)).append("\n");
        sb.append("    xindent: ").append(this.toIndentedString(this.xindent)).append("\n");
        sb.append("    yindent: ").append(this.toIndentedString(this.yindent)).append("\n");
        sb.append("    zoom: ").append(this.toIndentedString(this.zoom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

