/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.LinkElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides link to attachment.")
public class Attachment
extends LinkElement {
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="MimeType")
    private String mimeType = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="CreationDate")
    private String creationDate = null;
    @SerializedName(value="ModificationDate")
    private String modificationDate = null;
    @SerializedName(value="Size")
    private Integer size = null;
    @SerializedName(value="CheckSum")
    private String checkSum = null;

    public Attachment description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Gets text associated with the attachment. ")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Attachment mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @ApiModelProperty(value="Gets subtype of the attachment file.")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Attachment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Gets the name of the attachment. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Attachment creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the embedded file was created.")
    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public Attachment modificationDate(String modificationDate) {
        this.modificationDate = modificationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the embedded file was last modified.")
    public String getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(String modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Attachment size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="The size of the uncompressed embedded file, in bytes.")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Attachment checkSum(String checkSum) {
        this.checkSum = checkSum;
        return this;
    }

    @ApiModelProperty(value="A 16-byte string that is the checksum of the bytes of the uncompressed embedded file.  The checksum is calculated by applying the standard MD5 message-digest algorithm  to the bytes of the embedded file stream.")
    public String getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(String checkSum) {
        this.checkSum = checkSum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment attachment = (Attachment)o;
        return Objects.equals(this.description, attachment.description) && Objects.equals(this.mimeType, attachment.mimeType) && Objects.equals(this.name, attachment.name) && Objects.equals(this.creationDate, attachment.creationDate) && Objects.equals(this.modificationDate, attachment.modificationDate) && Objects.equals(this.size, attachment.size) && Objects.equals(this.checkSum, attachment.checkSum) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.mimeType, this.name, this.creationDate, this.modificationDate, this.size, this.checkSum, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attachment {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    modificationDate: ").append(this.toIndentedString(this.modificationDate)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    checkSum: ").append(this.toIndentedString(this.checkSum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

