/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents the privileges for accessing Pdf file.")
public class DocumentPrivilege {
    @SerializedName(value="AllowPrint")
    private Boolean allowPrint = null;
    @SerializedName(value="AllowDegradedPrinting")
    private Boolean allowDegradedPrinting = null;
    @SerializedName(value="AllowModifyContents")
    private Boolean allowModifyContents = null;
    @SerializedName(value="AllowCopy")
    private Boolean allowCopy = null;
    @SerializedName(value="AllowModifyAnnotations")
    private Boolean allowModifyAnnotations = null;
    @SerializedName(value="AllowFillIn")
    private Boolean allowFillIn = null;
    @SerializedName(value="AllowScreenReaders")
    private Boolean allowScreenReaders = null;
    @SerializedName(value="AllowAssembly")
    private Boolean allowAssembly = null;
    @SerializedName(value="PrintAllowLevel")
    private Integer printAllowLevel = null;
    @SerializedName(value="ChangeAllowLevel")
    private Integer changeAllowLevel = null;
    @SerializedName(value="CopyAllowLevel")
    private Integer copyAllowLevel = null;

    public DocumentPrivilege allowPrint(Boolean allowPrint) {
        this.allowPrint = allowPrint;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow print or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowPrint() {
        return this.allowPrint;
    }

    public void setAllowPrint(Boolean allowPrint) {
        this.allowPrint = allowPrint;
    }

    public DocumentPrivilege allowDegradedPrinting(Boolean allowDegradedPrinting) {
        this.allowDegradedPrinting = allowDegradedPrinting;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow degraded printing or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowDegradedPrinting() {
        return this.allowDegradedPrinting;
    }

    public void setAllowDegradedPrinting(Boolean allowDegradedPrinting) {
        this.allowDegradedPrinting = allowDegradedPrinting;
    }

    public DocumentPrivilege allowModifyContents(Boolean allowModifyContents) {
        this.allowModifyContents = allowModifyContents;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow modify contents or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowModifyContents() {
        return this.allowModifyContents;
    }

    public void setAllowModifyContents(Boolean allowModifyContents) {
        this.allowModifyContents = allowModifyContents;
    }

    public DocumentPrivilege allowCopy(Boolean allowCopy) {
        this.allowCopy = allowCopy;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow copy or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowCopy() {
        return this.allowCopy;
    }

    public void setAllowCopy(Boolean allowCopy) {
        this.allowCopy = allowCopy;
    }

    public DocumentPrivilege allowModifyAnnotations(Boolean allowModifyAnnotations) {
        this.allowModifyAnnotations = allowModifyAnnotations;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow modify annotations or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowModifyAnnotations() {
        return this.allowModifyAnnotations;
    }

    public void setAllowModifyAnnotations(Boolean allowModifyAnnotations) {
        this.allowModifyAnnotations = allowModifyAnnotations;
    }

    public DocumentPrivilege allowFillIn(Boolean allowFillIn) {
        this.allowFillIn = allowFillIn;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow fill in forms or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowFillIn() {
        return this.allowFillIn;
    }

    public void setAllowFillIn(Boolean allowFillIn) {
        this.allowFillIn = allowFillIn;
    }

    public DocumentPrivilege allowScreenReaders(Boolean allowScreenReaders) {
        this.allowScreenReaders = allowScreenReaders;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow screen readers or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowScreenReaders() {
        return this.allowScreenReaders;
    }

    public void setAllowScreenReaders(Boolean allowScreenReaders) {
        this.allowScreenReaders = allowScreenReaders;
    }

    public DocumentPrivilege allowAssembly(Boolean allowAssembly) {
        this.allowAssembly = allowAssembly;
        return this;
    }

    @ApiModelProperty(value="Sets the permission which allow assembly or not.  true is allow and false or not set is forbidden.")
    public Boolean isAllowAssembly() {
        return this.allowAssembly;
    }

    public void setAllowAssembly(Boolean allowAssembly) {
        this.allowAssembly = allowAssembly;
    }

    public DocumentPrivilege printAllowLevel(Integer printAllowLevel) {
        this.printAllowLevel = printAllowLevel;
        return this;
    }

    @ApiModelProperty(value="Sets the print level of  document's privilege. Just as the Adobe Professional's Printing Allowed settings. 0: None. 1: Low Resolution (150 dpi). 2: High Resolution.")
    public Integer getPrintAllowLevel() {
        return this.printAllowLevel;
    }

    public void setPrintAllowLevel(Integer printAllowLevel) {
        this.printAllowLevel = printAllowLevel;
    }

    public DocumentPrivilege changeAllowLevel(Integer changeAllowLevel) {
        this.changeAllowLevel = changeAllowLevel;
        return this;
    }

    @ApiModelProperty(value="Sets the change level of  document's privilege. Just as the Adobe Professional's Changes Allowed settings. 0: None. 1: Inserting, Deleting and Rotating pages. 2: Filling in form fields and signing existing signature fields. 3: Commenting, filling in form fields, and signing existing signature fields. 4: Any except extracting pages.")
    public Integer getChangeAllowLevel() {
        return this.changeAllowLevel;
    }

    public void setChangeAllowLevel(Integer changeAllowLevel) {
        this.changeAllowLevel = changeAllowLevel;
    }

    public DocumentPrivilege copyAllowLevel(Integer copyAllowLevel) {
        this.copyAllowLevel = copyAllowLevel;
        return this;
    }

    @ApiModelProperty(value="Sets the copy level of  document's privilege. Just as the Adobe Professional's permission settings. 0: None. 1: Enable text access for screen reader devices for the visually impaired. 2: Enable copying of text, images and other content.")
    public Integer getCopyAllowLevel() {
        return this.copyAllowLevel;
    }

    public void setCopyAllowLevel(Integer copyAllowLevel) {
        this.copyAllowLevel = copyAllowLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPrivilege documentPrivilege = (DocumentPrivilege)o;
        return Objects.equals(this.allowPrint, documentPrivilege.allowPrint) && Objects.equals(this.allowDegradedPrinting, documentPrivilege.allowDegradedPrinting) && Objects.equals(this.allowModifyContents, documentPrivilege.allowModifyContents) && Objects.equals(this.allowCopy, documentPrivilege.allowCopy) && Objects.equals(this.allowModifyAnnotations, documentPrivilege.allowModifyAnnotations) && Objects.equals(this.allowFillIn, documentPrivilege.allowFillIn) && Objects.equals(this.allowScreenReaders, documentPrivilege.allowScreenReaders) && Objects.equals(this.allowAssembly, documentPrivilege.allowAssembly) && Objects.equals(this.printAllowLevel, documentPrivilege.printAllowLevel) && Objects.equals(this.changeAllowLevel, documentPrivilege.changeAllowLevel) && Objects.equals(this.copyAllowLevel, documentPrivilege.copyAllowLevel);
    }

    public int hashCode() {
        return Objects.hash(this.allowPrint, this.allowDegradedPrinting, this.allowModifyContents, this.allowCopy, this.allowModifyAnnotations, this.allowFillIn, this.allowScreenReaders, this.allowAssembly, this.printAllowLevel, this.changeAllowLevel, this.copyAllowLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentPrivilege {\n");
        sb.append("    allowPrint: ").append(this.toIndentedString(this.allowPrint)).append("\n");
        sb.append("    allowDegradedPrinting: ").append(this.toIndentedString(this.allowDegradedPrinting)).append("\n");
        sb.append("    allowModifyContents: ").append(this.toIndentedString(this.allowModifyContents)).append("\n");
        sb.append("    allowCopy: ").append(this.toIndentedString(this.allowCopy)).append("\n");
        sb.append("    allowModifyAnnotations: ").append(this.toIndentedString(this.allowModifyAnnotations)).append("\n");
        sb.append("    allowFillIn: ").append(this.toIndentedString(this.allowFillIn)).append("\n");
        sb.append("    allowScreenReaders: ").append(this.toIndentedString(this.allowScreenReaders)).append("\n");
        sb.append("    allowAssembly: ").append(this.toIndentedString(this.allowAssembly)).append("\n");
        sb.append("    printAllowLevel: ").append(this.toIndentedString(this.printAllowLevel)).append("\n");
        sb.append("    changeAllowLevel: ").append(this.toIndentedString(this.changeAllowLevel)).append("\n");
        sb.append("    copyAllowLevel: ").append(this.toIndentedString(this.copyAllowLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

