/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Color;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents graphics info.")
public class GraphInfo {
    @SerializedName(value="LineWidth")
    private Double lineWidth = null;
    @SerializedName(value="Color")
    private Color color = null;
    @SerializedName(value="DashArray")
    private List<Integer> dashArray = null;
    @SerializedName(value="DashPhase")
    private Integer dashPhase = null;
    @SerializedName(value="FillColor")
    private Color fillColor = null;
    @SerializedName(value="IsDoubled")
    private Boolean isDoubled = null;
    @SerializedName(value="SkewAngleX")
    private Double skewAngleX = null;
    @SerializedName(value="SkewAngleY")
    private Double skewAngleY = null;
    @SerializedName(value="ScalingRateX")
    private Double scalingRateX = null;
    @SerializedName(value="ScalingRateY")
    private Double scalingRateY = null;
    @SerializedName(value="RotationAngle")
    private Double rotationAngle = null;

    public GraphInfo lineWidth(Double lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a float value that indicates the line width of the graph.")
    public Double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(Double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public GraphInfo color(Color color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a Color object that indicates the color of the graph.")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public GraphInfo dashArray(List<Integer> dashArray) {
        this.dashArray = dashArray;
        return this;
    }

    public GraphInfo addDashArrayItem(Integer dashArrayItem) {
        if (this.dashArray == null) {
            this.dashArray = new ArrayList<Integer>();
        }
        this.dashArray.add(dashArrayItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets a dash array.")
    public List<Integer> getDashArray() {
        return this.dashArray;
    }

    public void setDashArray(List<Integer> dashArray) {
        this.dashArray = dashArray;
    }

    public GraphInfo dashPhase(Integer dashPhase) {
        this.dashPhase = dashPhase;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a dash phase.")
    public Integer getDashPhase() {
        return this.dashPhase;
    }

    public void setDashPhase(Integer dashPhase) {
        this.dashPhase = dashPhase;
    }

    public GraphInfo fillColor(Color fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a Color object that indicates the fill color of the graph.")
    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public GraphInfo isDoubled(Boolean isDoubled) {
        this.isDoubled = isDoubled;
        return this;
    }

    @ApiModelProperty(value="Gets or sets is border doubled.")
    public Boolean isIsDoubled() {
        return this.isDoubled;
    }

    public void setIsDoubled(Boolean isDoubled) {
        this.isDoubled = isDoubled;
    }

    public GraphInfo skewAngleX(Double skewAngleX) {
        this.skewAngleX = skewAngleX;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a float value that indicates the skew angle of the x-coordinate when transforming a coordinate system.")
    public Double getSkewAngleX() {
        return this.skewAngleX;
    }

    public void setSkewAngleX(Double skewAngleX) {
        this.skewAngleX = skewAngleX;
    }

    public GraphInfo skewAngleY(Double skewAngleY) {
        this.skewAngleY = skewAngleY;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a float value that indicates the skew angle of the y-coordinate when transforming a coordinate system.")
    public Double getSkewAngleY() {
        return this.skewAngleY;
    }

    public void setSkewAngleY(Double skewAngleY) {
        this.skewAngleY = skewAngleY;
    }

    public GraphInfo scalingRateX(Double scalingRateX) {
        this.scalingRateX = scalingRateX;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a float value that indicates the scaling rate of the x-coordinate when transforming a coordinate system.")
    public Double getScalingRateX() {
        return this.scalingRateX;
    }

    public void setScalingRateX(Double scalingRateX) {
        this.scalingRateX = scalingRateX;
    }

    public GraphInfo scalingRateY(Double scalingRateY) {
        this.scalingRateY = scalingRateY;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a float value that indicates the scaling rate of the y-coordinate when transforming a coordinate system.")
    public Double getScalingRateY() {
        return this.scalingRateY;
    }

    public void setScalingRateY(Double scalingRateY) {
        this.scalingRateY = scalingRateY;
    }

    public GraphInfo rotationAngle(Double rotationAngle) {
        this.rotationAngle = rotationAngle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a float value that indicates the rotation angle of the coordinate system  when transforming a coordinate system.")
    public Double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(Double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphInfo graphInfo = (GraphInfo)o;
        return Objects.equals(this.lineWidth, graphInfo.lineWidth) && Objects.equals(this.color, graphInfo.color) && Objects.equals(this.dashArray, graphInfo.dashArray) && Objects.equals(this.dashPhase, graphInfo.dashPhase) && Objects.equals(this.fillColor, graphInfo.fillColor) && Objects.equals(this.isDoubled, graphInfo.isDoubled) && Objects.equals(this.skewAngleX, graphInfo.skewAngleX) && Objects.equals(this.skewAngleY, graphInfo.skewAngleY) && Objects.equals(this.scalingRateX, graphInfo.scalingRateX) && Objects.equals(this.scalingRateY, graphInfo.scalingRateY) && Objects.equals(this.rotationAngle, graphInfo.rotationAngle);
    }

    public int hashCode() {
        return Objects.hash(this.lineWidth, this.color, this.dashArray, this.dashPhase, this.fillColor, this.isDoubled, this.skewAngleX, this.skewAngleY, this.scalingRateX, this.scalingRateY, this.rotationAngle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GraphInfo {\n");
        sb.append("    lineWidth: ").append(this.toIndentedString(this.lineWidth)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    dashArray: ").append(this.toIndentedString(this.dashArray)).append("\n");
        sb.append("    dashPhase: ").append(this.toIndentedString(this.dashPhase)).append("\n");
        sb.append("    fillColor: ").append(this.toIndentedString(this.fillColor)).append("\n");
        sb.append("    isDoubled: ").append(this.toIndentedString(this.isDoubled)).append("\n");
        sb.append("    skewAngleX: ").append(this.toIndentedString(this.skewAngleX)).append("\n");
        sb.append("    skewAngleY: ").append(this.toIndentedString(this.skewAngleY)).append("\n");
        sb.append("    scalingRateX: ").append(this.toIndentedString(this.scalingRateX)).append("\n");
        sb.append("    scalingRateY: ").append(this.toIndentedString(this.scalingRateY)).append("\n");
        sb.append("    rotationAngle: ").append(this.toIndentedString(this.rotationAngle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

