/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.StampBase;
import com.aspose.asposecloudpdf.model.TextState;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents Pdf text header.")
public class TextFooter
extends StampBase {
    @SerializedName(value="TextAlignment")
    private HorizontalAlignment textAlignment = null;
    @SerializedName(value="Value")
    private String value = null;
    @SerializedName(value="TextState")
    private TextState textState = null;
    @SerializedName(value="BottomMargin")
    private Double bottomMargin = null;
    @SerializedName(value="LeftMargin")
    private Double leftMargin = null;
    @SerializedName(value="RightMargin")
    private Double rightMargin = null;

    public TextFooter textAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    @ApiModelProperty(value="Alignment of the text inside the stamp.")
    public HorizontalAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public TextFooter value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Gets or sets string value which is used as stamp on the page.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TextFooter textState(TextState textState) {
        this.textState = textState;
        return this;
    }

    @ApiModelProperty(value="Gets text properties of the stamp. See TextState for details.")
    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public TextFooter bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets bottom margin of stamp.")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public TextFooter leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets left margin of stamp.")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public TextFooter rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets right margin of stamp.")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextFooter textFooter = (TextFooter)o;
        return Objects.equals((Object)this.textAlignment, (Object)textFooter.textAlignment) && Objects.equals(this.value, textFooter.value) && Objects.equals(this.textState, textFooter.textState) && Objects.equals(this.bottomMargin, textFooter.bottomMargin) && Objects.equals(this.leftMargin, textFooter.leftMargin) && Objects.equals(this.rightMargin, textFooter.rightMargin) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.textAlignment, this.value, this.textState, this.bottomMargin, this.leftMargin, this.rightMargin, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextFooter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    textAlignment: ").append(this.toIndentedString((Object)this.textAlignment)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    textState: ").append(this.toIndentedString(this.textState)).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.bottomMargin)).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.leftMargin)).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.rightMargin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

