/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.BoxStyle;
import com.aspose.asposecloudpdf.model.FormField;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides CheckBoxField.")
public class CheckBoxField
extends FormField {
    @SerializedName(value="AllowedStates")
    private List<String> allowedStates = null;
    @SerializedName(value="Style")
    private BoxStyle style = null;
    @SerializedName(value="ActiveState")
    private String activeState = null;
    @SerializedName(value="Checked")
    private Boolean checked = null;
    @SerializedName(value="ExportValue")
    private String exportValue = null;

    public CheckBoxField allowedStates(List<String> allowedStates) {
        this.allowedStates = allowedStates;
        return this;
    }

    public CheckBoxField addAllowedStatesItem(String allowedStatesItem) {
        if (this.allowedStates == null) {
            this.allowedStates = new ArrayList<String>();
        }
        this.allowedStates.add(allowedStatesItem);
        return this;
    }

    @ApiModelProperty(value="Returns list of allowed states.")
    public List<String> getAllowedStates() {
        return this.allowedStates;
    }

    public void setAllowedStates(List<String> allowedStates) {
        this.allowedStates = allowedStates;
    }

    public CheckBoxField style(BoxStyle style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(value="Gets or sets style of check box.")
    public BoxStyle getStyle() {
        return this.style;
    }

    public void setStyle(BoxStyle style) {
        this.style = style;
    }

    public CheckBoxField activeState(String activeState) {
        this.activeState = activeState;
        return this;
    }

    @ApiModelProperty(value="Gets or sets current annotation appearance state.")
    public String getActiveState() {
        return this.activeState;
    }

    public void setActiveState(String activeState) {
        this.activeState = activeState;
    }

    public CheckBoxField checked(Boolean checked) {
        this.checked = checked;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets state of check box.")
    public Boolean isChecked() {
        return this.checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public CheckBoxField exportValue(String exportValue) {
        this.exportValue = exportValue;
        return this;
    }

    @ApiModelProperty(value="Gets or sets export value of CheckBox field.")
    public String getExportValue() {
        return this.exportValue;
    }

    public void setExportValue(String exportValue) {
        this.exportValue = exportValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckBoxField checkBoxField = (CheckBoxField)o;
        return Objects.equals(this.allowedStates, checkBoxField.allowedStates) && Objects.equals((Object)this.style, (Object)checkBoxField.style) && Objects.equals(this.activeState, checkBoxField.activeState) && Objects.equals(this.checked, checkBoxField.checked) && Objects.equals(this.exportValue, checkBoxField.exportValue) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedStates, this.style, this.activeState, this.checked, this.exportValue, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckBoxField {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    allowedStates: ").append(this.toIndentedString(this.allowedStates)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("    activeState: ").append(this.toIndentedString(this.activeState)).append("\n");
        sb.append("    checked: ").append(this.toIndentedString(this.checked)).append("\n");
        sb.append("    exportValue: ").append(this.toIndentedString(this.exportValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

