/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.Rotation;
import com.aspose.asposecloudpdf.model.StampType;
import com.aspose.asposecloudpdf.model.TextState;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents Pdf stamps.")
public class Stamp {
    @SerializedName(value="Type")
    private StampType type = null;
    @SerializedName(value="Background")
    private Boolean background = null;
    @SerializedName(value="BottomMargin")
    private Double bottomMargin = null;
    @SerializedName(value="HorizontalAlignment")
    private HorizontalAlignment horizontalAlignment = null;
    @SerializedName(value="LeftMargin")
    private Double leftMargin = null;
    @SerializedName(value="Opacity")
    private Double opacity = null;
    @SerializedName(value="RightMargin")
    private Double rightMargin = null;
    @SerializedName(value="Rotate")
    private Rotation rotate = null;
    @SerializedName(value="RotateAngle")
    private Double rotateAngle = null;
    @SerializedName(value="TopMargin")
    private Double topMargin = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;
    @SerializedName(value="XIndent")
    private Double xindent = null;
    @SerializedName(value="YIndent")
    private Double yindent = null;
    @SerializedName(value="Zoom")
    private Double zoom = null;
    @SerializedName(value="TextAlignment")
    private HorizontalAlignment textAlignment = null;
    @SerializedName(value="Value")
    private String value = null;
    @SerializedName(value="TextState")
    private TextState textState = null;
    @SerializedName(value="FileName")
    private String fileName = null;
    @SerializedName(value="Width")
    private Double width = null;
    @SerializedName(value="Height")
    private Double height = null;
    @SerializedName(value="PageIndex")
    private Integer pageIndex = null;
    @SerializedName(value="StartingNumber")
    private Integer startingNumber = null;

    public Stamp type(StampType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the stamp type.")
    public StampType getType() {
        return this.type;
    }

    public void setType(StampType type) {
        this.type = type;
    }

    public Stamp background(Boolean background) {
        this.background = background;
        return this;
    }

    @ApiModelProperty(value="Sets or gets a bool value that indicates the content is stamped as background. If the value is true, the stamp content is layed at the bottom. By defalt, the value is false, the stamp content is layed at the top.")
    public Boolean isBackground() {
        return this.background;
    }

    public void setBackground(Boolean background) {
        this.background = background;
    }

    public Stamp bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets bottom margin of stamp.")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public Stamp horizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets Horizontal alignment of stamp on the page. ")
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public Stamp leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets left margin of stamp.")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public Stamp opacity(Double opacity) {
        this.opacity = opacity;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a value to indicate the stamp opacity. The value is from 0.0 to 1.0. By default the value is 1.0.")
    public Double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Double opacity) {
        this.opacity = opacity;
    }

    public Stamp rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets right margin of stamp.")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    public Stamp rotate(Rotation rotate) {
        this.rotate = rotate;
        return this;
    }

    @ApiModelProperty(value="Sets or gets the rotation of stamp content according Rotation values. Note. This property is for set angles which are multiples of 90 degrees (0, 90, 180, 270 degrees). To set arbitrary angle use RotateAngle property.  If angle set by ArbitraryAngle is not multiple of 90 then Rotate property returns Rotation.None.")
    public Rotation getRotate() {
        return this.rotate;
    }

    public void setRotate(Rotation rotate) {
        this.rotate = rotate;
    }

    public Stamp rotateAngle(Double rotateAngle) {
        this.rotateAngle = rotateAngle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets rotate angle of stamp in degrees. This property allows to set arbitrary rotate angle. ")
    public Double getRotateAngle() {
        return this.rotateAngle;
    }

    public void setRotateAngle(Double rotateAngle) {
        this.rotateAngle = rotateAngle;
    }

    public Stamp topMargin(Double topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets top margin of stamp.")
    public Double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    public Stamp verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets vertical alignment of stamp on page.")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public Stamp xindent(Double xindent) {
        this.xindent = xindent;
        return this;
    }

    @ApiModelProperty(value="Horizontal stamp coordinate, starting from the left.")
    public Double getXindent() {
        return this.xindent;
    }

    public void setXindent(Double xindent) {
        this.xindent = xindent;
    }

    public Stamp yindent(Double yindent) {
        this.yindent = yindent;
        return this;
    }

    @ApiModelProperty(value="Vertical stamp coordinate, starting from the bottom.")
    public Double getYindent() {
        return this.yindent;
    }

    public void setYindent(Double yindent) {
        this.yindent = yindent;
    }

    public Stamp zoom(Double zoom) {
        this.zoom = zoom;
        return this;
    }

    @ApiModelProperty(value="Zooming factor of the stamp. Allows to scale stamp.")
    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        this.zoom = zoom;
    }

    public Stamp textAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    @ApiModelProperty(value="Alignment of the text inside the stamp.")
    public HorizontalAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public Stamp value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Gets or sets string value which is used as stamp on the page.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Stamp textState(TextState textState) {
        this.textState = textState;
        return this;
    }

    @ApiModelProperty(value="Gets text properties of the stamp. See TextState for details.")
    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public Stamp fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the file name.")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Stamp width(Double width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="Gets or sets image width. Setting this property allos to scal image horizontally.")
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Stamp height(Double height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="Gets or sets image height. Setting this image allows to scale image vertically.")
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Stamp pageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the index of the page.")
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Stamp startingNumber(Integer startingNumber) {
        this.startingNumber = startingNumber;
        return this;
    }

    @ApiModelProperty(value="Gets or sets value of the number of starting page. Other pages will be numbered starting from this value.")
    public Integer getStartingNumber() {
        return this.startingNumber;
    }

    public void setStartingNumber(Integer startingNumber) {
        this.startingNumber = startingNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stamp stamp = (Stamp)o;
        return Objects.equals((Object)this.type, (Object)stamp.type) && Objects.equals(this.background, stamp.background) && Objects.equals(this.bottomMargin, stamp.bottomMargin) && Objects.equals((Object)this.horizontalAlignment, (Object)stamp.horizontalAlignment) && Objects.equals(this.leftMargin, stamp.leftMargin) && Objects.equals(this.opacity, stamp.opacity) && Objects.equals(this.rightMargin, stamp.rightMargin) && Objects.equals((Object)this.rotate, (Object)stamp.rotate) && Objects.equals(this.rotateAngle, stamp.rotateAngle) && Objects.equals(this.topMargin, stamp.topMargin) && Objects.equals((Object)this.verticalAlignment, (Object)stamp.verticalAlignment) && Objects.equals(this.xindent, stamp.xindent) && Objects.equals(this.yindent, stamp.yindent) && Objects.equals(this.zoom, stamp.zoom) && Objects.equals((Object)this.textAlignment, (Object)stamp.textAlignment) && Objects.equals(this.value, stamp.value) && Objects.equals(this.textState, stamp.textState) && Objects.equals(this.fileName, stamp.fileName) && Objects.equals(this.width, stamp.width) && Objects.equals(this.height, stamp.height) && Objects.equals(this.pageIndex, stamp.pageIndex) && Objects.equals(this.startingNumber, stamp.startingNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.background, this.bottomMargin, this.horizontalAlignment, this.leftMargin, this.opacity, this.rightMargin, this.rotate, this.rotateAngle, this.topMargin, this.verticalAlignment, this.xindent, this.yindent, this.zoom, this.textAlignment, this.value, this.textState, this.fileName, this.width, this.height, this.pageIndex, this.startingNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Stamp {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    background: ").append(this.toIndentedString(this.background)).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.bottomMargin)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.leftMargin)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.rightMargin)).append("\n");
        sb.append("    rotate: ").append(this.toIndentedString((Object)this.rotate)).append("\n");
        sb.append("    rotateAngle: ").append(this.toIndentedString(this.rotateAngle)).append("\n");
        sb.append("    topMargin: ").append(this.toIndentedString(this.topMargin)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    xindent: ").append(this.toIndentedString(this.xindent)).append("\n");
        sb.append("    yindent: ").append(this.toIndentedString(this.yindent)).append("\n");
        sb.append("    zoom: ").append(this.toIndentedString(this.zoom)).append("\n");
        sb.append("    textAlignment: ").append(this.toIndentedString((Object)this.textAlignment)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    textState: ").append(this.toIndentedString(this.textState)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.pageIndex)).append("\n");
        sb.append("    startingNumber: ").append(this.toIndentedString(this.startingNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

