/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Rectangle;
import com.aspose.asposecloudpdf.model.TextState;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Single text replacement setting.")
public class TextReplace {
    @SerializedName(value="OldValue")
    private String oldValue = null;
    @SerializedName(value="NewValue")
    private String newValue = null;
    @SerializedName(value="Regex")
    private Boolean regex = null;
    @SerializedName(value="TextState")
    private TextState textState = null;
    @SerializedName(value="Rect")
    private Rectangle rect = null;
    @SerializedName(value="CenterTextHorizontally")
    private Boolean centerTextHorizontally = null;

    public TextReplace oldValue(String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Original text.")
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public TextReplace newValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    @ApiModelProperty(value="New text.")
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public TextReplace regex(Boolean regex) {
        this.regex = regex;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value indicating whether search text is regular expression.")
    public Boolean isRegex() {
        return this.regex;
    }

    public void setRegex(Boolean regex) {
        this.regex = regex;
    }

    public TextReplace textState(TextState textState) {
        this.textState = textState;
        return this;
    }

    @ApiModelProperty(value="Text properties of a new text.")
    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public TextReplace rect(Rectangle rect) {
        this.rect = rect;
        return this;
    }

    @ApiModelProperty(value="Rectangle area where searched original text.")
    public Rectangle getRect() {
        return this.rect;
    }

    public void setRect(Rectangle rect) {
        this.rect = rect;
    }

    public TextReplace centerTextHorizontally(Boolean centerTextHorizontally) {
        this.centerTextHorizontally = centerTextHorizontally;
        return this;
    }

    @ApiModelProperty(value="The text after replacement is centered horizontally relative to the text being replaced.")
    public Boolean isCenterTextHorizontally() {
        return this.centerTextHorizontally;
    }

    public void setCenterTextHorizontally(Boolean centerTextHorizontally) {
        this.centerTextHorizontally = centerTextHorizontally;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextReplace textReplace = (TextReplace)o;
        return Objects.equals(this.oldValue, textReplace.oldValue) && Objects.equals(this.newValue, textReplace.newValue) && Objects.equals(this.regex, textReplace.regex) && Objects.equals(this.textState, textReplace.textState) && Objects.equals(this.rect, textReplace.rect) && Objects.equals(this.centerTextHorizontally, textReplace.centerTextHorizontally);
    }

    public int hashCode() {
        return Objects.hash(this.oldValue, this.newValue, this.regex, this.textState, this.rect, this.centerTextHorizontally);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextReplace {\n");
        sb.append("    oldValue: ").append(this.toIndentedString(this.oldValue)).append("\n");
        sb.append("    newValue: ").append(this.toIndentedString(this.newValue)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    textState: ").append(this.toIndentedString(this.textState)).append("\n");
        sb.append("    rect: ").append(this.toIndentedString(this.rect)).append("\n");
        sb.append("    centerTextHorizontally: ").append(this.toIndentedString(this.centerTextHorizontally)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

