/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.TextReplace;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Multiple text replacements request.")
public class TextReplaceListRequest {
    @SerializedName(value="TextReplaces")
    private List<TextReplace> textReplaces = new ArrayList<TextReplace>();
    @SerializedName(value="DefaultFont")
    private String defaultFont = null;
    @SerializedName(value="StartIndex")
    private Integer startIndex = null;
    @SerializedName(value="CountReplace")
    private Integer countReplace = null;

    public TextReplaceListRequest textReplaces(List<TextReplace> textReplaces) {
        this.textReplaces = textReplaces;
        return this;
    }

    public TextReplaceListRequest addTextReplacesItem(TextReplace textReplacesItem) {
        this.textReplaces.add(textReplacesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of text replacement settings.")
    public List<TextReplace> getTextReplaces() {
        return this.textReplaces;
    }

    public void setTextReplaces(List<TextReplace> textReplaces) {
        this.textReplaces = textReplaces;
    }

    public TextReplaceListRequest defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Name of font to use if requested font is not embedded into document.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public TextReplaceListRequest startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="The index of first match to be replaced.")
    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public TextReplaceListRequest countReplace(Integer countReplace) {
        this.countReplace = countReplace;
        return this;
    }

    @ApiModelProperty(value="The number of matches to be replaced.")
    public Integer getCountReplace() {
        return this.countReplace;
    }

    public void setCountReplace(Integer countReplace) {
        this.countReplace = countReplace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextReplaceListRequest textReplaceListRequest = (TextReplaceListRequest)o;
        return Objects.equals(this.textReplaces, textReplaceListRequest.textReplaces) && Objects.equals(this.defaultFont, textReplaceListRequest.defaultFont) && Objects.equals(this.startIndex, textReplaceListRequest.startIndex) && Objects.equals(this.countReplace, textReplaceListRequest.countReplace);
    }

    public int hashCode() {
        return Objects.hash(this.textReplaces, this.defaultFont, this.startIndex, this.countReplace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextReplaceListRequest {\n");
        sb.append("    textReplaces: ").append(this.toIndentedString(this.textReplaces)).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    countReplace: ").append(this.toIndentedString(this.countReplace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

