/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.FontStyles;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a text state of a text")
public class TextState {
    @SerializedName(value="FontSize")
    private Double fontSize = null;
    @SerializedName(value="Font")
    private String font = null;
    @SerializedName(value="ForegroundColor")
    private Color foregroundColor = null;
    @SerializedName(value="BackgroundColor")
    private Color backgroundColor = null;
    @SerializedName(value="FontStyle")
    private FontStyles fontStyle = null;
    @SerializedName(value="FontFile")
    private String fontFile = null;
    @SerializedName(value="Underline")
    private Boolean underline = null;
    @SerializedName(value="StrikeOut")
    private Boolean strikeOut = null;
    @SerializedName(value="Superscript")
    private Boolean superscript = null;
    @SerializedName(value="Subscript")
    private Boolean subscript = null;

    public TextState fontSize(Double fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets font size of the text.")
    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public TextState font(String font) {
        this.font = font;
        return this;
    }

    @ApiModelProperty(value="Gets or sets font name of the text.")
    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public TextState foregroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets foreground color of the text.")
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public TextState backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Sets background color of the text.")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public TextState fontStyle(FontStyles fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets font style of the text.")
    public FontStyles getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyles fontStyle) {
        this.fontStyle = fontStyle;
    }

    public TextState fontFile(String fontFile) {
        this.fontFile = fontFile;
        return this;
    }

    @ApiModelProperty(value="Sets path of font file in storage.")
    public String getFontFile() {
        return this.fontFile;
    }

    public void setFontFile(String fontFile) {
        this.fontFile = fontFile;
    }

    public TextState underline(Boolean underline) {
        this.underline = underline;
        return this;
    }

    @ApiModelProperty(value="Gets or sets underline of the text.")
    public Boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public TextState strikeOut(Boolean strikeOut) {
        this.strikeOut = strikeOut;
        return this;
    }

    @ApiModelProperty(value="Gets or sets strikeout of the text.")
    public Boolean isStrikeOut() {
        return this.strikeOut;
    }

    public void setStrikeOut(Boolean strikeOut) {
        this.strikeOut = strikeOut;
    }

    public TextState superscript(Boolean superscript) {
        this.superscript = superscript;
        return this;
    }

    @ApiModelProperty(value="Gets or sets superscript mode of the text.")
    public Boolean isSuperscript() {
        return this.superscript;
    }

    public void setSuperscript(Boolean superscript) {
        this.superscript = superscript;
    }

    public TextState subscript(Boolean subscript) {
        this.subscript = subscript;
        return this;
    }

    @ApiModelProperty(value="Gets or sets subscript mode of the text.")
    public Boolean isSubscript() {
        return this.subscript;
    }

    public void setSubscript(Boolean subscript) {
        this.subscript = subscript;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextState textState = (TextState)o;
        return Objects.equals(this.fontSize, textState.fontSize) && Objects.equals(this.font, textState.font) && Objects.equals(this.foregroundColor, textState.foregroundColor) && Objects.equals(this.backgroundColor, textState.backgroundColor) && Objects.equals((Object)this.fontStyle, (Object)textState.fontStyle) && Objects.equals(this.fontFile, textState.fontFile) && Objects.equals(this.underline, textState.underline) && Objects.equals(this.strikeOut, textState.strikeOut) && Objects.equals(this.superscript, textState.superscript) && Objects.equals(this.subscript, textState.subscript);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fontSize, this.font, this.foregroundColor, this.backgroundColor, this.fontStyle, this.fontFile, this.underline, this.strikeOut, this.superscript, this.subscript});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextState {\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    font: ").append(this.toIndentedString(this.font)).append("\n");
        sb.append("    foregroundColor: ").append(this.toIndentedString(this.foregroundColor)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    fontStyle: ").append(this.toIndentedString((Object)this.fontStyle)).append("\n");
        sb.append("    fontFile: ").append(this.toIndentedString(this.fontFile)).append("\n");
        sb.append("    underline: ").append(this.toIndentedString(this.underline)).append("\n");
        sb.append("    strikeOut: ").append(this.toIndentedString(this.strikeOut)).append("\n");
        sb.append("    superscript: ").append(this.toIndentedString(this.superscript)).append("\n");
        sb.append("    subscript: ").append(this.toIndentedString(this.subscript)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

