/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.StampBase;
import com.aspose.asposecloudpdf.model.TextState;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents Pdf stamps.")
public class TextStamp
extends StampBase {
    @SerializedName(value="TextAlignment")
    private HorizontalAlignment textAlignment = null;
    @SerializedName(value="Value")
    private String value = null;
    @SerializedName(value="TextState")
    private TextState textState = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;
    @SerializedName(value="BottomMargin")
    private Double bottomMargin = null;
    @SerializedName(value="LeftMargin")
    private Double leftMargin = null;
    @SerializedName(value="TopMargin")
    private Double topMargin = null;
    @SerializedName(value="RightMargin")
    private Double rightMargin = null;

    public TextStamp textAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    @ApiModelProperty(value="Alignment of the text inside the stamp.")
    public HorizontalAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public TextStamp value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Gets or sets string value which is used as stamp on the page.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TextStamp textState(TextState textState) {
        this.textState = textState;
        return this;
    }

    @ApiModelProperty(value="Gets text properties of the stamp. See TextState for details.")
    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public TextStamp verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets vertical alignment of stamp on page.")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public TextStamp bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets bottom margin of stamp.")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public TextStamp leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets left margin of stamp.")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public TextStamp topMargin(Double topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets top margin of stamp.")
    public Double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    public TextStamp rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets right margin of stamp.")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextStamp textStamp = (TextStamp)o;
        return Objects.equals((Object)this.textAlignment, (Object)textStamp.textAlignment) && Objects.equals(this.value, textStamp.value) && Objects.equals(this.textState, textStamp.textState) && Objects.equals((Object)this.verticalAlignment, (Object)textStamp.verticalAlignment) && Objects.equals(this.bottomMargin, textStamp.bottomMargin) && Objects.equals(this.leftMargin, textStamp.leftMargin) && Objects.equals(this.topMargin, textStamp.topMargin) && Objects.equals(this.rightMargin, textStamp.rightMargin) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.textAlignment, this.value, this.textState, this.verticalAlignment, this.bottomMargin, this.leftMargin, this.topMargin, this.rightMargin, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextStamp {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    textAlignment: ").append(this.toIndentedString((Object)this.textAlignment)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    textState: ").append(this.toIndentedString(this.textState)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.bottomMargin)).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.leftMargin)).append("\n");
        sb.append("    topMargin: ").append(this.toIndentedString(this.topMargin)).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.rightMargin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

