/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.AnnotationFlags;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.LinkElement;
import com.aspose.asposecloudpdf.model.Rectangle;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides annotation.")
public class Annotation
extends LinkElement {
    @SerializedName(value="Color")
    private Color color = null;
    @SerializedName(value="Contents")
    private String contents = null;
    @SerializedName(value="Modified")
    private String modified = null;
    @SerializedName(value="Id")
    private String id = null;
    @SerializedName(value="Flags")
    private List<AnnotationFlags> flags = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Rect")
    private Rectangle rect = null;
    @SerializedName(value="PageIndex")
    private Integer pageIndex = null;
    @SerializedName(value="ZIndex")
    private Integer zindex = null;
    @SerializedName(value="HorizontalAlignment")
    private HorizontalAlignment horizontalAlignment = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;

    public Annotation color(Color color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Color of the annotation.")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Annotation contents(String contents) {
        this.contents = contents;
        return this;
    }

    @ApiModelProperty(value="Get the annotation content.")
    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public Annotation modified(String modified) {
        this.modified = modified;
        return this;
    }

    @ApiModelProperty(value="The date and time when the annotation was last modified.")
    public String getModified() {
        return this.modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public Annotation id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Gets ID of the annotation.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Annotation flags(List<AnnotationFlags> flags) {
        this.flags = flags;
        return this;
    }

    public Annotation addFlagsItem(AnnotationFlags flagsItem) {
        if (this.flags == null) {
            this.flags = new ArrayList<AnnotationFlags>();
        }
        this.flags.add(flagsItem);
        return this;
    }

    @ApiModelProperty(value="Gets Flags of the annotation.")
    public List<AnnotationFlags> getFlags() {
        return this.flags;
    }

    public void setFlags(List<AnnotationFlags> flags) {
        this.flags = flags;
    }

    public Annotation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Gets Name of the annotation.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Annotation rect(Rectangle rect) {
        this.rect = rect;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets Rect of the annotation.")
    public Rectangle getRect() {
        return this.rect;
    }

    public void setRect(Rectangle rect) {
        this.rect = rect;
    }

    public Annotation pageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    @ApiModelProperty(value="Gets PageIndex of the annotation.")
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Annotation zindex(Integer zindex) {
        this.zindex = zindex;
        return this;
    }

    @ApiModelProperty(value="Gets ZIndex of the annotation.")
    public Integer getZindex() {
        return this.zindex;
    }

    public void setZindex(Integer zindex) {
        this.zindex = zindex;
    }

    public Annotation horizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets HorizontalAlignment of the annotation.")
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public Annotation verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets VerticalAlignment of the annotation.")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation annotation = (Annotation)o;
        return Objects.equals(this.color, annotation.color) && Objects.equals(this.contents, annotation.contents) && Objects.equals(this.modified, annotation.modified) && Objects.equals(this.id, annotation.id) && Objects.equals(this.flags, annotation.flags) && Objects.equals(this.name, annotation.name) && Objects.equals(this.rect, annotation.rect) && Objects.equals(this.pageIndex, annotation.pageIndex) && Objects.equals(this.zindex, annotation.zindex) && Objects.equals((Object)this.horizontalAlignment, (Object)annotation.horizontalAlignment) && Objects.equals((Object)this.verticalAlignment, (Object)annotation.verticalAlignment) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.contents, this.modified, this.id, this.flags, this.name, this.rect, this.pageIndex, this.zindex, this.horizontalAlignment, this.verticalAlignment, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Annotation {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rect: ").append(this.toIndentedString(this.rect)).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.pageIndex)).append("\n");
        sb.append("    zindex: ").append(this.toIndentedString(this.zindex)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

