/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.StampBase;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents Pdf stamps.")
public class PageNumberStamp
extends StampBase {
    @SerializedName(value="Value")
    private String value = null;
    @SerializedName(value="StartingNumber")
    private Integer startingNumber = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;
    @SerializedName(value="BottomMargin")
    private Double bottomMargin = null;
    @SerializedName(value="LeftMargin")
    private Double leftMargin = null;
    @SerializedName(value="TopMargin")
    private Double topMargin = null;
    @SerializedName(value="RightMargin")
    private Double rightMargin = null;

    public PageNumberStamp value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Gets or sets string value which is used as stamp on the page.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PageNumberStamp startingNumber(Integer startingNumber) {
        this.startingNumber = startingNumber;
        return this;
    }

    @ApiModelProperty(value="Gets or sets value of the number of starting page. Other pages will be numbered starting from this value.")
    public Integer getStartingNumber() {
        return this.startingNumber;
    }

    public void setStartingNumber(Integer startingNumber) {
        this.startingNumber = startingNumber;
    }

    public PageNumberStamp verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets vertical alignment of stamp on page.")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public PageNumberStamp bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets bottom margin of stamp.")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public PageNumberStamp leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets left margin of stamp.")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public PageNumberStamp topMargin(Double topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets top margin of stamp.")
    public Double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    public PageNumberStamp rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets right margin of stamp.")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageNumberStamp pageNumberStamp = (PageNumberStamp)o;
        return Objects.equals(this.value, pageNumberStamp.value) && Objects.equals(this.startingNumber, pageNumberStamp.startingNumber) && Objects.equals((Object)this.verticalAlignment, (Object)pageNumberStamp.verticalAlignment) && Objects.equals(this.bottomMargin, pageNumberStamp.bottomMargin) && Objects.equals(this.leftMargin, pageNumberStamp.leftMargin) && Objects.equals(this.topMargin, pageNumberStamp.topMargin) && Objects.equals(this.rightMargin, pageNumberStamp.rightMargin) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.startingNumber, this.verticalAlignment, this.bottomMargin, this.leftMargin, this.topMargin, this.rightMargin, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageNumberStamp {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    startingNumber: ").append(this.toIndentedString(this.startingNumber)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.bottomMargin)).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.leftMargin)).append("\n");
        sb.append("    topMargin: ").append(this.toIndentedString(this.topMargin)).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.rightMargin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

