/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Rectangle;
import com.aspose.asposecloudpdf.model.SignatureCustomAppearance;
import com.aspose.asposecloudpdf.model.SignatureType;
import com.aspose.asposecloudpdf.model.TimestampSettings;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents signature.")
public class Signature {
    @SerializedName(value="SignaturePath")
    private String signaturePath = null;
    @SerializedName(value="SignatureType")
    private SignatureType signatureType = null;
    @SerializedName(value="Password")
    private String password = null;
    @SerializedName(value="Appearance")
    private String appearance = null;
    @SerializedName(value="Reason")
    private String reason = null;
    @SerializedName(value="Contact")
    private String contact = null;
    @SerializedName(value="Location")
    private String location = null;
    @SerializedName(value="Visible")
    private Boolean visible = null;
    @SerializedName(value="Rectangle")
    private Rectangle rectangle = null;
    @SerializedName(value="FormFieldName")
    private String formFieldName = null;
    @SerializedName(value="Authority")
    private String authority = null;
    @SerializedName(value="Date")
    private String date = null;
    @SerializedName(value="ShowProperties")
    private Boolean showProperties = null;
    @SerializedName(value="TimestampSettings")
    private TimestampSettings timestampSettings = null;
    @SerializedName(value="IsValid")
    private Boolean isValid = null;
    @SerializedName(value="CustomAppearance")
    private SignatureCustomAppearance customAppearance = null;

    public Signature signaturePath(String signaturePath) {
        this.signaturePath = signaturePath;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the signature path.")
    public String getSignaturePath() {
        return this.signaturePath;
    }

    public void setSignaturePath(String signaturePath) {
        this.signaturePath = signaturePath;
    }

    public Signature signatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the type of the signature.")
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public Signature password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Signature appearance(String appearance) {
        this.appearance = appearance;
        return this;
    }

    @ApiModelProperty(value="Sets or gets a graphic appearance for the signature. Property value represents an image file name.")
    public String getAppearance() {
        return this.appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }

    public Signature reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the reason of the signature.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Signature contact(String contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the contact of the signature.")
    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public Signature location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the location of the signature.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Signature visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value indicating whether this Signature is visible. Supports only when signing particular page.")
    public Boolean isVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Signature rectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the visible rectangle of the signature. Supports only when signing particular page.")
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Signature formFieldName(String formFieldName) {
        this.formFieldName = formFieldName;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the name of the signature field. Supports only when signing document with particular form field.")
    public String getFormFieldName() {
        return this.formFieldName;
    }

    public void setFormFieldName(String formFieldName) {
        this.formFieldName = formFieldName;
    }

    public Signature authority(String authority) {
        this.authority = authority;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the name of the person or authority signing the document..")
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public Signature date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the time of signing.")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Signature showProperties(Boolean showProperties) {
        this.showProperties = showProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the showproperties in signature field")
    public Boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(Boolean showProperties) {
        this.showProperties = showProperties;
    }

    public Signature timestampSettings(TimestampSettings timestampSettings) {
        this.timestampSettings = timestampSettings;
        return this;
    }

    @ApiModelProperty(value="Gets/sets timestamp settings.")
    public TimestampSettings getTimestampSettings() {
        return this.timestampSettings;
    }

    public void setTimestampSettings(TimestampSettings timestampSettings) {
        this.timestampSettings = timestampSettings;
    }

    public Signature isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @ApiModelProperty(value="Verify the document regarding this signature and return true if document is valid or otherwise false.")
    public Boolean isIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Signature customAppearance(SignatureCustomAppearance customAppearance) {
        this.customAppearance = customAppearance;
        return this;
    }

    @ApiModelProperty(value="Gets/sets the custom appearance.")
    public SignatureCustomAppearance getCustomAppearance() {
        return this.customAppearance;
    }

    public void setCustomAppearance(SignatureCustomAppearance customAppearance) {
        this.customAppearance = customAppearance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equals(this.signaturePath, signature.signaturePath) && Objects.equals((Object)this.signatureType, (Object)signature.signatureType) && Objects.equals(this.password, signature.password) && Objects.equals(this.appearance, signature.appearance) && Objects.equals(this.reason, signature.reason) && Objects.equals(this.contact, signature.contact) && Objects.equals(this.location, signature.location) && Objects.equals(this.visible, signature.visible) && Objects.equals(this.rectangle, signature.rectangle) && Objects.equals(this.formFieldName, signature.formFieldName) && Objects.equals(this.authority, signature.authority) && Objects.equals(this.date, signature.date) && Objects.equals(this.showProperties, signature.showProperties) && Objects.equals(this.timestampSettings, signature.timestampSettings) && Objects.equals(this.isValid, signature.isValid) && Objects.equals(this.customAppearance, signature.customAppearance);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signaturePath, this.signatureType, this.password, this.appearance, this.reason, this.contact, this.location, this.visible, this.rectangle, this.formFieldName, this.authority, this.date, this.showProperties, this.timestampSettings, this.isValid, this.customAppearance});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Signature {\n");
        sb.append("    signaturePath: ").append(this.toIndentedString(this.signaturePath)).append("\n");
        sb.append("    signatureType: ").append(this.toIndentedString((Object)this.signatureType)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    appearance: ").append(this.toIndentedString(this.appearance)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    rectangle: ").append(this.toIndentedString(this.rectangle)).append("\n");
        sb.append("    formFieldName: ").append(this.toIndentedString(this.formFieldName)).append("\n");
        sb.append("    authority: ").append(this.toIndentedString(this.authority)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    showProperties: ").append(this.toIndentedString(this.showProperties)).append("\n");
        sb.append("    timestampSettings: ").append(this.toIndentedString(this.timestampSettings)).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.isValid)).append("\n");
        sb.append("    customAppearance: ").append(this.toIndentedString(this.customAppearance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

