/**
 *
 * Copyright (c) 2026 Aspose.PDF Cloud
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */


package com.aspose.asposecloudpdf.model;

import java.util.Objects;
import com.aspose.asposecloudpdf.model.AnnotationFlags;
import com.aspose.asposecloudpdf.model.Border;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.FormField;
import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.Link;
import com.aspose.asposecloudpdf.model.LinkHighlightingMode;
import com.aspose.asposecloudpdf.model.MarginInfo;
import com.aspose.asposecloudpdf.model.Rectangle;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;

/**
 * Provides Choice field.
 */
@ApiModel(description = "Provides Choice field.")

public class ChoiceField extends FormField {
  @SerializedName("MultiSelect")
  private Boolean multiSelect = null;

  @SerializedName("Selected")
  private Integer selected = null;

  public ChoiceField multiSelect(Boolean multiSelect) {
    this.multiSelect = multiSelect;
    return this;
  }

   /**
   * Gets or sets multiselection flag.
   * @return multiSelect
  **/
  @ApiModelProperty(value = "Gets or sets multiselection flag.")
  public Boolean isMultiSelect() {
    return multiSelect;
  }

  public void setMultiSelect(Boolean multiSelect) {
    this.multiSelect = multiSelect;
  }

  public ChoiceField selected(Integer selected) {
    this.selected = selected;
    return this;
  }

   /**
   * Gets or sets index of selected item. Numbering of items is started from 1.
   * @return selected
  **/
  @ApiModelProperty(value = "Gets or sets index of selected item. Numbering of items is started from 1.")
  public Integer getSelected() {
    return selected;
  }

  public void setSelected(Integer selected) {
    this.selected = selected;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChoiceField choiceField = (ChoiceField) o;
    return Objects.equals(this.multiSelect, choiceField.multiSelect) &&
        Objects.equals(this.selected, choiceField.selected) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(multiSelect, selected, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChoiceField {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    multiSelect: ").append(toIndentedString(multiSelect)).append("\n");
    sb.append("    selected: ").append(toIndentedString(selected)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

