/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.ImageCompressionVersion;
import com.aspose.asposecloudpdf.model.ImageEncoding;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents Pdf optimize options.")
public class OptimizeOptions {
    @SerializedName(value="Password")
    private String password = null;
    @SerializedName(value="AllowReusePageContent")
    private Boolean allowReusePageContent = null;
    @SerializedName(value="CompressImages")
    private Boolean compressImages = null;
    @SerializedName(value="ImageQuality")
    private Integer imageQuality = null;
    @SerializedName(value="LinkDuplcateStreams")
    private Boolean linkDuplcateStreams = null;
    @SerializedName(value="RemoveUnusedObjects")
    private Boolean removeUnusedObjects = null;
    @SerializedName(value="RemoveUnusedStreams")
    private Boolean removeUnusedStreams = null;
    @SerializedName(value="UnembedFonts")
    private Boolean unembedFonts = null;
    @SerializedName(value="ResizeImages")
    private Boolean resizeImages = null;
    @SerializedName(value="MaxResolution")
    private Integer maxResolution = null;
    @SerializedName(value="SubsetFonts")
    private Boolean subsetFonts = null;
    @SerializedName(value="RemovePrivateInfo")
    private Boolean removePrivateInfo = null;
    @SerializedName(value="ImageEncoding")
    private ImageEncoding imageEncoding = null;
    @SerializedName(value="ImageCompressionVersion")
    private ImageCompressionVersion imageCompressionVersion = null;

    public OptimizeOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Specifies document password (if any) encoded with base-64.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public OptimizeOptions allowReusePageContent(Boolean allowReusePageContent) {
        this.allowReusePageContent = allowReusePageContent;
        return this;
    }

    @ApiModelProperty(value="If true page contents will be reused when document is optimized for equal pages. LinkDuplcateStreams option must be set to true.")
    public Boolean isAllowReusePageContent() {
        return this.allowReusePageContent;
    }

    public void setAllowReusePageContent(Boolean allowReusePageContent) {
        this.allowReusePageContent = allowReusePageContent;
    }

    public OptimizeOptions compressImages(Boolean compressImages) {
        this.compressImages = compressImages;
        return this;
    }

    @ApiModelProperty(value="If this flag is set to true images will be compressed in the document. Compression level is specified with ImageQuality property.")
    public Boolean isCompressImages() {
        return this.compressImages;
    }

    public void setCompressImages(Boolean compressImages) {
        this.compressImages = compressImages;
    }

    public OptimizeOptions imageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
        return this;
    }

    @ApiModelProperty(value="Specifies level of image compression when CompressImages flag is used.")
    public Integer getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
    }

    public OptimizeOptions linkDuplcateStreams(Boolean linkDuplcateStreams) {
        this.linkDuplcateStreams = linkDuplcateStreams;
        return this;
    }

    @ApiModelProperty(value="If this flag is set to true, Resource streams will be analyzed. If duplicate streams are found (i.e. if stream contents is equal), then thees streams will be stored as one object.  This allows to decrease document size in some cases (for example, when same document was concatenated multiple times).")
    public Boolean isLinkDuplcateStreams() {
        return this.linkDuplcateStreams;
    }

    public void setLinkDuplcateStreams(Boolean linkDuplcateStreams) {
        this.linkDuplcateStreams = linkDuplcateStreams;
    }

    public OptimizeOptions removeUnusedObjects(Boolean removeUnusedObjects) {
        this.removeUnusedObjects = removeUnusedObjects;
        return this;
    }

    @ApiModelProperty(value="If this flag is set to true, all document objects will be checked and unused objects (i.e. objects which does not have any reference) are removed from document.")
    public Boolean isRemoveUnusedObjects() {
        return this.removeUnusedObjects;
    }

    public void setRemoveUnusedObjects(Boolean removeUnusedObjects) {
        this.removeUnusedObjects = removeUnusedObjects;
    }

    public OptimizeOptions removeUnusedStreams(Boolean removeUnusedStreams) {
        this.removeUnusedStreams = removeUnusedStreams;
        return this;
    }

    @ApiModelProperty(value="If this flag set to true, every resource is checked on it's usage. If resource is never used, then resources is removed. This may decrease document size for example when pages were extracted from document. ")
    public Boolean isRemoveUnusedStreams() {
        return this.removeUnusedStreams;
    }

    public void setRemoveUnusedStreams(Boolean removeUnusedStreams) {
        this.removeUnusedStreams = removeUnusedStreams;
    }

    public OptimizeOptions unembedFonts(Boolean unembedFonts) {
        this.unembedFonts = unembedFonts;
        return this;
    }

    @ApiModelProperty(value="Make fonts not embedded if set to true. Unembedding a font means removing the embedded byte stream data of the font included in a PDF document.")
    public Boolean isUnembedFonts() {
        return this.unembedFonts;
    }

    public void setUnembedFonts(Boolean unembedFonts) {
        this.unembedFonts = unembedFonts;
    }

    public OptimizeOptions resizeImages(Boolean resizeImages) {
        this.resizeImages = resizeImages;
        return this;
    }

    @ApiModelProperty(value="If this flag set to true and CompressImages is true images will be resized if image resolution is greater then specified MaxResolution parameter.")
    public Boolean isResizeImages() {
        return this.resizeImages;
    }

    public void setResizeImages(Boolean resizeImages) {
        this.resizeImages = resizeImages;
    }

    public OptimizeOptions maxResolution(Integer maxResolution) {
        this.maxResolution = maxResolution;
        return this;
    }

    @ApiModelProperty(value="Specifies maximum resolution of images. If image has higher resolution it will be scaled.")
    public Integer getMaxResolution() {
        return this.maxResolution;
    }

    public void setMaxResolution(Integer maxResolution) {
        this.maxResolution = maxResolution;
    }

    public OptimizeOptions subsetFonts(Boolean subsetFonts) {
        this.subsetFonts = subsetFonts;
        return this;
    }

    @ApiModelProperty(value="Fonts will be converted into subsets if set to true. Only those characters that are actually used in the layout are stored in the PDF. ")
    public Boolean isSubsetFonts() {
        return this.subsetFonts;
    }

    public void setSubsetFonts(Boolean subsetFonts) {
        this.subsetFonts = subsetFonts;
    }

    public OptimizeOptions removePrivateInfo(Boolean removePrivateInfo) {
        this.removePrivateInfo = removePrivateInfo;
        return this;
    }

    @ApiModelProperty(value="Remove private information (page piece info).")
    public Boolean isRemovePrivateInfo() {
        return this.removePrivateInfo;
    }

    public void setRemovePrivateInfo(Boolean removePrivateInfo) {
        this.removePrivateInfo = removePrivateInfo;
    }

    public OptimizeOptions imageEncoding(ImageEncoding imageEncoding) {
        this.imageEncoding = imageEncoding;
        return this;
    }

    @ApiModelProperty(value="Image encode which will be used.")
    public ImageEncoding getImageEncoding() {
        return this.imageEncoding;
    }

    public void setImageEncoding(ImageEncoding imageEncoding) {
        this.imageEncoding = imageEncoding;
    }

    public OptimizeOptions imageCompressionVersion(ImageCompressionVersion imageCompressionVersion) {
        this.imageCompressionVersion = imageCompressionVersion;
        return this;
    }

    @ApiModelProperty(value="Version of compression algorithm. Possible values are: \"Standard\" - standard compression, \"Fast\" - fast (improved compression which is faster then standard but may be applicable not for all images), \"Mixed\" - mixed (standard compression is applied to images which can not be compressed by  faster algorithm, this may give best compression but more slow then \"Fast\" algorithm. Version \"Fast\" is not applicable for resizing images (standard method will be used). Default is \"Standard\".")
    public ImageCompressionVersion getImageCompressionVersion() {
        return this.imageCompressionVersion;
    }

    public void setImageCompressionVersion(ImageCompressionVersion imageCompressionVersion) {
        this.imageCompressionVersion = imageCompressionVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizeOptions optimizeOptions = (OptimizeOptions)o;
        return Objects.equals(this.password, optimizeOptions.password) && Objects.equals(this.allowReusePageContent, optimizeOptions.allowReusePageContent) && Objects.equals(this.compressImages, optimizeOptions.compressImages) && Objects.equals(this.imageQuality, optimizeOptions.imageQuality) && Objects.equals(this.linkDuplcateStreams, optimizeOptions.linkDuplcateStreams) && Objects.equals(this.removeUnusedObjects, optimizeOptions.removeUnusedObjects) && Objects.equals(this.removeUnusedStreams, optimizeOptions.removeUnusedStreams) && Objects.equals(this.unembedFonts, optimizeOptions.unembedFonts) && Objects.equals(this.resizeImages, optimizeOptions.resizeImages) && Objects.equals(this.maxResolution, optimizeOptions.maxResolution) && Objects.equals(this.subsetFonts, optimizeOptions.subsetFonts) && Objects.equals(this.removePrivateInfo, optimizeOptions.removePrivateInfo) && Objects.equals((Object)this.imageEncoding, (Object)optimizeOptions.imageEncoding) && Objects.equals((Object)this.imageCompressionVersion, (Object)optimizeOptions.imageCompressionVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.password, this.allowReusePageContent, this.compressImages, this.imageQuality, this.linkDuplcateStreams, this.removeUnusedObjects, this.removeUnusedStreams, this.unembedFonts, this.resizeImages, this.maxResolution, this.subsetFonts, this.removePrivateInfo, this.imageEncoding, this.imageCompressionVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptimizeOptions {\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    allowReusePageContent: ").append(this.toIndentedString(this.allowReusePageContent)).append("\n");
        sb.append("    compressImages: ").append(this.toIndentedString(this.compressImages)).append("\n");
        sb.append("    imageQuality: ").append(this.toIndentedString(this.imageQuality)).append("\n");
        sb.append("    linkDuplcateStreams: ").append(this.toIndentedString(this.linkDuplcateStreams)).append("\n");
        sb.append("    removeUnusedObjects: ").append(this.toIndentedString(this.removeUnusedObjects)).append("\n");
        sb.append("    removeUnusedStreams: ").append(this.toIndentedString(this.removeUnusedStreams)).append("\n");
        sb.append("    unembedFonts: ").append(this.toIndentedString(this.unembedFonts)).append("\n");
        sb.append("    resizeImages: ").append(this.toIndentedString(this.resizeImages)).append("\n");
        sb.append("    maxResolution: ").append(this.toIndentedString(this.maxResolution)).append("\n");
        sb.append("    subsetFonts: ").append(this.toIndentedString(this.subsetFonts)).append("\n");
        sb.append("    removePrivateInfo: ").append(this.toIndentedString(this.removePrivateInfo)).append("\n");
        sb.append("    imageEncoding: ").append(this.toIndentedString((Object)this.imageEncoding)).append("\n");
        sb.append("    imageCompressionVersion: ").append(this.toIndentedString((Object)this.imageCompressionVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

