/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.api;

import com.aspose.slides.ApiCallback;
import com.aspose.slides.ApiClient;
import com.aspose.slides.ApiException;
import com.aspose.slides.ApiResponse;
import com.aspose.slides.Configuration;
import com.aspose.slides.FileInfo;
import com.aspose.slides.Pair;
import com.aspose.slides.ProgressRequestBody;
import com.aspose.slides.ProgressResponseBody;
import com.aspose.slides.auth.NeedRepeatRequestException;
import com.aspose.slides.model.ApiInfo;
import com.aspose.slides.model.Axis;
import com.aspose.slides.model.AxisType;
import com.aspose.slides.model.CaptionTrack;
import com.aspose.slides.model.CaptionTracks;
import com.aspose.slides.model.Chart;
import com.aspose.slides.model.ChartCategory;
import com.aspose.slides.model.ChartSeriesGroup;
import com.aspose.slides.model.ChartWall;
import com.aspose.slides.model.ChartWallType;
import com.aspose.slides.model.ColorScheme;
import com.aspose.slides.model.CommentAuthors;
import com.aspose.slides.model.DataPoint;
import com.aspose.slides.model.DiscUsage;
import com.aspose.slides.model.Document;
import com.aspose.slides.model.DocumentProperties;
import com.aspose.slides.model.DocumentProperty;
import com.aspose.slides.model.DocumentReplaceResult;
import com.aspose.slides.model.Effect;
import com.aspose.slides.model.EntityExists;
import com.aspose.slides.model.ExportFormat;
import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.FileVersions;
import com.aspose.slides.model.FilesList;
import com.aspose.slides.model.FilesUploadResult;
import com.aspose.slides.model.FontScheme;
import com.aspose.slides.model.FontsData;
import com.aspose.slides.model.FormatScheme;
import com.aspose.slides.model.GeometryPaths;
import com.aspose.slides.model.HeaderFooter;
import com.aspose.slides.model.IShapeExportOptions;
import com.aspose.slides.model.ImageExportFormat;
import com.aspose.slides.model.Images;
import com.aspose.slides.model.InteractiveSequence;
import com.aspose.slides.model.LayoutSlide;
import com.aspose.slides.model.LayoutSlides;
import com.aspose.slides.model.Legend;
import com.aspose.slides.model.MasterSlide;
import com.aspose.slides.model.MasterSlides;
import com.aspose.slides.model.MathFormat;
import com.aspose.slides.model.NotesSlide;
import com.aspose.slides.model.NotesSlideExportFormat;
import com.aspose.slides.model.NotesSlideHeaderFooter;
import com.aspose.slides.model.ObjectExist;
import com.aspose.slides.model.OrderedMergeRequest;
import com.aspose.slides.model.Paragraph;
import com.aspose.slides.model.Paragraphs;
import com.aspose.slides.model.PdfImportOptions;
import com.aspose.slides.model.PictureFrame;
import com.aspose.slides.model.Pipeline;
import com.aspose.slides.model.Placeholder;
import com.aspose.slides.model.Placeholders;
import com.aspose.slides.model.Portion;
import com.aspose.slides.model.PortionFormat;
import com.aspose.slides.model.Portions;
import com.aspose.slides.model.PresentationsMergeRequest;
import com.aspose.slides.model.ProtectionProperties;
import com.aspose.slides.model.Sections;
import com.aspose.slides.model.Series;
import com.aspose.slides.model.Shape;
import com.aspose.slides.model.ShapeBase;
import com.aspose.slides.model.ShapeExportFormat;
import com.aspose.slides.model.ShapeThumbnailBounds;
import com.aspose.slides.model.ShapeType;
import com.aspose.slides.model.Shapes;
import com.aspose.slides.model.ShapesAlignmentType;
import com.aspose.slides.model.Slide;
import com.aspose.slides.model.SlideAnimation;
import com.aspose.slides.model.SlideBackground;
import com.aspose.slides.model.SlideCommentBase;
import com.aspose.slides.model.SlideComments;
import com.aspose.slides.model.SlideExportFormat;
import com.aspose.slides.model.SlideProperties;
import com.aspose.slides.model.SlideReplaceResult;
import com.aspose.slides.model.SlideShowProperties;
import com.aspose.slides.model.Slides;
import com.aspose.slides.model.SmartArt;
import com.aspose.slides.model.SpecialSlideType;
import com.aspose.slides.model.SplitDocumentResult;
import com.aspose.slides.model.StorageExist;
import com.aspose.slides.model.Table;
import com.aspose.slides.model.TableCell;
import com.aspose.slides.model.TableCellMergeOptions;
import com.aspose.slides.model.TableCellSplitType;
import com.aspose.slides.model.TableRow;
import com.aspose.slides.model.TextBounds;
import com.aspose.slides.model.TextItems;
import com.aspose.slides.model.Theme;
import com.aspose.slides.model.VbaModule;
import com.aspose.slides.model.VbaProject;
import com.aspose.slides.model.ViewProperties;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class SlidesApi {
    private final ApiClient apiClient;

    public SlidesApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public SlidesApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public Call alignShapesCall(String name, Integer slideIndex, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling alignShapes(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling alignShapes(Async)");
        }
        if (alignmentType == null) {
            throw new ApiException("Missing the required parameter 'alignmentType' when calling alignShapes(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/align/{alignmentType}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{alignmentType\\}", this.apiClient.objectToString((Object)alignmentType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "alignToSlide", alignToSlide);
        this.apiClient.addQueryParameter(queryParams, "shapes", shapes);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes alignShapes(String name, Integer slideIndex, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.alignShapesWithHttpInfo(name, slideIndex, alignmentType, alignToSlide, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.alignShapesWithHttpInfo(name, slideIndex, alignmentType, alignToSlide, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> alignShapesWithHttpInfo(String name, Integer slideIndex, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.alignShapesCall(name, slideIndex, alignmentType, alignToSlide, shapes, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call alignShapesAsync(String name, Integer slideIndex, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.alignShapesCall(name, slideIndex, alignmentType, alignToSlide, shapes, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call alignSpecialSlideShapesCall(String name, Integer slideIndex, SpecialSlideType slideType, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling alignSpecialSlideShapes(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling alignSpecialSlideShapes(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling alignSpecialSlideShapes(Async)");
        }
        if (alignmentType == null) {
            throw new ApiException("Missing the required parameter 'alignmentType' when calling alignSpecialSlideShapes(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/align/{alignmentType}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{alignmentType\\}", this.apiClient.objectToString((Object)alignmentType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "alignToSlide", alignToSlide);
        this.apiClient.addQueryParameter(queryParams, "shapes", shapes);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes alignSpecialSlideShapes(String name, Integer slideIndex, SpecialSlideType slideType, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.alignSpecialSlideShapesWithHttpInfo(name, slideIndex, slideType, alignmentType, alignToSlide, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.alignSpecialSlideShapesWithHttpInfo(name, slideIndex, slideType, alignmentType, alignToSlide, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> alignSpecialSlideShapesWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.alignSpecialSlideShapesCall(name, slideIndex, slideType, alignmentType, alignToSlide, shapes, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call alignSpecialSlideShapesAsync(String name, Integer slideIndex, SpecialSlideType slideType, ShapesAlignmentType alignmentType, Boolean alignToSlide, List<Integer> shapes, String password, String folder, String storage, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.alignSpecialSlideShapesCall(name, slideIndex, slideType, alignmentType, alignToSlide, shapes, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call compressEmbeddedFontsCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling compressEmbeddedFonts(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/fonts/embedded/compress".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void compressEmbeddedFonts(String name, String password, String folder, String storage) throws ApiException {
        try {
            this.compressEmbeddedFontsWithHttpInfo(name, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.compressEmbeddedFontsWithHttpInfo(name, password, folder, storage);
        }
    }

    public ApiResponse<Void> compressEmbeddedFontsWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.compressEmbeddedFontsCall(name, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call compressEmbeddedFontsAsync(String name, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.compressEmbeddedFontsCall(name, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call compressEmbeddedFontsOnlineCall(byte[] document, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling compressEmbeddedFontsOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/fonts/embedded/compress";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File compressEmbeddedFontsOnline(byte[] document, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.compressEmbeddedFontsOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.compressEmbeddedFontsOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> compressEmbeddedFontsOnlineWithHttpInfo(byte[] document, String password) throws ApiException {
        Call call = this.compressEmbeddedFontsOnlineCall(document, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call compressEmbeddedFontsOnlineAsync(byte[] document, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.compressEmbeddedFontsOnlineCall(document, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call compressImageCall(String name, Integer slideIndex, Integer shapeIndex, Double resolution, Boolean deletePictureCroppedAreas, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling compressImage(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling compressImage(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling compressImage(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/compressImage".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "resolution", resolution);
        this.apiClient.addQueryParameter(queryParams, "deletePictureCroppedAreas", deletePictureCroppedAreas);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void compressImage(String name, Integer slideIndex, Integer shapeIndex, Double resolution, Boolean deletePictureCroppedAreas, String password, String folder, String storage) throws ApiException {
        try {
            this.compressImageWithHttpInfo(name, slideIndex, shapeIndex, resolution, deletePictureCroppedAreas, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.compressImageWithHttpInfo(name, slideIndex, shapeIndex, resolution, deletePictureCroppedAreas, password, folder, storage);
        }
    }

    public ApiResponse<Void> compressImageWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Double resolution, Boolean deletePictureCroppedAreas, String password, String folder, String storage) throws ApiException {
        Call call = this.compressImageCall(name, slideIndex, shapeIndex, resolution, deletePictureCroppedAreas, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call compressImageAsync(String name, Integer slideIndex, Integer shapeIndex, Double resolution, Boolean deletePictureCroppedAreas, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.compressImageCall(name, slideIndex, shapeIndex, resolution, deletePictureCroppedAreas, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call convertCall(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling convert(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling convert(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/convert/{format}".replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File convert(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        try {
            ApiResponse<File> resp = this.convertWithHttpInfo(document, format, password, storage, fontsFolder, slides, options);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.convertWithHttpInfo(document, format, password, storage, fontsFolder, slides, options);
            return resp.getData();
        }
    }

    public ApiResponse<File> convertWithHttpInfo(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        Call call = this.convertCall(document, format, password, storage, fontsFolder, slides, options, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call convertAsync(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertCall(document, format, password, storage, fontsFolder, slides, options, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call convertAndSaveCall(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling convertAndSave(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling convertAndSave(Async)");
        }
        if (outPath == null) {
            throw new ApiException("Missing the required parameter 'outPath' when calling convertAndSave(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/convert/{format}".replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "outPath", outPath);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void convertAndSave(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        try {
            this.convertAndSaveWithHttpInfo(document, format, outPath, password, storage, fontsFolder, slides, options);
        }
        catch (NeedRepeatRequestException e) {
            this.convertAndSaveWithHttpInfo(document, format, outPath, password, storage, fontsFolder, slides, options);
        }
    }

    public ApiResponse<Void> convertAndSaveWithHttpInfo(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        Call call = this.convertAndSaveCall(document, format, outPath, password, storage, fontsFolder, slides, options, null, null);
        return this.apiClient.execute(call);
    }

    public Call convertAndSaveAsync(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertAndSaveCall(document, format, outPath, password, storage, fontsFolder, slides, options, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call copyFileCall(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling copyFile(Async)");
        }
        if (destPath == null) {
            throw new ApiException("Missing the required parameter 'destPath' when calling copyFile(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/storage/file/copy/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.objectToString(srcPath));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "destPath", destPath);
        this.apiClient.addQueryParameter(queryParams, "srcStorageName", srcStorageName);
        this.apiClient.addQueryParameter(queryParams, "destStorageName", destStorageName);
        this.apiClient.addQueryParameter(queryParams, "versionId", versionId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void copyFile(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId) throws ApiException {
        try {
            this.copyFileWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName, versionId);
        }
        catch (NeedRepeatRequestException e) {
            this.copyFileWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName, versionId);
        }
    }

    public ApiResponse<Void> copyFileWithHttpInfo(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId) throws ApiException {
        Call call = this.copyFileCall(srcPath, destPath, srcStorageName, destStorageName, versionId, null, null);
        return this.apiClient.execute(call);
    }

    public Call copyFileAsync(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFileCall(srcPath, destPath, srcStorageName, destStorageName, versionId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call copyFolderCall(String srcPath, String destPath, String srcStorageName, String destStorageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling copyFolder(Async)");
        }
        if (destPath == null) {
            throw new ApiException("Missing the required parameter 'destPath' when calling copyFolder(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/storage/folder/copy/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.objectToString(srcPath));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "destPath", destPath);
        this.apiClient.addQueryParameter(queryParams, "srcStorageName", srcStorageName);
        this.apiClient.addQueryParameter(queryParams, "destStorageName", destStorageName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void copyFolder(String srcPath, String destPath, String srcStorageName, String destStorageName) throws ApiException {
        try {
            this.copyFolderWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName);
        }
        catch (NeedRepeatRequestException e) {
            this.copyFolderWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName);
        }
    }

    public ApiResponse<Void> copyFolderWithHttpInfo(String srcPath, String destPath, String srcStorageName, String destStorageName) throws ApiException {
        Call call = this.copyFolderCall(srcPath, destPath, srcStorageName, destStorageName, null, null);
        return this.apiClient.execute(call);
    }

    public Call copyFolderAsync(String srcPath, String destPath, String srcStorageName, String destStorageName, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFolderCall(srcPath, destPath, srcStorageName, destStorageName, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call copyLayoutSlideCall(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling copyLayoutSlide(Async)");
        }
        if (cloneFrom == null) {
            throw new ApiException("Missing the required parameter 'cloneFrom' when calling copyLayoutSlide(Async)");
        }
        if (cloneFromPosition == null) {
            throw new ApiException("Missing the required parameter 'cloneFromPosition' when calling copyLayoutSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/layoutSlides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "cloneFrom", cloneFrom);
        this.apiClient.addQueryParameter(queryParams, "cloneFromPosition", cloneFromPosition);
        this.apiClient.addQueryParameter(queryParams, "cloneFromStorage", cloneFromStorage);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (cloneFromPassword != null) {
            headerParams.put("cloneFromPassword", this.apiClient.parameterToString(cloneFromPassword));
        }
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public LayoutSlide copyLayoutSlide(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<LayoutSlide> resp = this.copyLayoutSlideWithHttpInfo(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<LayoutSlide> resp = this.copyLayoutSlideWithHttpInfo(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<LayoutSlide> copyLayoutSlideWithHttpInfo(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, String password, String folder, String storage) throws ApiException {
        Call call = this.copyLayoutSlideCall(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, password, folder, storage, null, null);
        Type returnType = new TypeToken<LayoutSlide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call copyLayoutSlideAsync(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, String password, String folder, String storage, final ApiCallback<LayoutSlide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyLayoutSlideCall(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<LayoutSlide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call copyMasterSlideCall(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, Boolean applyToAll, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling copyMasterSlide(Async)");
        }
        if (cloneFrom == null) {
            throw new ApiException("Missing the required parameter 'cloneFrom' when calling copyMasterSlide(Async)");
        }
        if (cloneFromPosition == null) {
            throw new ApiException("Missing the required parameter 'cloneFromPosition' when calling copyMasterSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/masterSlides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "cloneFrom", cloneFrom);
        this.apiClient.addQueryParameter(queryParams, "cloneFromPosition", cloneFromPosition);
        this.apiClient.addQueryParameter(queryParams, "cloneFromStorage", cloneFromStorage);
        this.apiClient.addQueryParameter(queryParams, "applyToAll", applyToAll);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (cloneFromPassword != null) {
            headerParams.put("cloneFromPassword", this.apiClient.parameterToString(cloneFromPassword));
        }
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public MasterSlide copyMasterSlide(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, Boolean applyToAll, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<MasterSlide> resp = this.copyMasterSlideWithHttpInfo(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, applyToAll, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<MasterSlide> resp = this.copyMasterSlideWithHttpInfo(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, applyToAll, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<MasterSlide> copyMasterSlideWithHttpInfo(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, Boolean applyToAll, String password, String folder, String storage) throws ApiException {
        Call call = this.copyMasterSlideCall(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, applyToAll, password, folder, storage, null, null);
        Type returnType = new TypeToken<MasterSlide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call copyMasterSlideAsync(String name, String cloneFrom, Integer cloneFromPosition, String cloneFromPassword, String cloneFromStorage, Boolean applyToAll, String password, String folder, String storage, final ApiCallback<MasterSlide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyMasterSlideCall(name, cloneFrom, cloneFromPosition, cloneFromPassword, cloneFromStorage, applyToAll, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<MasterSlide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call copySlideCall(String name, Integer slideToCopy, Integer position, String source, String sourcePassword, String sourceStorage, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling copySlide(Async)");
        }
        if (slideToCopy == null) {
            throw new ApiException("Missing the required parameter 'slideToCopy' when calling copySlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/copy".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "slideToCopy", slideToCopy);
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "source", source);
        this.apiClient.addQueryParameter(queryParams, "sourceStorage", sourceStorage);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (sourcePassword != null) {
            headerParams.put("sourcePassword", this.apiClient.parameterToString(sourcePassword));
        }
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Slides copySlide(String name, Integer slideToCopy, Integer position, String source, String sourcePassword, String sourceStorage, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Slides> resp = this.copySlideWithHttpInfo(name, slideToCopy, position, source, sourcePassword, sourceStorage, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Slides> resp = this.copySlideWithHttpInfo(name, slideToCopy, position, source, sourcePassword, sourceStorage, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Slides> copySlideWithHttpInfo(String name, Integer slideToCopy, Integer position, String source, String sourcePassword, String sourceStorage, String password, String folder, String storage) throws ApiException {
        Call call = this.copySlideCall(name, slideToCopy, position, source, sourcePassword, sourceStorage, password, folder, storage, null, null);
        Type returnType = new TypeToken<Slides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call copySlideAsync(String name, Integer slideToCopy, Integer position, String source, String sourcePassword, String sourceStorage, String password, String folder, String storage, final ApiCallback<Slides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copySlideCall(name, slideToCopy, position, source, sourcePassword, sourceStorage, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Slides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createAnimationEffectCall(String name, Integer slideIndex, Effect effect, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createAnimationEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createAnimationEffect(Async)");
        }
        if (effect == null) {
            throw new ApiException("Missing the required parameter 'effect' when calling createAnimationEffect(Async)");
        }
        Effect postBody = effect;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/mainSequence".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation createAnimationEffect(String name, Integer slideIndex, Effect effect, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.createAnimationEffectWithHttpInfo(name, slideIndex, effect, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.createAnimationEffectWithHttpInfo(name, slideIndex, effect, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> createAnimationEffectWithHttpInfo(String name, Integer slideIndex, Effect effect, String password, String folder, String storage) throws ApiException {
        Call call = this.createAnimationEffectCall(name, slideIndex, effect, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createAnimationEffectAsync(String name, Integer slideIndex, Effect effect, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createAnimationEffectCall(name, slideIndex, effect, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createAnimationInteractiveSequenceCall(String name, Integer slideIndex, InteractiveSequence sequence, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createAnimationInteractiveSequence(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createAnimationInteractiveSequence(Async)");
        }
        if (sequence == null) {
            throw new ApiException("Missing the required parameter 'sequence' when calling createAnimationInteractiveSequence(Async)");
        }
        InteractiveSequence postBody = sequence;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/interactiveSequences".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation createAnimationInteractiveSequence(String name, Integer slideIndex, InteractiveSequence sequence, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.createAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, sequence, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.createAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, sequence, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> createAnimationInteractiveSequenceWithHttpInfo(String name, Integer slideIndex, InteractiveSequence sequence, String password, String folder, String storage) throws ApiException {
        Call call = this.createAnimationInteractiveSequenceCall(name, slideIndex, sequence, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createAnimationInteractiveSequenceAsync(String name, Integer slideIndex, InteractiveSequence sequence, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createAnimationInteractiveSequenceCall(name, slideIndex, sequence, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createAnimationInteractiveSequenceEffectCall(String name, Integer slideIndex, Integer sequenceIndex, Effect effect, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createAnimationInteractiveSequenceEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createAnimationInteractiveSequenceEffect(Async)");
        }
        if (sequenceIndex == null) {
            throw new ApiException("Missing the required parameter 'sequenceIndex' when calling createAnimationInteractiveSequenceEffect(Async)");
        }
        if (effect == null) {
            throw new ApiException("Missing the required parameter 'effect' when calling createAnimationInteractiveSequenceEffect(Async)");
        }
        Effect postBody = effect;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{sequenceIndex\\}", this.apiClient.objectToString(sequenceIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation createAnimationInteractiveSequenceEffect(String name, Integer slideIndex, Integer sequenceIndex, Effect effect, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.createAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, sequenceIndex, effect, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.createAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, sequenceIndex, effect, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> createAnimationInteractiveSequenceEffectWithHttpInfo(String name, Integer slideIndex, Integer sequenceIndex, Effect effect, String password, String folder, String storage) throws ApiException {
        Call call = this.createAnimationInteractiveSequenceEffectCall(name, slideIndex, sequenceIndex, effect, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createAnimationInteractiveSequenceEffectAsync(String name, Integer slideIndex, Integer sequenceIndex, Effect effect, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createAnimationInteractiveSequenceEffectCall(name, slideIndex, sequenceIndex, effect, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createCaptionTrackCall(String name, Integer slideIndex, Integer shapeIndex, String label, String data, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createCaptionTrack(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createCaptionTrack(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createCaptionTrack(Async)");
        }
        if (label == null) {
            throw new ApiException("Missing the required parameter 'label' when calling createCaptionTrack(Async)");
        }
        String postBody = data;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/captionTracks".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "label", label);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public CaptionTrack createCaptionTrack(String name, Integer slideIndex, Integer shapeIndex, String label, String data, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<CaptionTrack> resp = this.createCaptionTrackWithHttpInfo(name, slideIndex, shapeIndex, label, data, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<CaptionTrack> resp = this.createCaptionTrackWithHttpInfo(name, slideIndex, shapeIndex, label, data, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<CaptionTrack> createCaptionTrackWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String label, String data, String password, String folder, String storage) throws ApiException {
        Call call = this.createCaptionTrackCall(name, slideIndex, shapeIndex, label, data, password, folder, storage, null, null);
        Type returnType = new TypeToken<CaptionTrack>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createCaptionTrackAsync(String name, Integer slideIndex, Integer shapeIndex, String label, String data, String password, String folder, String storage, final ApiCallback<CaptionTrack> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createCaptionTrackCall(name, slideIndex, shapeIndex, label, data, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<CaptionTrack>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createChartCategoryCall(String name, Integer slideIndex, Integer shapeIndex, ChartCategory category, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createChartCategory(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createChartCategory(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createChartCategory(Async)");
        }
        if (category == null) {
            throw new ApiException("Missing the required parameter 'category' when calling createChartCategory(Async)");
        }
        ChartCategory postBody = category;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Chart createChartCategory(String name, Integer slideIndex, Integer shapeIndex, ChartCategory category, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Chart> resp = this.createChartCategoryWithHttpInfo(name, slideIndex, shapeIndex, category, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Chart> resp = this.createChartCategoryWithHttpInfo(name, slideIndex, shapeIndex, category, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Chart> createChartCategoryWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, ChartCategory category, String password, String folder, String storage) throws ApiException {
        Call call = this.createChartCategoryCall(name, slideIndex, shapeIndex, category, password, folder, storage, null, null);
        Type returnType = new TypeToken<Chart>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createChartCategoryAsync(String name, Integer slideIndex, Integer shapeIndex, ChartCategory category, String password, String folder, String storage, final ApiCallback<Chart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createChartCategoryCall(name, slideIndex, shapeIndex, category, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Chart>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createChartDataPointCall(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, DataPoint dataPoint, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createChartDataPoint(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createChartDataPoint(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createChartDataPoint(Async)");
        }
        if (seriesIndex == null) {
            throw new ApiException("Missing the required parameter 'seriesIndex' when calling createChartDataPoint(Async)");
        }
        if (dataPoint == null) {
            throw new ApiException("Missing the required parameter 'dataPoint' when calling createChartDataPoint(Async)");
        }
        DataPoint postBody = dataPoint;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{seriesIndex\\}", this.apiClient.objectToString(seriesIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Chart createChartDataPoint(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, DataPoint dataPoint, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Chart> resp = this.createChartDataPointWithHttpInfo(name, slideIndex, shapeIndex, seriesIndex, dataPoint, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Chart> resp = this.createChartDataPointWithHttpInfo(name, slideIndex, shapeIndex, seriesIndex, dataPoint, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Chart> createChartDataPointWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, DataPoint dataPoint, String password, String folder, String storage) throws ApiException {
        Call call = this.createChartDataPointCall(name, slideIndex, shapeIndex, seriesIndex, dataPoint, password, folder, storage, null, null);
        Type returnType = new TypeToken<Chart>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createChartDataPointAsync(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, DataPoint dataPoint, String password, String folder, String storage, final ApiCallback<Chart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createChartDataPointCall(name, slideIndex, shapeIndex, seriesIndex, dataPoint, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Chart>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createChartSeriesCall(String name, Integer slideIndex, Integer shapeIndex, Series series, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createChartSeries(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createChartSeries(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createChartSeries(Async)");
        }
        if (series == null) {
            throw new ApiException("Missing the required parameter 'series' when calling createChartSeries(Async)");
        }
        Series postBody = series;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Chart createChartSeries(String name, Integer slideIndex, Integer shapeIndex, Series series, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Chart> resp = this.createChartSeriesWithHttpInfo(name, slideIndex, shapeIndex, series, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Chart> resp = this.createChartSeriesWithHttpInfo(name, slideIndex, shapeIndex, series, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Chart> createChartSeriesWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Series series, String password, String folder, String storage) throws ApiException {
        Call call = this.createChartSeriesCall(name, slideIndex, shapeIndex, series, password, folder, storage, null, null);
        Type returnType = new TypeToken<Chart>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createChartSeriesAsync(String name, Integer slideIndex, Integer shapeIndex, Series series, String password, String folder, String storage, final ApiCallback<Chart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createChartSeriesCall(name, slideIndex, shapeIndex, series, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Chart>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createCommentCall(String name, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createComment(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createComment(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createComment(Async)");
        }
        SlideCommentBase postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/comments".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeIndex", shapeIndex);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideComments createComment(String name, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideComments> resp = this.createCommentWithHttpInfo(name, slideIndex, dto, shapeIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideComments> resp = this.createCommentWithHttpInfo(name, slideIndex, dto, shapeIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideComments> createCommentWithHttpInfo(String name, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.createCommentCall(name, slideIndex, dto, shapeIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideComments>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createCommentAsync(String name, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password, String folder, String storage, final ApiCallback<SlideComments> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createCommentCall(name, slideIndex, dto, shapeIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideComments>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createCommentOnlineCall(byte[] document, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling createCommentOnline(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createCommentOnline(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createCommentOnline(Async)");
        }
        SlideCommentBase postBody = dto;
        String methodPath = "/slides/slides/{slideIndex}/comments".replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeIndex", shapeIndex);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File createCommentOnline(byte[] document, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.createCommentOnlineWithHttpInfo(document, slideIndex, dto, shapeIndex, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.createCommentOnlineWithHttpInfo(document, slideIndex, dto, shapeIndex, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> createCommentOnlineWithHttpInfo(byte[] document, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password) throws ApiException {
        Call call = this.createCommentOnlineCall(document, slideIndex, dto, shapeIndex, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createCommentOnlineAsync(byte[] document, Integer slideIndex, SlideCommentBase dto, Integer shapeIndex, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createCommentOnlineCall(document, slideIndex, dto, shapeIndex, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createFolderCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void createFolder(String path, String storageName) throws ApiException {
        try {
            this.createFolderWithHttpInfo(path, storageName);
        }
        catch (NeedRepeatRequestException e) {
            this.createFolderWithHttpInfo(path, storageName);
        }
    }

    public ApiResponse<Void> createFolderWithHttpInfo(String path, String storageName) throws ApiException {
        Call call = this.createFolderCall(path, storageName, null, null);
        return this.apiClient.execute(call);
    }

    public Call createFolderAsync(String path, String storageName, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createFolderCall(path, storageName, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createImageWatermarkCall(String name, byte[] image, PictureFrame pictureFrame, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createImageWatermark(Async)");
        }
        PictureFrame postBody = pictureFrame;
        String methodPath = "/slides/{name}/watermark/image".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (image != null) {
            formParams.put("image", image);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void createImageWatermark(String name, byte[] image, PictureFrame pictureFrame, String password, String folder, String storage) throws ApiException {
        try {
            this.createImageWatermarkWithHttpInfo(name, image, pictureFrame, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.createImageWatermarkWithHttpInfo(name, image, pictureFrame, password, folder, storage);
        }
    }

    public ApiResponse<Void> createImageWatermarkWithHttpInfo(String name, byte[] image, PictureFrame pictureFrame, String password, String folder, String storage) throws ApiException {
        Call call = this.createImageWatermarkCall(name, image, pictureFrame, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call createImageWatermarkAsync(String name, byte[] image, PictureFrame pictureFrame, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createImageWatermarkCall(name, image, pictureFrame, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createImageWatermarkOnlineCall(byte[] document, byte[] image, PictureFrame pictureFrame, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling createImageWatermarkOnline(Async)");
        }
        PictureFrame postBody = pictureFrame;
        String methodPath = "/slides/watermark/image";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if (image != null) {
            formParams.put("image", image);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File createImageWatermarkOnline(byte[] document, byte[] image, PictureFrame pictureFrame, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.createImageWatermarkOnlineWithHttpInfo(document, image, pictureFrame, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.createImageWatermarkOnlineWithHttpInfo(document, image, pictureFrame, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> createImageWatermarkOnlineWithHttpInfo(byte[] document, byte[] image, PictureFrame pictureFrame, String password) throws ApiException {
        Call call = this.createImageWatermarkOnlineCall(document, image, pictureFrame, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createImageWatermarkOnlineAsync(byte[] document, byte[] image, PictureFrame pictureFrame, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createImageWatermarkOnlineCall(document, image, pictureFrame, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createNotesSlideCall(String name, Integer slideIndex, NotesSlide dto, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createNotesSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createNotesSlide(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createNotesSlide(Async)");
        }
        NotesSlide postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/notesSlide".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public NotesSlide createNotesSlide(String name, Integer slideIndex, NotesSlide dto, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<NotesSlide> resp = this.createNotesSlideWithHttpInfo(name, slideIndex, dto, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<NotesSlide> resp = this.createNotesSlideWithHttpInfo(name, slideIndex, dto, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<NotesSlide> createNotesSlideWithHttpInfo(String name, Integer slideIndex, NotesSlide dto, String password, String folder, String storage) throws ApiException {
        Call call = this.createNotesSlideCall(name, slideIndex, dto, password, folder, storage, null, null);
        Type returnType = new TypeToken<NotesSlide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createNotesSlideAsync(String name, Integer slideIndex, NotesSlide dto, String password, String folder, String storage, final ApiCallback<NotesSlide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createNotesSlideCall(name, slideIndex, dto, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<NotesSlide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createParagraphCall(String name, Integer slideIndex, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createParagraph(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createParagraph(Async)");
        }
        Paragraph postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraph createParagraph(String name, Integer slideIndex, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraph> resp = this.createParagraphWithHttpInfo(name, slideIndex, shapeIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraph> resp = this.createParagraphWithHttpInfo(name, slideIndex, shapeIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraph> createParagraphWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.createParagraphCall(name, slideIndex, shapeIndex, dto, position, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createParagraphAsync(String name, Integer slideIndex, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape, final ApiCallback<Paragraph> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createParagraphCall(name, slideIndex, shapeIndex, dto, position, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createPortionCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createPortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createPortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createPortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling createPortion(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createPortion(Async)");
        }
        Portion postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portion createPortion(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portion> resp = this.createPortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portion> resp = this.createPortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portion> createPortionWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.createPortionCall(name, slideIndex, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portion>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createPortionAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape, final ApiCallback<Portion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPortionCall(name, slideIndex, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portion>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createPresentationCall(String name, byte[] data, String inputPassword, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createPresentation(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (inputPassword != null) {
            headerParams.put("inputPassword", this.apiClient.parameterToString(inputPassword));
        }
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (data != null) {
            formParams.put("data", data);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Document createPresentation(String name, byte[] data, String inputPassword, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Document> resp = this.createPresentationWithHttpInfo(name, data, inputPassword, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Document> resp = this.createPresentationWithHttpInfo(name, data, inputPassword, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Document> createPresentationWithHttpInfo(String name, byte[] data, String inputPassword, String password, String folder, String storage) throws ApiException {
        Call call = this.createPresentationCall(name, data, inputPassword, password, folder, storage, null, null);
        Type returnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createPresentationAsync(String name, byte[] data, String inputPassword, String password, String folder, String storage, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPresentationCall(name, data, inputPassword, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createPresentationFromSourceCall(String name, String sourcePath, String sourcePassword, String sourceStorage, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createPresentationFromSource(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/fromSource".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "sourcePath", sourcePath);
        this.apiClient.addQueryParameter(queryParams, "sourceStorage", sourceStorage);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (sourcePassword != null) {
            headerParams.put("sourcePassword", this.apiClient.parameterToString(sourcePassword));
        }
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Document createPresentationFromSource(String name, String sourcePath, String sourcePassword, String sourceStorage, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Document> resp = this.createPresentationFromSourceWithHttpInfo(name, sourcePath, sourcePassword, sourceStorage, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Document> resp = this.createPresentationFromSourceWithHttpInfo(name, sourcePath, sourcePassword, sourceStorage, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Document> createPresentationFromSourceWithHttpInfo(String name, String sourcePath, String sourcePassword, String sourceStorage, String password, String folder, String storage) throws ApiException {
        Call call = this.createPresentationFromSourceCall(name, sourcePath, sourcePassword, sourceStorage, password, folder, storage, null, null);
        Type returnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createPresentationFromSourceAsync(String name, String sourcePath, String sourcePassword, String sourceStorage, String password, String folder, String storage, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPresentationFromSourceCall(name, sourcePath, sourcePassword, sourceStorage, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createPresentationFromTemplateCall(String name, String templatePath, String data, String templatePassword, String templateStorage, Boolean isImageDataEmbedded, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createPresentationFromTemplate(Async)");
        }
        if (templatePath == null) {
            throw new ApiException("Missing the required parameter 'templatePath' when calling createPresentationFromTemplate(Async)");
        }
        String postBody = data;
        String methodPath = "/slides/{name}/fromTemplate".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "templatePath", templatePath);
        this.apiClient.addQueryParameter(queryParams, "templateStorage", templateStorage);
        this.apiClient.addQueryParameter(queryParams, "isImageDataEmbedded", isImageDataEmbedded);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (templatePassword != null) {
            headerParams.put("templatePassword", this.apiClient.parameterToString(templatePassword));
        }
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Document createPresentationFromTemplate(String name, String templatePath, String data, String templatePassword, String templateStorage, Boolean isImageDataEmbedded, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Document> resp = this.createPresentationFromTemplateWithHttpInfo(name, templatePath, data, templatePassword, templateStorage, isImageDataEmbedded, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Document> resp = this.createPresentationFromTemplateWithHttpInfo(name, templatePath, data, templatePassword, templateStorage, isImageDataEmbedded, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Document> createPresentationFromTemplateWithHttpInfo(String name, String templatePath, String data, String templatePassword, String templateStorage, Boolean isImageDataEmbedded, String password, String folder, String storage) throws ApiException {
        Call call = this.createPresentationFromTemplateCall(name, templatePath, data, templatePassword, templateStorage, isImageDataEmbedded, password, folder, storage, null, null);
        Type returnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createPresentationFromTemplateAsync(String name, String templatePath, String data, String templatePassword, String templateStorage, Boolean isImageDataEmbedded, String password, String folder, String storage, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPresentationFromTemplateCall(name, templatePath, data, templatePassword, templateStorage, isImageDataEmbedded, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSectionCall(String name, String sectionName, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSection(Async)");
        }
        if (sectionName == null) {
            throw new ApiException("Missing the required parameter 'sectionName' when calling createSection(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSection(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/sections".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "sectionName", sectionName);
        this.apiClient.addQueryParameter(queryParams, "slideIndex", slideIndex);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Sections createSection(String name, String sectionName, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Sections> resp = this.createSectionWithHttpInfo(name, sectionName, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Sections> resp = this.createSectionWithHttpInfo(name, sectionName, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Sections> createSectionWithHttpInfo(String name, String sectionName, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.createSectionCall(name, sectionName, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Sections>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSectionAsync(String name, String sectionName, Integer slideIndex, String password, String folder, String storage, final ApiCallback<Sections> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSectionCall(name, sectionName, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Sections>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createShapeCall(String name, Integer slideIndex, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createShape(Async)");
        }
        ShapeBase postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeToClone", shapeToClone);
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ShapeBase createShape(String name, Integer slideIndex, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<ShapeBase> resp = this.createShapeWithHttpInfo(name, slideIndex, dto, shapeToClone, position, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ShapeBase> resp = this.createShapeWithHttpInfo(name, slideIndex, dto, shapeToClone, position, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<ShapeBase> createShapeWithHttpInfo(String name, Integer slideIndex, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.createShapeCall(name, slideIndex, dto, shapeToClone, position, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createShapeAsync(String name, Integer slideIndex, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape, final ApiCallback<ShapeBase> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createShapeCall(name, slideIndex, dto, shapeToClone, position, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSlideCall(String name, String layoutAlias, Integer position, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "layoutAlias", layoutAlias);
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Slides createSlide(String name, String layoutAlias, Integer position, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Slides> resp = this.createSlideWithHttpInfo(name, layoutAlias, position, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Slides> resp = this.createSlideWithHttpInfo(name, layoutAlias, position, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Slides> createSlideWithHttpInfo(String name, String layoutAlias, Integer position, String password, String folder, String storage) throws ApiException {
        Call call = this.createSlideCall(name, layoutAlias, position, password, folder, storage, null, null);
        Type returnType = new TypeToken<Slides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSlideAsync(String name, String layoutAlias, Integer position, String password, String folder, String storage, final ApiCallback<Slides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSlideCall(name, layoutAlias, position, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Slides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSmartArtNodeCall(String name, Integer slideIndex, Integer smartArtIndex, String subNode, String text, Integer position, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSmartArtNode(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSmartArtNode(Async)");
        }
        if (smartArtIndex == null) {
            throw new ApiException("Missing the required parameter 'smartArtIndex' when calling createSmartArtNode(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/smartArts/{smartArtIndex}/nodes".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{smartArtIndex\\}", this.apiClient.objectToString(smartArtIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "subNode", subNode);
        this.apiClient.addQueryParameter(queryParams, "text", text);
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SmartArt createSmartArtNode(String name, Integer slideIndex, Integer smartArtIndex, String subNode, String text, Integer position, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SmartArt> resp = this.createSmartArtNodeWithHttpInfo(name, slideIndex, smartArtIndex, subNode, text, position, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SmartArt> resp = this.createSmartArtNodeWithHttpInfo(name, slideIndex, smartArtIndex, subNode, text, position, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SmartArt> createSmartArtNodeWithHttpInfo(String name, Integer slideIndex, Integer smartArtIndex, String subNode, String text, Integer position, String password, String folder, String storage) throws ApiException {
        Call call = this.createSmartArtNodeCall(name, slideIndex, smartArtIndex, subNode, text, position, password, folder, storage, null, null);
        Type returnType = new TypeToken<SmartArt>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSmartArtNodeAsync(String name, Integer slideIndex, Integer smartArtIndex, String subNode, String text, Integer position, String password, String folder, String storage, final ApiCallback<SmartArt> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSmartArtNodeCall(name, slideIndex, smartArtIndex, subNode, text, position, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SmartArt>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSpecialSlideAnimationEffectCall(String name, Integer slideIndex, SpecialSlideType slideType, Effect effect, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSpecialSlideAnimationEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSpecialSlideAnimationEffect(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling createSpecialSlideAnimationEffect(Async)");
        }
        if (effect == null) {
            throw new ApiException("Missing the required parameter 'effect' when calling createSpecialSlideAnimationEffect(Async)");
        }
        Effect postBody = effect;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation createSpecialSlideAnimationEffect(String name, Integer slideIndex, SpecialSlideType slideType, Effect effect, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.createSpecialSlideAnimationEffectWithHttpInfo(name, slideIndex, slideType, effect, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.createSpecialSlideAnimationEffectWithHttpInfo(name, slideIndex, slideType, effect, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> createSpecialSlideAnimationEffectWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Effect effect, String password, String folder, String storage) throws ApiException {
        Call call = this.createSpecialSlideAnimationEffectCall(name, slideIndex, slideType, effect, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSpecialSlideAnimationEffectAsync(String name, Integer slideIndex, SpecialSlideType slideType, Effect effect, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSpecialSlideAnimationEffectCall(name, slideIndex, slideType, effect, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSpecialSlideAnimationInteractiveSequenceCall(String name, Integer slideIndex, SpecialSlideType slideType, InteractiveSequence sequence, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSpecialSlideAnimationInteractiveSequence(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSpecialSlideAnimationInteractiveSequence(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling createSpecialSlideAnimationInteractiveSequence(Async)");
        }
        if (sequence == null) {
            throw new ApiException("Missing the required parameter 'sequence' when calling createSpecialSlideAnimationInteractiveSequence(Async)");
        }
        InteractiveSequence postBody = sequence;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation createSpecialSlideAnimationInteractiveSequence(String name, Integer slideIndex, SpecialSlideType slideType, InteractiveSequence sequence, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.createSpecialSlideAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, slideType, sequence, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.createSpecialSlideAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, slideType, sequence, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> createSpecialSlideAnimationInteractiveSequenceWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, InteractiveSequence sequence, String password, String folder, String storage) throws ApiException {
        Call call = this.createSpecialSlideAnimationInteractiveSequenceCall(name, slideIndex, slideType, sequence, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSpecialSlideAnimationInteractiveSequenceAsync(String name, Integer slideIndex, SpecialSlideType slideType, InteractiveSequence sequence, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSpecialSlideAnimationInteractiveSequenceCall(name, slideIndex, slideType, sequence, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSpecialSlideAnimationInteractiveSequenceEffectCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Effect effect, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling createSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (sequenceIndex == null) {
            throw new ApiException("Missing the required parameter 'sequenceIndex' when calling createSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (effect == null) {
            throw new ApiException("Missing the required parameter 'effect' when calling createSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        Effect postBody = effect;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{sequenceIndex\\}", this.apiClient.objectToString(sequenceIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation createSpecialSlideAnimationInteractiveSequenceEffect(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Effect effect, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.createSpecialSlideAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, slideType, sequenceIndex, effect, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.createSpecialSlideAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, slideType, sequenceIndex, effect, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> createSpecialSlideAnimationInteractiveSequenceEffectWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Effect effect, String password, String folder, String storage) throws ApiException {
        Call call = this.createSpecialSlideAnimationInteractiveSequenceEffectCall(name, slideIndex, slideType, sequenceIndex, effect, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSpecialSlideAnimationInteractiveSequenceEffectAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Effect effect, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSpecialSlideAnimationInteractiveSequenceEffectCall(name, slideIndex, slideType, sequenceIndex, effect, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSpecialSlideParagraphCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSpecialSlideParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSpecialSlideParagraph(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling createSpecialSlideParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createSpecialSlideParagraph(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createSpecialSlideParagraph(Async)");
        }
        Paragraph postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraph createSpecialSlideParagraph(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraph> resp = this.createSpecialSlideParagraphWithHttpInfo(name, slideIndex, slideType, shapeIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraph> resp = this.createSpecialSlideParagraphWithHttpInfo(name, slideIndex, slideType, shapeIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraph> createSpecialSlideParagraphWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.createSpecialSlideParagraphCall(name, slideIndex, slideType, shapeIndex, dto, position, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSpecialSlideParagraphAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Paragraph dto, Integer position, String password, String folder, String storage, String subShape, final ApiCallback<Paragraph> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSpecialSlideParagraphCall(name, slideIndex, slideType, shapeIndex, dto, position, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSpecialSlidePortionCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSpecialSlidePortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSpecialSlidePortion(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling createSpecialSlidePortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createSpecialSlidePortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling createSpecialSlidePortion(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createSpecialSlidePortion(Async)");
        }
        Portion postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portion createSpecialSlidePortion(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portion> resp = this.createSpecialSlidePortionWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portion> resp = this.createSpecialSlidePortionWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portion> createSpecialSlidePortionWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.createSpecialSlidePortionCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portion>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSpecialSlidePortionAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Portion dto, Integer position, String password, String folder, String storage, String subShape, final ApiCallback<Portion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSpecialSlidePortionCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, dto, position, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portion>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createSpecialSlideShapeCall(String name, Integer slideIndex, SpecialSlideType slideType, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createSpecialSlideShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createSpecialSlideShape(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling createSpecialSlideShape(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createSpecialSlideShape(Async)");
        }
        ShapeBase postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeToClone", shapeToClone);
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ShapeBase createSpecialSlideShape(String name, Integer slideIndex, SpecialSlideType slideType, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<ShapeBase> resp = this.createSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, dto, shapeToClone, position, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ShapeBase> resp = this.createSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, dto, shapeToClone, position, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<ShapeBase> createSpecialSlideShapeWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.createSpecialSlideShapeCall(name, slideIndex, slideType, dto, shapeToClone, position, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createSpecialSlideShapeAsync(String name, Integer slideIndex, SpecialSlideType slideType, ShapeBase dto, Integer shapeToClone, Integer position, String password, String folder, String storage, String subShape, final ApiCallback<ShapeBase> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSpecialSlideShapeCall(name, slideIndex, slideType, dto, shapeToClone, position, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createTableCellParagraphCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Paragraph dto, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createTableCellParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createTableCellParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createTableCellParagraph(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling createTableCellParagraph(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling createTableCellParagraph(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createTableCellParagraph(Async)");
        }
        Paragraph postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraph createTableCellParagraph(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Paragraph dto, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Paragraph> resp = this.createTableCellParagraphWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, dto, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraph> resp = this.createTableCellParagraphWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, dto, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraph> createTableCellParagraphWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Paragraph dto, String password, String folder, String storage) throws ApiException {
        Call call = this.createTableCellParagraphCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, dto, password, folder, storage, null, null);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createTableCellParagraphAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Paragraph dto, String password, String folder, String storage, final ApiCallback<Paragraph> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTableCellParagraphCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, dto, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createTableCellPortionCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Portion dto, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createTableCellPortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createTableCellPortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createTableCellPortion(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling createTableCellPortion(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling createTableCellPortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling createTableCellPortion(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createTableCellPortion(Async)");
        }
        Portion postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portion createTableCellPortion(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Portion dto, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Portion> resp = this.createTableCellPortionWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, dto, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portion> resp = this.createTableCellPortionWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, dto, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Portion> createTableCellPortionWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Portion dto, String password, String folder, String storage) throws ApiException {
        Call call = this.createTableCellPortionCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, dto, password, folder, storage, null, null);
        Type returnType = new TypeToken<Portion>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createTableCellPortionAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Portion dto, String password, String folder, String storage, final ApiCallback<Portion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTableCellPortionCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, dto, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portion>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createTableRowCall(String name, Integer slideIndex, Integer shapeIndex, TableRow dto, Integer position, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createTableRow(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling createTableRow(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling createTableRow(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling createTableRow(Async)");
        }
        TableRow postBody = dto;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public TableRow createTableRow(String name, Integer slideIndex, Integer shapeIndex, TableRow dto, Integer position, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<TableRow> resp = this.createTableRowWithHttpInfo(name, slideIndex, shapeIndex, dto, position, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<TableRow> resp = this.createTableRowWithHttpInfo(name, slideIndex, shapeIndex, dto, position, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<TableRow> createTableRowWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, TableRow dto, Integer position, String password, String folder, String storage) throws ApiException {
        Call call = this.createTableRowCall(name, slideIndex, shapeIndex, dto, position, password, folder, storage, null, null);
        Type returnType = new TypeToken<TableRow>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createTableRowAsync(String name, Integer slideIndex, Integer shapeIndex, TableRow dto, Integer position, String password, String folder, String storage, final ApiCallback<TableRow> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTableRowCall(name, slideIndex, shapeIndex, dto, position, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<TableRow>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createVbaModuleCall(String name, VbaModule moduleDto, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createVbaModule(Async)");
        }
        if (moduleDto == null) {
            throw new ApiException("Missing the required parameter 'moduleDto' when calling createVbaModule(Async)");
        }
        VbaModule postBody = moduleDto;
        String methodPath = "/slides/{name}/vbaProject/modules".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public VbaModule createVbaModule(String name, VbaModule moduleDto, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<VbaModule> resp = this.createVbaModuleWithHttpInfo(name, moduleDto, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<VbaModule> resp = this.createVbaModuleWithHttpInfo(name, moduleDto, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<VbaModule> createVbaModuleWithHttpInfo(String name, VbaModule moduleDto, String password, String folder, String storage) throws ApiException {
        Call call = this.createVbaModuleCall(name, moduleDto, password, folder, storage, null, null);
        Type returnType = new TypeToken<VbaModule>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createVbaModuleAsync(String name, VbaModule moduleDto, String password, String folder, String storage, final ApiCallback<VbaModule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createVbaModuleCall(name, moduleDto, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<VbaModule>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call createWatermarkCall(String name, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createWatermark(Async)");
        }
        Shape postBody = shape;
        String methodPath = "/slides/{name}/watermark".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "fontHeight", fontHeight);
        this.apiClient.addQueryParameter(queryParams, "text", text);
        this.apiClient.addQueryParameter(queryParams, "fontName", fontName);
        this.apiClient.addQueryParameter(queryParams, "fontColor", fontColor);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void createWatermark(String name, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password, String folder, String storage) throws ApiException {
        try {
            this.createWatermarkWithHttpInfo(name, shape, fontHeight, text, fontName, fontColor, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.createWatermarkWithHttpInfo(name, shape, fontHeight, text, fontName, fontColor, password, folder, storage);
        }
    }

    public ApiResponse<Void> createWatermarkWithHttpInfo(String name, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password, String folder, String storage) throws ApiException {
        Call call = this.createWatermarkCall(name, shape, fontHeight, text, fontName, fontColor, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call createWatermarkAsync(String name, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createWatermarkCall(name, shape, fontHeight, text, fontName, fontColor, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createWatermarkOnlineCall(byte[] document, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling createWatermarkOnline(Async)");
        }
        Shape postBody = shape;
        String methodPath = "/slides/watermark";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "fontHeight", fontHeight);
        this.apiClient.addQueryParameter(queryParams, "text", text);
        this.apiClient.addQueryParameter(queryParams, "fontName", fontName);
        this.apiClient.addQueryParameter(queryParams, "fontColor", fontColor);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File createWatermarkOnline(byte[] document, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.createWatermarkOnlineWithHttpInfo(document, shape, fontHeight, text, fontName, fontColor, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.createWatermarkOnlineWithHttpInfo(document, shape, fontHeight, text, fontName, fontColor, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> createWatermarkOnlineWithHttpInfo(byte[] document, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password) throws ApiException {
        Call call = this.createWatermarkOnlineCall(document, shape, fontHeight, text, fontName, fontColor, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call createWatermarkOnlineAsync(byte[] document, Shape shape, Double fontHeight, String text, String fontName, String fontColor, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createWatermarkOnlineCall(document, shape, fontHeight, text, fontName, fontColor, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteAnimationCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAnimation(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteAnimation(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteAnimation(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteAnimationWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteAnimationCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteAnimationAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAnimationCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteAnimationEffectCall(String name, Integer slideIndex, Integer effectIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAnimationEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteAnimationEffect(Async)");
        }
        if (effectIndex == null) {
            throw new ApiException("Missing the required parameter 'effectIndex' when calling deleteAnimationEffect(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/mainSequence/{effectIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{effectIndex\\}", this.apiClient.objectToString(effectIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteAnimationEffect(String name, Integer slideIndex, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationEffectWithHttpInfo(name, slideIndex, effectIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationEffectWithHttpInfo(name, slideIndex, effectIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteAnimationEffectWithHttpInfo(String name, Integer slideIndex, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteAnimationEffectCall(name, slideIndex, effectIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteAnimationEffectAsync(String name, Integer slideIndex, Integer effectIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAnimationEffectCall(name, slideIndex, effectIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteAnimationInteractiveSequenceCall(String name, Integer slideIndex, Integer sequenceIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAnimationInteractiveSequence(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteAnimationInteractiveSequence(Async)");
        }
        if (sequenceIndex == null) {
            throw new ApiException("Missing the required parameter 'sequenceIndex' when calling deleteAnimationInteractiveSequence(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{sequenceIndex\\}", this.apiClient.objectToString(sequenceIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteAnimationInteractiveSequence(String name, Integer slideIndex, Integer sequenceIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, sequenceIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, sequenceIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteAnimationInteractiveSequenceWithHttpInfo(String name, Integer slideIndex, Integer sequenceIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteAnimationInteractiveSequenceCall(name, slideIndex, sequenceIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteAnimationInteractiveSequenceAsync(String name, Integer slideIndex, Integer sequenceIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAnimationInteractiveSequenceCall(name, slideIndex, sequenceIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteAnimationInteractiveSequenceEffectCall(String name, Integer slideIndex, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAnimationInteractiveSequenceEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteAnimationInteractiveSequenceEffect(Async)");
        }
        if (sequenceIndex == null) {
            throw new ApiException("Missing the required parameter 'sequenceIndex' when calling deleteAnimationInteractiveSequenceEffect(Async)");
        }
        if (effectIndex == null) {
            throw new ApiException("Missing the required parameter 'effectIndex' when calling deleteAnimationInteractiveSequenceEffect(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}/{effectIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{sequenceIndex\\}", this.apiClient.objectToString(sequenceIndex)).replaceAll("\\{effectIndex\\}", this.apiClient.objectToString(effectIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteAnimationInteractiveSequenceEffect(String name, Integer slideIndex, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, sequenceIndex, effectIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, sequenceIndex, effectIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteAnimationInteractiveSequenceEffectWithHttpInfo(String name, Integer slideIndex, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteAnimationInteractiveSequenceEffectCall(name, slideIndex, sequenceIndex, effectIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteAnimationInteractiveSequenceEffectAsync(String name, Integer slideIndex, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAnimationInteractiveSequenceEffectCall(name, slideIndex, sequenceIndex, effectIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteAnimationInteractiveSequencesCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAnimationInteractiveSequences(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteAnimationInteractiveSequences(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/interactiveSequences".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteAnimationInteractiveSequences(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationInteractiveSequencesWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationInteractiveSequencesWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteAnimationInteractiveSequencesWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteAnimationInteractiveSequencesCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteAnimationInteractiveSequencesAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAnimationInteractiveSequencesCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteAnimationMainSequenceCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAnimationMainSequence(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteAnimationMainSequence(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation/mainSequence".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteAnimationMainSequence(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationMainSequenceWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteAnimationMainSequenceWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteAnimationMainSequenceWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteAnimationMainSequenceCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteAnimationMainSequenceAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAnimationMainSequenceCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteBackgroundCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteBackground(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteBackground(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/background".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideBackground deleteBackground(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideBackground> resp = this.deleteBackgroundWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideBackground> resp = this.deleteBackgroundWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideBackground> deleteBackgroundWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteBackgroundCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideBackground>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteBackgroundAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<SlideBackground> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteBackgroundCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideBackground>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteCaptionTrackCall(String name, Integer slideIndex, Integer shapeIndex, Integer captionsIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteCaptionTrack(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteCaptionTrack(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteCaptionTrack(Async)");
        }
        if (captionsIndex == null) {
            throw new ApiException("Missing the required parameter 'captionsIndex' when calling deleteCaptionTrack(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/captionTracks/{captionsIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{captionsIndex\\}", this.apiClient.objectToString(captionsIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void deleteCaptionTrack(String name, Integer slideIndex, Integer shapeIndex, Integer captionsIndex, String password, String folder, String storage) throws ApiException {
        try {
            this.deleteCaptionTrackWithHttpInfo(name, slideIndex, shapeIndex, captionsIndex, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.deleteCaptionTrackWithHttpInfo(name, slideIndex, shapeIndex, captionsIndex, password, folder, storage);
        }
    }

    public ApiResponse<Void> deleteCaptionTrackWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer captionsIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteCaptionTrackCall(name, slideIndex, shapeIndex, captionsIndex, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCaptionTrackAsync(String name, Integer slideIndex, Integer shapeIndex, Integer captionsIndex, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCaptionTrackCall(name, slideIndex, shapeIndex, captionsIndex, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteCaptionTracksCall(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteCaptionTracks(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteCaptionTracks(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteCaptionTracks(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/captionTracks".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void deleteCaptionTracks(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage) throws ApiException {
        try {
            this.deleteCaptionTracksWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.deleteCaptionTracksWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage);
        }
    }

    public ApiResponse<Void> deleteCaptionTracksWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteCaptionTracksCall(name, slideIndex, shapeIndex, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCaptionTracksAsync(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCaptionTracksCall(name, slideIndex, shapeIndex, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteChartCategoryCall(String name, Integer slideIndex, Integer shapeIndex, Integer categoryIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteChartCategory(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteChartCategory(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteChartCategory(Async)");
        }
        if (categoryIndex == null) {
            throw new ApiException("Missing the required parameter 'categoryIndex' when calling deleteChartCategory(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories/{categoryIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{categoryIndex\\}", this.apiClient.objectToString(categoryIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Chart deleteChartCategory(String name, Integer slideIndex, Integer shapeIndex, Integer categoryIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Chart> resp = this.deleteChartCategoryWithHttpInfo(name, slideIndex, shapeIndex, categoryIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Chart> resp = this.deleteChartCategoryWithHttpInfo(name, slideIndex, shapeIndex, categoryIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Chart> deleteChartCategoryWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer categoryIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteChartCategoryCall(name, slideIndex, shapeIndex, categoryIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Chart>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteChartCategoryAsync(String name, Integer slideIndex, Integer shapeIndex, Integer categoryIndex, String password, String folder, String storage, final ApiCallback<Chart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteChartCategoryCall(name, slideIndex, shapeIndex, categoryIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Chart>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteChartDataPointCall(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, Integer pointIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteChartDataPoint(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteChartDataPoint(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteChartDataPoint(Async)");
        }
        if (seriesIndex == null) {
            throw new ApiException("Missing the required parameter 'seriesIndex' when calling deleteChartDataPoint(Async)");
        }
        if (pointIndex == null) {
            throw new ApiException("Missing the required parameter 'pointIndex' when calling deleteChartDataPoint(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints/{pointIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{seriesIndex\\}", this.apiClient.objectToString(seriesIndex)).replaceAll("\\{pointIndex\\}", this.apiClient.objectToString(pointIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Chart deleteChartDataPoint(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, Integer pointIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Chart> resp = this.deleteChartDataPointWithHttpInfo(name, slideIndex, shapeIndex, seriesIndex, pointIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Chart> resp = this.deleteChartDataPointWithHttpInfo(name, slideIndex, shapeIndex, seriesIndex, pointIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Chart> deleteChartDataPointWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, Integer pointIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteChartDataPointCall(name, slideIndex, shapeIndex, seriesIndex, pointIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Chart>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteChartDataPointAsync(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, Integer pointIndex, String password, String folder, String storage, final ApiCallback<Chart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteChartDataPointCall(name, slideIndex, shapeIndex, seriesIndex, pointIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Chart>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteChartSeriesCall(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteChartSeries(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteChartSeries(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteChartSeries(Async)");
        }
        if (seriesIndex == null) {
            throw new ApiException("Missing the required parameter 'seriesIndex' when calling deleteChartSeries(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{seriesIndex\\}", this.apiClient.objectToString(seriesIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Chart deleteChartSeries(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Chart> resp = this.deleteChartSeriesWithHttpInfo(name, slideIndex, shapeIndex, seriesIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Chart> resp = this.deleteChartSeriesWithHttpInfo(name, slideIndex, shapeIndex, seriesIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Chart> deleteChartSeriesWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteChartSeriesCall(name, slideIndex, shapeIndex, seriesIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Chart>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteChartSeriesAsync(String name, Integer slideIndex, Integer shapeIndex, Integer seriesIndex, String password, String folder, String storage, final ApiCallback<Chart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteChartSeriesCall(name, slideIndex, shapeIndex, seriesIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Chart>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteCommentsCall(String name, String author, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteComments(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/comments".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "author", author);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void deleteComments(String name, String author, String password, String folder, String storage) throws ApiException {
        try {
            this.deleteCommentsWithHttpInfo(name, author, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.deleteCommentsWithHttpInfo(name, author, password, folder, storage);
        }
    }

    public ApiResponse<Void> deleteCommentsWithHttpInfo(String name, String author, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteCommentsCall(name, author, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCommentsAsync(String name, String author, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCommentsCall(name, author, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteCommentsOnlineCall(byte[] document, String author, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling deleteCommentsOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/comments/delete";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "author", author);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File deleteCommentsOnline(byte[] document, String author, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.deleteCommentsOnlineWithHttpInfo(document, author, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.deleteCommentsOnlineWithHttpInfo(document, author, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> deleteCommentsOnlineWithHttpInfo(byte[] document, String author, String password) throws ApiException {
        Call call = this.deleteCommentsOnlineCall(document, author, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteCommentsOnlineAsync(byte[] document, String author, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCommentsOnlineCall(document, author, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteDocumentPropertiesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDocumentProperties(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/documentproperties".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public DocumentProperties deleteDocumentProperties(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<DocumentProperties> resp = this.deleteDocumentPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<DocumentProperties> resp = this.deleteDocumentPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<DocumentProperties> deleteDocumentPropertiesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteDocumentPropertiesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<DocumentProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteDocumentPropertiesAsync(String name, String password, String folder, String storage, final ApiCallback<DocumentProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteDocumentPropertiesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<DocumentProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteDocumentPropertyCall(String name, String propertyName, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDocumentProperty(Async)");
        }
        if (propertyName == null) {
            throw new ApiException("Missing the required parameter 'propertyName' when calling deleteDocumentProperty(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/documentproperties/{propertyName}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{propertyName\\}", this.apiClient.objectToString(propertyName));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public DocumentProperties deleteDocumentProperty(String name, String propertyName, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<DocumentProperties> resp = this.deleteDocumentPropertyWithHttpInfo(name, propertyName, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<DocumentProperties> resp = this.deleteDocumentPropertyWithHttpInfo(name, propertyName, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<DocumentProperties> deleteDocumentPropertyWithHttpInfo(String name, String propertyName, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteDocumentPropertyCall(name, propertyName, password, folder, storage, null, null);
        Type returnType = new TypeToken<DocumentProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteDocumentPropertyAsync(String name, String propertyName, String password, String folder, String storage, final ApiCallback<DocumentProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteDocumentPropertyCall(name, propertyName, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<DocumentProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteEmbeddedFontCall(String name, String fontName, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteEmbeddedFont(Async)");
        }
        if (fontName == null) {
            throw new ApiException("Missing the required parameter 'fontName' when calling deleteEmbeddedFont(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/fonts/embedded/{fontName}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{fontName\\}", this.apiClient.objectToString(fontName));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FontsData deleteEmbeddedFont(String name, String fontName, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<FontsData> resp = this.deleteEmbeddedFontWithHttpInfo(name, fontName, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FontsData> resp = this.deleteEmbeddedFontWithHttpInfo(name, fontName, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<FontsData> deleteEmbeddedFontWithHttpInfo(String name, String fontName, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteEmbeddedFontCall(name, fontName, password, folder, storage, null, null);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteEmbeddedFontAsync(String name, String fontName, String password, String folder, String storage, final ApiCallback<FontsData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteEmbeddedFontCall(name, fontName, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteEmbeddedFontOnlineCall(byte[] document, String fontName, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling deleteEmbeddedFontOnline(Async)");
        }
        if (fontName == null) {
            throw new ApiException("Missing the required parameter 'fontName' when calling deleteEmbeddedFontOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/fonts/embedded/{fontName}/delete".replaceAll("\\{fontName\\}", this.apiClient.objectToString(fontName));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File deleteEmbeddedFontOnline(byte[] document, String fontName, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.deleteEmbeddedFontOnlineWithHttpInfo(document, fontName, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.deleteEmbeddedFontOnlineWithHttpInfo(document, fontName, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> deleteEmbeddedFontOnlineWithHttpInfo(byte[] document, String fontName, String password) throws ApiException {
        Call call = this.deleteEmbeddedFontOnlineCall(document, fontName, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteEmbeddedFontOnlineAsync(byte[] document, String fontName, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteEmbeddedFontOnlineCall(document, fontName, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteFileCall(String path, String storageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        this.apiClient.addQueryParameter(queryParams, "versionId", versionId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void deleteFile(String path, String storageName, String versionId) throws ApiException {
        try {
            this.deleteFileWithHttpInfo(path, storageName, versionId);
        }
        catch (NeedRepeatRequestException e) {
            this.deleteFileWithHttpInfo(path, storageName, versionId);
        }
    }

    public ApiResponse<Void> deleteFileWithHttpInfo(String path, String storageName, String versionId) throws ApiException {
        Call call = this.deleteFileCall(path, storageName, versionId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFileAsync(String path, String storageName, String versionId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFileCall(path, storageName, versionId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteFolderCall(String path, String storageName, Boolean recursive, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        this.apiClient.addQueryParameter(queryParams, "recursive", recursive);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void deleteFolder(String path, String storageName, Boolean recursive) throws ApiException {
        try {
            this.deleteFolderWithHttpInfo(path, storageName, recursive);
        }
        catch (NeedRepeatRequestException e) {
            this.deleteFolderWithHttpInfo(path, storageName, recursive);
        }
    }

    public ApiResponse<Void> deleteFolderWithHttpInfo(String path, String storageName, Boolean recursive) throws ApiException {
        Call call = this.deleteFolderCall(path, storageName, recursive, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFolderAsync(String path, String storageName, Boolean recursive, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFolderCall(path, storageName, recursive, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteNotesSlideCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNotesSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteNotesSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/notesSlide".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Slide deleteNotesSlide(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Slide> resp = this.deleteNotesSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Slide> resp = this.deleteNotesSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Slide> deleteNotesSlideWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteNotesSlideCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Slide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteNotesSlideAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<Slide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteNotesSlideCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Slide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteParagraphCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteParagraph(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deleteParagraph(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs deleteParagraph(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.deleteParagraphWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.deleteParagraphWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> deleteParagraphWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteParagraphCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteParagraphAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteParagraphCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteParagraphsCall(String name, Integer slideIndex, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteParagraphs(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteParagraphs(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteParagraphs(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "paragraphs", paragraphs);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs deleteParagraphs(String name, Integer slideIndex, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.deleteParagraphsWithHttpInfo(name, slideIndex, shapeIndex, paragraphs, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.deleteParagraphsWithHttpInfo(name, slideIndex, shapeIndex, paragraphs, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> deleteParagraphsWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteParagraphsCall(name, slideIndex, shapeIndex, paragraphs, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteParagraphsAsync(String name, Integer slideIndex, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteParagraphsCall(name, slideIndex, shapeIndex, paragraphs, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deletePortionCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deletePortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deletePortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deletePortion(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling deletePortion(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions deletePortion(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.deletePortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.deletePortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> deletePortionWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deletePortionCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deletePortionAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletePortionCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deletePortionsCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePortions(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deletePortions(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deletePortions(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deletePortions(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "portions", portions);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions deletePortions(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.deletePortionsWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.deletePortionsWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> deletePortionsWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deletePortionsCall(name, slideIndex, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deletePortionsAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletePortionsCall(name, slideIndex, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteProtectionCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteProtection(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/protection".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ProtectionProperties deleteProtection(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<ProtectionProperties> resp = this.deleteProtectionWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ProtectionProperties> resp = this.deleteProtectionWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<ProtectionProperties> deleteProtectionWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteProtectionCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<ProtectionProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteProtectionAsync(String name, String password, String folder, String storage, final ApiCallback<ProtectionProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteProtectionCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ProtectionProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteProtectionOnlineCall(byte[] document, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling deleteProtectionOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/protection/delete";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File deleteProtectionOnline(byte[] document, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.deleteProtectionOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.deleteProtectionOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> deleteProtectionOnlineWithHttpInfo(byte[] document, String password) throws ApiException {
        Call call = this.deleteProtectionOnlineCall(document, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteProtectionOnlineAsync(byte[] document, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteProtectionOnlineCall(document, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSectionCall(String name, Integer sectionIndex, Boolean withSlides, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSection(Async)");
        }
        if (sectionIndex == null) {
            throw new ApiException("Missing the required parameter 'sectionIndex' when calling deleteSection(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/sections/{sectionIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{sectionIndex\\}", this.apiClient.objectToString(sectionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "withSlides", withSlides);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Sections deleteSection(String name, Integer sectionIndex, Boolean withSlides, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Sections> resp = this.deleteSectionWithHttpInfo(name, sectionIndex, withSlides, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Sections> resp = this.deleteSectionWithHttpInfo(name, sectionIndex, withSlides, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Sections> deleteSectionWithHttpInfo(String name, Integer sectionIndex, Boolean withSlides, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSectionCall(name, sectionIndex, withSlides, password, folder, storage, null, null);
        Type returnType = new TypeToken<Sections>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSectionAsync(String name, Integer sectionIndex, Boolean withSlides, String password, String folder, String storage, final ApiCallback<Sections> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSectionCall(name, sectionIndex, withSlides, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Sections>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSectionsCall(String name, List<Integer> sections, Boolean withSlides, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSections(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/sections".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "sections", sections);
        this.apiClient.addQueryParameter(queryParams, "withSlides", withSlides);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Sections deleteSections(String name, List<Integer> sections, Boolean withSlides, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Sections> resp = this.deleteSectionsWithHttpInfo(name, sections, withSlides, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Sections> resp = this.deleteSectionsWithHttpInfo(name, sections, withSlides, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Sections> deleteSectionsWithHttpInfo(String name, List<Integer> sections, Boolean withSlides, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSectionsCall(name, sections, withSlides, password, folder, storage, null, null);
        Type returnType = new TypeToken<Sections>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSectionsAsync(String name, List<Integer> sections, Boolean withSlides, String password, String folder, String storage, final ApiCallback<Sections> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSectionsCall(name, sections, withSlides, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Sections>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteShapeCall(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteShape(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteShape(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes deleteShape(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.deleteShapeWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.deleteShapeWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> deleteShapeWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteShapeCall(name, slideIndex, shapeIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteShapeAsync(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteShapeCall(name, slideIndex, shapeIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteShapesCall(String name, Integer slideIndex, List<Integer> shapes, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteShapes(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteShapes(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapes", shapes);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes deleteShapes(String name, Integer slideIndex, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.deleteShapesWithHttpInfo(name, slideIndex, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.deleteShapesWithHttpInfo(name, slideIndex, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> deleteShapesWithHttpInfo(String name, Integer slideIndex, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteShapesCall(name, slideIndex, shapes, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteShapesAsync(String name, Integer slideIndex, List<Integer> shapes, String password, String folder, String storage, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteShapesCall(name, slideIndex, shapes, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSlideCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Slides deleteSlide(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Slides> resp = this.deleteSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Slides> resp = this.deleteSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Slides> deleteSlideWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSlideCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Slides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSlideAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<Slides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSlideCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Slides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSlideCommentsCall(String name, Integer slideIndex, String author, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSlideComments(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSlideComments(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/comments".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "author", author);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideComments deleteSlideComments(String name, Integer slideIndex, String author, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideComments> resp = this.deleteSlideCommentsWithHttpInfo(name, slideIndex, author, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideComments> resp = this.deleteSlideCommentsWithHttpInfo(name, slideIndex, author, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideComments> deleteSlideCommentsWithHttpInfo(String name, Integer slideIndex, String author, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSlideCommentsCall(name, slideIndex, author, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideComments>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSlideCommentsAsync(String name, Integer slideIndex, String author, String password, String folder, String storage, final ApiCallback<SlideComments> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSlideCommentsCall(name, slideIndex, author, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideComments>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSlideCommentsOnlineCall(byte[] document, Integer slideIndex, String author, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling deleteSlideCommentsOnline(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSlideCommentsOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/slides/{slideIndex}/comments/delete".replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "author", author);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File deleteSlideCommentsOnline(byte[] document, Integer slideIndex, String author, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.deleteSlideCommentsOnlineWithHttpInfo(document, slideIndex, author, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.deleteSlideCommentsOnlineWithHttpInfo(document, slideIndex, author, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> deleteSlideCommentsOnlineWithHttpInfo(byte[] document, Integer slideIndex, String author, String password) throws ApiException {
        Call call = this.deleteSlideCommentsOnlineCall(document, slideIndex, author, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSlideCommentsOnlineAsync(byte[] document, Integer slideIndex, String author, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSlideCommentsOnlineCall(document, slideIndex, author, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSlidesCall(String name, List<Integer> slides, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSlides(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Slides deleteSlides(String name, List<Integer> slides, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Slides> resp = this.deleteSlidesWithHttpInfo(name, slides, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Slides> resp = this.deleteSlidesWithHttpInfo(name, slides, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Slides> deleteSlidesWithHttpInfo(String name, List<Integer> slides, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSlidesCall(name, slides, password, folder, storage, null, null);
        Type returnType = new TypeToken<Slides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSlidesAsync(String name, List<Integer> slides, String password, String folder, String storage, final ApiCallback<Slides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSlidesCall(name, slides, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Slides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSmartArtNodeCall(String name, Integer slideIndex, Integer smartArtIndex, Integer nodeIndex, String subNode, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSmartArtNode(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSmartArtNode(Async)");
        }
        if (smartArtIndex == null) {
            throw new ApiException("Missing the required parameter 'smartArtIndex' when calling deleteSmartArtNode(Async)");
        }
        if (nodeIndex == null) {
            throw new ApiException("Missing the required parameter 'nodeIndex' when calling deleteSmartArtNode(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/smartArts/{smartArtIndex}/nodes/{nodeIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{smartArtIndex\\}", this.apiClient.objectToString(smartArtIndex)).replaceAll("\\{nodeIndex\\}", this.apiClient.objectToString(nodeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "subNode", subNode);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SmartArt deleteSmartArtNode(String name, Integer slideIndex, Integer smartArtIndex, Integer nodeIndex, String subNode, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SmartArt> resp = this.deleteSmartArtNodeWithHttpInfo(name, slideIndex, smartArtIndex, nodeIndex, subNode, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SmartArt> resp = this.deleteSmartArtNodeWithHttpInfo(name, slideIndex, smartArtIndex, nodeIndex, subNode, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SmartArt> deleteSmartArtNodeWithHttpInfo(String name, Integer slideIndex, Integer smartArtIndex, Integer nodeIndex, String subNode, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSmartArtNodeCall(name, slideIndex, smartArtIndex, nodeIndex, subNode, password, folder, storage, null, null);
        Type returnType = new TypeToken<SmartArt>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSmartArtNodeAsync(String name, Integer slideIndex, Integer smartArtIndex, Integer nodeIndex, String subNode, String password, String folder, String storage, final ApiCallback<SmartArt> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSmartArtNodeCall(name, slideIndex, smartArtIndex, nodeIndex, subNode, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SmartArt>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideAnimationCall(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideAnimation(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideAnimation(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideAnimation(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteSpecialSlideAnimation(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationWithHttpInfo(name, slideIndex, slideType, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationWithHttpInfo(name, slideIndex, slideType, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteSpecialSlideAnimationWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSpecialSlideAnimationCall(name, slideIndex, slideType, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideAnimationAsync(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideAnimationCall(name, slideIndex, slideType, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideAnimationEffectCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer effectIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideAnimationEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideAnimationEffect(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideAnimationEffect(Async)");
        }
        if (effectIndex == null) {
            throw new ApiException("Missing the required parameter 'effectIndex' when calling deleteSpecialSlideAnimationEffect(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence/{effectIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{effectIndex\\}", this.apiClient.objectToString(effectIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteSpecialSlideAnimationEffect(String name, Integer slideIndex, SpecialSlideType slideType, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationEffectWithHttpInfo(name, slideIndex, slideType, effectIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationEffectWithHttpInfo(name, slideIndex, slideType, effectIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteSpecialSlideAnimationEffectWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSpecialSlideAnimationEffectCall(name, slideIndex, slideType, effectIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideAnimationEffectAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer effectIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideAnimationEffectCall(name, slideIndex, slideType, effectIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideAnimationInteractiveSequenceCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideAnimationInteractiveSequence(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideAnimationInteractiveSequence(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideAnimationInteractiveSequence(Async)");
        }
        if (sequenceIndex == null) {
            throw new ApiException("Missing the required parameter 'sequenceIndex' when calling deleteSpecialSlideAnimationInteractiveSequence(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{sequenceIndex\\}", this.apiClient.objectToString(sequenceIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteSpecialSlideAnimationInteractiveSequence(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, slideType, sequenceIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationInteractiveSequenceWithHttpInfo(name, slideIndex, slideType, sequenceIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteSpecialSlideAnimationInteractiveSequenceWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSpecialSlideAnimationInteractiveSequenceCall(name, slideIndex, slideType, sequenceIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideAnimationInteractiveSequenceAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideAnimationInteractiveSequenceCall(name, slideIndex, slideType, sequenceIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideAnimationInteractiveSequenceEffectCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (sequenceIndex == null) {
            throw new ApiException("Missing the required parameter 'sequenceIndex' when calling deleteSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        if (effectIndex == null) {
            throw new ApiException("Missing the required parameter 'effectIndex' when calling deleteSpecialSlideAnimationInteractiveSequenceEffect(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}/{effectIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{sequenceIndex\\}", this.apiClient.objectToString(sequenceIndex)).replaceAll("\\{effectIndex\\}", this.apiClient.objectToString(effectIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteSpecialSlideAnimationInteractiveSequenceEffect(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, slideType, sequenceIndex, effectIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationInteractiveSequenceEffectWithHttpInfo(name, slideIndex, slideType, sequenceIndex, effectIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteSpecialSlideAnimationInteractiveSequenceEffectWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSpecialSlideAnimationInteractiveSequenceEffectCall(name, slideIndex, slideType, sequenceIndex, effectIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideAnimationInteractiveSequenceEffectAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer sequenceIndex, Integer effectIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideAnimationInteractiveSequenceEffectCall(name, slideIndex, slideType, sequenceIndex, effectIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideAnimationInteractiveSequencesCall(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideAnimationInteractiveSequences(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideAnimationInteractiveSequences(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideAnimationInteractiveSequences(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteSpecialSlideAnimationInteractiveSequences(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationInteractiveSequencesWithHttpInfo(name, slideIndex, slideType, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationInteractiveSequencesWithHttpInfo(name, slideIndex, slideType, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteSpecialSlideAnimationInteractiveSequencesWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSpecialSlideAnimationInteractiveSequencesCall(name, slideIndex, slideType, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideAnimationInteractiveSequencesAsync(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideAnimationInteractiveSequencesCall(name, slideIndex, slideType, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideAnimationMainSequenceCall(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideAnimationMainSequence(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideAnimationMainSequence(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideAnimationMainSequence(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation deleteSpecialSlideAnimationMainSequence(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationMainSequenceWithHttpInfo(name, slideIndex, slideType, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.deleteSpecialSlideAnimationMainSequenceWithHttpInfo(name, slideIndex, slideType, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> deleteSpecialSlideAnimationMainSequenceWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteSpecialSlideAnimationMainSequenceCall(name, slideIndex, slideType, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideAnimationMainSequenceAsync(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideAnimationMainSequenceCall(name, slideIndex, slideType, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideParagraphCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideParagraph(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteSpecialSlideParagraph(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deleteSpecialSlideParagraph(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs deleteSpecialSlideParagraph(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.deleteSpecialSlideParagraphWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.deleteSpecialSlideParagraphWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> deleteSpecialSlideParagraphWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteSpecialSlideParagraphCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideParagraphAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideParagraphCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideParagraphsCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideParagraphs(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideParagraphs(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideParagraphs(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteSpecialSlideParagraphs(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "paragraphs", paragraphs);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs deleteSpecialSlideParagraphs(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.deleteSpecialSlideParagraphsWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphs, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.deleteSpecialSlideParagraphsWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphs, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> deleteSpecialSlideParagraphsWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteSpecialSlideParagraphsCall(name, slideIndex, slideType, shapeIndex, paragraphs, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideParagraphsAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, List<Integer> paragraphs, String password, String folder, String storage, String subShape, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideParagraphsCall(name, slideIndex, slideType, shapeIndex, paragraphs, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlidePortionCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlidePortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlidePortion(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlidePortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteSpecialSlidePortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deleteSpecialSlidePortion(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling deleteSpecialSlidePortion(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions deleteSpecialSlidePortion(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.deleteSpecialSlidePortionWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.deleteSpecialSlidePortionWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> deleteSpecialSlidePortionWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteSpecialSlidePortionCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlidePortionAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlidePortionCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlidePortionsCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlidePortions(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlidePortions(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlidePortions(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteSpecialSlidePortions(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deleteSpecialSlidePortions(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "portions", portions);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions deleteSpecialSlidePortions(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.deleteSpecialSlidePortionsWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.deleteSpecialSlidePortionsWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> deleteSpecialSlidePortionsWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteSpecialSlidePortionsCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlidePortionsAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, List<Integer> portions, String password, String folder, String storage, String subShape, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlidePortionsCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, portions, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideShapeCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideShape(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideShape(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteSpecialSlideShape(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes deleteSpecialSlideShape(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.deleteSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.deleteSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> deleteSpecialSlideShapeWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteSpecialSlideShapeCall(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideShapeAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideShapeCall(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteSpecialSlideShapesCall(String name, Integer slideIndex, SpecialSlideType slideType, List<Integer> shapes, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSpecialSlideShapes(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteSpecialSlideShapes(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling deleteSpecialSlideShapes(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapes", shapes);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes deleteSpecialSlideShapes(String name, Integer slideIndex, SpecialSlideType slideType, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.deleteSpecialSlideShapesWithHttpInfo(name, slideIndex, slideType, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.deleteSpecialSlideShapesWithHttpInfo(name, slideIndex, slideType, shapes, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> deleteSpecialSlideShapesWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, List<Integer> shapes, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.deleteSpecialSlideShapesCall(name, slideIndex, slideType, shapes, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteSpecialSlideShapesAsync(String name, Integer slideIndex, SpecialSlideType slideType, List<Integer> shapes, String password, String folder, String storage, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSpecialSlideShapesCall(name, slideIndex, slideType, shapes, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteTableCellParagraphCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteTableCellParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteTableCellParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteTableCellParagraph(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling deleteTableCellParagraph(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling deleteTableCellParagraph(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deleteTableCellParagraph(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs deleteTableCellParagraph(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.deleteTableCellParagraphWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.deleteTableCellParagraphWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> deleteTableCellParagraphWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteTableCellParagraphCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteTableCellParagraphAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTableCellParagraphCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteTableCellPortionCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteTableCellPortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteTableCellPortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteTableCellPortion(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling deleteTableCellPortion(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling deleteTableCellPortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling deleteTableCellPortion(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling deleteTableCellPortion(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions deleteTableCellPortion(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.deleteTableCellPortionWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.deleteTableCellPortionWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> deleteTableCellPortionWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteTableCellPortionCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteTableCellPortionAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTableCellPortionCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteTableRowCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Boolean withAttachedRows, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteTableRow(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling deleteTableRow(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling deleteTableRow(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling deleteTableRow(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "withAttachedRows", withAttachedRows);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Table deleteTableRow(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Boolean withAttachedRows, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Table> resp = this.deleteTableRowWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, withAttachedRows, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Table> resp = this.deleteTableRowWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, withAttachedRows, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Table> deleteTableRowWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Boolean withAttachedRows, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteTableRowCall(name, slideIndex, shapeIndex, rowIndex, withAttachedRows, password, folder, storage, null, null);
        Type returnType = new TypeToken<Table>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteTableRowAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Boolean withAttachedRows, String password, String folder, String storage, final ApiCallback<Table> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTableRowCall(name, slideIndex, shapeIndex, rowIndex, withAttachedRows, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Table>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteUnusedLayoutSlidesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteUnusedLayoutSlides(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/layoutSlides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public LayoutSlides deleteUnusedLayoutSlides(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<LayoutSlides> resp = this.deleteUnusedLayoutSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<LayoutSlides> resp = this.deleteUnusedLayoutSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<LayoutSlides> deleteUnusedLayoutSlidesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteUnusedLayoutSlidesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<LayoutSlides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteUnusedLayoutSlidesAsync(String name, String password, String folder, String storage, final ApiCallback<LayoutSlides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUnusedLayoutSlidesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<LayoutSlides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteUnusedLayoutSlidesOnlineCall(byte[] document, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling deleteUnusedLayoutSlidesOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/layoutSlides/delete";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File deleteUnusedLayoutSlidesOnline(byte[] document, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.deleteUnusedLayoutSlidesOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.deleteUnusedLayoutSlidesOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> deleteUnusedLayoutSlidesOnlineWithHttpInfo(byte[] document, String password) throws ApiException {
        Call call = this.deleteUnusedLayoutSlidesOnlineCall(document, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteUnusedLayoutSlidesOnlineAsync(byte[] document, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUnusedLayoutSlidesOnlineCall(document, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteUnusedMasterSlidesCall(String name, Boolean ignorePreserveField, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteUnusedMasterSlides(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/masterSlides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "ignorePreserveField", ignorePreserveField);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public MasterSlides deleteUnusedMasterSlides(String name, Boolean ignorePreserveField, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<MasterSlides> resp = this.deleteUnusedMasterSlidesWithHttpInfo(name, ignorePreserveField, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<MasterSlides> resp = this.deleteUnusedMasterSlidesWithHttpInfo(name, ignorePreserveField, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<MasterSlides> deleteUnusedMasterSlidesWithHttpInfo(String name, Boolean ignorePreserveField, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteUnusedMasterSlidesCall(name, ignorePreserveField, password, folder, storage, null, null);
        Type returnType = new TypeToken<MasterSlides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteUnusedMasterSlidesAsync(String name, Boolean ignorePreserveField, String password, String folder, String storage, final ApiCallback<MasterSlides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUnusedMasterSlidesCall(name, ignorePreserveField, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<MasterSlides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteUnusedMasterSlidesOnlineCall(byte[] document, Boolean ignorePreserveField, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling deleteUnusedMasterSlidesOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/masterSlides/delete";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "ignorePreserveField", ignorePreserveField);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File deleteUnusedMasterSlidesOnline(byte[] document, Boolean ignorePreserveField, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.deleteUnusedMasterSlidesOnlineWithHttpInfo(document, ignorePreserveField, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.deleteUnusedMasterSlidesOnlineWithHttpInfo(document, ignorePreserveField, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> deleteUnusedMasterSlidesOnlineWithHttpInfo(byte[] document, Boolean ignorePreserveField, String password) throws ApiException {
        Call call = this.deleteUnusedMasterSlidesOnlineCall(document, ignorePreserveField, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteUnusedMasterSlidesOnlineAsync(byte[] document, Boolean ignorePreserveField, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUnusedMasterSlidesOnlineCall(document, ignorePreserveField, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteVbaModuleCall(String name, Integer moduleIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteVbaModule(Async)");
        }
        if (moduleIndex == null) {
            throw new ApiException("Missing the required parameter 'moduleIndex' when calling deleteVbaModule(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/vbaProject/modules/{moduleIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{moduleIndex\\}", this.apiClient.objectToString(moduleIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public VbaProject deleteVbaModule(String name, Integer moduleIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<VbaProject> resp = this.deleteVbaModuleWithHttpInfo(name, moduleIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<VbaProject> resp = this.deleteVbaModuleWithHttpInfo(name, moduleIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<VbaProject> deleteVbaModuleWithHttpInfo(String name, Integer moduleIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteVbaModuleCall(name, moduleIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<VbaProject>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteVbaModuleAsync(String name, Integer moduleIndex, String password, String folder, String storage, final ApiCallback<VbaProject> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteVbaModuleCall(name, moduleIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<VbaProject>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call deleteWatermarkCall(String name, String shapeName, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteWatermark(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/watermark/delete".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeName", shapeName);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "DELETE", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public void deleteWatermark(String name, String shapeName, String password, String folder, String storage) throws ApiException {
        try {
            this.deleteWatermarkWithHttpInfo(name, shapeName, password, folder, storage);
        }
        catch (NeedRepeatRequestException e) {
            this.deleteWatermarkWithHttpInfo(name, shapeName, password, folder, storage);
        }
    }

    public ApiResponse<Void> deleteWatermarkWithHttpInfo(String name, String shapeName, String password, String folder, String storage) throws ApiException {
        Call call = this.deleteWatermarkCall(name, shapeName, password, folder, storage, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteWatermarkAsync(String name, String shapeName, String password, String folder, String storage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWatermarkCall(name, shapeName, password, folder, storage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteWatermarkOnlineCall(byte[] document, String shapeName, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling deleteWatermarkOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/watermark/delete";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeName", shapeName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File deleteWatermarkOnline(byte[] document, String shapeName, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.deleteWatermarkOnlineWithHttpInfo(document, shapeName, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.deleteWatermarkOnlineWithHttpInfo(document, shapeName, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> deleteWatermarkOnlineWithHttpInfo(byte[] document, String shapeName, String password) throws ApiException {
        Call call = this.deleteWatermarkOnlineCall(document, shapeName, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call deleteWatermarkOnlineAsync(byte[] document, String shapeName, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWatermarkOnlineCall(document, shapeName, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadFileCall(String path, String storageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        this.apiClient.addQueryParameter(queryParams, "versionId", versionId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadFile(String path, String storageName, String versionId) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadFileWithHttpInfo(path, storageName, versionId);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadFileWithHttpInfo(path, storageName, versionId);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadFileWithHttpInfo(String path, String storageName, String versionId) throws ApiException {
        Call call = this.downloadFileCall(path, storageName, versionId, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadFileAsync(String path, String storageName, String versionId, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadFileCall(path, storageName, versionId, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImageCall(String name, Integer index, ImageExportFormat format, String password, String folder, String storage, Integer quality, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadImage(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling downloadImage(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadImage(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/images/{index}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{index\\}", this.apiClient.objectToString(index)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "quality", quality);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImage(String name, Integer index, ImageExportFormat format, String password, String folder, String storage, Integer quality) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImageWithHttpInfo(name, index, format, password, folder, storage, quality);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImageWithHttpInfo(name, index, format, password, folder, storage, quality);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImageWithHttpInfo(String name, Integer index, ImageExportFormat format, String password, String folder, String storage, Integer quality) throws ApiException {
        Call call = this.downloadImageCall(name, index, format, password, folder, storage, quality, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImageAsync(String name, Integer index, ImageExportFormat format, String password, String folder, String storage, Integer quality, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImageCall(name, index, format, password, folder, storage, quality, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImageDefaultFormatCall(String name, Integer index, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadImageDefaultFormat(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling downloadImageDefaultFormat(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/images/{index}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{index\\}", this.apiClient.objectToString(index));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImageDefaultFormat(String name, Integer index, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImageDefaultFormatWithHttpInfo(name, index, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImageDefaultFormatWithHttpInfo(name, index, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImageDefaultFormatWithHttpInfo(String name, Integer index, String password, String folder, String storage) throws ApiException {
        Call call = this.downloadImageDefaultFormatCall(name, index, password, folder, storage, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImageDefaultFormatAsync(String name, Integer index, String password, String folder, String storage, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImageDefaultFormatCall(name, index, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImageDefaultFormatOnlineCall(byte[] document, Integer index, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling downloadImageDefaultFormatOnline(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling downloadImageDefaultFormatOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/images/{index}".replaceAll("\\{index\\}", this.apiClient.objectToString(index));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImageDefaultFormatOnline(byte[] document, Integer index, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImageDefaultFormatOnlineWithHttpInfo(document, index, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImageDefaultFormatOnlineWithHttpInfo(document, index, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImageDefaultFormatOnlineWithHttpInfo(byte[] document, Integer index, String password) throws ApiException {
        Call call = this.downloadImageDefaultFormatOnlineCall(document, index, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImageDefaultFormatOnlineAsync(byte[] document, Integer index, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImageDefaultFormatOnlineCall(document, index, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImageOnlineCall(byte[] document, Integer index, ImageExportFormat format, String password, Integer quality, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling downloadImageOnline(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling downloadImageOnline(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadImageOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/images/{index}/{format}".replaceAll("\\{index\\}", this.apiClient.objectToString(index)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "quality", quality);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImageOnline(byte[] document, Integer index, ImageExportFormat format, String password, Integer quality) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImageOnlineWithHttpInfo(document, index, format, password, quality);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImageOnlineWithHttpInfo(document, index, format, password, quality);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImageOnlineWithHttpInfo(byte[] document, Integer index, ImageExportFormat format, String password, Integer quality) throws ApiException {
        Call call = this.downloadImageOnlineCall(document, index, format, password, quality, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImageOnlineAsync(byte[] document, Integer index, ImageExportFormat format, String password, Integer quality, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImageOnlineCall(document, index, format, password, quality, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImagesCall(String name, ImageExportFormat format, String password, String folder, String storage, Integer quality, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadImages(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadImages(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/images/download/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "quality", quality);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImages(String name, ImageExportFormat format, String password, String folder, String storage, Integer quality) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImagesWithHttpInfo(name, format, password, folder, storage, quality);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImagesWithHttpInfo(name, format, password, folder, storage, quality);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImagesWithHttpInfo(String name, ImageExportFormat format, String password, String folder, String storage, Integer quality) throws ApiException {
        Call call = this.downloadImagesCall(name, format, password, folder, storage, quality, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImagesAsync(String name, ImageExportFormat format, String password, String folder, String storage, Integer quality, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImagesCall(name, format, password, folder, storage, quality, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImagesDefaultFormatCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadImagesDefaultFormat(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/images/download".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImagesDefaultFormat(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImagesDefaultFormatWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImagesDefaultFormatWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImagesDefaultFormatWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.downloadImagesDefaultFormatCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImagesDefaultFormatAsync(String name, String password, String folder, String storage, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImagesDefaultFormatCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImagesDefaultFormatOnlineCall(byte[] document, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling downloadImagesDefaultFormatOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/images/download";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImagesDefaultFormatOnline(byte[] document, String password) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImagesDefaultFormatOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImagesDefaultFormatOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImagesDefaultFormatOnlineWithHttpInfo(byte[] document, String password) throws ApiException {
        Call call = this.downloadImagesDefaultFormatOnlineCall(document, password, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImagesDefaultFormatOnlineAsync(byte[] document, String password, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImagesDefaultFormatOnlineCall(document, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadImagesOnlineCall(byte[] document, ImageExportFormat format, String password, Integer quality, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling downloadImagesOnline(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadImagesOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/images/download/{format}".replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "quality", quality);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadImagesOnline(byte[] document, ImageExportFormat format, String password, Integer quality) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadImagesOnlineWithHttpInfo(document, format, password, quality);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadImagesOnlineWithHttpInfo(document, format, password, quality);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadImagesOnlineWithHttpInfo(byte[] document, ImageExportFormat format, String password, Integer quality) throws ApiException {
        Call call = this.downloadImagesOnlineCall(document, format, password, quality, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadImagesOnlineAsync(byte[] document, ImageExportFormat format, String password, Integer quality, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImagesOnlineCall(document, format, password, quality, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadMathPortionCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, MathFormat format, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadMathPortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadMathPortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling downloadMathPortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling downloadMathPortion(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling downloadMathPortion(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadMathPortion(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadMathPortion(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, MathFormat format, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadMathPortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, format, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadMathPortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, format, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadMathPortionWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, MathFormat format, String password, String folder, String storage) throws ApiException {
        Call call = this.downloadMathPortionCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, format, password, folder, storage, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadMathPortionAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, MathFormat format, String password, String folder, String storage, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadMathPortionCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, format, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadNotesSlideCall(String name, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String folder, String storage, String fontsFolder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadNotesSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadNotesSlide(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadNotesSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/notesSlide/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "width", width);
        this.apiClient.addQueryParameter(queryParams, "height", height);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadNotesSlide(String name, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String folder, String storage, String fontsFolder) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadNotesSlideWithHttpInfo(name, slideIndex, format, width, height, password, folder, storage, fontsFolder);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadNotesSlideWithHttpInfo(name, slideIndex, format, width, height, password, folder, storage, fontsFolder);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadNotesSlideWithHttpInfo(String name, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String folder, String storage, String fontsFolder) throws ApiException {
        Call call = this.downloadNotesSlideCall(name, slideIndex, format, width, height, password, folder, storage, fontsFolder, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadNotesSlideAsync(String name, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String folder, String storage, String fontsFolder, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadNotesSlideCall(name, slideIndex, format, width, height, password, folder, storage, fontsFolder, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadNotesSlideOnlineCall(byte[] document, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String fontsFolder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling downloadNotesSlideOnline(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadNotesSlideOnline(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadNotesSlideOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/slides/{slideIndex}/notesSlide/{format}".replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "width", width);
        this.apiClient.addQueryParameter(queryParams, "height", height);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadNotesSlideOnline(byte[] document, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String fontsFolder) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadNotesSlideOnlineWithHttpInfo(document, slideIndex, format, width, height, password, fontsFolder);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadNotesSlideOnlineWithHttpInfo(document, slideIndex, format, width, height, password, fontsFolder);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadNotesSlideOnlineWithHttpInfo(byte[] document, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String fontsFolder) throws ApiException {
        Call call = this.downloadNotesSlideOnlineCall(document, slideIndex, format, width, height, password, fontsFolder, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadNotesSlideOnlineAsync(byte[] document, Integer slideIndex, NotesSlideExportFormat format, Integer width, Integer height, String password, String fontsFolder, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadNotesSlideOnlineCall(document, slideIndex, format, width, height, password, fontsFolder, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadPresentationCall(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadPresentation(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadPresentation(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/{name}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadPresentation(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadPresentationWithHttpInfo(name, format, options, password, folder, storage, fontsFolder, slides);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadPresentationWithHttpInfo(name, format, options, password, folder, storage, fontsFolder, slides);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadPresentationWithHttpInfo(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides) throws ApiException {
        Call call = this.downloadPresentationCall(name, format, options, password, folder, storage, fontsFolder, slides, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadPresentationAsync(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadPresentationCall(name, format, options, password, folder, storage, fontsFolder, slides, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadShapeCall(String name, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadShape(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling downloadShape(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadShape(Async)");
        }
        IShapeExportOptions postBody = options;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "scaleX", scaleX);
        this.apiClient.addQueryParameter(queryParams, "scaleY", scaleY);
        this.apiClient.addQueryParameter(queryParams, "bounds", (Object)bounds);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadShape(String name, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadShapeWithHttpInfo(name, slideIndex, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadShapeWithHttpInfo(name, slideIndex, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadShapeWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape) throws ApiException {
        Call call = this.downloadShapeCall(name, slideIndex, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadShapeAsync(String name, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadShapeCall(name, slideIndex, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadShapeFromDtoCall(ShapeExportFormat format, ShapeBase dto, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadShapeFromDto(Async)");
        }
        if (dto == null) {
            throw new ApiException("Missing the required parameter 'dto' when calling downloadShapeFromDto(Async)");
        }
        ShapeBase postBody = dto;
        String methodPath = "/slides/shape/{format}".replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadShapeFromDto(ShapeExportFormat format, ShapeBase dto) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadShapeFromDtoWithHttpInfo(format, dto);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadShapeFromDtoWithHttpInfo(format, dto);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadShapeFromDtoWithHttpInfo(ShapeExportFormat format, ShapeBase dto) throws ApiException {
        Call call = this.downloadShapeFromDtoCall(format, dto, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadShapeFromDtoAsync(ShapeExportFormat format, ShapeBase dto, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadShapeFromDtoCall(format, dto, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadShapeOnlineCall(byte[] document, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String storage, String fontsFolder, IShapeExportOptions options, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling downloadShapeOnline(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadShapeOnline(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling downloadShapeOnline(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadShapeOnline(Async)");
        }
        IShapeExportOptions postBody = options;
        String methodPath = "/slides/slides/{slideIndex}/shapes/{shapeIndex}/{format}".replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "scaleX", scaleX);
        this.apiClient.addQueryParameter(queryParams, "scaleY", scaleY);
        this.apiClient.addQueryParameter(queryParams, "bounds", (Object)bounds);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadShapeOnline(byte[] document, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String storage, String fontsFolder, IShapeExportOptions options) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadShapeOnlineWithHttpInfo(document, slideIndex, shapeIndex, format, scaleX, scaleY, bounds, password, storage, fontsFolder, options);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadShapeOnlineWithHttpInfo(document, slideIndex, shapeIndex, format, scaleX, scaleY, bounds, password, storage, fontsFolder, options);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadShapeOnlineWithHttpInfo(byte[] document, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String storage, String fontsFolder, IShapeExportOptions options) throws ApiException {
        Call call = this.downloadShapeOnlineCall(document, slideIndex, shapeIndex, format, scaleX, scaleY, bounds, password, storage, fontsFolder, options, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadShapeOnlineAsync(byte[] document, Integer slideIndex, Integer shapeIndex, ShapeExportFormat format, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String storage, String fontsFolder, IShapeExportOptions options, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadShapeOnlineCall(document, slideIndex, shapeIndex, format, scaleX, scaleY, bounds, password, storage, fontsFolder, options, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadSlideCall(String name, Integer slideIndex, SlideExportFormat format, ExportOptions options, Integer width, Integer height, String password, String folder, String storage, String fontsFolder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadSlide(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadSlide(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "width", width);
        this.apiClient.addQueryParameter(queryParams, "height", height);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadSlide(String name, Integer slideIndex, SlideExportFormat format, ExportOptions options, Integer width, Integer height, String password, String folder, String storage, String fontsFolder) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadSlideWithHttpInfo(name, slideIndex, format, options, width, height, password, folder, storage, fontsFolder);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadSlideWithHttpInfo(name, slideIndex, format, options, width, height, password, folder, storage, fontsFolder);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadSlideWithHttpInfo(String name, Integer slideIndex, SlideExportFormat format, ExportOptions options, Integer width, Integer height, String password, String folder, String storage, String fontsFolder) throws ApiException {
        Call call = this.downloadSlideCall(name, slideIndex, format, options, width, height, password, folder, storage, fontsFolder, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadSlideAsync(String name, Integer slideIndex, SlideExportFormat format, ExportOptions options, Integer width, Integer height, String password, String folder, String storage, String fontsFolder, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadSlideCall(name, slideIndex, format, options, width, height, password, folder, storage, fontsFolder, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadSlideOnlineCall(byte[] document, Integer slideIndex, SlideExportFormat format, Integer width, Integer height, String password, String storage, String fontsFolder, ExportOptions options, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling downloadSlideOnline(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadSlideOnline(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadSlideOnline(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/slides/{slideIndex}/{format}".replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "width", width);
        this.apiClient.addQueryParameter(queryParams, "height", height);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"multipart/form-data"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadSlideOnline(byte[] document, Integer slideIndex, SlideExportFormat format, Integer width, Integer height, String password, String storage, String fontsFolder, ExportOptions options) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadSlideOnlineWithHttpInfo(document, slideIndex, format, width, height, password, storage, fontsFolder, options);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadSlideOnlineWithHttpInfo(document, slideIndex, format, width, height, password, storage, fontsFolder, options);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadSlideOnlineWithHttpInfo(byte[] document, Integer slideIndex, SlideExportFormat format, Integer width, Integer height, String password, String storage, String fontsFolder, ExportOptions options) throws ApiException {
        Call call = this.downloadSlideOnlineCall(document, slideIndex, format, width, height, password, storage, fontsFolder, options, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadSlideOnlineAsync(byte[] document, Integer slideIndex, SlideExportFormat format, Integer width, Integer height, String password, String storage, String fontsFolder, ExportOptions options, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadSlideOnlineCall(document, slideIndex, format, width, height, password, storage, fontsFolder, options, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call downloadSpecialSlideShapeCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling downloadSpecialSlideShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling downloadSpecialSlideShape(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling downloadSpecialSlideShape(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling downloadSpecialSlideShape(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling downloadSpecialSlideShape(Async)");
        }
        IShapeExportOptions postBody = options;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "scaleX", scaleX);
        this.apiClient.addQueryParameter(queryParams, "scaleY", scaleY);
        this.apiClient.addQueryParameter(queryParams, "bounds", (Object)bounds);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File downloadSpecialSlideShape(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadSpecialSlideShapeWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape) throws ApiException {
        Call call = this.downloadSpecialSlideShapeCall(name, slideIndex, slideType, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadSpecialSlideShapeAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, ShapeExportFormat format, IShapeExportOptions options, Double scaleX, Double scaleY, ShapeThumbnailBounds bounds, String password, String folder, String storage, String fontsFolder, String subShape, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadSpecialSlideShapeCall(name, slideIndex, slideType, shapeIndex, format, options, scaleX, scaleY, bounds, password, folder, storage, fontsFolder, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getAnimationCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getAnimation(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getAnimation(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/animation".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeIndex", shapeIndex);
        this.apiClient.addQueryParameter(queryParams, "paragraphIndex", paragraphIndex);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation getAnimation(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.getAnimationWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.getAnimationWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> getAnimationWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getAnimationCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getAnimationAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAnimationCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getApiInfoCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/info";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ApiInfo getApiInfo() throws ApiException {
        try {
            ApiResponse<ApiInfo> resp = this.getApiInfoWithHttpInfo();
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ApiInfo> resp = this.getApiInfoWithHttpInfo();
            return resp.getData();
        }
    }

    public ApiResponse<ApiInfo> getApiInfoWithHttpInfo() throws ApiException {
        Call call = this.getApiInfoCall(null, null);
        Type returnType = new TypeToken<ApiInfo>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getApiInfoAsync(final ApiCallback<ApiInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getApiInfoCall(progressListener, progressRequestListener);
        Type returnType = new TypeToken<ApiInfo>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getAvailableFontsCall(String fontsFolder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/fonts/available";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FontsData getAvailableFonts(String fontsFolder, String storage) throws ApiException {
        try {
            ApiResponse<FontsData> resp = this.getAvailableFontsWithHttpInfo(fontsFolder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FontsData> resp = this.getAvailableFontsWithHttpInfo(fontsFolder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<FontsData> getAvailableFontsWithHttpInfo(String fontsFolder, String storage) throws ApiException {
        Call call = this.getAvailableFontsCall(fontsFolder, storage, null, null);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getAvailableFontsAsync(String fontsFolder, String storage, final ApiCallback<FontsData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAvailableFontsCall(fontsFolder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getBackgroundCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getBackground(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getBackground(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/background".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideBackground getBackground(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideBackground> resp = this.getBackgroundWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideBackground> resp = this.getBackgroundWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideBackground> getBackgroundWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getBackgroundCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideBackground>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getBackgroundAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<SlideBackground> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getBackgroundCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideBackground>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getCaptionTracksCall(String name, Integer slideIndex, Integer shapeIndex, Boolean includeData, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getCaptionTracks(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getCaptionTracks(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getCaptionTracks(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/captionTracks".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "includeData", includeData);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public CaptionTracks getCaptionTracks(String name, Integer slideIndex, Integer shapeIndex, Boolean includeData, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<CaptionTracks> resp = this.getCaptionTracksWithHttpInfo(name, slideIndex, shapeIndex, includeData, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<CaptionTracks> resp = this.getCaptionTracksWithHttpInfo(name, slideIndex, shapeIndex, includeData, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<CaptionTracks> getCaptionTracksWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Boolean includeData, String password, String folder, String storage) throws ApiException {
        Call call = this.getCaptionTracksCall(name, slideIndex, shapeIndex, includeData, password, folder, storage, null, null);
        Type returnType = new TypeToken<CaptionTracks>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getCaptionTracksAsync(String name, Integer slideIndex, Integer shapeIndex, Boolean includeData, String password, String folder, String storage, final ApiCallback<CaptionTracks> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCaptionTracksCall(name, slideIndex, shapeIndex, includeData, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<CaptionTracks>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getColorSchemeCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getColorScheme(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getColorScheme(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/theme/colorScheme".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ColorScheme getColorScheme(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<ColorScheme> resp = this.getColorSchemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ColorScheme> resp = this.getColorSchemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<ColorScheme> getColorSchemeWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getColorSchemeCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<ColorScheme>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getColorSchemeAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<ColorScheme> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getColorSchemeCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ColorScheme>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getCommentAuthorsCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getCommentAuthors(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/comments/authors".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public CommentAuthors getCommentAuthors(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<CommentAuthors> resp = this.getCommentAuthorsWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<CommentAuthors> resp = this.getCommentAuthorsWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<CommentAuthors> getCommentAuthorsWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getCommentAuthorsCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<CommentAuthors>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getCommentAuthorsAsync(String name, String password, String folder, String storage, final ApiCallback<CommentAuthors> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCommentAuthorsCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<CommentAuthors>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getDiscUsageCall(String storageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/storage/disc";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public DiscUsage getDiscUsage(String storageName) throws ApiException {
        try {
            ApiResponse<DiscUsage> resp = this.getDiscUsageWithHttpInfo(storageName);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<DiscUsage> resp = this.getDiscUsageWithHttpInfo(storageName);
            return resp.getData();
        }
    }

    public ApiResponse<DiscUsage> getDiscUsageWithHttpInfo(String storageName) throws ApiException {
        Call call = this.getDiscUsageCall(storageName, null, null);
        Type returnType = new TypeToken<DiscUsage>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getDiscUsageAsync(String storageName, final ApiCallback<DiscUsage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDiscUsageCall(storageName, progressListener, progressRequestListener);
        Type returnType = new TypeToken<DiscUsage>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getDocumentPropertiesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentProperties(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/documentproperties".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public DocumentProperties getDocumentProperties(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<DocumentProperties> resp = this.getDocumentPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<DocumentProperties> resp = this.getDocumentPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<DocumentProperties> getDocumentPropertiesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getDocumentPropertiesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<DocumentProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getDocumentPropertiesAsync(String name, String password, String folder, String storage, final ApiCallback<DocumentProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDocumentPropertiesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<DocumentProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getDocumentPropertyCall(String name, String propertyName, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentProperty(Async)");
        }
        if (propertyName == null) {
            throw new ApiException("Missing the required parameter 'propertyName' when calling getDocumentProperty(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/documentproperties/{propertyName}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{propertyName\\}", this.apiClient.objectToString(propertyName));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public DocumentProperty getDocumentProperty(String name, String propertyName, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<DocumentProperty> resp = this.getDocumentPropertyWithHttpInfo(name, propertyName, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<DocumentProperty> resp = this.getDocumentPropertyWithHttpInfo(name, propertyName, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<DocumentProperty> getDocumentPropertyWithHttpInfo(String name, String propertyName, String password, String folder, String storage) throws ApiException {
        Call call = this.getDocumentPropertyCall(name, propertyName, password, folder, storage, null, null);
        Type returnType = new TypeToken<DocumentProperty>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getDocumentPropertyAsync(String name, String propertyName, String password, String folder, String storage, final ApiCallback<DocumentProperty> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDocumentPropertyCall(name, propertyName, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<DocumentProperty>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getFileVersionsCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/storage/version/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FileVersions getFileVersions(String path, String storageName) throws ApiException {
        try {
            ApiResponse<FileVersions> resp = this.getFileVersionsWithHttpInfo(path, storageName);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FileVersions> resp = this.getFileVersionsWithHttpInfo(path, storageName);
            return resp.getData();
        }
    }

    public ApiResponse<FileVersions> getFileVersionsWithHttpInfo(String path, String storageName) throws ApiException {
        Call call = this.getFileVersionsCall(path, storageName, null, null);
        Type returnType = new TypeToken<FileVersions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getFileVersionsAsync(String path, String storageName, final ApiCallback<FileVersions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFileVersionsCall(path, storageName, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FileVersions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getFilesListCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FilesList getFilesList(String path, String storageName) throws ApiException {
        try {
            ApiResponse<FilesList> resp = this.getFilesListWithHttpInfo(path, storageName);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FilesList> resp = this.getFilesListWithHttpInfo(path, storageName);
            return resp.getData();
        }
    }

    public ApiResponse<FilesList> getFilesListWithHttpInfo(String path, String storageName) throws ApiException {
        Call call = this.getFilesListCall(path, storageName, null, null);
        Type returnType = new TypeToken<FilesList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getFilesListAsync(String path, String storageName, final ApiCallback<FilesList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFilesListCall(path, storageName, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FilesList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getFontSchemeCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFontScheme(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getFontScheme(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/theme/fontScheme".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FontScheme getFontScheme(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<FontScheme> resp = this.getFontSchemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FontScheme> resp = this.getFontSchemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<FontScheme> getFontSchemeWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getFontSchemeCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<FontScheme>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getFontSchemeAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<FontScheme> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFontSchemeCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FontScheme>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getFontsCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFonts(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/fonts".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FontsData getFonts(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<FontsData> resp = this.getFontsWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FontsData> resp = this.getFontsWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<FontsData> getFontsWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getFontsCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getFontsAsync(String name, String password, String folder, String storage, final ApiCallback<FontsData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFontsCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getFontsOnlineCall(byte[] document, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling getFontsOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/fonts";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FontsData getFontsOnline(byte[] document, String password) throws ApiException {
        try {
            ApiResponse<FontsData> resp = this.getFontsOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FontsData> resp = this.getFontsOnlineWithHttpInfo(document, password);
            return resp.getData();
        }
    }

    public ApiResponse<FontsData> getFontsOnlineWithHttpInfo(byte[] document, String password) throws ApiException {
        Call call = this.getFontsOnlineCall(document, password, null, null);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getFontsOnlineAsync(byte[] document, String password, final ApiCallback<FontsData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFontsOnlineCall(document, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FontsData>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getFormatSchemeCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFormatScheme(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getFormatScheme(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/theme/formatScheme".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FormatScheme getFormatScheme(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<FormatScheme> resp = this.getFormatSchemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FormatScheme> resp = this.getFormatSchemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<FormatScheme> getFormatSchemeWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getFormatSchemeCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<FormatScheme>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getFormatSchemeAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<FormatScheme> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFormatSchemeCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FormatScheme>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getHtml5TemplatesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/html5Templates";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File getHtml5Templates() throws ApiException {
        try {
            ApiResponse<File> resp = this.getHtml5TemplatesWithHttpInfo();
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.getHtml5TemplatesWithHttpInfo();
            return resp.getData();
        }
    }

    public ApiResponse<File> getHtml5TemplatesWithHttpInfo() throws ApiException {
        Call call = this.getHtml5TemplatesCall(null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getHtml5TemplatesAsync(final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getHtml5TemplatesCall(progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getLayoutSlideCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getLayoutSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getLayoutSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/layoutSlides/{slideIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public LayoutSlide getLayoutSlide(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<LayoutSlide> resp = this.getLayoutSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<LayoutSlide> resp = this.getLayoutSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<LayoutSlide> getLayoutSlideWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getLayoutSlideCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<LayoutSlide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getLayoutSlideAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<LayoutSlide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLayoutSlideCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<LayoutSlide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getLayoutSlidesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getLayoutSlides(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/layoutSlides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public LayoutSlides getLayoutSlides(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<LayoutSlides> resp = this.getLayoutSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<LayoutSlides> resp = this.getLayoutSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<LayoutSlides> getLayoutSlidesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getLayoutSlidesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<LayoutSlides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getLayoutSlidesAsync(String name, String password, String folder, String storage, final ApiCallback<LayoutSlides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLayoutSlidesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<LayoutSlides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getMasterSlideCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getMasterSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getMasterSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/masterSlides/{slideIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public MasterSlide getMasterSlide(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<MasterSlide> resp = this.getMasterSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<MasterSlide> resp = this.getMasterSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<MasterSlide> getMasterSlideWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getMasterSlideCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<MasterSlide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getMasterSlideAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<MasterSlide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMasterSlideCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<MasterSlide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getMasterSlidesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getMasterSlides(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/masterSlides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public MasterSlides getMasterSlides(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<MasterSlides> resp = this.getMasterSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<MasterSlides> resp = this.getMasterSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<MasterSlides> getMasterSlidesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getMasterSlidesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<MasterSlides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getMasterSlidesAsync(String name, String password, String folder, String storage, final ApiCallback<MasterSlides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMasterSlidesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<MasterSlides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getNotesSlideCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNotesSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getNotesSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/notesSlide".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public NotesSlide getNotesSlide(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<NotesSlide> resp = this.getNotesSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<NotesSlide> resp = this.getNotesSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<NotesSlide> getNotesSlideWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getNotesSlideCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<NotesSlide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getNotesSlideAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<NotesSlide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNotesSlideCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<NotesSlide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getNotesSlideHeaderFooterCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNotesSlideHeaderFooter(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getNotesSlideHeaderFooter(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/notesSlide/headerFooter".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public NotesSlideHeaderFooter getNotesSlideHeaderFooter(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<NotesSlideHeaderFooter> resp = this.getNotesSlideHeaderFooterWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<NotesSlideHeaderFooter> resp = this.getNotesSlideHeaderFooterWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<NotesSlideHeaderFooter> getNotesSlideHeaderFooterWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getNotesSlideHeaderFooterCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<NotesSlideHeaderFooter>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getNotesSlideHeaderFooterAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<NotesSlideHeaderFooter> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNotesSlideHeaderFooterCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<NotesSlideHeaderFooter>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getNotesSlideOnlineCall(byte[] document, Integer slideIndex, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling getNotesSlideOnline(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getNotesSlideOnline(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/slides/{slideIndex}/notesSlide".replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public NotesSlide getNotesSlideOnline(byte[] document, Integer slideIndex, String password) throws ApiException {
        try {
            ApiResponse<NotesSlide> resp = this.getNotesSlideOnlineWithHttpInfo(document, slideIndex, password);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<NotesSlide> resp = this.getNotesSlideOnlineWithHttpInfo(document, slideIndex, password);
            return resp.getData();
        }
    }

    public ApiResponse<NotesSlide> getNotesSlideOnlineWithHttpInfo(byte[] document, Integer slideIndex, String password) throws ApiException {
        Call call = this.getNotesSlideOnlineCall(document, slideIndex, password, null, null);
        Type returnType = new TypeToken<NotesSlide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getNotesSlideOnlineAsync(byte[] document, Integer slideIndex, String password, final ApiCallback<NotesSlide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNotesSlideOnlineCall(document, slideIndex, password, progressListener, progressRequestListener);
        Type returnType = new TypeToken<NotesSlide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getParagraphCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getParagraph(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getParagraph(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraph getParagraph(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraph> resp = this.getParagraphWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraph> resp = this.getParagraphWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraph> getParagraphWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getParagraphCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getParagraphAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ApiCallback<Paragraph> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getParagraphCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getParagraphEffectiveCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getParagraphEffective(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getParagraphEffective(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getParagraphEffective(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getParagraphEffective(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/effective".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraph getParagraphEffective(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraph> resp = this.getParagraphEffectiveWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraph> resp = this.getParagraphEffectiveWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraph> getParagraphEffectiveWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getParagraphEffectiveCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getParagraphEffectiveAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ApiCallback<Paragraph> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getParagraphEffectiveCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getParagraphRectangleCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getParagraphRectangle(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getParagraphRectangle(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getParagraphRectangle(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getParagraphRectangle(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/bounds".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public TextBounds getParagraphRectangle(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<TextBounds> resp = this.getParagraphRectangleWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<TextBounds> resp = this.getParagraphRectangleWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<TextBounds> getParagraphRectangleWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getParagraphRectangleCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<TextBounds>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getParagraphRectangleAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, final ApiCallback<TextBounds> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getParagraphRectangleCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<TextBounds>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getParagraphsCall(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getParagraphs(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getParagraphs(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getParagraphs(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs getParagraphs(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.getParagraphsWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.getParagraphsWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> getParagraphsWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getParagraphsCall(name, slideIndex, shapeIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getParagraphsAsync(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getParagraphsCall(name, slideIndex, shapeIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPlaceholderCall(String name, Integer slideIndex, Integer placeholderIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPlaceholder(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getPlaceholder(Async)");
        }
        if (placeholderIndex == null) {
            throw new ApiException("Missing the required parameter 'placeholderIndex' when calling getPlaceholder(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/placeholders/{placeholderIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{placeholderIndex\\}", this.apiClient.objectToString(placeholderIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Placeholder getPlaceholder(String name, Integer slideIndex, Integer placeholderIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Placeholder> resp = this.getPlaceholderWithHttpInfo(name, slideIndex, placeholderIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Placeholder> resp = this.getPlaceholderWithHttpInfo(name, slideIndex, placeholderIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Placeholder> getPlaceholderWithHttpInfo(String name, Integer slideIndex, Integer placeholderIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getPlaceholderCall(name, slideIndex, placeholderIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Placeholder>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPlaceholderAsync(String name, Integer slideIndex, Integer placeholderIndex, String password, String folder, String storage, final ApiCallback<Placeholder> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPlaceholderCall(name, slideIndex, placeholderIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Placeholder>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPlaceholdersCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPlaceholders(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getPlaceholders(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/placeholders".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Placeholders getPlaceholders(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Placeholders> resp = this.getPlaceholdersWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Placeholders> resp = this.getPlaceholdersWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Placeholders> getPlaceholdersWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getPlaceholdersCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Placeholders>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPlaceholdersAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<Placeholders> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPlaceholdersCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Placeholders>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPortionCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getPortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getPortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getPortion(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling getPortion(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portion getPortion(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portion> resp = this.getPortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portion> resp = this.getPortionWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portion> getPortionWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getPortionCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portion>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPortionAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ApiCallback<Portion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPortionCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portion>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPortionEffectiveCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPortionEffective(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getPortionEffective(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getPortionEffective(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getPortionEffective(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling getPortionEffective(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}/effective".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portion getPortionEffective(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portion> resp = this.getPortionEffectiveWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portion> resp = this.getPortionEffectiveWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portion> getPortionEffectiveWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getPortionEffectiveCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portion>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPortionEffectiveAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ApiCallback<Portion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPortionEffectiveCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portion>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPortionRectangleCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPortionRectangle(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getPortionRectangle(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getPortionRectangle(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getPortionRectangle(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling getPortionRectangle(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}/bounds".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public TextBounds getPortionRectangle(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<TextBounds> resp = this.getPortionRectangleWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<TextBounds> resp = this.getPortionRectangleWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<TextBounds> getPortionRectangleWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getPortionRectangleCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<TextBounds>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPortionRectangleAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, final ApiCallback<TextBounds> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPortionRectangleCall(name, slideIndex, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<TextBounds>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPortionsCall(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPortions(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getPortions(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getPortions(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getPortions(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions getPortions(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.getPortionsWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.getPortionsWithHttpInfo(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> getPortionsWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getPortionsCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPortionsAsync(String name, Integer slideIndex, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPortionsCall(name, slideIndex, shapeIndex, paragraphIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPresentationCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPresentation(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Document getPresentation(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Document> resp = this.getPresentationWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Document> resp = this.getPresentationWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Document> getPresentationWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getPresentationCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPresentationAsync(String name, String password, String folder, String storage, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPresentationCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPresentationImagesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPresentationImages(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/images".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Images getPresentationImages(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Images> resp = this.getPresentationImagesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Images> resp = this.getPresentationImagesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Images> getPresentationImagesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getPresentationImagesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<Images>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPresentationImagesAsync(String name, String password, String folder, String storage, final ApiCallback<Images> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPresentationImagesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Images>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getPresentationTextItemsCall(String name, Boolean withEmpty, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPresentationTextItems(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/textItems".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "withEmpty", withEmpty);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public TextItems getPresentationTextItems(String name, Boolean withEmpty, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<TextItems> resp = this.getPresentationTextItemsWithHttpInfo(name, withEmpty, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<TextItems> resp = this.getPresentationTextItemsWithHttpInfo(name, withEmpty, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<TextItems> getPresentationTextItemsWithHttpInfo(String name, Boolean withEmpty, String password, String folder, String storage) throws ApiException {
        Call call = this.getPresentationTextItemsCall(name, withEmpty, password, folder, storage, null, null);
        Type returnType = new TypeToken<TextItems>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPresentationTextItemsAsync(String name, Boolean withEmpty, String password, String folder, String storage, final ApiCallback<TextItems> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPresentationTextItemsCall(name, withEmpty, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<TextItems>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getProtectionPropertiesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getProtectionProperties(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/protection".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ProtectionProperties getProtectionProperties(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<ProtectionProperties> resp = this.getProtectionPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ProtectionProperties> resp = this.getProtectionPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<ProtectionProperties> getProtectionPropertiesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getProtectionPropertiesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<ProtectionProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getProtectionPropertiesAsync(String name, String password, String folder, String storage, final ApiCallback<ProtectionProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getProtectionPropertiesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ProtectionProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSectionsCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSections(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/sections".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Sections getSections(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Sections> resp = this.getSectionsWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Sections> resp = this.getSectionsWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Sections> getSectionsWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getSectionsCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<Sections>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSectionsAsync(String name, String password, String folder, String storage, final ApiCallback<Sections> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSectionsCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Sections>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getShapeCall(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getShape(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getShape(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ShapeBase getShape(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<ShapeBase> resp = this.getShapeWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ShapeBase> resp = this.getShapeWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<ShapeBase> getShapeWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getShapeCall(name, slideIndex, shapeIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getShapeAsync(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, String subShape, final ApiCallback<ShapeBase> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getShapeCall(name, slideIndex, shapeIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getShapeGeometryPathCall(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getShapeGeometryPath(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getShapeGeometryPath(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getShapeGeometryPath(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/geometryPath".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public GeometryPaths getShapeGeometryPath(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<GeometryPaths> resp = this.getShapeGeometryPathWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<GeometryPaths> resp = this.getShapeGeometryPathWithHttpInfo(name, slideIndex, shapeIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<GeometryPaths> getShapeGeometryPathWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getShapeGeometryPathCall(name, slideIndex, shapeIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<GeometryPaths>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getShapeGeometryPathAsync(String name, Integer slideIndex, Integer shapeIndex, String password, String folder, String storage, final ApiCallback<GeometryPaths> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getShapeGeometryPathCall(name, slideIndex, shapeIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<GeometryPaths>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getShapesCall(String name, Integer slideIndex, String password, String folder, String storage, ShapeType shapeType, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getShapes(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getShapes(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "shapeType", (Object)shapeType);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes getShapes(String name, Integer slideIndex, String password, String folder, String storage, ShapeType shapeType, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.getShapesWithHttpInfo(name, slideIndex, password, folder, storage, shapeType, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.getShapesWithHttpInfo(name, slideIndex, password, folder, storage, shapeType, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> getShapesWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage, ShapeType shapeType, String subShape) throws ApiException {
        Call call = this.getShapesCall(name, slideIndex, password, folder, storage, shapeType, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getShapesAsync(String name, Integer slideIndex, String password, String folder, String storage, ShapeType shapeType, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getShapesCall(name, slideIndex, password, folder, storage, shapeType, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlideCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlide(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSlide(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Slide getSlide(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Slide> resp = this.getSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Slide> resp = this.getSlideWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Slide> getSlideWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlideCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Slide>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlideAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<Slide> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlideCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Slide>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlideCommentsCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlideComments(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSlideComments(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/comments".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideComments getSlideComments(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideComments> resp = this.getSlideCommentsWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideComments> resp = this.getSlideCommentsWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideComments> getSlideCommentsWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlideCommentsCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideComments>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlideCommentsAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<SlideComments> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlideCommentsCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideComments>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlideHeaderFooterCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlideHeaderFooter(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSlideHeaderFooter(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/headerFooter".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public HeaderFooter getSlideHeaderFooter(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<HeaderFooter> resp = this.getSlideHeaderFooterWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<HeaderFooter> resp = this.getSlideHeaderFooterWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<HeaderFooter> getSlideHeaderFooterWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlideHeaderFooterCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<HeaderFooter>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlideHeaderFooterAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<HeaderFooter> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlideHeaderFooterCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<HeaderFooter>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlideImagesCall(String name, Integer slideIndex, Integer shapeIndex, String shapeAltText, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlideImages(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSlideImages(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/images".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeIndex", shapeIndex);
        this.apiClient.addQueryParameter(queryParams, "shapeAltText", shapeAltText);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Images getSlideImages(String name, Integer slideIndex, Integer shapeIndex, String shapeAltText, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Images> resp = this.getSlideImagesWithHttpInfo(name, slideIndex, shapeIndex, shapeAltText, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Images> resp = this.getSlideImagesWithHttpInfo(name, slideIndex, shapeIndex, shapeAltText, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Images> getSlideImagesWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String shapeAltText, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlideImagesCall(name, slideIndex, shapeIndex, shapeAltText, password, folder, storage, null, null);
        Type returnType = new TypeToken<Images>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlideImagesAsync(String name, Integer slideIndex, Integer shapeIndex, String shapeAltText, String password, String folder, String storage, final ApiCallback<Images> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlideImagesCall(name, slideIndex, shapeIndex, shapeAltText, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Images>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlidePropertiesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlideProperties(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slideProperties".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideProperties getSlideProperties(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideProperties> resp = this.getSlidePropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideProperties> resp = this.getSlidePropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideProperties> getSlidePropertiesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlidePropertiesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlidePropertiesAsync(String name, String password, String folder, String storage, final ApiCallback<SlideProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlidePropertiesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlideShowPropertiesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlideShowProperties(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slideShowProperties".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideShowProperties getSlideShowProperties(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideShowProperties> resp = this.getSlideShowPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideShowProperties> resp = this.getSlideShowPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideShowProperties> getSlideShowPropertiesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlideShowPropertiesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideShowProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlideShowPropertiesAsync(String name, String password, String folder, String storage, final ApiCallback<SlideShowProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlideShowPropertiesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideShowProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlideTextItemsCall(String name, Integer slideIndex, Boolean withEmpty, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlideTextItems(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSlideTextItems(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/textItems".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "withEmpty", withEmpty);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public TextItems getSlideTextItems(String name, Integer slideIndex, Boolean withEmpty, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<TextItems> resp = this.getSlideTextItemsWithHttpInfo(name, slideIndex, withEmpty, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<TextItems> resp = this.getSlideTextItemsWithHttpInfo(name, slideIndex, withEmpty, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<TextItems> getSlideTextItemsWithHttpInfo(String name, Integer slideIndex, Boolean withEmpty, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlideTextItemsCall(name, slideIndex, withEmpty, password, folder, storage, null, null);
        Type returnType = new TypeToken<TextItems>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlideTextItemsAsync(String name, Integer slideIndex, Boolean withEmpty, String password, String folder, String storage, final ApiCallback<TextItems> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlideTextItemsCall(name, slideIndex, withEmpty, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<TextItems>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSlidesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSlides(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Slides getSlides(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Slides> resp = this.getSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Slides> resp = this.getSlidesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Slides> getSlidesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getSlidesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<Slides>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSlidesAsync(String name, String password, String folder, String storage, final ApiCallback<Slides> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSlidesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Slides>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSpecialSlideAnimationCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSpecialSlideAnimation(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSpecialSlideAnimation(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling getSpecialSlideAnimation(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/animation".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "shapeIndex", shapeIndex);
        this.apiClient.addQueryParameter(queryParams, "paragraphIndex", paragraphIndex);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public SlideAnimation getSpecialSlideAnimation(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<SlideAnimation> resp = this.getSpecialSlideAnimationWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<SlideAnimation> resp = this.getSpecialSlideAnimationWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<SlideAnimation> getSpecialSlideAnimationWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getSpecialSlideAnimationCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSpecialSlideAnimationAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, final ApiCallback<SlideAnimation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSpecialSlideAnimationCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<SlideAnimation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSpecialSlideParagraphCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSpecialSlideParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSpecialSlideParagraph(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling getSpecialSlideParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getSpecialSlideParagraph(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getSpecialSlideParagraph(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraph getSpecialSlideParagraph(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraph> resp = this.getSpecialSlideParagraphWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraph> resp = this.getSpecialSlideParagraphWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraph> getSpecialSlideParagraphWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getSpecialSlideParagraphCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSpecialSlideParagraphAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ApiCallback<Paragraph> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSpecialSlideParagraphCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSpecialSlideParagraphsCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSpecialSlideParagraphs(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSpecialSlideParagraphs(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling getSpecialSlideParagraphs(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getSpecialSlideParagraphs(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs getSpecialSlideParagraphs(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.getSpecialSlideParagraphsWithHttpInfo(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.getSpecialSlideParagraphsWithHttpInfo(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> getSpecialSlideParagraphsWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getSpecialSlideParagraphsCall(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSpecialSlideParagraphsAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSpecialSlideParagraphsCall(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSpecialSlidePortionCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSpecialSlidePortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSpecialSlidePortion(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling getSpecialSlidePortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getSpecialSlidePortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getSpecialSlidePortion(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling getSpecialSlidePortion(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portion getSpecialSlidePortion(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portion> resp = this.getSpecialSlidePortionWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portion> resp = this.getSpecialSlidePortionWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portion> getSpecialSlidePortionWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getSpecialSlidePortionCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portion>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSpecialSlidePortionAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, String subShape, final ApiCallback<Portion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSpecialSlidePortionCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, portionIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portion>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSpecialSlidePortionsCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSpecialSlidePortions(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSpecialSlidePortions(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling getSpecialSlidePortions(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getSpecialSlidePortions(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getSpecialSlidePortions(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions getSpecialSlidePortions(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.getSpecialSlidePortionsWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.getSpecialSlidePortionsWithHttpInfo(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> getSpecialSlidePortionsWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getSpecialSlidePortionsCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSpecialSlidePortionsAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, Integer paragraphIndex, String password, String folder, String storage, String subShape, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSpecialSlidePortionsCall(name, slideIndex, slideType, shapeIndex, paragraphIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSpecialSlideShapeCall(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSpecialSlideShape(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSpecialSlideShape(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling getSpecialSlideShape(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getSpecialSlideShape(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ShapeBase getSpecialSlideShape(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<ShapeBase> resp = this.getSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ShapeBase> resp = this.getSpecialSlideShapeWithHttpInfo(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<ShapeBase> getSpecialSlideShapeWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getSpecialSlideShapeCall(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSpecialSlideShapeAsync(String name, Integer slideIndex, SpecialSlideType slideType, Integer shapeIndex, String password, String folder, String storage, String subShape, final ApiCallback<ShapeBase> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSpecialSlideShapeCall(name, slideIndex, slideType, shapeIndex, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ShapeBase>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getSpecialSlideShapesCall(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, String subShape, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getSpecialSlideShapes(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getSpecialSlideShapes(Async)");
        }
        if (slideType == null) {
            throw new ApiException("Missing the required parameter 'slideType' when calling getSpecialSlideShapes(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/{slideType}/shapes".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{slideType\\}", this.apiClient.objectToString((Object)slideType));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "subShape", subShape);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes getSpecialSlideShapes(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, String subShape) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.getSpecialSlideShapesWithHttpInfo(name, slideIndex, slideType, password, folder, storage, subShape);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.getSpecialSlideShapesWithHttpInfo(name, slideIndex, slideType, password, folder, storage, subShape);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> getSpecialSlideShapesWithHttpInfo(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, String subShape) throws ApiException {
        Call call = this.getSpecialSlideShapesCall(name, slideIndex, slideType, password, folder, storage, subShape, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getSpecialSlideShapesAsync(String name, Integer slideIndex, SpecialSlideType slideType, String password, String folder, String storage, String subShape, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSpecialSlideShapesCall(name, slideIndex, slideType, password, folder, storage, subShape, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getTableCellParagraphCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getTableCellParagraph(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getTableCellParagraph(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getTableCellParagraph(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling getTableCellParagraph(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling getTableCellParagraph(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getTableCellParagraph(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraph getTableCellParagraph(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Paragraph> resp = this.getTableCellParagraphWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraph> resp = this.getTableCellParagraphWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraph> getTableCellParagraphWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getTableCellParagraphCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getTableCellParagraphAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage, final ApiCallback<Paragraph> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTableCellParagraphCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraph>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getTableCellParagraphsCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getTableCellParagraphs(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getTableCellParagraphs(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getTableCellParagraphs(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling getTableCellParagraphs(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling getTableCellParagraphs(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Paragraphs getTableCellParagraphs(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Paragraphs> resp = this.getTableCellParagraphsWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Paragraphs> resp = this.getTableCellParagraphsWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Paragraphs> getTableCellParagraphsWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getTableCellParagraphsCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getTableCellParagraphsAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, String password, String folder, String storage, final ApiCallback<Paragraphs> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTableCellParagraphsCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Paragraphs>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getTableCellPortionCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getTableCellPortion(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getTableCellPortion(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getTableCellPortion(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling getTableCellPortion(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling getTableCellPortion(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getTableCellPortion(Async)");
        }
        if (portionIndex == null) {
            throw new ApiException("Missing the required parameter 'portionIndex' when calling getTableCellPortion(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex)).replaceAll("\\{portionIndex\\}", this.apiClient.objectToString(portionIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portion getTableCellPortion(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Portion> resp = this.getTableCellPortionWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portion> resp = this.getTableCellPortionWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Portion> getTableCellPortionWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getTableCellPortionCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Portion>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getTableCellPortionAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, Integer portionIndex, String password, String folder, String storage, final ApiCallback<Portion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTableCellPortionCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, portionIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portion>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getTableCellPortionsCall(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getTableCellPortions(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getTableCellPortions(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling getTableCellPortions(Async)");
        }
        if (rowIndex == null) {
            throw new ApiException("Missing the required parameter 'rowIndex' when calling getTableCellPortions(Async)");
        }
        if (cellIndex == null) {
            throw new ApiException("Missing the required parameter 'cellIndex' when calling getTableCellPortions(Async)");
        }
        if (paragraphIndex == null) {
            throw new ApiException("Missing the required parameter 'paragraphIndex' when calling getTableCellPortions(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex)).replaceAll("\\{rowIndex\\}", this.apiClient.objectToString(rowIndex)).replaceAll("\\{cellIndex\\}", this.apiClient.objectToString(cellIndex)).replaceAll("\\{paragraphIndex\\}", this.apiClient.objectToString(paragraphIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Portions getTableCellPortions(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Portions> resp = this.getTableCellPortionsWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Portions> resp = this.getTableCellPortionsWithHttpInfo(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Portions> getTableCellPortionsWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getTableCellPortionsCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Portions>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getTableCellPortionsAsync(String name, Integer slideIndex, Integer shapeIndex, Integer rowIndex, Integer cellIndex, Integer paragraphIndex, String password, String folder, String storage, final ApiCallback<Portions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTableCellPortionsCall(name, slideIndex, shapeIndex, rowIndex, cellIndex, paragraphIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Portions>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getThemeCall(String name, Integer slideIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getTheme(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling getTheme(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/theme".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Theme getTheme(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Theme> resp = this.getThemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Theme> resp = this.getThemeWithHttpInfo(name, slideIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Theme> getThemeWithHttpInfo(String name, Integer slideIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getThemeCall(name, slideIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<Theme>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getThemeAsync(String name, Integer slideIndex, String password, String folder, String storage, final ApiCallback<Theme> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getThemeCall(name, slideIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Theme>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getVbaModuleCall(String name, Integer moduleIndex, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getVbaModule(Async)");
        }
        if (moduleIndex == null) {
            throw new ApiException("Missing the required parameter 'moduleIndex' when calling getVbaModule(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/vbaProject/modules/{moduleIndex}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{moduleIndex\\}", this.apiClient.objectToString(moduleIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public VbaModule getVbaModule(String name, Integer moduleIndex, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<VbaModule> resp = this.getVbaModuleWithHttpInfo(name, moduleIndex, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<VbaModule> resp = this.getVbaModuleWithHttpInfo(name, moduleIndex, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<VbaModule> getVbaModuleWithHttpInfo(String name, Integer moduleIndex, String password, String folder, String storage) throws ApiException {
        Call call = this.getVbaModuleCall(name, moduleIndex, password, folder, storage, null, null);
        Type returnType = new TypeToken<VbaModule>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getVbaModuleAsync(String name, Integer moduleIndex, String password, String folder, String storage, final ApiCallback<VbaModule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getVbaModuleCall(name, moduleIndex, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<VbaModule>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getVbaProjectCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getVbaProject(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/vbaProject".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public VbaProject getVbaProject(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<VbaProject> resp = this.getVbaProjectWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<VbaProject> resp = this.getVbaProjectWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<VbaProject> getVbaProjectWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getVbaProjectCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<VbaProject>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getVbaProjectAsync(String name, String password, String folder, String storage, final ApiCallback<VbaProject> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getVbaProjectCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<VbaProject>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getViewPropertiesCall(String name, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getViewProperties(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/viewProperties".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public ViewProperties getViewProperties(String name, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<ViewProperties> resp = this.getViewPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<ViewProperties> resp = this.getViewPropertiesWithHttpInfo(name, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<ViewProperties> getViewPropertiesWithHttpInfo(String name, String password, String folder, String storage) throws ApiException {
        Call call = this.getViewPropertiesCall(name, password, folder, storage, null, null);
        Type returnType = new TypeToken<ViewProperties>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getViewPropertiesAsync(String name, String password, String folder, String storage, final ApiCallback<ViewProperties> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getViewPropertiesCall(name, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<ViewProperties>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call highlightPresentationRegexCall(String name, String regex, String color, Boolean ignoreCase, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling highlightPresentationRegex(Async)");
        }
        if (regex == null) {
            throw new ApiException("Missing the required parameter 'regex' when calling highlightPresentationRegex(Async)");
        }
        if (color == null) {
            throw new ApiException("Missing the required parameter 'color' when calling highlightPresentationRegex(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/highlightRegex".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "regex", regex);
        this.apiClient.addQueryParameter(queryParams, "color", color);
        this.apiClient.addQueryParameter(queryParams, "ignoreCase", ignoreCase);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public DocumentReplaceResult highlightPresentationRegex(String name, String regex, String color, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<DocumentReplaceResult> resp = this.highlightPresentationRegexWithHttpInfo(name, regex, color, ignoreCase, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<DocumentReplaceResult> resp = this.highlightPresentationRegexWithHttpInfo(name, regex, color, ignoreCase, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<DocumentReplaceResult> highlightPresentationRegexWithHttpInfo(String name, String regex, String color, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        Call call = this.highlightPresentationRegexCall(name, regex, color, ignoreCase, password, folder, storage, null, null);
        Type returnType = new TypeToken<DocumentReplaceResult>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call highlightPresentationRegexAsync(String name, String regex, String color, Boolean ignoreCase, String password, String folder, String storage, final ApiCallback<DocumentReplaceResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.highlightPresentationRegexCall(name, regex, color, ignoreCase, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<DocumentReplaceResult>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call highlightPresentationTextCall(String name, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling highlightPresentationText(Async)");
        }
        if (text == null) {
            throw new ApiException("Missing the required parameter 'text' when calling highlightPresentationText(Async)");
        }
        if (color == null) {
            throw new ApiException("Missing the required parameter 'color' when calling highlightPresentationText(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/highlightText".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "text", text);
        this.apiClient.addQueryParameter(queryParams, "color", color);
        this.apiClient.addQueryParameter(queryParams, "wholeWordsOnly", wholeWordsOnly);
        this.apiClient.addQueryParameter(queryParams, "ignoreCase", ignoreCase);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public DocumentReplaceResult highlightPresentationText(String name, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<DocumentReplaceResult> resp = this.highlightPresentationTextWithHttpInfo(name, text, color, wholeWordsOnly, ignoreCase, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<DocumentReplaceResult> resp = this.highlightPresentationTextWithHttpInfo(name, text, color, wholeWordsOnly, ignoreCase, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<DocumentReplaceResult> highlightPresentationTextWithHttpInfo(String name, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        Call call = this.highlightPresentationTextCall(name, text, color, wholeWordsOnly, ignoreCase, password, folder, storage, null, null);
        Type returnType = new TypeToken<DocumentReplaceResult>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call highlightPresentationTextAsync(String name, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage, final ApiCallback<DocumentReplaceResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.highlightPresentationTextCall(name, text, color, wholeWordsOnly, ignoreCase, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<DocumentReplaceResult>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call highlightShapeRegexCall(String name, Integer slideIndex, Integer shapeIndex, String regex, String color, Boolean ignoreCase, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling highlightShapeRegex(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling highlightShapeRegex(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling highlightShapeRegex(Async)");
        }
        if (regex == null) {
            throw new ApiException("Missing the required parameter 'regex' when calling highlightShapeRegex(Async)");
        }
        if (color == null) {
            throw new ApiException("Missing the required parameter 'color' when calling highlightShapeRegex(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/highlightRegex".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "regex", regex);
        this.apiClient.addQueryParameter(queryParams, "color", color);
        this.apiClient.addQueryParameter(queryParams, "ignoreCase", ignoreCase);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shape highlightShapeRegex(String name, Integer slideIndex, Integer shapeIndex, String regex, String color, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Shape> resp = this.highlightShapeRegexWithHttpInfo(name, slideIndex, shapeIndex, regex, color, ignoreCase, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shape> resp = this.highlightShapeRegexWithHttpInfo(name, slideIndex, shapeIndex, regex, color, ignoreCase, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Shape> highlightShapeRegexWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String regex, String color, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        Call call = this.highlightShapeRegexCall(name, slideIndex, shapeIndex, regex, color, ignoreCase, password, folder, storage, null, null);
        Type returnType = new TypeToken<Shape>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call highlightShapeRegexAsync(String name, Integer slideIndex, Integer shapeIndex, String regex, String color, Boolean ignoreCase, String password, String folder, String storage, final ApiCallback<Shape> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.highlightShapeRegexCall(name, slideIndex, shapeIndex, regex, color, ignoreCase, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shape>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call highlightShapeTextCall(String name, Integer slideIndex, Integer shapeIndex, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling highlightShapeText(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling highlightShapeText(Async)");
        }
        if (shapeIndex == null) {
            throw new ApiException("Missing the required parameter 'shapeIndex' when calling highlightShapeText(Async)");
        }
        if (text == null) {
            throw new ApiException("Missing the required parameter 'text' when calling highlightShapeText(Async)");
        }
        if (color == null) {
            throw new ApiException("Missing the required parameter 'color' when calling highlightShapeText(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/highlightText".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex)).replaceAll("\\{shapeIndex\\}", this.apiClient.objectToString(shapeIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "text", text);
        this.apiClient.addQueryParameter(queryParams, "color", color);
        this.apiClient.addQueryParameter(queryParams, "wholeWordsOnly", wholeWordsOnly);
        this.apiClient.addQueryParameter(queryParams, "ignoreCase", ignoreCase);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shape highlightShapeText(String name, Integer slideIndex, Integer shapeIndex, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Shape> resp = this.highlightShapeTextWithHttpInfo(name, slideIndex, shapeIndex, text, color, wholeWordsOnly, ignoreCase, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shape> resp = this.highlightShapeTextWithHttpInfo(name, slideIndex, shapeIndex, text, color, wholeWordsOnly, ignoreCase, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Shape> highlightShapeTextWithHttpInfo(String name, Integer slideIndex, Integer shapeIndex, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage) throws ApiException {
        Call call = this.highlightShapeTextCall(name, slideIndex, shapeIndex, text, color, wholeWordsOnly, ignoreCase, password, folder, storage, null, null);
        Type returnType = new TypeToken<Shape>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call highlightShapeTextAsync(String name, Integer slideIndex, Integer shapeIndex, String text, String color, Boolean wholeWordsOnly, Boolean ignoreCase, String password, String folder, String storage, final ApiCallback<Shape> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.highlightShapeTextCall(name, slideIndex, shapeIndex, text, color, wholeWordsOnly, ignoreCase, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shape>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call importFromHtmlCall(String name, String html, String password, String folder, String storage, Integer position, Boolean useSlideWithIndexAsStart, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling importFromHtml(Async)");
        }
        String postBody = html;
        String methodPath = "/slides/{name}/fromHtml".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "position", position);
        this.apiClient.addQueryParameter(queryParams, "useSlideWithIndexAsStart", useSlideWithIndexAsStart);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Document importFromHtml(String name, String html, String password, String folder, String storage, Integer position, Boolean useSlideWithIndexAsStart) throws ApiException {
        try {
            ApiResponse<Document> resp = this.importFromHtmlWithHttpInfo(name, html, password, folder, storage, position, useSlideWithIndexAsStart);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Document> resp = this.importFromHtmlWithHttpInfo(name, html, password, folder, storage, position, useSlideWithIndexAsStart);
            return resp.getData();
        }
    }

    public ApiResponse<Document> importFromHtmlWithHttpInfo(String name, String html, String password, String folder, String storage, Integer position, Boolean useSlideWithIndexAsStart) throws ApiException {
        Call call = this.importFromHtmlCall(name, html, password, folder, storage, position, useSlideWithIndexAsStart, null, null);
        Type returnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call importFromHtmlAsync(String name, String html, String password, String folder, String storage, Integer position, Boolean useSlideWithIndexAsStart, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importFromHtmlCall(name, html, password, folder, storage, position, useSlideWithIndexAsStart, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call importFromPdfCall(String name, byte[] pdf, PdfImportOptions options, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling importFromPdf(Async)");
        }
        if (pdf == null) {
            throw new ApiException("Missing the required parameter 'pdf' when calling importFromPdf(Async)");
        }
        PdfImportOptions postBody = options;
        String methodPath = "/slides/{name}/fromPdf".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (pdf != null) {
            formParams.put("pdf", pdf);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Document importFromPdf(String name, byte[] pdf, PdfImportOptions options, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Document> resp = this.importFromPdfWithHttpInfo(name, pdf, options, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Document> resp = this.importFromPdfWithHttpInfo(name, pdf, options, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Document> importFromPdfWithHttpInfo(String name, byte[] pdf, PdfImportOptions options, String password, String folder, String storage) throws ApiException {
        Call call = this.importFromPdfCall(name, pdf, options, password, folder, storage, null, null);
        Type returnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call importFromPdfAsync(String name, byte[] pdf, PdfImportOptions options, String password, String folder, String storage, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importFromPdfCall(name, pdf, options, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call importShapesFromSvgCall(String name, Integer slideIndex, byte[] image, Integer x, Integer y, Integer width, Integer height, List<Integer> shapes, Boolean group, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling importShapesFromSvg(Async)");
        }
        if (slideIndex == null) {
            throw new ApiException("Missing the required parameter 'slideIndex' when calling importShapesFromSvg(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/{name}/slides/{slideIndex}/shapes/fromSvg".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{slideIndex\\}", this.apiClient.objectToString(slideIndex));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "x", x);
        this.apiClient.addQueryParameter(queryParams, "y", y);
        this.apiClient.addQueryParameter(queryParams, "width", width);
        this.apiClient.addQueryParameter(queryParams, "height", height);
        this.apiClient.addQueryParameter(queryParams, "shapes", shapes);
        this.apiClient.addQueryParameter(queryParams, "group", group);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (image != null) {
            formParams.put("image", image);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Shapes importShapesFromSvg(String name, Integer slideIndex, byte[] image, Integer x, Integer y, Integer width, Integer height, List<Integer> shapes, Boolean group, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Shapes> resp = this.importShapesFromSvgWithHttpInfo(name, slideIndex, image, x, y, width, height, shapes, group, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Shapes> resp = this.importShapesFromSvgWithHttpInfo(name, slideIndex, image, x, y, width, height, shapes, group, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Shapes> importShapesFromSvgWithHttpInfo(String name, Integer slideIndex, byte[] image, Integer x, Integer y, Integer width, Integer height, List<Integer> shapes, Boolean group, String password, String folder, String storage) throws ApiException {
        Call call = this.importShapesFromSvgCall(name, slideIndex, image, x, y, width, height, shapes, group, password, folder, storage, null, null);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call importShapesFromSvgAsync(String name, Integer slideIndex, byte[] image, Integer x, Integer y, Integer width, Integer height, List<Integer> shapes, Boolean group, String password, String folder, String storage, final ApiCallback<Shapes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importShapesFromSvgCall(name, slideIndex, image, x, y, width, height, shapes, group, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Shapes>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call mergeCall(String name, PresentationsMergeRequest request, String password, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling merge(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling merge(Async)");
        }
        PresentationsMergeRequest postBody = request;
        String methodPath = "/slides/{name}/merge".replaceAll("\\{name\\}", this.apiClient.objectToString(name));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Document merge(String name, PresentationsMergeRequest request, String password, String folder, String storage) throws ApiException {
        try {
            ApiResponse<Document> resp = this.mergeWithHttpInfo(name, request, password, folder, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Document> resp = this.mergeWithHttpInfo(name, request, password, folder, storage);
            return resp.getData();
        }
    }

    public ApiResponse<Document> mergeWithHttpInfo(String name, PresentationsMergeRequest request, String password, String folder, String storage) throws ApiException {
        Call call = this.mergeCall(name, request, password, folder, storage, null, null);
        Type returnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call mergeAsync(String name, PresentationsMergeRequest request, String password, String folder, String storage, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.mergeCall(name, request, password, folder, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call mergeAndSaveOnlineCall(String outPath, List<FileInfo> files, OrderedMergeRequest request, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (outPath == null) {
            throw new ApiException("Missing the required parameter 'outPath' when calling mergeAndSaveOnline(Async)");
        }
        OrderedMergeRequest postBody = request;
        String methodPath = "/slides/merge";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "outPath", outPath);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (files != null) {
            formParams.put("files", files);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
       