/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies the accent function, consisting of a base and a combining diacritical mark")
public class AccentElement
extends MathElement {
    @SerializedName(value="base", alternate={"Base"})
    private MathElement base;
    @SerializedName(value="character", alternate={"Character"})
    private String character;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public AccentElement() {
        this.setType(MathElement.TypeEnum.ACCENT);
    }

    public AccentElement base(MathElement base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="The argument to which the accent was applied")
    public MathElement getBase() {
        return this.base;
    }

    public void setBase(MathElement base) {
        this.base = base;
    }

    public AccentElement character(String character) {
        this.character = character;
        return this;
    }

    @ApiModelProperty(value="Accent Character")
    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccentElement accentElement = (AccentElement)o;
        return Objects.equals(this.base, accentElement.base) && Objects.equals(this.character, accentElement.character) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.character, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccentElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    character: ").append(this.toIndentedString(this.character)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.ACCENT);
    }
}

