/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="A set of properties specifying which access permissions should be granted when the document is opened with user access.")
public class AccessPermissions {
    @SerializedName(value="printDocument", alternate={"PrintDocument"})
    private Boolean printDocument;
    @SerializedName(value="modifyContent", alternate={"ModifyContent"})
    private Boolean modifyContent;
    @SerializedName(value="copyTextAndGraphics", alternate={"CopyTextAndGraphics"})
    private Boolean copyTextAndGraphics;
    @SerializedName(value="addOrModifyFields", alternate={"AddOrModifyFields"})
    private Boolean addOrModifyFields;
    @SerializedName(value="fillExistingFields", alternate={"FillExistingFields"})
    private Boolean fillExistingFields;
    @SerializedName(value="extractTextAndGraphics", alternate={"ExtractTextAndGraphics"})
    private Boolean extractTextAndGraphics;
    @SerializedName(value="assembleDocument", alternate={"AssembleDocument"})
    private Boolean assembleDocument;
    @SerializedName(value="highQualityPrint", alternate={"HighQualityPrint"})
    private Boolean highQualityPrint;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public AccessPermissions printDocument(Boolean printDocument) {
        this.printDocument = printDocument;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may print the document (possibly not at the highest quality level, depending on whether bit HighQualityPrint is also set).")
    public Boolean isPrintDocument() {
        return this.printDocument;
    }

    public void setPrintDocument(Boolean printDocument) {
        this.printDocument = printDocument;
    }

    public AccessPermissions modifyContent(Boolean modifyContent) {
        this.modifyContent = modifyContent;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may modify the contents of the document by operations other than those controlled by bits AddOrModifyFields, FillExistingFields, AssembleDocument.")
    public Boolean isModifyContent() {
        return this.modifyContent;
    }

    public void setModifyContent(Boolean modifyContent) {
        this.modifyContent = modifyContent;
    }

    public AccessPermissions copyTextAndGraphics(Boolean copyTextAndGraphics) {
        this.copyTextAndGraphics = copyTextAndGraphics;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may copy or otherwise extract text and graphics from the document by operations other than that controlled by bit ExtractTextAndGraphics.")
    public Boolean isCopyTextAndGraphics() {
        return this.copyTextAndGraphics;
    }

    public void setCopyTextAndGraphics(Boolean copyTextAndGraphics) {
        this.copyTextAndGraphics = copyTextAndGraphics;
    }

    public AccessPermissions addOrModifyFields(Boolean addOrModifyFields) {
        this.addOrModifyFields = addOrModifyFields;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may add or modify text annotations, fill in interactive form fields, and, if bit ModifyContent is also set, create or modify interactive form fields (including signature fields).")
    public Boolean isAddOrModifyFields() {
        return this.addOrModifyFields;
    }

    public void setAddOrModifyFields(Boolean addOrModifyFields) {
        this.addOrModifyFields = addOrModifyFields;
    }

    public AccessPermissions fillExistingFields(Boolean fillExistingFields) {
        this.fillExistingFields = fillExistingFields;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may fill in existing interactive form fields (including signature fields), even if bit AddOrModifyFields is clear.")
    public Boolean isFillExistingFields() {
        return this.fillExistingFields;
    }

    public void setFillExistingFields(Boolean fillExistingFields) {
        this.fillExistingFields = fillExistingFields;
    }

    public AccessPermissions extractTextAndGraphics(Boolean extractTextAndGraphics) {
        this.extractTextAndGraphics = extractTextAndGraphics;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may extract text and graphics in support of accessibility to users with disabilities or for other purposes.")
    public Boolean isExtractTextAndGraphics() {
        return this.extractTextAndGraphics;
    }

    public void setExtractTextAndGraphics(Boolean extractTextAndGraphics) {
        this.extractTextAndGraphics = extractTextAndGraphics;
    }

    public AccessPermissions assembleDocument(Boolean assembleDocument) {
        this.assembleDocument = assembleDocument;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may assemble the document (insert, rotate, or delete pages and create bookmarks or thumbnail images), even if bit ModifyContent is clear.")
    public Boolean isAssembleDocument() {
        return this.assembleDocument;
    }

    public void setAssembleDocument(Boolean assembleDocument) {
        this.assembleDocument = assembleDocument;
    }

    public AccessPermissions highQualityPrint(Boolean highQualityPrint) {
        this.highQualityPrint = highQualityPrint;
        return this;
    }

    @ApiModelProperty(required=true, value="The user may print the document to a representation from which a faithful digital copy of the PDF content could be generated. When this bit is clear (and bit PrintDocument is set), printing is limited to a low-level representation of the appearance, possibly of degraded quality.")
    public Boolean isHighQualityPrint() {
        return this.highQualityPrint;
    }

    public void setHighQualityPrint(Boolean highQualityPrint) {
        this.highQualityPrint = highQualityPrint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessPermissions accessPermissions = (AccessPermissions)o;
        return Objects.equals(this.printDocument, accessPermissions.printDocument) && Objects.equals(this.modifyContent, accessPermissions.modifyContent) && Objects.equals(this.copyTextAndGraphics, accessPermissions.copyTextAndGraphics) && Objects.equals(this.addOrModifyFields, accessPermissions.addOrModifyFields) && Objects.equals(this.fillExistingFields, accessPermissions.fillExistingFields) && Objects.equals(this.extractTextAndGraphics, accessPermissions.extractTextAndGraphics) && Objects.equals(this.assembleDocument, accessPermissions.assembleDocument) && Objects.equals(this.highQualityPrint, accessPermissions.highQualityPrint);
    }

    public int hashCode() {
        return Objects.hash(this.printDocument, this.modifyContent, this.copyTextAndGraphics, this.addOrModifyFields, this.fillExistingFields, this.extractTextAndGraphics, this.assembleDocument, this.highQualityPrint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessPermissions {\n");
        sb.append("    printDocument: ").append(this.toIndentedString(this.printDocument)).append("\n");
        sb.append("    modifyContent: ").append(this.toIndentedString(this.modifyContent)).append("\n");
        sb.append("    copyTextAndGraphics: ").append(this.toIndentedString(this.copyTextAndGraphics)).append("\n");
        sb.append("    addOrModifyFields: ").append(this.toIndentedString(this.addOrModifyFields)).append("\n");
        sb.append("    fillExistingFields: ").append(this.toIndentedString(this.fillExistingFields)).append("\n");
        sb.append("    extractTextAndGraphics: ").append(this.toIndentedString(this.extractTextAndGraphics)).append("\n");
        sb.append("    assembleDocument: ").append(this.toIndentedString(this.assembleDocument)).append("\n");
        sb.append("    highQualityPrint: ").append(this.toIndentedString(this.highQualityPrint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

