/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.InputFile;
import com.aspose.slides.model.Task;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Add slide task.")
public class AddSlide
extends Task {
    @SerializedName(value="cloneFromFile", alternate={"CloneFromFile"})
    private InputFile cloneFromFile;
    @SerializedName(value="cloneFromPosition", alternate={"CloneFromPosition"})
    private Integer cloneFromPosition;
    @SerializedName(value="position", alternate={"Position"})
    private Integer position;
    @SerializedName(value="layoutAlias", alternate={"LayoutAlias"})
    private String layoutAlias;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public AddSlide() {
        this.setType(Task.TypeEnum.ADDSLIDE);
    }

    public AddSlide cloneFromFile(InputFile cloneFromFile) {
        this.cloneFromFile = cloneFromFile;
        return this;
    }

    @ApiModelProperty(value="File to clone a slide from.")
    public InputFile getCloneFromFile() {
        return this.cloneFromFile;
    }

    public void setCloneFromFile(InputFile cloneFromFile) {
        this.cloneFromFile = cloneFromFile;
    }

    public AddSlide cloneFromPosition(Integer cloneFromPosition) {
        this.cloneFromPosition = cloneFromPosition;
        return this;
    }

    @ApiModelProperty(required=true, value="Position of the slide to clone.")
    public Integer getCloneFromPosition() {
        return this.cloneFromPosition;
    }

    public void setCloneFromPosition(Integer cloneFromPosition) {
        this.cloneFromPosition = cloneFromPosition;
    }

    public AddSlide position(Integer position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(required=true, value="Position at which to insert the slide.")
    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public AddSlide layoutAlias(String layoutAlias) {
        this.layoutAlias = layoutAlias;
        return this;
    }

    @ApiModelProperty(value="Alias of layout (href, index or type). If value is null a blank slide is added.")
    public String getLayoutAlias() {
        return this.layoutAlias;
    }

    public void setLayoutAlias(String layoutAlias) {
        this.layoutAlias = layoutAlias;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddSlide addSlide = (AddSlide)o;
        return Objects.equals(this.cloneFromFile, addSlide.cloneFromFile) && Objects.equals(this.cloneFromPosition, addSlide.cloneFromPosition) && Objects.equals(this.position, addSlide.position) && Objects.equals(this.layoutAlias, addSlide.layoutAlias) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cloneFromFile, this.cloneFromPosition, this.position, this.layoutAlias, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddSlide {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cloneFromFile: ").append(this.toIndentedString(this.cloneFromFile)).append("\n");
        sb.append("    cloneFromPosition: ").append(this.toIndentedString(this.cloneFromPosition)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    layoutAlias: ").append(this.toIndentedString(this.layoutAlias)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)Task.TypeEnum.ADDSLIDE);
    }
}

