/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.PathSegment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Arc segment of the geometry path")
public class ArcToPathSegment
extends PathSegment {
    @SerializedName(value="width", alternate={"Width"})
    private Double width;
    @SerializedName(value="height", alternate={"Height"})
    private Double height;
    @SerializedName(value="startAngle", alternate={"StartAngle"})
    private Double startAngle;
    @SerializedName(value="sweepAngle", alternate={"SweepAngle"})
    private Double sweepAngle;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ArcToPathSegment() {
        this.setType(PathSegment.TypeEnum.ARCTO);
    }

    public ArcToPathSegment width(Double width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Width of the rectangle")
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public ArcToPathSegment height(Double height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Height of the rectangle")
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public ArcToPathSegment startAngle(Double startAngle) {
        this.startAngle = startAngle;
        return this;
    }

    @ApiModelProperty(required=true, value="Start angle")
    public Double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(Double startAngle) {
        this.startAngle = startAngle;
    }

    public ArcToPathSegment sweepAngle(Double sweepAngle) {
        this.sweepAngle = sweepAngle;
        return this;
    }

    @ApiModelProperty(required=true, value="Sweep angle")
    public Double getSweepAngle() {
        return this.sweepAngle;
    }

    public void setSweepAngle(Double sweepAngle) {
        this.sweepAngle = sweepAngle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArcToPathSegment arcToPathSegment = (ArcToPathSegment)o;
        return Objects.equals(this.width, arcToPathSegment.width) && Objects.equals(this.height, arcToPathSegment.height) && Objects.equals(this.startAngle, arcToPathSegment.startAngle) && Objects.equals(this.sweepAngle, arcToPathSegment.sweepAngle) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.width, this.height, this.startAngle, this.sweepAngle, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArcToPathSegment {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    startAngle: ").append(this.toIndentedString(this.startAngle)).append("\n");
        sb.append("    sweepAngle: ").append(this.toIndentedString(this.sweepAngle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)PathSegment.TypeEnum.ARCTO);
    }
}

