/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies the bar function, consisting of a base argument and an overbar or underbar")
public class BarElement
extends MathElement {
    @SerializedName(value="base", alternate={"Base"})
    private MathElement base;
    @SerializedName(value="position", alternate={"Position"})
    private PositionEnum position;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public BarElement() {
        this.setType(MathElement.TypeEnum.BAR);
    }

    public BarElement base(MathElement base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="Base")
    public MathElement getBase() {
        return this.base;
    }

    public void setBase(MathElement base) {
        this.base = base;
    }

    public BarElement position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="Position of the bar line.             ")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarElement barElement = (BarElement)o;
        return Objects.equals(this.base, barElement.base) && Objects.equals((Object)this.position, (Object)barElement.position) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.base, this.position, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BarElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.BAR);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PositionEnum {
        NOTDEFINED("NotDefined"),
        TOP("Top"),
        BOTTOM("Bottom");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PositionEnum fromValue(String text) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PositionEnum> {
            public void write(JsonWriter jsonWriter, PositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PositionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

