/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.BubbleChartDataPoint;
import com.aspose.slides.model.DataSource;
import com.aspose.slides.model.Series;
import com.aspose.slides.model.XYSeries;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="A bubble series.")
public class BubbleSeries
extends XYSeries {
    @SerializedName(value="dataPoints", alternate={"DataPoints"})
    private List<BubbleChartDataPoint> dataPoints = null;
    @SerializedName(value="numberFormatOfBubbleSizes", alternate={"NumberFormatOfBubbleSizes"})
    private String numberFormatOfBubbleSizes;
    @SerializedName(value="dataSourceForBubbleSizeValues", alternate={"DataSourceForBubbleSizeValues"})
    private DataSource dataSourceForBubbleSizeValues;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public BubbleSeries() {
        this.setDataPointType(Series.DataPointTypeEnum.BUBBLE);
    }

    public BubbleSeries dataPoints(List<BubbleChartDataPoint> dataPoints) {
        this.dataPoints = dataPoints;
        return this;
    }

    public BubbleSeries addDataPointsItem(BubbleChartDataPoint dataPointsItem) {
        if (this.dataPoints == null) {
            this.dataPoints = new ArrayList<BubbleChartDataPoint>();
        }
        this.dataPoints.add(dataPointsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the values.")
    public List<BubbleChartDataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(List<BubbleChartDataPoint> dataPoints) {
        this.dataPoints = dataPoints;
    }

    public BubbleSeries numberFormatOfBubbleSizes(String numberFormatOfBubbleSizes) {
        this.numberFormatOfBubbleSizes = numberFormatOfBubbleSizes;
        return this;
    }

    @ApiModelProperty(value="The number format for the series bubble sizes.")
    public String getNumberFormatOfBubbleSizes() {
        return this.numberFormatOfBubbleSizes;
    }

    public void setNumberFormatOfBubbleSizes(String numberFormatOfBubbleSizes) {
        this.numberFormatOfBubbleSizes = numberFormatOfBubbleSizes;
    }

    public BubbleSeries dataSourceForBubbleSizeValues(DataSource dataSourceForBubbleSizeValues) {
        this.dataSourceForBubbleSizeValues = dataSourceForBubbleSizeValues;
        return this;
    }

    @ApiModelProperty(value="Data source type for Bubble size values.")
    public DataSource getDataSourceForBubbleSizeValues() {
        return this.dataSourceForBubbleSizeValues;
    }

    public void setDataSourceForBubbleSizeValues(DataSource dataSourceForBubbleSizeValues) {
        this.dataSourceForBubbleSizeValues = dataSourceForBubbleSizeValues;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BubbleSeries bubbleSeries = (BubbleSeries)o;
        return Objects.equals(this.dataPoints, bubbleSeries.dataPoints) && Objects.equals(this.numberFormatOfBubbleSizes, bubbleSeries.numberFormatOfBubbleSizes) && Objects.equals(this.dataSourceForBubbleSizeValues, bubbleSeries.dataSourceForBubbleSizeValues) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataPoints, this.numberFormatOfBubbleSizes, this.dataSourceForBubbleSizeValues, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BubbleSeries {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    dataPoints: ").append(this.toIndentedString(this.dataPoints)).append("\n");
        sb.append("    numberFormatOfBubbleSizes: ").append(this.toIndentedString(this.numberFormatOfBubbleSizes)).append("\n");
        sb.append("    dataSourceForBubbleSizeValues: ").append(this.toIndentedString(this.dataSourceForBubbleSizeValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("DataPointType", (Object)Series.DataPointTypeEnum.BUBBLE);
    }
}

