/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.Axes;
import com.aspose.slides.model.ChartCategory;
import com.aspose.slides.model.ChartSeriesGroup;
import com.aspose.slides.model.ChartTitle;
import com.aspose.slides.model.ChartWall;
import com.aspose.slides.model.DataSource;
import com.aspose.slides.model.Legend;
import com.aspose.slides.model.PlotArea;
import com.aspose.slides.model.Series;
import com.aspose.slides.model.ShapeBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents chart resource")
public class Chart
extends ShapeBase {
    @SerializedName(value="chartType", alternate={"ChartType"})
    private ChartTypeEnum chartType;
    @SerializedName(value="showDataLabelsOverMaximum", alternate={"ShowDataLabelsOverMaximum"})
    private Boolean showDataLabelsOverMaximum;
    @SerializedName(value="series", alternate={"Series"})
    private List<Series> series = null;
    @SerializedName(value="categories", alternate={"Categories"})
    private List<ChartCategory> categories = null;
    @SerializedName(value="dataSourceForCategories", alternate={"DataSourceForCategories"})
    private DataSource dataSourceForCategories;
    @SerializedName(value="hasTitle", alternate={"HasTitle"})
    private Boolean hasTitle;
    @SerializedName(value="title", alternate={"Title"})
    private ChartTitle title;
    @SerializedName(value="backWall", alternate={"BackWall"})
    private ChartWall backWall;
    @SerializedName(value="sideWall", alternate={"SideWall"})
    private ChartWall sideWall;
    @SerializedName(value="floor", alternate={"Floor"})
    private ChartWall floor;
    @SerializedName(value="legend", alternate={"Legend"})
    private Legend legend;
    @SerializedName(value="axes", alternate={"Axes"})
    private Axes axes;
    @SerializedName(value="plotArea", alternate={"PlotArea"})
    private PlotArea plotArea;
    @SerializedName(value="hasRoundedCorners", alternate={"HasRoundedCorners"})
    private Boolean hasRoundedCorners;
    @SerializedName(value="seriesGroups", alternate={"SeriesGroups"})
    private List<ChartSeriesGroup> seriesGroups = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Chart() {
        this.setType(ShapeBase.TypeEnum.CHART);
    }

    public Chart chartType(ChartTypeEnum chartType) {
        this.chartType = chartType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the type of the chart.")
    public ChartTypeEnum getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartTypeEnum chartType) {
        this.chartType = chartType;
    }

    public Chart showDataLabelsOverMaximum(Boolean showDataLabelsOverMaximum) {
        this.showDataLabelsOverMaximum = showDataLabelsOverMaximum;
        return this;
    }

    @ApiModelProperty(value="True if data labels over the maximum of the chart shall be shown.")
    public Boolean isShowDataLabelsOverMaximum() {
        return this.showDataLabelsOverMaximum;
    }

    public void setShowDataLabelsOverMaximum(Boolean showDataLabelsOverMaximum) {
        this.showDataLabelsOverMaximum = showDataLabelsOverMaximum;
    }

    public Chart series(List<Series> series) {
        this.series = series;
        return this;
    }

    public Chart addSeriesItem(Series seriesItem) {
        if (this.series == null) {
            this.series = new ArrayList<Series>();
        }
        this.series.add(seriesItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the series of chart data values.")
    public List<Series> getSeries() {
        return this.series;
    }

    public void setSeries(List<Series> series) {
        this.series = series;
    }

    public Chart categories(List<ChartCategory> categories) {
        this.categories = categories;
        return this;
    }

    public Chart addCategoriesItem(ChartCategory categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<ChartCategory>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the categories for chart data")
    public List<ChartCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<ChartCategory> categories) {
        this.categories = categories;
    }

    public Chart dataSourceForCategories(DataSource dataSourceForCategories) {
        this.dataSourceForCategories = dataSourceForCategories;
        return this;
    }

    @ApiModelProperty(value="Data source type for categories.")
    public DataSource getDataSourceForCategories() {
        return this.dataSourceForCategories;
    }

    public void setDataSourceForCategories(DataSource dataSourceForCategories) {
        this.dataSourceForCategories = dataSourceForCategories;
    }

    public Chart hasTitle(Boolean hasTitle) {
        this.hasTitle = hasTitle;
        return this;
    }

    @ApiModelProperty(value="True if the chart has a title.")
    public Boolean isHasTitle() {
        return this.hasTitle;
    }

    public void setHasTitle(Boolean hasTitle) {
        this.hasTitle = hasTitle;
    }

    public Chart title(ChartTitle title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the title.")
    public ChartTitle getTitle() {
        return this.title;
    }

    public void setTitle(ChartTitle title) {
        this.title = title;
    }

    public Chart backWall(ChartWall backWall) {
        this.backWall = backWall;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the back wall.")
    public ChartWall getBackWall() {
        return this.backWall;
    }

    public void setBackWall(ChartWall backWall) {
        this.backWall = backWall;
    }

    public Chart sideWall(ChartWall sideWall) {
        this.sideWall = sideWall;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the side wall.")
    public ChartWall getSideWall() {
        return this.sideWall;
    }

    public void setSideWall(ChartWall sideWall) {
        this.sideWall = sideWall;
    }

    public Chart floor(ChartWall floor) {
        this.floor = floor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the floor.")
    public ChartWall getFloor() {
        return this.floor;
    }

    public void setFloor(ChartWall floor) {
        this.floor = floor;
    }

    public Chart legend(Legend legend) {
        this.legend = legend;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the legend.")
    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Chart axes(Axes axes) {
        this.axes = axes;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the axes.")
    public Axes getAxes() {
        return this.axes;
    }

    public void setAxes(Axes axes) {
        this.axes = axes;
    }

    public Chart plotArea(PlotArea plotArea) {
        this.plotArea = plotArea;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the plot area.")
    public PlotArea getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(PlotArea plotArea) {
        this.plotArea = plotArea;
    }

    public Chart hasRoundedCorners(Boolean hasRoundedCorners) {
        this.hasRoundedCorners = hasRoundedCorners;
        return this;
    }

    @ApiModelProperty(value="Specifies the chart area shall have rounded corners.")
    public Boolean isHasRoundedCorners() {
        return this.hasRoundedCorners;
    }

    public void setHasRoundedCorners(Boolean hasRoundedCorners) {
        this.hasRoundedCorners = hasRoundedCorners;
    }

    public Chart seriesGroups(List<ChartSeriesGroup> seriesGroups) {
        this.seriesGroups = seriesGroups;
        return this;
    }

    public Chart addSeriesGroupsItem(ChartSeriesGroup seriesGroupsItem) {
        if (this.seriesGroups == null) {
            this.seriesGroups = new ArrayList<ChartSeriesGroup>();
        }
        this.seriesGroups.add(seriesGroupsItem);
        return this;
    }

    @ApiModelProperty(value="Gets groups of series. ")
    public List<ChartSeriesGroup> getSeriesGroups() {
        return this.seriesGroups;
    }

    public void setSeriesGroups(List<ChartSeriesGroup> seriesGroups) {
        this.seriesGroups = seriesGroups;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chart chart = (Chart)o;
        return Objects.equals((Object)this.chartType, (Object)chart.chartType) && Objects.equals(this.showDataLabelsOverMaximum, chart.showDataLabelsOverMaximum) && Objects.equals(this.series, chart.series) && Objects.equals(this.categories, chart.categories) && Objects.equals(this.dataSourceForCategories, chart.dataSourceForCategories) && Objects.equals(this.hasTitle, chart.hasTitle) && Objects.equals(this.title, chart.title) && Objects.equals(this.backWall, chart.backWall) && Objects.equals(this.sideWall, chart.sideWall) && Objects.equals(this.floor, chart.floor) && Objects.equals(this.legend, chart.legend) && Objects.equals(this.axes, chart.axes) && Objects.equals(this.plotArea, chart.plotArea) && Objects.equals(this.hasRoundedCorners, chart.hasRoundedCorners) && Objects.equals(this.seriesGroups, chart.seriesGroups) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.chartType, this.showDataLabelsOverMaximum, this.series, this.categories, this.dataSourceForCategories, this.hasTitle, this.title, this.backWall, this.sideWall, this.floor, this.legend, this.axes, this.plotArea, this.hasRoundedCorners, this.seriesGroups, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Chart {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    chartType: ").append(this.toIndentedString((Object)this.chartType)).append("\n");
        sb.append("    showDataLabelsOverMaximum: ").append(this.toIndentedString(this.showDataLabelsOverMaximum)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    dataSourceForCategories: ").append(this.toIndentedString(this.dataSourceForCategories)).append("\n");
        sb.append("    hasTitle: ").append(this.toIndentedString(this.hasTitle)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    backWall: ").append(this.toIndentedString(this.backWall)).append("\n");
        sb.append("    sideWall: ").append(this.toIndentedString(this.sideWall)).append("\n");
        sb.append("    floor: ").append(this.toIndentedString(this.floor)).append("\n");
        sb.append("    legend: ").append(this.toIndentedString(this.legend)).append("\n");
        sb.append("    axes: ").append(this.toIndentedString(this.axes)).append("\n");
        sb.append("    plotArea: ").append(this.toIndentedString(this.plotArea)).append("\n");
        sb.append("    hasRoundedCorners: ").append(this.toIndentedString(this.hasRoundedCorners)).append("\n");
        sb.append("    seriesGroups: ").append(this.toIndentedString(this.seriesGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ShapeBase.TypeEnum.CHART);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChartTypeEnum {
        CLUSTEREDCOLUMN("ClusteredColumn"),
        STACKEDCOLUMN("StackedColumn"),
        PERCENTSSTACKEDCOLUMN("PercentsStackedColumn"),
        CLUSTEREDCOLUMN3D("ClusteredColumn3D"),
        STACKEDCOLUMN3D("StackedColumn3D"),
        PERCENTSSTACKEDCOLUMN3D("PercentsStackedColumn3D"),
        COLUMN3D("Column3D"),
        CLUSTEREDCYLINDER("ClusteredCylinder"),
        STACKEDCYLINDER("StackedCylinder"),
        PERCENTSSTACKEDCYLINDER("PercentsStackedCylinder"),
        CYLINDER3D("Cylinder3D"),
        CLUSTEREDCONE("ClusteredCone"),
        STACKEDCONE("StackedCone"),
        PERCENTSSTACKEDCONE("PercentsStackedCone"),
        CONE3D("Cone3D"),
        CLUSTEREDPYRAMID("ClusteredPyramid"),
        STACKEDPYRAMID("StackedPyramid"),
        PERCENTSSTACKEDPYRAMID("PercentsStackedPyramid"),
        PYRAMID3D("Pyramid3D"),
        LINE("Line"),
        STACKEDLINE("StackedLine"),
        PERCENTSSTACKEDLINE("PercentsStackedLine"),
        LINEWITHMARKERS("LineWithMarkers"),
        STACKEDLINEWITHMARKERS("StackedLineWithMarkers"),
        PERCENTSSTACKEDLINEWITHMARKERS("PercentsStackedLineWithMarkers"),
        LINE3D("Line3D"),
        PIE("Pie"),
        PIE3D("Pie3D"),
        PIEOFPIE("PieOfPie"),
        EXPLODEDPIE("ExplodedPie"),
        EXPLODEDPIE3D("ExplodedPie3D"),
        BAROFPIE("BarOfPie"),
        PERCENTSSTACKEDBAR("PercentsStackedBar"),
        CLUSTEREDBAR3D("ClusteredBar3D"),
        CLUSTEREDBAR("ClusteredBar"),
        STACKEDBAR("StackedBar"),
        STACKEDBAR3D("StackedBar3D"),
        PERCENTSSTACKEDBAR3D("PercentsStackedBar3D"),
        CLUSTEREDHORIZONTALCYLINDER("ClusteredHorizontalCylinder"),
        STACKEDHORIZONTALCYLINDER("StackedHorizontalCylinder"),
        PERCENTSSTACKEDHORIZONTALCYLINDER("PercentsStackedHorizontalCylinder"),
        CLUSTEREDHORIZONTALCONE("ClusteredHorizontalCone"),
        STACKEDHORIZONTALCONE("StackedHorizontalCone"),
        PERCENTSSTACKEDHORIZONTALCONE("PercentsStackedHorizontalCone"),
        CLUSTEREDHORIZONTALPYRAMID("ClusteredHorizontalPyramid"),
        STACKEDHORIZONTALPYRAMID("StackedHorizontalPyramid"),
        PERCENTSSTACKEDHORIZONTALPYRAMID("PercentsStackedHorizontalPyramid"),
        AREA("Area"),
        STACKEDAREA("StackedArea"),
        PERCENTSSTACKEDAREA("PercentsStackedArea"),
        AREA3D("Area3D"),
        STACKEDAREA3D("StackedArea3D"),
        PERCENTSSTACKEDAREA3D("PercentsStackedArea3D"),
        SCATTERWITHMARKERS("ScatterWithMarkers"),
        SCATTERWITHSMOOTHLINESANDMARKERS("ScatterWithSmoothLinesAndMarkers"),
        SCATTERWITHSMOOTHLINES("ScatterWithSmoothLines"),
        SCATTERWITHSTRAIGHTLINESANDMARKERS("ScatterWithStraightLinesAndMarkers"),
        SCATTERWITHSTRAIGHTLINES("ScatterWithStraightLines"),
        HIGHLOWCLOSE("HighLowClose"),
        OPENHIGHLOWCLOSE("OpenHighLowClose"),
        VOLUMEHIGHLOWCLOSE("VolumeHighLowClose"),
        VOLUMEOPENHIGHLOWCLOSE("VolumeOpenHighLowClose"),
        SURFACE3D("Surface3D"),
        WIREFRAMESURFACE3D("WireframeSurface3D"),
        CONTOUR("Contour"),
        WIREFRAMECONTOUR("WireframeContour"),
        DOUGHNUT("Doughnut"),
        EXPLODEDDOUGHNUT("ExplodedDoughnut"),
        BUBBLE("Bubble"),
        BUBBLEWITH3D("BubbleWith3D"),
        RADAR("Radar"),
        RADARWITHMARKERS("RadarWithMarkers"),
        FILLEDRADAR("FilledRadar"),
        SERIESOFMIXEDTYPES("SeriesOfMixedTypes"),
        TREEMAP("Treemap"),
        SUNBURST("Sunburst"),
        HISTOGRAM("Histogram"),
        PARETOLINE("ParetoLine"),
        BOXANDWHISKER("BoxAndWhisker"),
        WATERFALL("Waterfall"),
        FUNNEL("Funnel"),
        MAP("Map");

        private String value;

        private ChartTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChartTypeEnum fromValue(String text) {
            for (ChartTypeEnum b : ChartTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ChartTypeEnum> {
            public void write(JsonWriter jsonWriter, ChartTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChartTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChartTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

