/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ImageTransformEffect;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a Color Change effect.")
public class ColorChangeEffect
extends ImageTransformEffect {
    @SerializedName(value="fromColor", alternate={"FromColor"})
    private String fromColor;
    @SerializedName(value="toColor", alternate={"ToColor"})
    private String toColor;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ColorChangeEffect() {
        this.setType(ImageTransformEffect.TypeEnum.COLORCHANGE);
    }

    public ColorChangeEffect fromColor(String fromColor) {
        this.fromColor = fromColor;
        return this;
    }

    @ApiModelProperty(value="Color which will be replaced.")
    public String getFromColor() {
        return this.fromColor;
    }

    public void setFromColor(String fromColor) {
        this.fromColor = fromColor;
    }

    public ColorChangeEffect toColor(String toColor) {
        this.toColor = toColor;
        return this;
    }

    @ApiModelProperty(value="Color which will replace.")
    public String getToColor() {
        return this.toColor;
    }

    public void setToColor(String toColor) {
        this.toColor = toColor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorChangeEffect colorChangeEffect = (ColorChangeEffect)o;
        return Objects.equals(this.fromColor, colorChangeEffect.fromColor) && Objects.equals(this.toColor, colorChangeEffect.toColor) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fromColor, this.toColor, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColorChangeEffect {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    fromColor: ").append(this.toIndentedString(this.fromColor)).append("\n");
        sb.append("    toColor: ").append(this.toIndentedString(this.toColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ImageTransformEffect.TypeEnum.COLORCHANGE);
    }
}

