/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ImageTransformEffect;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a Color Replacement effect.")
public class ColorReplaceEffect
extends ImageTransformEffect {
    @SerializedName(value="color", alternate={"Color"})
    private String color;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ColorReplaceEffect() {
        this.setType(ImageTransformEffect.TypeEnum.COLORREPLACE);
    }

    public ColorReplaceEffect color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Returns color format which will replace color of every pixel.")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorReplaceEffect colorReplaceEffect = (ColorReplaceEffect)o;
        return Objects.equals(this.color, colorReplaceEffect.color) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.color, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColorReplaceEffect {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ImageTransformEffect.TypeEnum.COLORREPLACE);
    }
}

