/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.PathSegment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Cubic Bezier curve segment of the geometry path")
public class CubicBezierToPathSegment
extends PathSegment {
    @SerializedName(value="x1", alternate={"X1"})
    private Double x1;
    @SerializedName(value="y1", alternate={"Y1"})
    private Double y1;
    @SerializedName(value="x2", alternate={"X2"})
    private Double x2;
    @SerializedName(value="y2", alternate={"Y2"})
    private Double y2;
    @SerializedName(value="x3", alternate={"X3"})
    private Double x3;
    @SerializedName(value="y3", alternate={"Y3"})
    private Double y3;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public CubicBezierToPathSegment() {
        this.setType(PathSegment.TypeEnum.CUBICBEZIERTO);
    }

    public CubicBezierToPathSegment x1(Double x1) {
        this.x1 = x1;
        return this;
    }

    @ApiModelProperty(required=true, value="X coordinate of the first direction point")
    public Double getX1() {
        return this.x1;
    }

    public void setX1(Double x1) {
        this.x1 = x1;
    }

    public CubicBezierToPathSegment y1(Double y1) {
        this.y1 = y1;
        return this;
    }

    @ApiModelProperty(required=true, value="Y coordinate of the first direction point")
    public Double getY1() {
        return this.y1;
    }

    public void setY1(Double y1) {
        this.y1 = y1;
    }

    public CubicBezierToPathSegment x2(Double x2) {
        this.x2 = x2;
        return this;
    }

    @ApiModelProperty(required=true, value="X coordinate of the second direction point")
    public Double getX2() {
        return this.x2;
    }

    public void setX2(Double x2) {
        this.x2 = x2;
    }

    public CubicBezierToPathSegment y2(Double y2) {
        this.y2 = y2;
        return this;
    }

    @ApiModelProperty(required=true, value="Y coordinate of the second direction point")
    public Double getY2() {
        return this.y2;
    }

    public void setY2(Double y2) {
        this.y2 = y2;
    }

    public CubicBezierToPathSegment x3(Double x3) {
        this.x3 = x3;
        return this;
    }

    @ApiModelProperty(required=true, value="X coordinate of end point")
    public Double getX3() {
        return this.x3;
    }

    public void setX3(Double x3) {
        this.x3 = x3;
    }

    public CubicBezierToPathSegment y3(Double y3) {
        this.y3 = y3;
        return this;
    }

    @ApiModelProperty(required=true, value="Y coordinate of end point")
    public Double getY3() {
        return this.y3;
    }

    public void setY3(Double y3) {
        this.y3 = y3;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubicBezierToPathSegment cubicBezierToPathSegment = (CubicBezierToPathSegment)o;
        return Objects.equals(this.x1, cubicBezierToPathSegment.x1) && Objects.equals(this.y1, cubicBezierToPathSegment.y1) && Objects.equals(this.x2, cubicBezierToPathSegment.x2) && Objects.equals(this.y2, cubicBezierToPathSegment.y2) && Objects.equals(this.x3, cubicBezierToPathSegment.x3) && Objects.equals(this.y3, cubicBezierToPathSegment.y3) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CubicBezierToPathSegment {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    x1: ").append(this.toIndentedString(this.x1)).append("\n");
        sb.append("    y1: ").append(this.toIndentedString(this.y1)).append("\n");
        sb.append("    x2: ").append(this.toIndentedString(this.x2)).append("\n");
        sb.append("    y2: ").append(this.toIndentedString(this.y2)).append("\n");
        sb.append("    x3: ").append(this.toIndentedString(this.x3)).append("\n");
        sb.append("    y3: ").append(this.toIndentedString(this.y3)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)PathSegment.TypeEnum.CUBICBEZIERTO);
    }
}

