/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Drawing guide.")
public class DrawingGuide {
    @SerializedName(value="orientation", alternate={"Orientation"})
    private OrientationEnum orientation;
    @SerializedName(value="position", alternate={"Position"})
    private Double position;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public DrawingGuide orientation(OrientationEnum orientation) {
        this.orientation = orientation;
        return this;
    }

    @ApiModelProperty(required=true, value="Last used view mode.")
    public OrientationEnum getOrientation() {
        return this.orientation;
    }

    public void setOrientation(OrientationEnum orientation) {
        this.orientation = orientation;
    }

    public DrawingGuide position(Double position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(required=true, value="Horizontal bar state.")
    public Double getPosition() {
        return this.position;
    }

    public void setPosition(Double position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawingGuide drawingGuide = (DrawingGuide)o;
        return Objects.equals((Object)this.orientation, (Object)drawingGuide.orientation) && Objects.equals(this.position, drawingGuide.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orientation, this.position});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawingGuide {\n");
        sb.append("    orientation: ").append(this.toIndentedString((Object)this.orientation)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrientationEnum {
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical");

        private String value;

        private OrientationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrientationEnum fromValue(String text) {
            for (OrientationEnum b : OrientationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrientationEnum> {
            public void write(JsonWriter jsonWriter, OrientationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrientationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrientationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

