/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ImageTransformEffect;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a Duotone effect.")
public class DuotoneEffect
extends ImageTransformEffect {
    @SerializedName(value="color1", alternate={"Color1"})
    private String color1;
    @SerializedName(value="color2", alternate={"Color2"})
    private String color2;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public DuotoneEffect() {
        this.setType(ImageTransformEffect.TypeEnum.DUOTONE);
    }

    public DuotoneEffect color1(String color1) {
        this.color1 = color1;
        return this;
    }

    @ApiModelProperty(value="Returns target color format for dark pixels.")
    public String getColor1() {
        return this.color1;
    }

    public void setColor1(String color1) {
        this.color1 = color1;
    }

    public DuotoneEffect color2(String color2) {
        this.color2 = color2;
        return this;
    }

    @ApiModelProperty(value="Returns target color format for light pixels.")
    public String getColor2() {
        return this.color2;
    }

    public void setColor2(String color2) {
        this.color2 = color2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuotoneEffect duotoneEffect = (DuotoneEffect)o;
        return Objects.equals(this.color1, duotoneEffect.color1) && Objects.equals(this.color2, duotoneEffect.color2) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.color1, this.color2, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DuotoneEffect {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    color1: ").append(this.toIndentedString(this.color1)).append("\n");
        sb.append("    color2: ").append(this.toIndentedString(this.color2)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ImageTransformEffect.TypeEnum.DUOTONE);
    }
}

