/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.ImageTransformEffect;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a Fill Overlay effect. A fill overlay may be used to specify an additional fill for an object and blend the two fills together.")
public class FillOverlayImageEffect
extends ImageTransformEffect {
    @SerializedName(value="blend", alternate={"Blend"})
    private BlendEnum blend;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public FillOverlayImageEffect() {
        this.setType(ImageTransformEffect.TypeEnum.FILLOVERLAY);
    }

    public FillOverlayImageEffect blend(BlendEnum blend) {
        this.blend = blend;
        return this;
    }

    @ApiModelProperty(required=true, value="FillBlendMode.")
    public BlendEnum getBlend() {
        return this.blend;
    }

    public void setBlend(BlendEnum blend) {
        this.blend = blend;
    }

    public FillOverlayImageEffect fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillOverlayImageEffect fillOverlayImageEffect = (FillOverlayImageEffect)o;
        return Objects.equals((Object)this.blend, (Object)fillOverlayImageEffect.blend) && Objects.equals(this.fillFormat, fillOverlayImageEffect.fillFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.blend, this.fillFormat, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FillOverlayImageEffect {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    blend: ").append(this.toIndentedString((Object)this.blend)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ImageTransformEffect.TypeEnum.FILLOVERLAY);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BlendEnum {
        DARKEN("Darken"),
        LIGHTEN("Lighten"),
        MULTIPLY("Multiply"),
        OVERLAY("Overlay"),
        SCREEN("Screen");

        private String value;

        private BlendEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BlendEnum fromValue(String text) {
            for (BlendEnum b : BlendEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BlendEnum> {
            public void write(JsonWriter jsonWriter, BlendEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BlendEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BlendEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

