/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents font substitution rule.")
public class FontSubstRule {
    @SerializedName(value="sourceFont", alternate={"SourceFont"})
    private String sourceFont;
    @SerializedName(value="targetFont", alternate={"TargetFont"})
    private String targetFont;
    @SerializedName(value="notFoundOnly", alternate={"NotFoundOnly"})
    private Boolean notFoundOnly;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public FontSubstRule sourceFont(String sourceFont) {
        this.sourceFont = sourceFont;
        return this;
    }

    @ApiModelProperty(value="Font to substitute.")
    public String getSourceFont() {
        return this.sourceFont;
    }

    public void setSourceFont(String sourceFont) {
        this.sourceFont = sourceFont;
    }

    public FontSubstRule targetFont(String targetFont) {
        this.targetFont = targetFont;
        return this;
    }

    @ApiModelProperty(value="Substitution font.")
    public String getTargetFont() {
        return this.targetFont;
    }

    public void setTargetFont(String targetFont) {
        this.targetFont = targetFont;
    }

    public FontSubstRule notFoundOnly(Boolean notFoundOnly) {
        this.notFoundOnly = notFoundOnly;
        return this;
    }

    @ApiModelProperty(value="Substitute when font is not found. Default: true.")
    public Boolean isNotFoundOnly() {
        return this.notFoundOnly;
    }

    public void setNotFoundOnly(Boolean notFoundOnly) {
        this.notFoundOnly = notFoundOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontSubstRule fontSubstRule = (FontSubstRule)o;
        return Objects.equals(this.sourceFont, fontSubstRule.sourceFont) && Objects.equals(this.targetFont, fontSubstRule.targetFont) && Objects.equals(this.notFoundOnly, fontSubstRule.notFoundOnly);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFont, this.targetFont, this.notFoundOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FontSubstRule {\n");
        sb.append("    sourceFont: ").append(this.toIndentedString(this.sourceFont)).append("\n");
        sb.append("    targetFont: ").append(this.toIndentedString(this.targetFont)).append("\n");
        sb.append("    notFoundOnly: ").append(this.toIndentedString(this.notFoundOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

