/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.aspose.slides.model.ResourceBase;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents Format Scheme for slide's theme")
public class FormatScheme
extends ResourceBase {
    @SerializedName(value="backgroundStyles", alternate={"BackgroundStyles"})
    private List<FillFormat> backgroundStyles = null;
    @SerializedName(value="effectStyles", alternate={"EffectStyles"})
    private List<EffectFormat> effectStyles = null;
    @SerializedName(value="fillStyles", alternate={"FillStyles"})
    private List<FillFormat> fillStyles = null;
    @SerializedName(value="lineStyles", alternate={"LineStyles"})
    private List<LineFormat> lineStyles = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public FormatScheme backgroundStyles(List<FillFormat> backgroundStyles) {
        this.backgroundStyles = backgroundStyles;
        return this;
    }

    public FormatScheme addBackgroundStylesItem(FillFormat backgroundStylesItem) {
        if (this.backgroundStyles == null) {
            this.backgroundStyles = new ArrayList<FillFormat>();
        }
        this.backgroundStyles.add(backgroundStylesItem);
        return this;
    }

    @ApiModelProperty(value="Background styles.")
    public List<FillFormat> getBackgroundStyles() {
        return this.backgroundStyles;
    }

    public void setBackgroundStyles(List<FillFormat> backgroundStyles) {
        this.backgroundStyles = backgroundStyles;
    }

    public FormatScheme effectStyles(List<EffectFormat> effectStyles) {
        this.effectStyles = effectStyles;
        return this;
    }

    public FormatScheme addEffectStylesItem(EffectFormat effectStylesItem) {
        if (this.effectStyles == null) {
            this.effectStyles = new ArrayList<EffectFormat>();
        }
        this.effectStyles.add(effectStylesItem);
        return this;
    }

    @ApiModelProperty(value="Effect styles.")
    public List<EffectFormat> getEffectStyles() {
        return this.effectStyles;
    }

    public void setEffectStyles(List<EffectFormat> effectStyles) {
        this.effectStyles = effectStyles;
    }

    public FormatScheme fillStyles(List<FillFormat> fillStyles) {
        this.fillStyles = fillStyles;
        return this;
    }

    public FormatScheme addFillStylesItem(FillFormat fillStylesItem) {
        if (this.fillStyles == null) {
            this.fillStyles = new ArrayList<FillFormat>();
        }
        this.fillStyles.add(fillStylesItem);
        return this;
    }

    @ApiModelProperty(value="Fill styles.")
    public List<FillFormat> getFillStyles() {
        return this.fillStyles;
    }

    public void setFillStyles(List<FillFormat> fillStyles) {
        this.fillStyles = fillStyles;
    }

    public FormatScheme lineStyles(List<LineFormat> lineStyles) {
        this.lineStyles = lineStyles;
        return this;
    }

    public FormatScheme addLineStylesItem(LineFormat lineStylesItem) {
        if (this.lineStyles == null) {
            this.lineStyles = new ArrayList<LineFormat>();
        }
        this.lineStyles.add(lineStylesItem);
        return this;
    }

    @ApiModelProperty(value="Line style.")
    public List<LineFormat> getLineStyles() {
        return this.lineStyles;
    }

    public void setLineStyles(List<LineFormat> lineStyles) {
        this.lineStyles = lineStyles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormatScheme formatScheme = (FormatScheme)o;
        return Objects.equals(this.backgroundStyles, formatScheme.backgroundStyles) && Objects.equals(this.effectStyles, formatScheme.effectStyles) && Objects.equals(this.fillStyles, formatScheme.fillStyles) && Objects.equals(this.lineStyles, formatScheme.lineStyles) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backgroundStyles, this.effectStyles, this.fillStyles, this.lineStyles, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormatScheme {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    backgroundStyles: ").append(this.toIndentedString(this.backgroundStyles)).append("\n");
        sb.append("    effectStyles: ").append(this.toIndentedString(this.effectStyles)).append("\n");
        sb.append("    fillStyles: ").append(this.toIndentedString(this.fillStyles)).append("\n");
        sb.append("    lineStyles: ").append(this.toIndentedString(this.lineStyles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

